--
--
-- Licensed Materials - Property of IBM
-- 5724X98 5724Y15 5655V82 5724X99 5724Y16 5655V89 5725B69 5655W88 5725C52 5655W90 5655Y31
-- Copyright IBM Corp. 1987, 2015 All Rights Reserved
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with
-- IBM Corp.
--
--
RENAME TABLE EXECUTION_TRACES TO OLD_EXECUTION_TRACES;

CREATE TABLE EXECUTION_TRACES (
  ID INT GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) NOT NULL,
  TIME_STAMP BIGINT NOT NULL,
  LOCATION VARCHAR(2000) NOT NULL,
  REQUEST_PATH VARCHAR(2000) NOT NULL,
  CANONICAL_PATH VARCHAR(2000) NOT NULL,
  RULESET_PROPERTIES CLOB NOT NULL,
  ELAPSED_TIME BIGINT NOT NULL,
  USER_DATA CLOB,
  NB_RULES INT,
  NB_RULES_FIRED INT,
  NB_RULES_NOT_FIRED INT,
  NB_TASKS INT,
  NB_TASKS_EXECUTED INT,
  NB_TASKS_NOT_EXECUTED INT,
  RULES CLOB,
  TASKS CLOB,
  EXECUTION_TRACE_TREE CLOB,
  EXEC_OUTPUT CLOB,
  INPUT_PARAMS CLOB,
  OUTPUT_PARAMS CLOB,
  EXECUTION_ID VARCHAR(255) NOT NULL,
  FULL_EXECUTION_TRACE CLOB,
  CONSTRAINT ET_PK PRIMARY KEY (ID),
  CONSTRAINT EID_UNQ UNIQUE (EXECUTION_ID)
) IN RESDWTS;

-- copy the existing data into the new execution trace table
CREATE FUNCTION SCALARMIN(VAL1 INTEGER, VAL2 INTEGER)
RETURNS INTEGER
LANGUAGE SQL
RETURN CASE WHEN VAL1 < VAL2 THEN VAL1 ELSE VAL2 END;

INSERT INTO EXECUTION_TRACES(TIME_STAMP, LOCATION, REQUEST_PATH, CANONICAL_PATH, RULESET_PROPERTIES,  ELAPSED_TIME, USER_DATA, NB_RULES, NB_RULES_FIRED, NB_RULES_NOT_FIRED, NB_TASKS, NB_TASKS_EXECUTED, NB_TASKS_NOT_EXECUTED, RULES, TASKS, EXECUTION_TRACE_TREE, EXEC_OUTPUT, INPUT_PARAMS, OUTPUT_PARAMS, EXECUTION_ID, FULL_EXECUTION_TRACE) SELECT TIME_STAMP, LOCATION, REQUEST_PATH, CANONICAL_PATH, RULESET_PROPERTIES,  ELAPSED_TIME, USER_DATA, NB_RULES, NB_RULES_FIRED, NB_RULES_NOT_FIRED, NB_TASKS, NB_TASKS_EXECUTED, NB_TASKS_NOT_EXECUTED, RULES, TASKS, EXECUTION_TRACE_TREE, EXEC_OUTPUT, INPUT_PARAMS, OUTPUT_PARAMS, SUBSTR(EXECUTION_ID, 1, SCALARMIN(255, LENGTH(EXECUTION_ID))), FULL_EXECUTION_TRACE FROM OLD_EXECUTION_TRACES;

DROP FUNCTION SCALARMIN;
DROP TABLE OLD_EXECUTION_TRACES;
