/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.htds.plugin.cci.internal;

public enum Compatibility {
    LATEST(0, "7.5"),
    RELEASE70(1, "7.0"),
    RELEASE71(2, "7.1"),
    RELEASE7113(3, "7.1.1.3");

    private short shortVersion;
    private String stringVersion;
    private String stringVersionWithoutSeparator;
    private String urlVersion;
    public static Compatibility defaultCompatibility;

    private Compatibility(short shortVersion, String stringVersion) {
        this.shortVersion = shortVersion;
        this.stringVersion = stringVersion;
        this.stringVersionWithoutSeparator = stringVersion.replaceAll("\\.", "");
        this.urlVersion = "v" + this.stringVersionWithoutSeparator;
    }

    public static Compatibility toCompatibility(String value) {
        for (Compatibility compatibility : Compatibility.values()) {
            if (value != null && compatibility.toString().toLowerCase().equals(value.toLowerCase())) {
                return compatibility;
            }
            if (compatibility.stringVersion.equals(value)) {
                return compatibility;
            }
            if (compatibility.stringVersionWithoutSeparator.equals(value)) {
                return compatibility;
            }
            if (!compatibility.urlVersion.equals(value)) continue;
            return compatibility;
        }
        return defaultCompatibility;
    }

    public static Compatibility toCompatibility(short value) {
        for (Compatibility compatibility : Compatibility.values()) {
            if (compatibility.shortVersion != value) continue;
            return compatibility;
        }
        return defaultCompatibility;
    }

    public static Compatibility parseUrlVersion(String value) {
        for (Compatibility compatibility : Compatibility.values()) {
            if (!compatibility.urlVersion.equals(value)) continue;
            return compatibility;
        }
        return defaultCompatibility;
    }

    public short getShortVersion() {
        return this.shortVersion;
    }

    public String getStringVersion() {
        return this.stringVersion;
    }

    public String getURLVersion() {
        return this.urlVersion;
    }

    public String getStringVersionWithoutSeparator() {
        return this.stringVersionWithoutSeparator;
    }

    static {
        defaultCompatibility = LATEST;
    }
}

