/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.htds.plugin.cci.internal;

import com.ibm.rules.htds.plugin.cci.internal.Compatibility;
import com.ibm.rules.htds.plugin.cci.internal.HTDSSignature;
import com.ibm.rules.htds.plugin.cci.internal.RESTVersion;
import com.ibm.rules.htds.plugin.cci.internal.RulesetParameterWrapperImpl;
import com.ibm.rules.htds.plugin.cci.internal.RulesetWrapperImpl;
import com.ibm.rules.res.logging.internal.AbstractLogger;
import com.ibm.rules.res.xml.internal.JAXBClassDesciption;
import com.ibm.rules.res.xml.internal.XSD;
import com.ibm.rules.res.xml.internal.XSDUtil;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import ilog.rules.bom.IlrType;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRulesetParameter;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import javax.xml.stream.XMLStreamException;

public class HTDSUtil {
    public static RulesetWrapperImpl getRulesetWrapper(Map<String, String> properties, String rulesetName, String ruleAppName, String compatibilityValue) {
        RulesetWrapperImpl rulesetWrapper = new RulesetWrapperImpl();
        rulesetWrapper.setRulesetName(rulesetName);
        rulesetWrapper.setRuleAppName(ruleAppName);
        Compatibility compatibility = Compatibility.LATEST;
        Enum restVersion = null;
        if (compatibilityValue != null) {
            if (compatibilityValue.startsWith("REST")) {
                restVersion = RESTVersion.valueOf(compatibilityValue.substring(4));
            } else {
                compatibility = Compatibility.valueOf(compatibilityValue);
            }
        }
        if (restVersion != null) {
            rulesetWrapper.setRESTVersion(restVersion.toString());
        }
        rulesetWrapper.setCompatibility(compatibility.toString());
        rulesetWrapper.setWSDLNamespace("wsdl");
        if (compatibility == Compatibility.LATEST) {
            if (properties != null) {
                rulesetWrapper.setParameterNamespaceURI(properties.get("wsdl.paramtargetnamespace"));
                rulesetWrapper.setDecisionServiceDefaultNamespaceURI(properties.get("wsdl.defaultnamespace"));
                rulesetWrapper.setTargetNamespaceURI(properties.get("wsdl.targetnamespace"));
            } else {
                rulesetWrapper.setParameterNamespaceURI(HTDSUtil.replaceTags("http://www.ibm.com/rules/decisionservice/<ruleapp>/<ruleset>/param", rulesetName, ruleAppName, rulesetName, true));
                rulesetWrapper.setDecisionServiceDefaultNamespaceURI(HTDSUtil.replaceTags("http://www.ibm.com/rules/decisionservice/<ruleapp>/<ruleset>/param", rulesetName, ruleAppName, rulesetName, true));
                rulesetWrapper.setTargetNamespaceURI(HTDSUtil.replaceTags("http://www.ibm.com/rules/decisionservice/<ruleapp>/<ruleset>", rulesetName, ruleAppName, rulesetName, true));
            }
        }
        if (compatibility == Compatibility.RELEASE70 || compatibility == Compatibility.RELEASE71) {
            rulesetWrapper.setTargetNamespaceURI("http://www.ilog.com/rules/DecisionService");
            rulesetWrapper.setParameterNamespaceURI("http://www.ilog.com/rules/param");
            rulesetWrapper.setDecisionServiceName("DecisionService<businessrulesetname>");
            rulesetWrapper.setDecisionServiceDefaultNamespace("ns");
            rulesetWrapper.definitionNoName(true);
            rulesetWrapper.simpleTraceElements(true);
            rulesetWrapper.setDecisionServiceOperationName("executeDecisionService");
            rulesetWrapper.setDecisionServiceRequestQName("DecisionServiceSoapRequest");
            rulesetWrapper.setDecisionServiceRequestPartName("parameters");
            rulesetWrapper.setDecisionServiceRequestPartQName("DecisionServiceRequest");
            rulesetWrapper.setDecisionServiceResponseQName("DecisionServiceSoapResponse");
            rulesetWrapper.setDecisionServiceResponsePartName("parameters");
            rulesetWrapper.setDecisionServiceResponsePartQName("DecisionServiceResponse");
            rulesetWrapper.setDecisionServiceBindingName("DecisionServiceSOAP");
            rulesetWrapper.setDecisionServicePortName("DecisionServiceSOAP<hostname>");
            rulesetWrapper.setDecisionServiceFaultQName("DecisionServiceSoapFault");
            rulesetWrapper.setDecisionServiceFaultPartQName("DecisionServiceException");
            rulesetWrapper.setDecisionIdName("DecisionID");
            rulesetWrapper.setOutputStringName("ilog.rules.outputString");
            rulesetWrapper.setFiredRuleCountName("ilog.rules.firedRulesCount");
            rulesetWrapper.setDecisionServiceDefaultNamespaceURI("http://www.ilog.com/rules/DecisionService/DefaultNs");
        }
        if (compatibility == Compatibility.RELEASE7113) {
            rulesetWrapper.simpleTraceElements(true);
            rulesetWrapper.setDecisionServiceDefaultNamespaceURI("http://www.ibm.com/rules/decisionservice/<ruleapp>/<ruleset>/defaultns");
            rulesetWrapper.setDecisionServiceRequestPartName("parameters");
            rulesetWrapper.setDecisionServiceResponsePartName("parameters");
            rulesetWrapper.setDecisionIdName("DecisionID");
            rulesetWrapper.setOutputStringName("ilog.rules.outputString");
            rulesetWrapper.setFiredRuleCountName("ilog.rules.firedRulesCount");
        }
        return rulesetWrapper;
    }

    public static String[] getHTDSSignature(IlrPath rulesetPath, Iterator<XURulesetParameter> signature, Map<String, String> properties, String compatibility) {
        HTDSSignature result;
        block42: {
            RulesetWrapperImpl rulesetWrapper;
            block41: {
                String name;
                rulesetWrapper = HTDSUtil.getRulesetWrapper(properties, rulesetPath.getRulesetName(), rulesetPath.getRuleAppName(), compatibility);
                result = new HTDSSignature();
                result.setDecisionServiceNamespace(rulesetWrapper.TargetNamespaceQName().getNamespaceURI());
                result.setDecisionServiceExceptionQName(rulesetWrapper.getDecisionServiceFaultPartQName());
                result.setParamNamespace(rulesetWrapper.ParameterNamespaceQName().getNamespaceURI());
                result.setDecisionID(rulesetWrapper.getDecisionIdName());
                result.setOutputStringQName(rulesetWrapper.getOutputStringName());
                result.setFiredRulesCountQName(rulesetWrapper.getFiredRuleCountName());
                result.setDefaultNamespace(rulesetWrapper.DecisionServiceDefaultNamespaceQName().getNamespaceURI());
                if (rulesetWrapper.getRESTVersion() == null) break block41;
                result.setDecisionServiceRequestQName(rulesetWrapper.getDecisionServiceRESTRequestQName());
                result.setDecisionServiceResponseQName(rulesetWrapper.getDecisionServiceRESTResponseQName());
                ArrayList<RulesetParameterWrapperImpl> params = new ArrayList<RulesetParameterWrapperImpl>();
                HashSet<Class> javaTypes = null;
                try {
                    if (signature != null) {
                        while (signature.hasNext()) {
                            IlrType xmlType = null;
                            XURulesetParameter param = signature.next();
                            XSDUtil.ArrayType arrayType = XSDUtil.extractArrayType(param.getType());
                            if (rulesetWrapper.getRulesetMetaData() != null && rulesetWrapper.getRulesetMetaData().getXMLReflect() != null) {
                                xmlType = rulesetWrapper.getRulesetMetaData().getXMLReflect().getType(param.getType());
                            }
                            if (param.getKind() == 0 && !XSDUtil.isSimpleJavaType(arrayType.getJavaType())) {
                                if (javaTypes == null) {
                                    javaTypes = new HashSet<Class>();
                                }
                                try {
                                    ClassLoader cl = rulesetWrapper.getManagedXOMClassLoader();
                                    if (cl == null) {
                                        cl = Thread.currentThread().getContextClassLoader();
                                    }
                                    javaTypes.add(XSDUtil.getJavaType(cl, arrayType.getJavaType(), true));
                                }
                                catch (ClassNotFoundException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            params.add(new RulesetParameterWrapperImpl(rulesetWrapper, param, rulesetWrapper.NamespaceURI2NameAndLocation(), xmlType));
                        }
                    }
                    rulesetWrapper.setRulesetParameter(params);
                }
                catch (ResourceException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                if (javaTypes != null && javaTypes.size() > 0) {
                    try {
                        new XSDUtil(null).generateSchema(javaTypes, rulesetWrapper.DecisionServiceDefaultNamespaceQName().getNamespaceURI(), rulesetWrapper.inlineWSDL(), rulesetWrapper.GeneratedSchemaNamePrefix(), rulesetWrapper.NamespaceURI2NameAndLocation(), rulesetWrapper.getDecisionServiceDefaultNamespace(), rulesetWrapper.JavaFqn2QName(), true);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                for (RulesetParameterWrapperImpl parameterWrapper : params) {
                    name = parameterWrapper.getRulesetParameter().getName();
                    byte dir = parameterWrapper.getRulesetParameter().getDirection();
                    char dirChar = '#';
                    switch (dir) {
                        case 1: {
                            dirChar = '+';
                            break;
                        }
                        case 2: {
                            dirChar = '-';
                            break;
                        }
                    }
                    if (parameterWrapper.getParameterType() == 2) {
                        result.addParameter(name + "=" + dirChar + "{" + rulesetWrapper.ParameterNamespaceQName().getNamespaceURI() + "}" + name, parameterWrapper.getRulesetParameter().getType());
                        continue;
                    }
                    switch (parameterWrapper.getParameterType()) {
                        case 1: {
                            String namespace = parameterWrapper.getXMLReference().getNamespace();
                            if (namespace.length() == 0) {
                                namespace = rulesetWrapper.DecisionServiceDefaultNamespaceQName().getNamespaceURI();
                            }
                            result.addParameter(name + "=" + dirChar + "{" + namespace + "}" + parameterWrapper.getXMLReference().getName(), "XMLE");
                            break;
                        }
                        case 0: {
                            result.addParameter(name + "=" + dirChar + "{" + rulesetWrapper.ParameterNamespaceQName().getNamespaceURI() + "}" + name, "XML");
                            break;
                        }
                        case 3: {
                            JAXBClassDesciption jaxbClassDesc = parameterWrapper.getJAXBClassDescription();
                            if (jaxbClassDesc.getElementLocalName() != null) {
                                result.addParameter(name + "=" + dirChar + "{" + jaxbClassDesc.getElementNamespaceURI() + "}" + jaxbClassDesc.getElementLocalName(), parameterWrapper.getRulesetParameter().getType());
                                break;
                            }
                            result.addParameter(name + "=" + dirChar + "{" + rulesetWrapper.ParameterNamespaceQName().getNamespaceURI() + "}" + name, parameterWrapper.getRulesetParameter().getType());
                        }
                    }
                }
                for (RulesetParameterWrapperImpl parameterWrapper : params) {
                    name = parameterWrapper.getRulesetParameter().getName();
                    if (parameterWrapper.getParameterType() == 2) {
                        result.addParameter(name + "={" + rulesetWrapper.ParameterNamespaceQName().getNamespaceURI() + "}" + name, parameterWrapper.getRulesetParameter().getType());
                        continue;
                    }
                    switch (parameterWrapper.getParameterType()) {
                        case 1: {
                            String namespace = parameterWrapper.getXMLReference().getNamespace();
                            if (namespace.length() == 0) {
                                namespace = rulesetWrapper.DecisionServiceDefaultNamespaceQName().getNamespaceURI();
                            }
                            result.addParameter(name + "={" + namespace + "}" + parameterWrapper.getXMLReference().getName(), "XML");
                            break;
                        }
                        case 0: {
                            result.addParameter(name + "={" + rulesetWrapper.ParameterNamespaceQName().getNamespaceURI() + "}" + name, "XML");
                            break;
                        }
                        case 3: {
                            JAXBClassDesciption jaxbClassDesc = parameterWrapper.getJAXBClassDescription();
                            if (jaxbClassDesc.getElementLocalName() != null) {
                                result.addParameter(name + "={" + rulesetWrapper.NameAndLocationWithCreation(jaxbClassDesc.getElementNamespaceURI(), null)[0] + "}" + jaxbClassDesc.getElementLocalName(), parameterWrapper.getRulesetParameter().getType());
                                break;
                            }
                            result.addParameter(name + "={" + rulesetWrapper.ParameterNamespaceQName().getNamespaceURI() + "}" + name, parameterWrapper.getRulesetParameter().getType());
                        }
                    }
                }
                break block42;
            }
            result.setDecisionServiceRequestQName(rulesetWrapper.getDecisionServiceRequestPartQName());
            result.setDecisionServiceResponseQName(rulesetWrapper.getDecisionServiceResponsePartQName());
            if (signature == null) break block42;
            block28: while (signature.hasNext()) {
                IlrRulesetParameter rulesetParameter = signature.next();
                switch (rulesetParameter.getKind()) {
                    case 1: {
                        result.addParameter(rulesetParameter.getName(), "XML");
                        continue block28;
                    }
                    case 0: {
                        result.addParameter(rulesetParameter.getName(), rulesetParameter.getType());
                        continue block28;
                    }
                }
                throw new RuntimeException("Unexpected value: " + rulesetParameter.getKind());
            }
        }
        return result.getInternalArrayForPluginCommunication();
    }

    public static String replaceTags(String input, String rulesetName, String ruleAppName, String rulesetBusinessName, boolean changeStressedLetter) {
        if (input == null) {
            return null;
        }
        int startIndexPattern = input.indexOf(60);
        if (startIndexPattern == -1) {
            return input;
        }
        String result = XSDUtil.replaceTagsIfAny(input, "<ruleapp>", ruleAppName, startIndexPattern, changeStressedLetter, false);
        result = XSDUtil.replaceTagsIfAny(result, "<ruleset>", rulesetName, startIndexPattern, changeStressedLetter, false);
        result = rulesetBusinessName != null ? XSDUtil.replaceTagsIfAny(result, "<businessrulesetname>", rulesetBusinessName, startIndexPattern, changeStressedLetter, true) : XSDUtil.replaceTagsIfAny(result, "<businessrulesetname>", rulesetName, startIndexPattern, changeStressedLetter, false);
        return result;
    }

    public static Map<String, XSD> createXSDMap(RulesetWrapperImpl rulesetWrapper, AbstractLogger logger) {
        XSDUtil xsdUtil = new XSDUtil(logger);
        boolean inline = rulesetWrapper.inlineWSDL();
        Map<String, XSD> map = new LinkedHashMap<String, XSD>();
        Map<String, List<String>> ns2shemaList = rulesetWrapper.getRulesetMetaData().getSchemaNames();
        if (ns2shemaList != null) {
            for (Map.Entry<String, List<String>> entry : ns2shemaList.entrySet()) {
                String namespace = entry.getKey();
                List<String> files = entry.getValue();
                for (String fileName : files) {
                    Object schema = rulesetWrapper.getRulesetMetaData().getSchema(namespace, fileName);
                    if (map.containsKey(fileName) || !(schema instanceof InputStream)) continue;
                    try {
                        map.put(fileName, xsdUtil.analyse((InputStream)schema, inline, rulesetWrapper.DecisionServiceDefaultNamespaceQName().getNamespaceURI()));
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        HashSet javaTypes = null;
        for (XURulesetParameter parameter : rulesetWrapper.getRulesetMetaData().getRulesetParameters()) {
            ClassLoader cl;
            XSDUtil.ArrayType arrayType = XSDUtil.extractArrayType(parameter.getType());
            if (arrayType.getDepth() > 1) {
                if (javaTypes == null) {
                    javaTypes = new HashSet();
                }
                if ((cl = rulesetWrapper.getManagedXOMClassLoader()) == null) {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                try {
                    Class<?> clazz = XSDUtil.findClass(cl, arrayType.getJavaType());
                    int[] mdepth = new int[arrayType.getDepth() - 1];
                    Arrays.fill(mdepth, 1);
                    Object array = Array.newInstance(clazz, mdepth);
                    clazz = array.getClass();
                    javaTypes.add(clazz);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!HTDSUtil.isComplexJavaType(parameter, arrayType)) continue;
            if (javaTypes == null) {
                javaTypes = new HashSet();
            }
            if ((cl = rulesetWrapper.getManagedXOMClassLoader()) == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            try {
                javaTypes.add(XSDUtil.findClass(cl, arrayType.getJavaType()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Map<String, XSD> xsds = null;
        if (javaTypes != null && javaTypes.size() > 0) {
            try {
                xsds = xsdUtil.generateSchema(javaTypes, rulesetWrapper.DecisionServiceDefaultNamespaceQName().getNamespaceURI(), rulesetWrapper.inlineWSDL(), rulesetWrapper.GeneratedSchemaNamePrefix(), rulesetWrapper.NamespaceURI2NameAndLocation(), rulesetWrapper.getDecisionServiceDefaultNamespace(), rulesetWrapper.JavaFqn2QName(), false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (xsds != null && xsds.size() != 0) {
            map.putAll(xsds);
        }
        if (inline) {
            map = xsdUtil.treatIncludeAndImport(map, rulesetWrapper.DecisionServiceDefaultNamespaceQName().getNamespaceURI(), null);
            map = xsdUtil.treatSameNamespaces(map, false);
        }
        return map;
    }

    public static boolean isComplexJavaType(XURulesetParameter parameter, XSDUtil.ArrayType arrayType) {
        boolean isArray;
        if (!(parameter.getKind() == 0)) {
            return false;
        }
        boolean bl = isArray = arrayType.getDepth() > 0;
        if (isArray) {
            try {
                if (parameter.getComponentKind() == 1) {
                    return false;
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return !XSDUtil.isSimpleJavaType(arrayType.getJavaType());
    }
}

