/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.logging.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class RESServerInfoConsoleHandler
extends Handler {
    private LinkedList<LogRecord> events = new LinkedList();
    public int maxLength = 10;

    @Override
    public void publish(LogRecord record) {
        if (this.events == null) {
            return;
        }
        Level level = record.getLevel();
        if (level.equals(Level.INFO) || level.equals(Level.WARNING) || level.equals(Level.SEVERE)) {
            this.events.addLast(record);
            if (this.events.size() > this.maxLength) {
                this.events.removeFirst();
            }
        }
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public synchronized void cleanRecords() {
        this.events = new LinkedList();
    }

    public synchronized void setMaxLength(int newMaxLength) {
        if (this.events != null && this.events.size() > newMaxLength) {
            while (this.events.size() > newMaxLength) {
                this.events.removeFirst();
            }
        }
        this.maxLength = newMaxLength;
    }

    public synchronized List<LogRecord> getEvents() {
        if (this.events != null) {
            return new ArrayList<LogRecord>(this.events);
        }
        return new ArrayList<LogRecord>();
    }

    @Override
    public void close() {
        this.events = null;
    }

    public boolean requiresLayout() {
        return false;
    }

    @Override
    public void flush() {
        if (this.events != null) {
            this.events.clear();
        }
    }
}

