/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.logging.internal;

import com.ibm.rules.res.logging.internal.RESLogRecord;
import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class RESSourceLogRecord
extends RESLogRecord {
    private static final long serialVersionUID = 1L;

    public RESSourceLogRecord(Level level, String msg, String loggerName, String bundleName, ResourceBundle bundle, Object ... params) {
        super(level, msg, params, bundleName, bundle);
        this.setLevel(level);
        this.setLoggerName(loggerName);
        this.computeCaller();
    }

    private void computeCaller() {
        StackTraceElement[] elts = Thread.currentThread().getStackTrace();
        boolean last = false;
        for (StackTraceElement elt : elts) {
            if (!elt.getClassName().equals(this.getClass().getName()) && last) {
                this.setSourceClassName(elt.getClassName());
                this.setSourceMethodName(elt.getMethodName());
                break;
            }
            if (!elt.getClassName().equals(this.getClass().getName())) continue;
            last = true;
        }
        String key = this.getSourceClassName() + " " + this.getSourceMethodName() + " " + this.getMessage();
        Object[] params = this.getParameters();
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                key = key + " {" + i + "}";
            }
        }
        this.setMessage(key);
    }

    public static class Exit
    extends RESSourceLogRecord {
        private static final long serialVersionUID = 1L;

        public Exit(String loggerName, Object returnedObj) {
            super(Level.FINER, "RETURN", loggerName, "com.ibm.rules.res.common", LocalizedMessageHelper.getResourceBundle("com.ibm.rules.res.common"), returnedObj);
        }

        public Exit(String loggerName) {
            super(Level.FINER, "EXIT", loggerName, "com.ibm.rules.res.common", LocalizedMessageHelper.getResourceBundle("com.ibm.rules.res.common"), "RETURN");
        }
    }

    public static class Entry
    extends RESSourceLogRecord {
        private static final long serialVersionUID = 1L;

        public Entry(String loggerName, Object ... parameters) {
            super(Level.FINER, "ENTERING", loggerName, "com.ibm.rules.res.common", LocalizedMessageHelper.getResourceBundle("com.ibm.rules.res.common"), parameters);
        }
    }
}

