/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.message.internal;

public class MessageCode {
    public static final String JRULES = "GBR";
    public static final String DVS = "GBRT";
    public static final String RES = "GBRX";
    public static final String CDI = "GBRI";
    public static final String HTDS = "GBRXH";
    public static final String XU = "GBRXU";
    public static final String RULE_SESSION = "GBRXR";
    public static final String CONSOLE = "GBRXC";
    public static final String JSR94 = "GBRXJ";
    public static final String COMMON = "GBRXX";
    public static final String DVS_COMMON = "GBRTX";
    public static final String DVS_VALIDATION = "GBRTV";
    public static final String DVS_GENERATION = "GBRTG";
    public static final String DVS_EXECUTION = "GBRTE";
    public static final String DVS_REPORT = "GBRTR";
    public static final String CDI_EXECUTION = "GBRIE";
    public static final String WARNING = "W";
    public static final String ERROR = "E";
    public static final String INFO = "I";

    public static String warningToString(String module, int n) {
        if (n < 10) {
            return module + "000" + n + WARNING;
        }
        if (n < 100) {
            return module + "00" + n + WARNING;
        }
        if (n < 1000) {
            return module + "0" + n + WARNING;
        }
        return module + n + WARNING;
    }

    public static String infoToString(String module, int n) {
        if (n < 10) {
            return module + "000" + n + INFO;
        }
        if (n < 100) {
            return module + "00" + n + INFO;
        }
        if (n < 1000) {
            return module + "0" + n + INFO;
        }
        return module + n + INFO;
    }

    public static String errorToString(String module, int n) {
        if (n < 10) {
            return module + "000" + n + ERROR;
        }
        if (n < 100) {
            return module + "00" + n + ERROR;
        }
        if (n < 1000) {
            return module + "0" + n + ERROR;
        }
        return module + n + ERROR;
    }

    public static boolean isValid(String code) {
        if (code == null || code.length() != 10) {
            return false;
        }
        String module = code.substring(0, 5);
        if (!(module.equals(XU) || module.equals(HTDS) || module.equals(RULE_SESSION) || module.equals(CONSOLE) || module.equals(JSR94) || module.equals(COMMON) || module.equals(DVS_COMMON) || module.equals(DVS_VALIDATION) || module.equals(DVS_GENERATION) || module.equals(DVS_EXECUTION) || module.equals(DVS_REPORT) || module.equals(CDI_EXECUTION))) {
            return false;
        }
        if (!(Character.isDigit(code.charAt(5)) && Character.isDigit(code.charAt(6)) && Character.isDigit(code.charAt(7)) && Character.isDigit(code.charAt(8)))) {
            return false;
        }
        String t = "" + code.charAt(9);
        return t.equals(WARNING) || t.equals(ERROR) || t.equals(INFO);
    }
}

