/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.internal;

import com.ibm.rules.res.message.internal.LocalizedException;
import com.ibm.rules.res.model.XOMLibraryId;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.internal.XOMLibraryIdImpl;
import com.ibm.rules.res.model.internal.XOMResourceIdImpl;
import com.ibm.rules.res.util.internal.StringUtil;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrModelImplLocalization;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import java.util.regex.Matcher;

public class XOMInternalNameUtil
extends StringUtil {
    public static IlrVersion computeLibLastestVersion(Set<XOMLibraryId> libraries, String name) {
        IlrVersion latestVersion = null;
        for (XOMLibraryId libraryId : libraries) {
            if (name != null && !libraryId.getName().equals(name)) continue;
            if (latestVersion == null) {
                latestVersion = libraryId.getVersion();
                continue;
            }
            if (latestVersion.compareTo(libraryId.getVersion()) >= 0) continue;
            latestVersion = libraryId.getVersion();
        }
        return latestVersion;
    }

    public static IlrVersion computeResLastestVersion(Set<XOMResourceId> resources, String name) {
        IlrVersion latestVersion = null;
        for (XOMResourceId resourceId : resources) {
            if (name != null && !resourceId.getName().equals(name)) continue;
            if (latestVersion == null) {
                latestVersion = resourceId.getVersion();
                continue;
            }
            if (latestVersion.compareTo(resourceId.getVersion()) >= 0) continue;
            latestVersion = resourceId.getVersion();
        }
        return latestVersion;
    }

    public static XOMLibraryId getXOMLibraryId(String internalName) throws IlrFormatException {
        return XOMInternalNameUtil.getXOMLibraryId(internalName, null);
    }

    public static XOMLibraryIdImpl getXOMLibraryId(String internalName, Date date) throws IlrFormatException {
        if (internalName == null) {
            return null;
        }
        Matcher m = PATTERN_WITHOUT_VERSION.matcher(internalName);
        if (!m.matches()) {
            throw new IlrFormatException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.TRANSLATE_LIBRARY_ERROR, new String[]{internalName});
        }
        String name = m.group(1);
        String majorVersion = null;
        String minorVersion = null;
        Matcher mVersion = PATTERN_WITH_VERSION.matcher(name);
        if (mVersion.matches()) {
            name = mVersion.group(1);
            majorVersion = mVersion.group(3);
            minorVersion = mVersion.group(4);
        }
        IlrVersion version = null;
        if (majorVersion != null && minorVersion != null) {
            try {
                version = new IlrVersion(Integer.parseInt(majorVersion), Integer.parseInt(minorVersion));
            }
            catch (NumberFormatException e) {
                throw new IlrFormatException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.TRANSLATE_LIBRARY_ERROR, new String[]{internalName});
            }
        }
        XOMLibraryIdImpl result = new XOMLibraryIdImpl(name, version);
        result.setDate(date);
        return result;
    }

    public static XOMResourceId getXOMResourceId(String internalName) throws IlrFormatException {
        if (internalName == null) {
            return null;
        }
        Matcher m = PATTERN_WITHOUT_VERSION.matcher(internalName = internalName.trim());
        if (!m.matches()) {
            throw new IlrFormatException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.TRANSLATE_RESOURCE_ERROR, new String[]{internalName});
        }
        String name = m.group(1);
        String majorVersion = null;
        String minorVersion = null;
        Matcher mVersion = PATTERN_WITH_VERSION.matcher(name);
        if (mVersion.matches()) {
            name = mVersion.group(1);
            majorVersion = mVersion.group(3);
            minorVersion = mVersion.group(4);
        }
        if (!name.toLowerCase().endsWith(".jar") && !name.toLowerCase().endsWith(".zip")) {
            throw new IlrFormatException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.TRANSLATE_RESOURCE_ERROR, new String[]{name});
        }
        IlrVersion version = null;
        if (majorVersion != null && minorVersion != null) {
            try {
                version = new IlrVersion(Integer.parseInt(majorVersion), Integer.parseInt(minorVersion));
            }
            catch (NumberFormatException e) {
                throw new IlrFormatException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.TRANSLATE_RESOURCE_ERROR, new String[]{internalName});
            }
        }
        return new XOMResourceIdImpl(name, version);
    }

    public static String getInternalName(XOMResourceId resourceId) {
        if (resourceId == null) {
            return null;
        }
        if (resourceId.getName() == null) {
            return null;
        }
        IlrVersion version = resourceId.getVersion();
        return resourceId.getName() + (version == null ? "" : "/" + version);
    }

    public static IlrVersion toVersion(String version) {
        if (version == null) {
            return null;
        }
        Matcher m = PATTERN_VERSION.matcher(version);
        if (!m.matches()) {
            return null;
        }
        return new IlrVersion(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
    }

    public static String getNameAsFile(String name, IlrVersion version) {
        if (version == null) {
            return name;
        }
        String[] nameAndExtension = XOMInternalNameUtil.splitNameAndExtension(name);
        return nameAndExtension[0] + (version == null ? "" : "_" + version) + (nameAndExtension[1] != null ? "." + nameAndExtension[1] : "");
    }

    public static XOMResourceId fromNameAsFile(String fileName) {
        try {
            String[] nameAndExtension = XOMInternalNameUtil.splitNameAndExtension(fileName);
            String rootName = nameAndExtension[0];
            int indexUnderscore = rootName.lastIndexOf("_");
            String initialJarName = rootName.substring(0, indexUnderscore);
            String version = rootName.substring(indexUnderscore);
            String extension = nameAndExtension[1];
            return new XOMResourceIdImpl(initialJarName + (extension == null ? "" : "." + extension), XOMInternalNameUtil.toVersion(version));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IlrVersion nextVersion(IlrVersion version, boolean major) {
        if (version == null) {
            return new IlrVersion(1, 0);
        }
        if (major) {
            return new IlrVersion(version.getMajor() + 1, 0);
        }
        return new IlrVersion(version.getMajor(), version.getMinor() + 1);
    }

    public static boolean validateURL(String url) throws LocalizedException {
        if (url == null || url.length() == 0) {
            throw new LocalizedException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.ERROR_EMPTY_URL, null);
        }
        if (url.startsWith("reslib://")) {
            try {
                XOMInternalNameUtil.getXOMLibraryId(url.substring(XOMLibraryId.RES_LIB_PROTOCOL_START_LENGTH));
            }
            catch (Exception e) {
                throw new LocalizedException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.ERROR_WRONG_RESLIB, new String[]{url});
            }
        }
        if (url.startsWith("resuri://")) {
            try {
                XOMInternalNameUtil.getXOMResourceId(url.substring(XOMResourceId.RES_URI_PROTOCOL_START_LENGTH));
            }
            catch (Exception e) {
                throw new LocalizedException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.ERROR_WRONG_RESURI, new String[]{url});
            }
        }
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new LocalizedException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.ERROR_WRONG_URL, new String[]{e.getMessage()});
        }
        return true;
    }

    public static Object translateURL(String url) throws LocalizedException {
        if (url == null || url.length() == 0) {
            throw new LocalizedException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.ERROR_EMPTY_URL, null);
        }
        if (url.startsWith("reslib://")) {
            try {
                return XOMInternalNameUtil.getXOMLibraryId(url.substring(XOMLibraryId.RES_LIB_PROTOCOL_START_LENGTH));
            }
            catch (Exception e) {
                throw new LocalizedException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.ERROR_WRONG_RESLIB, new String[]{url});
            }
        }
        if (url.startsWith("resuri://")) {
            try {
                return XOMInternalNameUtil.getXOMResourceId(url.substring(XOMResourceId.RES_URI_PROTOCOL_START_LENGTH));
            }
            catch (Exception e) {
                throw new LocalizedException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.ERROR_WRONG_RESURI, new String[]{url});
            }
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new LocalizedException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.ERROR_WRONG_URL, new String[]{e.getMessage()});
        }
    }

    public static String getInternalName(XOMLibraryId libraryId) {
        if (libraryId == null) {
            return null;
        }
        if (libraryId.getName() == null) {
            return null;
        }
        IlrVersion version = libraryId.getVersion();
        return libraryId.getName() + (version == null ? "" : "/" + version);
    }
}

