/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.internal;

import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.internal.XOMInternalNameUtil;
import ilog.rules.res.model.IlrVersion;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class XOMResourceIdImpl
implements XOMResourceId {
    private static final long serialVersionUID = -9041855360013975520L;
    public static final char RESOURCE_ID_SEPARATOR = ',';
    protected String name;
    protected IlrVersion version;
    protected byte[] sha1;
    protected String internalName;
    protected Date date;
    protected String loadingInfo;

    public XOMResourceIdImpl(String name, IlrVersion version) {
        this.name = name;
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IlrVersion getVersion() {
        return this.version;
    }

    @Override
    public byte[] getSHA1() {
        return this.sha1;
    }

    public void setSHA1(byte[] sha1) {
        this.sha1 = sha1;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getInternalName() {
        if (this.internalName == null) {
            this.internalName = XOMInternalNameUtil.getInternalName(this);
        }
        return this.internalName;
    }

    public String getLoadingInfo() {
        return this.loadingInfo;
    }

    public void setLoadingInfo(String loadingInfo) {
        this.loadingInfo = loadingInfo;
    }

    public String toString() {
        return this.getInternalName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XOMResourceId)) {
            return false;
        }
        XOMResourceId other = (XOMResourceId)obj;
        if (this == obj) {
            return true;
        }
        if (this.sha1 == null || other.getSHA1() == null || Arrays.equals(this.sha1, other.getSHA1())) {
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + (this.name == null ? 0 : this.name.hashCode());
        hash = hash * 31 + (this.sha1 == null ? 0 : Arrays.hashCode(this.sha1));
        return hash;
    }

    @Override
    public int compareTo(XOMResourceId other) {
        if (this.name == null) {
            if (other.getName() != null) {
                return 1;
            }
            if (this.version == null) {
                if (other.getVersion() != null) {
                    return 1;
                }
                return 0;
            }
            if (other.getVersion() == null) {
                return -1;
            }
            return this.version.compareTo(other.getVersion());
        }
        if (other.getName() == null) {
            return -1;
        }
        if (!this.name.equals(other.getName())) {
            return this.name.compareTo(other.getName());
        }
        if (this.version == null) {
            if (other.getVersion() != null) {
                return 1;
            }
            return 0;
        }
        if (other.getVersion() == null) {
            return -1;
        }
        return this.version.compareTo(other.getVersion());
    }

    public static String getResouceListAsString(List<XOMResourceId> resourceList) {
        StringBuffer result = new StringBuffer();
        String internalName = null;
        for (XOMResourceId resourceID : resourceList) {
            if (internalName != null) {
                result.append(',');
            }
            internalName = "resuri://" + XOMInternalNameUtil.getInternalName(resourceID);
            result.append(internalName);
        }
        return result.toString();
    }
}

