/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.internal;

import com.ibm.rules.res.message.internal.LocalizedException;
import com.ibm.rules.res.model.ResourceRuntimeException;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.XOMResourceInformation;
import com.ibm.rules.res.model.internal.XOMResourceIdImpl;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import java.util.Arrays;

public class XOMResourceInformationImpl
extends XOMResourceIdImpl
implements XOMResourceInformation {
    private static final long serialVersionUID = 1L;
    private byte[] data;
    private XOMRepositoryDAO repositoryDAO;

    public XOMResourceInformationImpl(XOMResourceId resourceId, byte[] data) {
        super(resourceId.getName(), resourceId.getVersion());
        this.data = data;
    }

    public XOMResourceInformationImpl(XOMResourceId resourceId, XOMRepositoryDAO repositoryDAO) {
        super(resourceId.getName(), resourceId.getVersion());
        this.repositoryDAO = repositoryDAO;
    }

    public XOMResourceInformationImpl(String name, byte[] data) {
        super(name, null);
        this.data = data;
    }

    @Override
    public byte[] getData() throws ResourceRuntimeException {
        if (this.data == null && this.repositoryDAO != null) {
            try {
                this.repositoryDAO.getContent(this);
            }
            catch (LocalizedException e) {
                throw new ResourceRuntimeException(e);
            }
        }
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XOMResourceInformation)) {
            return false;
        }
        XOMResourceInformation other = (XOMResourceInformation)obj;
        if (!this.equals(other.getName(), this.getName())) {
            return false;
        }
        if (!this.equals(other.getDate(), this.getDate())) {
            return false;
        }
        if (!Arrays.equals(other.getSHA1(), this.getSHA1())) {
            return false;
        }
        return Arrays.equals(other.getData(), this.getData());
    }

    private boolean equals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 != null) {
            return false;
        }
        if (obj1 != null && obj2 == null) {
            return false;
        }
        if (obj1 == null && obj2 == null) {
            return true;
        }
        return obj1.equals(obj2);
    }
}

