/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.model.rest;

import com.ibm.rules.res.model.rest.Parts;
import com.ibm.rules.res.model.rest.Ruleset;
import com.ibm.rules.res.model.rest.Signature;
import com.ibm.rules.rest.HTTPError;
import com.ibm.rules.rest.RESTCollection;
import com.ibm.rules.rest.RESTProperties;
import com.ibm.rules.rest.io.RESTCollectionJsonSerializer;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.internal.IlrRESArchiveUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@XmlRootElement(name="rulesets")
@JsonSerialize(using=RESTCollectionJsonSerializer.class)
public class Rulesets
extends RESTCollection<IlrMutableRulesetArchiveInformation, Ruleset> {
    public static Rulesets DEFAULT_IN_INSTANCE;
    public static Rulesets DEFAULT_OUT_INSTANCE;
    private Parts parts;
    private IlrMutableRuleAppInformation ruleApp;
    private Collection<Ruleset> rulesets;

    public Rulesets() {
    }

    public Rulesets(IlrMutableRuleAppInformation ruleApp, Locale locale, Parts parts) {
        super(locale);
        this.ruleApp = ruleApp;
        this.parts = parts;
    }

    @XmlElement(name="ruleset")
    public Collection<Ruleset> getRulesets() {
        if (this.rulesets != null) {
            return this.rulesets;
        }
        if (this.ruleApp == null) {
            this.rulesets = new ArrayList<Ruleset>();
            return this.rulesets;
        }
        return this.getRESTCollection();
    }

    public void setRulesets(Collection<Ruleset> rulesets) {
        this.rulesets = rulesets;
    }

    @Override
    @JsonIgnore
    public Collection<IlrMutableRulesetArchiveInformation> getInitialCollection() {
        if (this.ruleApp != null) {
            Set<IlrMutableRulesetArchiveInformation> initialCollection = this.ruleApp.getRulesets();
            return initialCollection;
        }
        return null;
    }

    @Override
    public Ruleset toRESTObject(IlrMutableRulesetArchiveInformation internalObject, Locale locale) {
        return Rulesets.toRESTObject(internalObject, locale, this.parts);
    }

    public static Ruleset toRESTObject(IlrMutableRulesetArchiveInformation internalObject, Locale locale, Parts parts) {
        IlrRESRulesetArchive tmp;
        if (internalObject == null) {
            return null;
        }
        Ruleset result = new Ruleset(internalObject);
        if (internalObject.getCanonicalPath() != null) {
            result.setId(internalObject.getCanonicalPath().toString().substring(1));
        }
        if (parts.isDisplayed("name")) {
            result.setName(internalObject.getName());
        }
        if (parts.isDisplayed("version")) {
            result.setVersion(internalObject.getVersion().toString());
        }
        if (parts.isDisplayed("creationDate")) {
            result.setCreationDate(internalObject.getCreationDate());
        }
        if (parts.isDisplayed("description")) {
            result.setDescription(internalObject.getDescription() == null ? "" : internalObject.getDescription());
        }
        if (parts.isDisplayed("displayName")) {
            result.setDisplayName(internalObject.getDisplayName());
        }
        if (parts.isDisplayed("properties")) {
            result.setProperties(new RESTProperties(internalObject.getProperties(), locale));
        }
        if (parts.isPart("archive")) {
            try {
                result.setByteArchive(IlrRESArchiveUtil.getRESRulesetArchiveAsBytes(internalObject.getRESRulesetArchive()));
            }
            catch (IOException e) {
                throw new HTTPError(500, e);
            }
        }
        if (parts.isPart("signature") && (tmp = internalObject.getRESRulesetArchive()) != null) {
            result.setSignature(new Signature(tmp.getRulesetParameters(), locale));
        }
        return result;
    }

    @Override
    public Collection<Ruleset> getForcedRESTCollection() {
        return this.rulesets;
    }

    static {
        ArrayList<Ruleset> collin = new ArrayList<Ruleset>();
        collin.add(Ruleset.DEFAULT_IN_INSTANCE);
        DEFAULT_IN_INSTANCE = new Rulesets();
        DEFAULT_IN_INSTANCE.setRulesets(collin);
        ArrayList<Ruleset> collout = new ArrayList<Ruleset>();
        collout.add(Ruleset.DEFAULT_OUT_INSTANCE);
        DEFAULT_OUT_INSTANCE = new Rulesets();
        DEFAULT_OUT_INSTANCE.setRulesets(collout);
    }
}

