/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.persistence.internal.XOMRepositoryDAOFactoryImpl;
import com.ibm.rules.res.persistence.internal.file.FileXOMRepositoryDAO;
import ilog.rules.crypto.IlrEncryptionService;
import ilog.rules.crypto.IlrEncryptionServiceException;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.IlrRepositoryDAOFactoryImpl;
import ilog.rules.res.persistence.impl.file.IlrFileRepositoryDAO;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class DAOLoader<T> {
    private static final RESLogger LOGGER = RESLogger.getRESLogger("com.ibm.rules.res.persistence", "ilog.rules.res.persistence.impl.messages");
    public static final String PERSISTENCE_DAO_NAME = "persistence";
    public static final String XOM_PERSISTENCE_DAO_NAME = "xomPersistence";
    public static final Properties PERSISTENCE_ALIAS = new Properties();
    public static final Properties PERSISTENCE_PROPERTY_ALIAS = new Properties();
    public static final Properties XOM_PERSISTENCE_ALIAS = new Properties();
    public static final Properties XOM_PERSISTENCE_PROPERTY_ALIAS = new Properties();
    private static final String TYPE_POSTFIX = "Type";
    private static final String PROPERTIES_POSTFIX = "Properties";
    private static final String CUSTOM_PREFIX = "custom";
    private static final String INITIALIZE_METHOD_NAME = "initialize";
    private static final String SET_CLASS_LOADER_METHOD_NAME = "setClassLoader";
    protected ClassLoader classLoader;
    protected String directory;
    protected String driverClassName;
    protected String url;
    protected String user;
    protected transient String password;
    protected String cryptedPassword;
    protected String jndiName;
    protected boolean expanded;
    protected boolean transacted;

    public DAOLoader() {
        PERSISTENCE_ALIAS.put("file", DAOLoader.class.getName());
        PERSISTENCE_ALIAS.put("jdbc", DAOLoader.class.getName());
        PERSISTENCE_ALIAS.put("datasource", DAOLoader.class.getName());
        PERSISTENCE_PROPERTY_ALIAS.put("rulesetArchiveExpanded", "filePersistenceExpanded");
        XOM_PERSISTENCE_ALIAS.put("file", DAOLoader.class.getName());
        XOM_PERSISTENCE_ALIAS.put("jdbc", DAOLoader.class.getName());
        XOM_PERSISTENCE_ALIAS.put("datasource", DAOLoader.class.getName());
        XOM_PERSISTENCE_PROPERTY_ALIAS.put("XOM_PERSISTENCE_TYPE", "xomPersistenceType");
        XOM_PERSISTENCE_PROPERTY_ALIAS.put("XOM_PERSISTENCE_DIRECTORY", "fileXomPersistenceDirectory");
        XOM_PERSISTENCE_PROPERTY_ALIAS.put("XOM_PERSISTENCE_USER", "jdbcXomPersistenceUser");
        XOM_PERSISTENCE_PROPERTY_ALIAS.put("XOM_PERSISTENCE_PASSWORD", "jdbcXomPersistencePassword");
        XOM_PERSISTENCE_PROPERTY_ALIAS.put("XOM_PERSISTENCE_DRIVER_CLASS_NAME", "jdbcXomPersistenceDriverClassName");
        XOM_PERSISTENCE_PROPERTY_ALIAS.put("XOM_PERSISTENCE_URL", "jdbcXomPersistenceUrl");
        XOM_PERSISTENCE_PROPERTY_ALIAS.put("XOM_PERSISTENCE_CRYPTED_PASSWORD", "jdbcXomPersistenceCryptedPassword");
        XOM_PERSISTENCE_PROPERTY_ALIAS.put("XOM_PERSISTENCE_JNDI_NAME", "datasourceXomPersistenceJndiName");
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public T getDAO(String name, Properties alias, Properties propertyAlias, Map<String, String> props) throws IlrDAOException {
        Object dao;
        block33: {
            Method method;
            String key;
            int equalIndex;
            String typeKey;
            String typeValue;
            String propListAsString = this.findPropertyIgnoreCase(name + PROPERTIES_POSTFIX, props, propertyAlias);
            Map<String, String> propertyList = null;
            if (propListAsString != null) {
                propertyList = this.toMap(propListAsString);
            }
            if ((typeValue = this.findPropertyIgnoreCase(typeKey = name + TYPE_POSTFIX, props, propertyAlias)) == null) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.UNABLE_TO_FIND_PERSISTENCE_TYPE, new String[]{typeKey, props.keySet().toString()});
            }
            String aliasValue = alias.getProperty(typeValue);
            Class<?> clazz = null;
            if (aliasValue != null) {
                try {
                    clazz = Class.forName(aliasValue);
                }
                catch (ClassNotFoundException e) {
                    throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.CANNOT_FIND_DAO_CLASS, new String[]{aliasValue, name});
                }
            }
            String customValue = typeValue.trim();
            if (typeValue.trim().startsWith(CUSTOM_PREFIX) && (equalIndex = typeValue.indexOf(61)) != -1) {
                customValue = typeValue.substring(equalIndex + 1).trim();
            }
            typeValue = CUSTOM_PREFIX;
            try {
                clazz = Class.forName(customValue);
            }
            catch (ClassNotFoundException e) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.CANNOT_FIND_DAO_CLASS, new String[]{customValue, name});
            }
            dao = null;
            Object builder = null;
            try {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                builder = constructor.newInstance(new Object[0]);
            }
            catch (SecurityException e) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.UNEXPECTED_EXCEPTION_DURING_DAO_CREATION_CLASS, new String[]{name, clazz.getName()}, e);
            }
            catch (NoSuchMethodException e) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.NO_DEFAULT_CONSTRUCTOR, new String[]{clazz.getName()});
            }
            catch (IllegalArgumentException e) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.UNEXPECTED_EXCEPTION_DURING_DAO_CREATION_CLASS, new String[]{name, clazz.getName()}, e);
            }
            catch (InstantiationException e) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.UNEXPECTED_EXCEPTION_DURING_DAO_CREATION_CLASS, new String[]{name, clazz.getName()}, e);
            }
            catch (IllegalAccessException e) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.UNEXPECTED_EXCEPTION_DURING_DAO_CREATION_CLASS, new String[]{name, clazz.getName()}, e);
            }
            catch (InvocationTargetException e) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.UNEXPECTED_EXCEPTION_DURING_DAO_CREATION_CLASS, new String[]{name, clazz.getName()}, e.getCause());
            }
            String propertyStart = typeValue + name;
            Set<Map.Entry<String, String>> entrySet = props.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                key = entry.getKey();
                String aliasName = (String)propertyAlias.get(key);
                if (aliasName != null) {
                    key = aliasName;
                }
                if (!key.toLowerCase().startsWith(propertyStart.toLowerCase())) continue;
                String value = entry.getValue();
                String methodName = this.getMethodName(key.toLowerCase().substring(propertyStart.length()));
                try {
                    Method method2 = this.findMethodIgnoreCase(methodName, clazz);
                    method2.invoke(builder, value);
                }
                catch (Exception e) {}
            }
            if (propertyList != null) {
                for (Map.Entry<String, String> entry : propertyList.entrySet()) {
                    key = entry.getKey();
                    String value = entry.getValue();
                    String methodName = this.getMethodName(key);
                    try {
                        Method method3 = this.findMethodIgnoreCase(methodName, clazz);
                        method3.invoke(builder, value);
                    }
                    catch (Exception e) {}
                }
            }
            if (this.classLoader != null) {
                try {
                    method = clazz.getMethod(SET_CLASS_LOADER_METHOD_NAME, ClassLoader.class);
                    dao = builder;
                    method.invoke(builder, this.classLoader);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            try {
                method = null;
                try {
                    method = clazz.getMethod(INITIALIZE_METHOD_NAME, String.class, String.class);
                    Class<?> returnType = method.getReturnType();
                    if (returnType != Void.TYPE) {
                        dao = method.invoke(builder, name, typeValue);
                        break block33;
                    }
                    dao = builder;
                    method.invoke(builder, name, typeValue);
                }
                catch (NoSuchMethodException e) {
                    method = clazz.getMethod(INITIALIZE_METHOD_NAME, new Class[0]);
                    Class<?> returnType = method.getReturnType();
                    if (returnType != Void.TYPE) {
                        dao = method.invoke(builder, new Object[0]);
                        break block33;
                    }
                    dao = builder;
                    method.invoke(builder, new Object[0]);
                }
            }
            catch (NoSuchMethodException e) {
                dao = builder;
            }
            catch (Exception e) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.UNEXPECTED_EXCEPTION_DURING_DAO_CREATION, new String[]{name}, e);
            }
        }
        return (T)dao;
    }

    protected Map<String, String> toMap(String pinput) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (pinput == null) {
            return properties;
        }
        int i = 0;
        String input = pinput.trim();
        int length = input.length();
        while (i < length) {
            String key = "";
            String value = "";
            int startKey = i;
            int nbEscape = 0;
            while (i < length && (input.charAt(i) != '=' && input.charAt(i) != ',' || (nbEscape & 1) > 0)) {
                nbEscape = input.charAt(i) == '\\' ? ++nbEscape : 0;
                ++i;
            }
            int endKey = i;
            key = input.substring(startKey, endKey);
            key = key.trim();
            if (i < length && input.charAt(i) == '=' && (nbEscape & 1) == 0) {
                int startValue = ++i;
                nbEscape = 0;
                while (i < length && (input.charAt(i) != ',' || (nbEscape & 1) > 0)) {
                    nbEscape = input.charAt(i) == '\\' ? ++nbEscape : 0;
                    ++i;
                }
                int endValue = i;
                value = input.substring(startValue, endValue);
                value = value.trim();
            }
            ++i;
            StringBuffer keyRes = new StringBuffer(key);
            for (int j = 0; j < keyRes.length(); ++j) {
                if (keyRes.charAt(j) != '\\') continue;
                keyRes.deleteCharAt(j);
            }
            StringBuffer valueRes = new StringBuffer(value);
            for (int j = 0; j < valueRes.length(); ++j) {
                if (valueRes.charAt(j) != '\\') continue;
                valueRes.deleteCharAt(j);
            }
            if (keyRes.toString().equals("")) continue;
            properties.put(keyRes.toString(), valueRes.toString());
        }
        return properties;
    }

    protected Properties parse(String input) {
        Properties properties = new Properties();
        Map<String, String> map = this.toMap(input);
        for (String key : map.keySet()) {
            String value = map.get(key);
            properties.put(key, value);
        }
        return properties;
    }

    protected String getMethodName(String initialName) {
        initialName = initialName.trim();
        StringBuffer result = new StringBuffer();
        result.append("set");
        boolean start = true;
        for (int i = 0; i < initialName.length(); ++i) {
            char ch = initialName.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                if (start) {
                    result.append(Character.toUpperCase(ch));
                    start = false;
                    continue;
                }
                result.append(Character.toLowerCase(ch));
                continue;
            }
            if (ch != '_' && ch != '-' && ch != '.') continue;
            start = true;
        }
        return result.toString();
    }

    protected String flatKeyList(Properties properties) {
        Set<Object> keySet = properties.keySet();
        StringBuffer result = new StringBuffer();
        for (Object key : keySet) {
            result.append(key).append(", ");
        }
        return result.toString();
    }

    protected String findPropertyIgnoreCase(String propertyName, Map<String, String> props, Properties aliasProp) {
        Set<Map.Entry<String, String>> entrySet = props.entrySet();
        String result = null;
        for (Map.Entry<String, String> entry : entrySet) {
            String key = entry.getKey();
            String alias = aliasProp.getProperty(key);
            if (alias != null) {
                key = alias;
            }
            if (!key.toLowerCase().equals(propertyName.toLowerCase())) continue;
            result = entry.getValue();
            break;
        }
        return result;
    }

    protected Method findMethodIgnoreCase(String name, Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        Method result = null;
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] paramTypes;
            Method m = methods[i];
            if (!m.getName().equalsIgnoreCase(name) || (paramTypes = m.getParameterTypes()).length != 1) continue;
            result = m;
            break;
        }
        return result;
    }

    public void setDirectory(String value) {
        if (value != null && value.length() > 0) {
            this.directory = value;
        }
    }

    public void setDriverClassName(String value) {
        if (value != null && value.length() > 0) {
            this.driverClassName = value;
        }
    }

    public void setUrl(String value) {
        if (value != null && value.length() > 0) {
            this.url = value;
        }
    }

    public void setUser(String value) {
        if (value != null && value.length() > 0) {
            this.user = value;
        }
    }

    public void setPassword(String value) {
        if (value != null && value.length() > 0) {
            this.password = value;
        }
    }

    public void setExpanded(String value) {
        if (value != null && value.length() > 0) {
            this.expanded = true;
        }
    }

    public void setTransactional(String value) {
        if (value != null && value.equalsIgnoreCase("true")) {
            this.transacted = true;
        }
    }

    public void setCryptedPassword(String value) {
        if (value != null && value.length() > 0) {
            try {
                this.password = IlrEncryptionService.getInstance().decrypt(value);
            }
            catch (IlrEncryptionServiceException e) {
                LOGGER.log(Level.SEVERE, IlrDAOLocalization.ERROR_DECRYPTING_PASSWORD, null, e);
            }
        }
    }

    public void setJndiName(String value) throws IlrEncryptionServiceException {
        if (value != null && value.length() > 0) {
            this.jndiName = value;
        }
    }

    public Object initialize(String name, String type) throws Exception {
        Object result = null;
        if (PERSISTENCE_DAO_NAME.equals(name)) {
            IlrRepositoryDAOFactoryImpl daoFactory = new IlrRepositoryDAOFactoryImpl();
            if ("file".equals(type)) {
                result = new IlrFileRepositoryDAO(this.classLoader, this.directory, this.expanded);
            } else if ("datasource".equals(type)) {
                result = daoFactory.getDataSourceRepositoryDAO(this.transacted);
            } else if ("jdbc".equals(type)) {
                result = daoFactory.getDriverRepositoryDAO(this.classLoader, this.driverClassName, this.url, this.user, this.password, this.cryptedPassword);
            }
        } else if (XOM_PERSISTENCE_DAO_NAME.equals(name)) {
            XOMRepositoryDAOFactoryImpl xomDaoFactory = new XOMRepositoryDAOFactoryImpl();
            if ("file".equals(type)) {
                result = new FileXOMRepositoryDAO(this.directory);
            } else if ("datasource".equals(type)) {
                result = xomDaoFactory.getDataSourceRepositoryDAO(this.jndiName, this.transacted);
            } else if ("jdbc".equals(type)) {
                result = xomDaoFactory.getDriverRepositoryDAO(this.classLoader, this.driverClassName, this.url, this.user, this.password);
            }
        }
        return result;
    }
}

