/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.model.XOMLibraryId;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.internal.XOMInternalNameUtil;
import com.ibm.rules.res.model.internal.XOMLibraryIdImpl;
import com.ibm.rules.res.model.internal.XOMResourceIdImpl;
import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.XOMRepositoryDAO;
import com.ibm.rules.res.persistence.internal.XOMClassLoader;
import com.ibm.rules.res.persistence.internal.XOMLibraryIdPath;
import com.ibm.rules.res.persistence.internal.XOMLoadingCaller;
import com.ibm.rules.res.persistence.internal.XOMResourceIdURL;
import com.ibm.rules.res.persistence.internal.file.FileXOMRepositoryDAO;
import com.ibm.rules.res.persistence.internal.security.URLPrivilegedAction;
import com.ibm.rules.res.persistence.internal.security.XOMClassLoaderPrivilegedAction;
import com.ibm.rules.res.urlhandler.PreLoadedURLStreamHandler;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrRulesetArchivePropertiesImpl;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.persistence.IlrResourceNotFoundDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandler;
import java.security.PrivilegedActionException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class XOMClassLoaderFactory
implements XOMLoadingCaller {
    private static final RESLogger logger = RESLogger.getRESLogger("com.ibm.rules.res.persistence", "ilog.rules.res.persistence.impl.messages");
    public static final String TMP_LIBRARY_NAME = "<TMP>";
    private String[] tmpLibraryContent = null;
    private XOMRepositoryDAO xomRepository;

    public static void displayInfoTrace(boolean parentFirst, IlrPath rulesetPath, String asciiDependencyTree) {
        if (parentFirst) {
            logger.log(Level.INFO, IlrDAOLocalization.INFO_PARENT_FIRST, new Object[]{rulesetPath, asciiDependencyTree}, null);
        } else {
            logger.log(Level.INFO, IlrDAOLocalization.INFO_PARENT_LAST, new Object[]{rulesetPath, asciiDependencyTree}, null);
        }
    }

    public URL getURL(XOMResourceId resourceId, boolean lazyLoading) throws MalformedURLException, IlrResourceNotFoundDAOException, DAOException {
        URL result = null;
        result = resourceId instanceof XOMResourceIdURL ? ((XOMResourceIdURL)resourceId).getURL() : (resourceId instanceof XOMResourceIdImpl ? (lazyLoading ? this.getPrivilegedURL(((XOMResourceIdImpl)resourceId).getInternalName(), new com.ibm.rules.res.urlhandler.URLStreamHandler(this.xomRepository)) : this.getPrivilegedURL(((XOMResourceIdImpl)resourceId).getInternalName(), new PreLoadedURLStreamHandler(this.xomRepository.getContent(resourceId)))) : (lazyLoading ? this.getPrivilegedURL(XOMInternalNameUtil.getInternalName(resourceId), new com.ibm.rules.res.urlhandler.URLStreamHandler(this.xomRepository)) : this.getPrivilegedURL(XOMInternalNameUtil.getInternalName(resourceId), new PreLoadedURLStreamHandler(this.xomRepository.getContent(resourceId)))));
        return result;
    }

    private URL getPrivilegedURL(String internalName, URLStreamHandler handlerToCreate) {
        URL result = null;
        StringBuilder urlToCreate = new StringBuilder("resuri://");
        urlToCreate.append(internalName);
        urlToCreate.append("/");
        try {
            result = URLPrivilegedAction.execute(urlToCreate.toString(), handlerToCreate);
        }
        catch (PrivilegedActionException e) {
            result = null;
        }
        return result;
    }

    public ClassLoader getManagedXOMClassLoader(IlrPath path, IlrRepositoryDAO repository, XOMRepositoryDAO xomRepository, ClassLoader xomcl, boolean clientFirst, boolean lazyLoading) throws IlrDAOException, DAOException, IlrResourceNotFoundDAOException {
        IlrRulesetArchivePropertiesImpl properties = new IlrRulesetArchivePropertiesImpl(repository.getProperties(path));
        this.xomRepository = xomRepository;
        String[] strings = properties.getManagedXOMURIs();
        StringBuffer asciiDependencyTree = new StringBuffer();
        try {
            if (strings == null || strings.length == 0 || strings.length == 1 && strings[0].equals("resuri")) {
                if (path != null) {
                    if (xomRepository == null) {
                        logger.warning(IlrDAOLocalization.ERROR_COULD_NOT_READ_INTERNAL_PROTOCOL_URL_REPO_NOT_SET, new Object[]{strings != null ? strings[0] : null}, null);
                    } else {
                        asciiDependencyTree.append("\\- " + strings[0]);
                        if (xomRepository instanceof FileXOMRepositoryDAO) {
                            XOMLibraryIdPath library = new XOMLibraryIdPath(path);
                            library.setLoadingInfo("\\-");
                            List<XOMResourceId> resources = ((FileXOMRepositoryDAO)xomRepository).getRulesetPathContent(library);
                            if (resources != null) {
                                URL[] uris = new URL[resources.size()];
                                int index = 0;
                                for (XOMResourceId resourceId : resources) {
                                    URL url = this.getURL(resourceId, lazyLoading);
                                    if (url == null) continue;
                                    uris[index++] = url;
                                }
                                XOMClassLoader result = new XOMClassLoader(uris, clientFirst);
                                result.setDependencyTree(library.getLoadingInfo());
                                return new URLClassLoader(uris);
                            }
                        }
                    }
                }
                return null;
            }
            if (strings == null || strings.length == 0) {
                return null;
            }
            if (xomRepository == null) {
                throw new DAOException("ilog.rules.res.persistence.impl.messages", IlrDAOLocalization.XOM_REPOSITORY_NOT_SET);
            }
            XOMLibraryIdImpl tmpLibrary = new XOMLibraryIdImpl(TMP_LIBRARY_NAME, IlrVersion.parseVersion("1.0"));
            tmpLibrary.setLoadingInfo("\\-");
            this.tmpLibraryContent = strings;
            List<XOMResourceId> resources = XOMClassLoaderFactory.getContent(this, tmpLibrary);
            URL[] uris = new URL[resources.size()];
            int index = 0;
            for (XOMResourceId resourceId : resources) {
                URL url = this.getURL(resourceId, lazyLoading);
                if (url == null) continue;
                uris[index++] = url;
            }
            XOMClassLoader result = XOMClassLoaderPrivilegedAction.execute(uris, xomcl, clientFirst);
            result.setDependencyTree(tmpLibrary.getLoadingInfo().replace("reslib://<TMP>/1.0", path.toString()));
            return result;
        }
        catch (Exception e) {
            throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.GET_XOM_ERROR, new String[]{String.valueOf(path)}, e);
        }
    }

    public static List<XOMResourceId> getContent(XOMLoadingCaller caller, XOMLibraryId initialLibraryId) throws DAOException, IlrResourceNotFoundDAOException, IlrFormatException, SQLException, MalformedURLException {
        return XOMClassLoaderFactory.getContent(caller, initialLibraryId, null, true, new ArrayList<XOMLibraryId>());
    }

    public static List<XOMResourceId> getContent(XOMLoadingCaller caller, XOMLibraryId initialLibraryId, String indent, boolean lastTopic, List<XOMLibraryId> alreadyRead) throws DAOException, IlrResourceNotFoundDAOException, IlrFormatException, SQLException, MalformedURLException {
        List<String> errors = null;
        StringBuffer loadingInfo = new StringBuffer();
        XOMLibraryIdImpl localLibraryID = null;
        localLibraryID = initialLibraryId instanceof XOMLibraryIdImpl ? (XOMLibraryIdImpl)initialLibraryId : new XOMLibraryIdImpl(initialLibraryId.getName(), initialLibraryId.getVersion());
        String tmpLoadingInfo = localLibraryID.getLoadingInfo();
        if (indent == null) {
            if (tmpLoadingInfo != null) {
                indent = tmpLoadingInfo;
                if (indent.endsWith("\\-")) {
                    indent = indent.substring(0, indent.length() - 2);
                    lastTopic = true;
                } else if (indent.endsWith("+-")) {
                    indent = indent.substring(0, indent.length() - 2);
                    lastTopic = false;
                }
            } else {
                indent = "";
            }
        }
        if (localLibraryID.getVersion() == null) {
            Set<XOMLibraryId> libraries = caller.loadLibraries(localLibraryID.getName());
            IlrVersion latestVersion = XOMInternalNameUtil.computeLibLastestVersion(libraries, localLibraryID.getName());
            if (latestVersion == null) {
                loadingInfo.append(indent + (lastTopic ? "\\" : "+") + "- " + "reslib://" + initialLibraryId.toString() + " => ERROR\n");
                errors = XOMClassLoaderFactory.addError(errors, "reslib://" + initialLibraryId.toString());
            } else {
                localLibraryID = new XOMLibraryIdImpl(localLibraryID.getName(), latestVersion);
                loadingInfo.append(indent + (lastTopic ? "\\" : "+") + "- " + "reslib://" + initialLibraryId.toString() + " => " + "reslib://" + localLibraryID.toString() + "\n");
            }
        } else {
            loadingInfo.append(indent + (lastTopic ? "\\" : "+") + "- " + "reslib://" + initialLibraryId.toString() + "\n");
        }
        indent = indent + (lastTopic ? " " : "|") + "  ";
        if (alreadyRead.contains(localLibraryID)) {
            loadingInfo.append(indent + "\\- [*]\n");
            if (initialLibraryId instanceof XOMLibraryIdImpl) {
                ((XOMLibraryIdImpl)initialLibraryId).setLoadingInfo(loadingInfo.toString());
            }
            return null;
        }
        alreadyRead.add(localLibraryID);
        ArrayList<XOMResourceId> result = null;
        String[] urls = caller.getContent(localLibraryID);
        if (urls != null) {
            int index = 0;
            int urlCount = urls.length;
            result = new ArrayList<XOMResourceId>();
            for (String url : urls) {
                Collection<XOMResourceId> resources;
                String internalName;
                if (url.startsWith("reslib://")) {
                    internalName = url.substring(XOMLibraryId.RES_LIB_PROTOCOL_START_LENGTH);
                    try {
                        XOMLibraryIdImpl currentLibrary = (XOMLibraryIdImpl)XOMInternalNameUtil.getXOMLibraryId(internalName);
                        resources = XOMClassLoaderFactory.getContent(caller, currentLibrary, indent, ++index == urlCount, alreadyRead);
                        if (resources != null) {
                            result.addAll(resources);
                        }
                        loadingInfo.append(currentLibrary.getLoadingInfo());
                        continue;
                    }
                    catch (IlrFormatException e) {
                        throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.ERROR_READ_LIB, new String[]{initialLibraryId.getName()}, e);
                    }
                }
                if (url.startsWith("resuri://")) {
                    internalName = url.substring(XOMResourceId.RES_URI_PROTOCOL_START_LENGTH);
                    XOMResourceId resourceId = XOMInternalNameUtil.getXOMResourceId(internalName);
                    if (resourceId.getVersion() == null) {
                        resources = caller.loadResources(resourceId.getName());
                        IlrVersion latestVersion = XOMInternalNameUtil.computeResLastestVersion(resources, resourceId.getName());
                        if (latestVersion == null) {
                            loadingInfo.append(indent + (++index == urlCount ? "\\" : "+") + "- " + "resuri://" + internalName + " => ERROR\n");
                            errors = XOMClassLoaderFactory.addError(errors, "resuri://" + internalName);
                            continue;
                        }
                        XOMResourceIdImpl localResourceID = new XOMResourceIdImpl(resourceId.getName(), latestVersion);
                        loadingInfo.append(indent + (++index == urlCount ? "\\" : "+") + "- " + "resuri://" + internalName + " => " + "resuri://" + localResourceID.toString() + "\n");
                        result.add(localResourceID);
                        continue;
                    }
                    if (caller.isAvailable(resourceId.getName(), resourceId.getVersion()) != null) {
                        loadingInfo.append(indent + (++index == urlCount ? "\\" : "+") + "- " + "resuri://" + internalName + "\n");
                        result.add(XOMInternalNameUtil.getXOMResourceId(internalName));
                        continue;
                    }
                    loadingInfo.append(indent + (++index == urlCount ? "\\" : "+") + "- " + "resuri://" + internalName + " => ERROR\n");
                    errors = XOMClassLoaderFactory.addError(errors, "resuri://" + internalName);
                    continue;
                }
                URL realURL = new URL(url);
                loadingInfo.append(indent + (++index == urlCount ? "\\" : "+") + "- " + realURL + "\n");
                result.add(new XOMResourceIdURL(realURL.getFile(), null, realURL));
            }
        }
        if (initialLibraryId instanceof XOMLibraryIdImpl) {
            ((XOMLibraryIdImpl)initialLibraryId).setLoadingInfo(loadingInfo.toString());
        }
        if (errors != null) {
            throw IlrDAOLocalization.newIlrResourceNotFoundDAOException(IlrDAOLocalization.ERROR_LOADING_RESOURCES, new String[]{errors.toString()});
        }
        return result;
    }

    private static List<String> addError(List<String> errors, String resourceDescription) {
        if (errors == null) {
            errors = new ArrayList<String>();
        }
        errors.add(resourceDescription);
        return errors;
    }

    @Override
    public Set<XOMLibraryId> loadLibraries(String name) throws DAOException {
        return this.xomRepository.loadLibraries(name);
    }

    @Override
    public String[] getContent(XOMLibraryId library) throws DAOException {
        if (library.getName().equals(TMP_LIBRARY_NAME)) {
            return this.tmpLibraryContent;
        }
        return this.xomRepository.getContent(library);
    }

    @Override
    public Set<XOMResourceId> loadResources(String name) throws DAOException {
        return this.xomRepository.loadResources(name);
    }

    @Override
    public XOMResourceId isAvailable(String name, IlrVersion version) throws DAOException, IlrResourceNotFoundDAOException {
        return this.xomRepository.isAvailable(name, version);
    }

    public void setTmpLibraryContent(String[] tmpLibraryContent) {
        this.tmpLibraryContent = tmpLibraryContent;
    }

    public void setXomRepository(XOMRepositoryDAO xomRepository) {
        this.xomRepository = xomRepository;
    }
}

