/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.persistence.internal.jdbc;

import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.Transaction;
import com.ibm.rules.res.persistence.internal.jdbc.DAOConfigurator;
import com.ibm.rules.res.persistence.internal.jdbc.GenericDAOBase;
import com.ibm.rules.res.persistence.internal.jdbc.JDBCTransaction;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.jdbc.IlrJDBCConnectionProvider;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.sql.Statement;

public abstract class GenericDAO
extends GenericDAOBase {
    protected GenericDAO(DAOConfigurator configurator, IlrJDBCConnectionProvider connectionProvider, String schemaPrefix) {
        super(configurator, connectionProvider, schemaPrefix);
    }

    public Transaction beginTransaction() throws DAOException {
        JDBCTransaction transaction = new JDBCTransaction(this.connectionProvider);
        try {
            transaction.begin();
        }
        catch (DAOException e) {
            transaction.close();
            throw e;
        }
        return transaction;
    }

    @Override
    public void executeSQL(String sqlStatement) throws DAOException {
        JDBCTransaction tr = (JDBCTransaction)this.beginTransaction();
        Statement statement = null;
        try {
            statement = tr.getConnection().createStatement();
            statement.execute(sqlStatement);
            tr.commit();
        }
        catch (Exception e) {
            tr.rollback();
            throw IlrDAOLocalization.newDAOException(IlrDAOLocalization.EXECUTE_SQL_ERROR, new String[]{sqlStatement}, e);
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
            tr.close();
        }
    }
}

