/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.rest.internal;

import com.ibm.rules.res.message.internal.LocalizedException;
import com.ibm.rules.res.model.XOMLibraryId;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.internal.XOMInternalNameUtil;
import com.ibm.rules.res.model.internal.XOMLibraryIdImpl;
import com.ibm.rules.res.model.rest.AllRulesets;
import com.ibm.rules.res.model.rest.DeploymentReport;
import com.ibm.rules.res.model.rest.Libraries;
import com.ibm.rules.res.model.rest.Library;
import com.ibm.rules.res.model.rest.Parts;
import com.ibm.rules.res.model.rest.Resource;
import com.ibm.rules.res.model.rest.Resources;
import com.ibm.rules.res.model.rest.RuleApp;
import com.ibm.rules.res.model.rest.RuleApps;
import com.ibm.rules.res.model.rest.Ruleset;
import com.ibm.rules.res.model.rest.Rulesets;
import com.ibm.rules.res.model.rest.Signature;
import com.ibm.rules.res.persistence.DAOException;
import com.ibm.rules.res.persistence.internal.XOMClassLoaderFactory;
import com.ibm.rules.res.persistence.internal.XOMResourceIdURL;
import com.ibm.rules.res.rest.LibrariesResource;
import com.ibm.rules.res.rest.RuleAppsResource;
import com.ibm.rules.res.rest.RulesetsResource;
import com.ibm.rules.res.rest.XomsResource;
import com.ibm.rules.res.rest.internal.ServiceLocalization;
import com.ibm.rules.res.service.ManagementService;
import com.ibm.rules.res.util.internal.StreamUtil;
import com.ibm.rules.rest.HTTPError;
import com.ibm.rules.rest.RESTActionResult;
import com.ibm.rules.rest.RESTContext;
import com.ibm.rules.rest.RESTPreResponse;
import com.ibm.rules.rest.RESTProperties;
import com.ibm.rules.rest.RESTProperty;
import com.ibm.rules.rest.io.RESTRequestMultipartParser;
import com.ibm.rules.util.engine.EngineArchiveUtil;
import com.ibm.rules.util.engine.EngineType;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrCRERulesetArchive;
import ilog.rules.res.model.IlrEngineType;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrRepositoryException;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.archive.IlrArchiveException;
import ilog.rules.res.model.internal.IlrDeploymentReport;
import ilog.rules.res.model.internal.IlrMutableRepositoryImpl;
import ilog.rules.res.model.internal.IlrNameValidator;
import ilog.rules.res.model.internal.IlrRESArchiveUtil;
import ilog.rules.res.model.internal.IlrRepositoryFactoryImpl;
import ilog.rules.res.persistence.IlrResourceNotFoundDAOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ManagementServiceImpl
implements RuleAppsResource,
RulesetsResource,
XomsResource,
LibrariesResource {
    private final IlrMutableRepositoryImpl repository;
    private final ManagementService managementService;

    public ManagementServiceImpl(ManagementService managementService, IlrRepositoryFactoryImpl repositoryFactory, IlrMutableRepository repository) {
        this.repository = (IlrMutableRepositoryImpl)repository;
        this.managementService = managementService;
    }

    @Override
    public RuleApps getRuleApps(RESTContext context, String parts) {
        if (this.repository == null) {
            return null;
        }
        Parts parsedParts = new Parts(parts);
        RuleApps result = new RuleApps(this.repository, context.getLocale(), parsedParts);
        return result;
    }

    @Override
    public RuleApps getRuleAppsByName(RESTContext context, String name, String parts) {
        if (this.repository == null) {
            return null;
        }
        Parts parsedParts = new Parts(parts);
        parsedParts.addPart("name");
        RuleApps result = new RuleApps(this.repository, context.getLocale(), parsedParts);
        result.addFilter("name", name);
        return result;
    }

    @Override
    public RuleApp getRuleApp(RESTContext context, String name, String version, String parts) {
        if (this.repository == null) {
            return null;
        }
        Parts parsedParts = new Parts(parts);
        parsedParts.addPart("name");
        parsedParts.addPart("version");
        RuleApps result = new RuleApps(this.repository, context.getLocale(), parsedParts);
        result.addFilter("name", name);
        result.addFilter("version", version);
        Collection<RuleApp> ruleApps = result.getRuleApps();
        if (ruleApps.size() == 1) {
            return ruleApps.iterator().next();
        }
        return null;
    }

    @Override
    public Rulesets getRulesets(RESTContext context, String raname, String raversion, String parts) {
        if (this.repository == null) {
            return null;
        }
        Parts parsedParts = new Parts(parts);
        RuleApp result = this.getRuleApp(context, raname, raversion, null);
        if (result != null) {
            Rulesets rulesets = new Rulesets(result.getInternalObject(), context.getLocale(), parsedParts);
            return rulesets;
        }
        return null;
    }

    @Override
    public Rulesets getRulesetsByName(RESTContext context, String raname, String raversion, String rsname, String parts) {
        if (this.repository == null) {
            return null;
        }
        Parts parsedParts = new Parts(parts);
        parsedParts.addPart("name");
        RuleApp result = this.getRuleApp(context, raname, raversion, null);
        if (result != null) {
            Rulesets rulesets = new Rulesets(result.getInternalObject(), context.getLocale(), parsedParts);
            rulesets.addFilter("name", rsname);
            return rulesets;
        }
        return null;
    }

    @Override
    public Ruleset getRuleset(RESTContext context, String raname, String raversion, String rsname, String rsversion, String parts) {
        RuleApp ruleApp = this.getRuleApp(context, raname, raversion, parts);
        if (ruleApp == null) {
            return null;
        }
        Parts parsedParts = new Parts(parts);
        parsedParts.addPart("name");
        parsedParts.addPart("version");
        Rulesets result = new Rulesets(ruleApp.getInternalObject(), context.getLocale(), parsedParts);
        result.addFilter("name", rsname);
        result.addFilter("version", rsversion);
        Collection<Ruleset> rulesets = result.getRulesets();
        if (rulesets.size() == 1) {
            return rulesets.iterator().next();
        }
        return null;
    }

    @Override
    public RESTPreResponse getRulesetArchive(RESTContext context, String raname, String raversion, String rsname, String rsversion, String filename) {
        Ruleset ruleset = this.getRuleset(context, raname, raversion, rsname, rsversion, null);
        if (ruleset == null) {
            return null;
        }
        IlrRESRulesetArchive archive = ruleset.getInternalObject().getRESRulesetArchive();
        if (archive == null) {
            return null;
        }
        try {
            RESTPreResponse result = new RESTPreResponse();
            result.setData(IlrRESArchiveUtil.getRESRulesetArchiveAsBytes(archive));
            result.setContentType("application/octet-stream; charset=utf-8");
            if (filename == null || filename.length() == 0) {
                result.setContentDisposition("attachment; filename=ruleset.jar");
            } else if (filename.endsWith(".jar")) {
                result.setContentDisposition("attachment; filename=" + filename);
            } else {
                result.setContentDisposition("attachment; filename=" + filename + ".jar");
            }
            return result;
        }
        catch (IOException e) {
            throw new HTTPError(500, e);
        }
    }

    @Override
    public RESTProperties getRuleAppProperties(RESTContext context, String raname, String raversion) {
        if (this.repository == null) {
            return null;
        }
        RuleApp result = this.getRuleApp(context, raname, raversion, "all");
        if (result == null) {
            return null;
        }
        return result.getProperties();
    }

    @Override
    public RESTProperties getRulesetProperties(RESTContext context, String raname, String raversion, String rsname, String rsversion) {
        Ruleset result = this.getRuleset(context, raname, raversion, rsname, rsversion, "all");
        if (result == null) {
            return null;
        }
        return result.getProperties();
    }

    @Override
    public Signature getRulesetSignature(RESTContext context, String raname, String raversion, String rsname, String rsversion) {
        Ruleset ruleset = this.getRuleset(context, raname, raversion, rsname, rsversion, null);
        if (ruleset == null) {
            return null;
        }
        IlrRESRulesetArchive archive = ruleset.getInternalObject().getRESRulesetArchive();
        if (archive == null) {
            return null;
        }
        Signature result = new Signature(archive.getRulesetParameters(), context.getLocale());
        return result;
    }

    @Override
    public RESTPreResponse getRuleAppArchive(String ruleappname, String ruleappversion, String filename) {
        try {
            RESTPreResponse result = new RESTPreResponse();
            result.setData(this.managementService.getRuleAppArchive(ruleappname, ruleappversion).toByteArray());
            result.setContentType("application/octet-stream; charset=utf-8");
            if (filename == null || filename.length() == 0) {
                result.setContentDisposition("attachment; filename=ruleapp.jar");
            } else if (filename.endsWith(".jar")) {
                result.setContentDisposition("attachment; filename=" + filename);
            } else {
                result.setContentDisposition("attachment; filename=" + filename + ".jar");
            }
            return result;
        }
        catch (IlrRepositoryException e) {
            return null;
        }
        catch (Exception e) {
            throw new HTTPError(500, e);
        }
    }

    public Ruleset getRuleset(RESTContext context, String ruleappname, String rulesetname, String parts) {
        IlrMutableRuleAppInformation ruleApp = this.getGreatestRuleApp(ruleappname);
        if (ruleApp == null) {
            return null;
        }
        List<IlrMutableRulesetArchiveInformation> rulesets = this.managementService.getGreatestRulesets(ruleApp);
        IlrMutableRulesetArchiveInformation ruleset = null;
        for (IlrMutableRulesetArchiveInformation information : rulesets) {
            if (!information.getName().equals(rulesetname)) continue;
            ruleset = information;
            break;
        }
        Parts parsedParts = new Parts(parts);
        return Rulesets.toRESTObject(ruleset, context.getLocale(), parsedParts);
    }

    private IlrMutableRuleAppInformation getGreatestRuleApp(String name) {
        List<IlrMutableRuleAppInformation> ruleApps = this.managementService.getGreatestRuleApps();
        if (ruleApps == null) {
            return null;
        }
        for (IlrMutableRuleAppInformation information : ruleApps) {
            if (!information.getName().equals(name)) continue;
            return information;
        }
        return null;
    }

    @Override
    public RuleApp getRuleAppWithHighestNumber(RESTContext context, String name, String parts) {
        Parts parsedParts = new Parts(parts);
        IlrMutableRuleAppInformation ruleApp = this.getGreatestRuleApp(name);
        if (ruleApp == null || ruleApp.getVersion() == null) {
            return null;
        }
        return RuleApps.toRESTObject(ruleApp, context.getLocale(), parsedParts);
    }

    @Override
    public RESTActionResult addRuleApp(RESTContext context, RuleApp ruleapp) throws HTTPError {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        try {
            result = this.check(context, result, ruleapp, "ruleapp");
            if (result.getSucceeded()) {
                IlrMutableRuleAppInformation newRuleApp = this.managementService.addRuleApp(ruleapp.getName(), ruleapp.getVersion(), ruleapp.getDisplayName(), ruleapp.getDescription());
                if (ruleapp.getProperties() != null) {
                    this.managementService.updateRuleApp(newRuleApp, ruleapp.getDisplayName(), ruleapp.getDescription(), ruleapp.getProperties().toJavaProperties());
                }
                if (ruleapp.getRulesets() != null) {
                    for (Ruleset ruleset : ruleapp.getRulesets().getRulesets()) {
                        RESTActionResult rulesetResult = this.addRuleset(context, ruleapp.getName(), ruleapp.getVersion(), ruleset);
                        if (rulesetResult.getSucceeded()) continue;
                        return rulesetResult;
                    }
                }
                result.setResource(RuleApps.toRESTObject(newRuleApp, context.getLocale(), new Parts(null)));
                result.setStatus(201);
            }
            return result;
        }
        catch (IlrAlreadyExistException e) {
            return this.putOnError(result, locale, ServiceLocalization.RULEAPP_ALREADY_EXISTS_FOR_INSERT_ERROR, "/" + ruleapp.getName() + "/" + ruleapp.getVersion());
        }
        catch (Exception e) {
            throw new HTTPError(500, e);
        }
    }

    @Override
    public RESTActionResult deployRuleAppArchive(RESTContext context, String merging, String version, byte[] archive) throws HTTPError {
        Locale locale = context.getLocale();
        if (version != null) {
            this.checkVersionPolicy(locale, version);
        }
        if (merging != null) {
            this.checkMergingPolicy(locale, merging);
        }
        if (version == null) {
            version = "MAJOR_VERSION_POLICY";
        }
        if (merging == null) {
            merging = "ADD_AT_END_MERGING_POLICY";
        }
        try {
            IlrDeploymentReport report = this.managementService.deployRuleAppArchive(StreamUtil.toStream(archive), merging, version);
            RESTActionResult result = new RESTActionResult();
            result.setResource(new DeploymentReport(report, locale));
            return result;
        }
        catch (IlrArchiveException e) {
            RESTActionResult result = new RESTActionResult();
            result.setMessage(e.getLocalizedMessage(locale));
            result.setSucceeded(false);
            result.setStatus(202);
            return result;
        }
        catch (Exception e) {
            throw new HTTPError(500, e);
        }
    }

    @Override
    public RESTActionResult addRuleAppProperty(RESTContext context, String ruleappname, String ruleappversion, String name, String value) throws HTTPError {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        if (value == null || value.length() == 0) {
            return this.putOnError(result, locale, ServiceLocalization.EMPTY_PROPERTY_PAYLOAD_ERROR, new Object[0]);
        }
        RuleApp ruleApp = this.getRuleApp(context, ruleappname, ruleappversion, null);
        if (ruleApp == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_RULEAPP_ERROR, "/" + ruleappname + "/" + ruleappversion);
        }
        IlrMutableRuleAppInformation ruleAppInfo = ruleApp.getInternalObject();
        if (!ruleAppInfo.getProperties().containsKey(name)) {
            this.managementService.setRuleAppProperty(ruleAppInfo, name, value);
            return result;
        }
        return this.putOnError(result, locale, ServiceLocalization.PROPERTY_ALREADY_EXISTS_FOR_INSERT_ERROR, name);
    }

    @Override
    public RESTActionResult addRuleset(RESTContext context, String ruleappname, String ruleappversion, Ruleset ruleset) throws HTTPError {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        try {
            IlrMutableRulesetArchiveInformation newRuleset = null;
            if (ruleset != null) {
                RuleApp ruleApp = this.getRuleApp(context, ruleappname, ruleappversion, null);
                if (ruleApp == null) {
                    return this.putOnError(result, locale, ServiceLocalization.UNKNOW_RULEAPP_ERROR, "/" + ruleappname + "/" + ruleappversion);
                }
                if ((result = this.check(context, result, ruleset, "/ruleset[0]")).getSucceeded()) {
                    byte[] archive = ruleset.getByteArchive();
                    if (context.getFiles().size() != 0) {
                        String fileName = ruleset.getArchive();
                        Object content = null;
                        RESTRequestMultipartParser.Part contentPart = context.getFiles().get(fileName);
                        if (contentPart != null) {
                            archive = contentPart.getContent();
                        } else {
                            contentPart = context.getFiles().get(new String(archive));
                            if (contentPart != null) {
                                archive = contentPart.getContent();
                            }
                        }
                    }
                    IlrEngineType engineType = IlrEngineType.toEngineType(EngineArchiveUtil.getEngineType((byte[])archive));
                    Properties props = null;
                    if (ruleset.getProperties() != null) {
                        props = ruleset.getProperties().toJavaProperties();
                    }
                    newRuleset = this.managementService.addRuleset(ruleApp.getInternalObject(), ruleset.getName(), ruleset.getVersion(), ruleset.getDisplayName(), ruleset.getDescription(), null, engineType, props, StreamUtil.toStream(archive));
                }
                if (newRuleset != null) {
                    result.setResource(Rulesets.toRESTObject(newRuleset, context.getLocale(), new Parts(null)));
                    result.setStatus(201);
                } else {
                    result.setSucceeded(false);
                }
            }
            return result;
        }
        catch (IlrAlreadyExistException e) {
            return this.putOnError(result, locale, ServiceLocalization.RULESET_ALREADY_EXISTS_FOR_INSERT_ERROR, "/" + ruleappname + "/" + ruleappversion + "/" + ruleset.getName() + "/" + ruleset.getVersion());
        }
        catch (Exception e) {
            throw new HTTPError(500, e);
        }
    }

    @Override
    public RESTActionResult addRulesetProperty(RESTContext context, String ruleappname, String ruleappversion, String rulesetname, String rulesetversion, String name, String value) throws HTTPError {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        Ruleset ruleset = this.getRuleset(context, ruleappname, ruleappversion, rulesetname, rulesetversion, null);
        if (ruleset == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_RULESET_ERROR, "/" + ruleappname + "/" + ruleappversion + "/" + rulesetname + "/" + rulesetversion);
        }
        IlrMutableRulesetArchiveInformation rulesetInfo = ruleset.getInternalObject();
        if (!rulesetInfo.getProperties().containsKey(name)) {
            this.managementService.setRulesetProperty(rulesetInfo, name, value);
            return result;
        }
        return this.putOnError(result, locale, ServiceLocalization.PROPERTY_ALREADY_EXISTS_FOR_INSERT_ERROR, name);
    }

    @Override
    public RESTActionResult deployRulesetArchive(RESTContext context, String ruleappname, String ruleappversion, String rulesetname, String rulesetversion, byte[] archive) throws HTTPError {
        RESTActionResult result = new RESTActionResult();
        Ruleset restRuleset = null;
        RuleApp restRuleApp = this.getRuleApp(context, ruleappname, ruleappversion, null);
        if (restRuleApp == null) {
            try {
                IlrMutableRuleAppInformation ruleApp = this.managementService.addRuleApp(ruleappname, ruleappversion, null, null);
                restRuleApp = RuleApps.toRESTObject(ruleApp, context.getLocale(), new Parts(null));
            }
            catch (Exception e) {
                throw new HTTPError(500, e);
            }
        }
        if ((restRuleset = this.getRuleset(context, ruleappname, ruleappversion, rulesetname, rulesetversion, null)) == null) {
            try {
                IlrEngineType engineType = IlrEngineType.toEngineType(EngineArchiveUtil.getEngineType((byte[])archive));
                IlrMutableRulesetArchiveInformation ruleset = this.managementService.addRuleset(restRuleApp.getInternalObject(), rulesetname, rulesetversion, null, null, null, engineType, null, StreamUtil.toStream(archive));
                restRuleset = Rulesets.toRESTObject(ruleset, context.getLocale(), new Parts(null));
            }
            catch (IlrRulesetArchive.RulesetArchiveException e) {
                result.setSucceeded(false);
                result.setStatus(202);
                result.setMessage(e.getMessage());
                return result;
            }
            catch (Exception e) {
                throw new HTTPError(500, e);
            }
        } else {
            return this.putOnError(result, context.getLocale(), ServiceLocalization.RULESET_ALREADY_EXIST_ERROR, "/" + ruleappname + "/" + ruleappversion + "/" + rulesetname + "/" + rulesetversion);
        }
        result.setResource(restRuleset);
        result.setStatus(201);
        return result;
    }

    public RESTActionResult addRulesetArchive(RESTContext context, String ruleappname, String rulesetname, byte[] archive) throws HTTPError {
        IlrMutableRulesetArchiveInformation ruleset;
        RESTActionResult result = new RESTActionResult();
        IlrMutableRuleAppInformation ruleApp = this.getGreatestRuleApp(ruleappname);
        if (ruleApp == null) {
            try {
                ruleApp = this.managementService.addRuleApp(ruleappname, "1.0", null, null);
            }
            catch (Exception e) {
                throw new HTTPError(500, e);
            }
        }
        if ((ruleset = (IlrMutableRulesetArchiveInformation)ruleApp.getGreatestRuleset(rulesetname)) == null) {
            try {
                IlrEngineType engineType = IlrEngineType.toEngineType(EngineArchiveUtil.getEngineType((byte[])archive));
                ruleset = this.managementService.addRuleset(ruleApp, rulesetname, "1.0", null, null, null, engineType, null, StreamUtil.toStream(archive));
            }
            catch (Exception e) {
                throw new HTTPError(500, e);
            }
        }
        try {
            IlrEngineType engineType = IlrEngineType.toEngineType(EngineArchiveUtil.getEngineType((byte[])archive));
            ruleset = this.managementService.addRuleset(ruleApp, rulesetname, ruleset.getVersion().getMajor() + 1 + "." + ruleset.getVersion().getMinor(), null, null, null, engineType, null, StreamUtil.toStream(archive));
        }
        catch (Exception e) {
            throw new HTTPError(500, e);
        }
        result.setResource(Rulesets.toRESTObject(ruleset, context.getLocale(), new Parts(null)));
        result.setStatus(201);
        return result;
    }

    @Override
    public RESTActionResult updateRuleApp(RESTContext context, String ruleappname, String ruleappversion, RuleApp ruleapp) {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        if (ruleapp == null) {
            return this.putOnError(result, locale, ServiceLocalization.EMPTY_RULEAPP_PAYLOAD_ERROR, new Object[0]);
        }
        if (ruleapp.getName() != null && !ruleapp.getName().equals(ruleappname)) {
            return this.putOnError(result, locale, ServiceLocalization.RULEAPP_NAME_OR_VERSION_CANNOT_BE_UPDATED, "/" + ruleappname + "/" + ruleappversion);
        }
        if (ruleapp.getVersion() != null && !ruleapp.getVersion().equals(ruleappversion)) {
            return this.putOnError(result, locale, ServiceLocalization.RULEAPP_NAME_OR_VERSION_CANNOT_BE_UPDATED, "/" + ruleappname + "/" + ruleappversion);
        }
        RuleApp target = this.getRuleApp(context, ruleappname, ruleappversion, null);
        if (target == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_RULEAPP_ERROR, "/" + ruleappname + "/" + ruleappversion);
        }
        IlrMutableRuleAppInformation ruleAppInfo = target.getInternalObject();
        Properties props = ruleapp.getProperties() == null ? null : ruleapp.getProperties().toJavaProperties();
        this.managementService.updateRuleApp(ruleAppInfo, ruleapp.getDisplayName(), ruleapp.getDescription(), props);
        result.setResource(this.getRuleApp(context, ruleappname, ruleappversion, "all"));
        return result;
    }

    @Override
    public RESTActionResult updateRuleAppProperty(RESTContext context, String ruleappname, String ruleappversion, String name, String value) {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        RuleApp ruleApp = this.getRuleApp(context, ruleappname, ruleappversion, null);
        if (ruleApp == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_RULEAPP_ERROR, "/" + ruleappname + "/" + ruleappversion);
        }
        IlrMutableRuleAppInformation ruleAppInfo = ruleApp.getInternalObject();
        if (ruleAppInfo.getProperties().containsKey(name)) {
            this.managementService.setRuleAppProperty(ruleAppInfo, name, value);
            return result;
        }
        return this.putOnError(result, locale, ServiceLocalization.PROPERTY_NOT_EXISTS_FOR_UPDATE_ERROR, name);
    }

    @Override
    public RESTActionResult updateRuleset(RESTContext context, String ruleappname, String ruleappversion, String rulesetname, String rulesetversion, Ruleset ruleset) {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        Ruleset target = this.getRuleset(context, ruleappname, ruleappversion, rulesetname, rulesetversion, null);
        if (target == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_RULESET_ERROR, "/" + ruleappname + "/" + ruleappversion + "/" + rulesetname + "/" + rulesetversion);
        }
        IlrMutableRulesetArchiveInformation rulesetInfo = target.getInternalObject();
        if (ruleset == null) {
            return this.putOnError(result, locale, ServiceLocalization.EMPTY_RULESET_PAYLOAD_ERROR, new Object[0]);
        }
        Properties props = ruleset.getProperties() == null ? null : ruleset.getProperties().toJavaProperties();
        this.managementService.updateRuleset(rulesetInfo, ruleset.getDisplayName(), ruleset.getDescription(), props);
        return result;
    }

    @Override
    public RESTActionResult updateRulesetProperty(RESTContext context, String ruleappname, String ruleappversion, String rulesetname, String rulesetversion, String name, String value) {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        Ruleset ruleset = this.getRuleset(context, ruleappname, ruleappversion, rulesetname, rulesetversion, null);
        if (ruleset == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_RULESET_ERROR, "/" + ruleappname + "/" + ruleappversion + "/" + rulesetname + "/" + rulesetversion);
        }
        IlrMutableRulesetArchiveInformation rulesetInfo = ruleset.getInternalObject();
        if (rulesetInfo.getProperties().containsKey(name)) {
            this.managementService.setRulesetProperty(rulesetInfo, name, value);
            return result;
        }
        return this.putOnError(result, locale, ServiceLocalization.PROPERTY_NOT_EXISTS_FOR_UPDATE_ERROR, name);
    }

    @Override
    public RESTActionResult deleteRuleApp(RESTContext context, String ruleappname, String ruleappversion) {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        RuleApp ruleApp = this.getRuleApp(context, ruleappname, ruleappversion, null);
        if (ruleApp == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_RULEAPP_ERROR, "/" + ruleappname + "/" + ruleappversion);
        }
        try {
            this.managementService.removeRuleApp(ruleappname, ruleappversion);
            return result;
        }
        catch (IlrFormatException e) {
            throw new HTTPError(500, e);
        }
        catch (IlrRepositoryException e) {
            throw new HTTPError(500, e);
        }
    }

    @Override
    public RESTActionResult deleteRuleAppProperty(RESTContext context, String ruleappname, String ruleappversion, String name) {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        RuleApp ruleApp = this.getRuleApp(context, ruleappname, ruleappversion, null);
        if (ruleApp == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_RULEAPP_ERROR, "/" + ruleappname + "/" + ruleappversion);
        }
        IlrMutableRuleAppInformation ruleAppInfo = ruleApp.getInternalObject();
        if (ruleAppInfo.getProperties().containsKey(name)) {
            this.managementService.setRuleAppProperty(ruleAppInfo, name, null);
            return result;
        }
        return this.putOnError(result, locale, ServiceLocalization.PROPERTY_NOT_EXISTS_FOR_DELETE_ERROR, name);
    }

    @Override
    public RESTActionResult deleteRuleset(RESTContext context, String ruleappname, String ruleappversion, String rulesetname, String rulesetversion) {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        Ruleset ruleset = this.getRuleset(context, ruleappname, ruleappversion, rulesetname, rulesetversion, null);
        if (ruleset == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_RULESET_ERROR, "/" + ruleappname + "/" + ruleappversion + "/" + rulesetname + "/" + rulesetversion);
        }
        IlrMutableRulesetArchiveInformation rulesetInfo = ruleset.getInternalObject();
        try {
            this.managementService.removeRuleset(rulesetInfo.getCanonicalPath());
            return result;
        }
        catch (IlrFormatException e) {
            throw new HTTPError(500, e);
        }
        catch (IlrRepositoryException e) {
            throw new HTTPError(500, e);
        }
    }

    @Override
    public RESTActionResult deleteRulesetProperty(RESTContext context, String ruleappname, String ruleappversion, String rulesetname, String rulesetversion, String name) {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        Ruleset ruleset = this.getRuleset(context, ruleappname, ruleappversion, rulesetname, rulesetversion, null);
        if (ruleset == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_RULESET_ERROR, "/" + ruleappname + "/" + ruleappversion);
        }
        IlrMutableRulesetArchiveInformation rulesetInfo = ruleset.getInternalObject();
        if (rulesetInfo.getProperties().containsKey(name)) {
            this.managementService.setRulesetProperty(rulesetInfo, name, null);
            return result;
        }
        return this.putOnError(result, locale, ServiceLocalization.PROPERTY_NOT_EXISTS_FOR_DELETE_ERROR, name);
    }

    @Override
    public Resources getResources(RESTContext context, String parts) {
        Resources result;
        if (this.repository == null) {
            return null;
        }
        Parts parsedParts = new Parts(parts);
        try {
            result = new Resources(this.repository.getDAO().getXOMRepositoryDAO(), this.repository.getDAO().getXOMRepositoryDAO().loadResources(), context.getLocale(), parsedParts);
        }
        catch (DAOException e) {
            throw new HTTPError(500, e);
        }
        return result;
    }

    @Override
    public RESTActionResult updateRulesetArchive(RESTContext context, String ruleappname, String ruleappversion, String rulesetname, String rulesetversion, byte[] archive) throws HTTPError {
        RESTActionResult result = new RESTActionResult();
        IlrMutableRuleAppInformation ruleapp = null;
        try {
            ruleapp = this.repository.getRuleApp(ruleappname, IlrVersion.parseVersion(ruleappversion));
        }
        catch (IlrFormatException e) {
            throw new HTTPError(500, e);
        }
        if (ruleapp == null) {
            return this.putOnError(result, context.getLocale(), ServiceLocalization.UNKNOW_RULEAPP_ERROR, "/" + ruleappname + "/" + ruleappversion);
        }
        IlrMutableRulesetArchiveInformation ruleset = null;
        try {
            ruleset = (IlrMutableRulesetArchiveInformation)ruleapp.getRuleset(rulesetname, IlrVersion.parseVersion(rulesetversion));
        }
        catch (IlrFormatException e) {
            throw new HTTPError(500, e);
        }
        if (ruleset == null) {
            return this.putOnError(new RESTActionResult(), context.getLocale(), ServiceLocalization.UNKNOW_RULESET_ERROR, "/" + ruleappname + "/" + ruleappversion + "/" + rulesetname + "/" + rulesetversion);
        }
        IlrEngineType engineType = IlrEngineType.toEngineType(EngineArchiveUtil.getEngineType((byte[])archive));
        try {
            this.managementService.setRESRulesetArchive(ruleset, engineType, StreamUtil.toStream(archive));
        }
        catch (Exception e) {
            throw new HTTPError(500, e);
        }
        return result;
    }

    private IlrMutableRulesetArchiveInformation getGreatestRuleset(IlrMutableRuleAppInformation ruleApp, String name) {
        List<IlrMutableRulesetArchiveInformation> rulesets = this.managementService.getGreatestRulesets(ruleApp);
        if (rulesets == null) {
            return null;
        }
        for (IlrMutableRulesetArchiveInformation information : rulesets) {
            if (!information.getName().equals(name)) continue;
            return information;
        }
        return null;
    }

    @Override
    public Ruleset getRulesetWithHighestNumber(RESTContext context, String ruleappname, String ruleappversion, String rulesetname, String parts) {
        Parts parsedParts = new Parts(parts);
        IlrMutableRuleAppInformation ruleapp = null;
        try {
            ruleapp = this.repository.getRuleApp(ruleappname, IlrVersion.parseVersion(ruleappversion));
        }
        catch (IlrFormatException e) {
            throw new HTTPError(500, e);
        }
        if (ruleapp == null) {
            return null;
        }
        IlrMutableRulesetArchiveInformation ruleset = this.getGreatestRuleset(ruleapp, rulesetname);
        if (ruleset == null || ruleset.getVersion() == null) {
            return null;
        }
        return Rulesets.toRESTObject(ruleset, context.getLocale(), parsedParts);
    }

    @Override
    public Libraries getLibraries(RESTContext context, String parts) {
        Libraries result;
        if (this.repository == null) {
            return null;
        }
        Parts parsedParts = new Parts(parts);
        try {
            result = new Libraries(this.repository.getDAO().getXOMRepositoryDAO(), this.repository.getDAO().getXOMRepositoryDAO().loadLibraries(), context.getLocale(), parsedParts);
        }
        catch (DAOException e) {
            throw new HTTPError(500, e);
        }
        return result;
    }

    @Override
    public Libraries getLibrariesByName(RESTContext context, String name, String parts) {
        Libraries result;
        if (this.repository == null) {
            return null;
        }
        Parts parsedParts = new Parts(parts);
        parsedParts.addPart("name");
        try {
            result = new Libraries(this.repository.getDAO().getXOMRepositoryDAO(), this.repository.getDAO().getXOMRepositoryDAO().loadLibraries(), context.getLocale(), parsedParts);
            result.addFilter("name", name);
        }
        catch (DAOException e) {
            throw new HTTPError(500, e);
        }
        return result;
    }

    @Override
    public Library getLibrary(RESTContext context, String name, String version, String parts) {
        Libraries result;
        if (this.repository == null) {
            return null;
        }
        Parts parsedParts = null;
        parsedParts = parts != null ? new Parts(parts + "|name|version") : new Parts(null);
        try {
            result = new Libraries(this.repository.getDAO().getXOMRepositoryDAO(), this.repository.getDAO().getXOMRepositoryDAO().loadLibraries(), context.getLocale(), parsedParts);
            result.addFilter("name", name);
            result.addFilter("version", version);
        }
        catch (DAOException e) {
            throw new HTTPError(500, e);
        }
        Collection<Library> libraries = result.getLibraries();
        if (libraries.size() == 1) {
            return libraries.iterator().next();
        }
        return null;
    }

    @Override
    public Library getLibraryWithHighestNumber(RESTContext context, String name, String parts) {
        XOMLibraryId library;
        Parts parsedParts = new Parts(parts);
        try {
            library = this.managementService.getLibraryLatestVersion(name);
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw new HTTPError(500, e);
        }
        catch (IlrRepositoryException e) {
            throw new HTTPError(500, e);
        }
        catch (DAOException e) {
            throw new HTTPError(500, e);
        }
        if (library == null || library.getVersion() == null) {
            return null;
        }
        return Libraries.toRESTObject(this.repository.getDAO().getXOMRepositoryDAO(), library, parsedParts);
    }

    @Override
    public RESTActionResult addLibrary(RESTContext context, String name, String version, String content) throws HTTPError {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        Library lib = this.getLibrary(context, name, version, null);
        if (lib == null) {
            lib = new Library();
            lib.setName(name);
            lib.setVersion(version);
            String[] initUris = content.split(String.valueOf(','));
            String[] uris = new String[initUris.length];
            for (int i = 0; i < initUris.length; ++i) {
                uris[i] = initUris[i].trim();
            }
            lib.setContent(uris);
            result = this.check(result, locale, lib);
            if (content == null || content.length() == 0) {
                return this.putOnError(result, locale, ServiceLocalization.NULL_LIBRARY_CONTENT, new Object[0]);
            }
            if (result.getSucceeded()) {
                XOMLibraryId resultingLib = null;
                try {
                    resultingLib = this.managementService.addXOMLibrary(name, IlrVersion.parseVersion(version), lib.getContent());
                }
                catch (IlrFormatException e) {
                    throw new HTTPError(500, e);
                }
                catch (IlrRepositoryException e) {
                    throw new HTTPError(500, e);
                }
                result.setResource(Libraries.toRESTObject(this.repository.getDAO().getXOMRepositoryDAO(), resultingLib, new Parts(null)));
                result.setStatus(201);
            }
            return result;
        }
        return this.putOnError(result, locale, ServiceLocalization.LIBRARY_ALREADY_EXISTS_FOR_INSERT_ERROR, name);
    }

    @Override
    public RESTActionResult deleteLibrary(RESTContext context, String name, String version) {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        Library library = this.getLibrary(context, name, version, null);
        if (library == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_LIBRARY_ERROR, "/" + name + "/" + version);
        }
        XOMLibraryId lib = library.getInternalObject();
        try {
            this.managementService.removeXOMLibrary(lib);
            return result;
        }
        catch (IlrRepositoryException e) {
            throw new HTTPError(500, e);
        }
    }

    @Override
    public Resources getResourcesByName(String name, String parts, RESTContext context) {
        Resources result;
        if (this.repository == null) {
            return null;
        }
        Parts parsedParts = new Parts(parts);
        parsedParts.addPart("name");
        try {
            result = new Resources(this.repository.getDAO().getXOMRepositoryDAO(), this.repository.getDAO().getXOMRepositoryDAO().loadResources(), context.getLocale(), parsedParts);
            result.addFilter("name", name);
        }
        catch (DAOException e) {
            throw new HTTPError(500, e);
        }
        return result;
    }

    @Override
    public Resource getResource(RESTContext context, String name, String version, String parts) {
        Resources result;
        if (this.repository == null) {
            return null;
        }
        Parts parsedParts = new Parts(parts);
        parsedParts.addPart("name");
        parsedParts.addPart("version");
        try {
            result = new Resources(this.repository.getDAO().getXOMRepositoryDAO(), this.repository.getDAO().getXOMRepositoryDAO().loadResources(), context.getLocale(), parsedParts);
            result.addFilter("name", name);
            result.addFilter("version", version);
        }
        catch (DAOException e) {
            throw new HTTPError(500, e);
        }
        Collection<Resource> resources = result.getResources();
        if (resources.size() == 1) {
            return resources.iterator().next();
        }
        return null;
    }

    @Override
    public Resource getResourceWithHighestNumber(RESTContext context, String name, String parts) {
        XOMResourceId resource;
        Parts parsedParts = new Parts(parts);
        try {
            resource = this.managementService.getResourceLatestVersion(name);
        }
        catch (IlrFormatException e) {
            throw new HTTPError(400, null, e.getLocalizedMessage(context.getLocale()));
        }
        catch (IlrResourceNotFoundDAOException e) {
            throw new HTTPError(500, e);
        }
        catch (IlrRepositoryException e) {
            throw new HTTPError(500, e);
        }
        catch (DAOException e) {
            throw new HTTPError(500, e);
        }
        if (resource == null || resource.getVersion() == null) {
            return null;
        }
        return Resources.toRESTObject(this.repository.getDAO().getXOMRepositoryDAO(), resource, parsedParts);
    }

    @Override
    public RESTActionResult deployResource(RESTContext context, String name, byte[] bytecode) throws HTTPError {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        XOMResourceId resultingXom = null;
        try {
            if (bytecode == null) {
                return this.putOnError(result, locale, ServiceLocalization.EMPTY_PAYLOAD_FOR_RESOURCE_CREATION, name);
            }
            try {
                XOMInternalNameUtil.getXOMResourceId(name);
            }
            catch (IlrFormatException e) {
                return this.putOnError(result, locale, ServiceLocalization.INVALID_RESOURCE_NAME, name);
            }
            resultingXom = this.managementService.addXOMResource(name, bytecode, true);
        }
        catch (IlrFormatException e) {
            throw new HTTPError(500, e);
        }
        catch (IlrRepositoryException e) {
            throw new HTTPError(500, e);
        }
        result.setResource(Resources.toRESTObject(this.repository.getDAO().getXOMRepositoryDAO(), resultingXom, new Parts(null)));
        result.setStatus(201);
        return result;
    }

    @Override
    public RESTActionResult deleteResource(RESTContext context, String name, String version) {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        Resource resource = this.getResource(context, name, version, null);
        if (resource == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_RESOURCE_ERROR, "/" + name + "/" + version);
        }
        XOMResourceId xom = resource.getInternalObject();
        try {
            this.managementService.removeXOMResource(xom);
            return result;
        }
        catch (IlrRepositoryException e) {
            throw new HTTPError(500, e);
        }
    }

    @Override
    public RESTActionResult updateLibrary(RESTContext context, String name, String version, String content) throws HTTPError {
        Locale locale = context.getLocale();
        RESTActionResult result = new RESTActionResult();
        Library target = this.getLibrary(context, name, version, null);
        if (content == null || content.length() == 0) {
            return this.putOnError(result, locale, ServiceLocalization.NULL_LIBRARY_CONTENT, new Object[0]);
        }
        if (target == null) {
            return this.putOnError(result, locale, ServiceLocalization.UNKNOW_LIBRARY_ERROR, "/" + name + "/" + version);
        }
        XOMLibraryId lib = target.getInternalObject();
        String[] initUris = content.split(String.valueOf(','));
        String[] uris = new String[initUris.length];
        for (int i = 0; i < initUris.length; ++i) {
            uris[i] = initUris[i].trim();
        }
        this.checkLibraryContent(result, locale, uris, "library[0]/content[0]");
        if (result.getSucceeded()) {
            try {
                this.managementService.addXOMLibrary(name, IlrVersion.parseVersion(version), uris);
            }
            catch (IlrFormatException e) {
                return this.putOnError(result, locale, ServiceLocalization.INCORRECT_VERSION, e.getLocalizedMessage(locale));
            }
            catch (IlrRepositoryException e) {
                throw new HTTPError(500, e);
            }
            result.setResource(Libraries.toRESTObject(this.repository.getDAO().getXOMRepositoryDAO(), lib, new Parts(null)));
            result.setStatus(201);
        }
        return result;
    }

    @Override
    public RESTPreResponse getByteCodeOfHighestResource(RESTContext context, String name, String fileName) {
        Resource resource = this.getResourceWithHighestNumber(context, name, null);
        if (resource == null) {
            return null;
        }
        try {
            RESTPreResponse result = new RESTPreResponse();
            result.setData(this.managementService.getResourceContent(name, resource.getVersion()).toByteArray());
            result.setContentType("application/octet-stream; charset=utf-8");
            if (fileName == null || fileName.length() == 0) {
                result.setContentDisposition("attachment; filename=" + name);
            } else {
                result.setContentDisposition("attachment; filename=" + fileName);
            }
            return result;
        }
        catch (Exception e) {
            throw new HTTPError(500, e);
        }
    }

    @Override
    public RESTPreResponse getByteCodeOfResource(RESTContext context, String name, String version, String fileName) {
        try {
            RESTPreResponse result = new RESTPreResponse();
            Resource resource = this.getResource(context, name, version, null);
            if (resource == null) {
                result.setStatus(204);
                return result;
            }
            result.setData(this.managementService.getResourceContent(name, version).toByteArray());
            result.setContentType("application/octet-stream; charset=utf-8");
            if (fileName == null || fileName.length() == 0) {
                result.setContentDisposition("attachment; filename=" + name);
            } else {
                result.setContentDisposition("attachment; filename=" + fileName);
            }
            return result;
        }
        catch (Exception e) {
            throw new HTTPError(500, e);
        }
    }

    private RESTActionResult putOnError(RESTActionResult result, Locale locale, String code, Object ... args) {
        return this.putOnError(result, locale, code, 202, args);
    }

    private RESTActionResult putOnError(RESTActionResult result, Locale locale, String code, int status, Object ... args) {
        result.setSucceeded(false);
        result.setCode(code);
        result.setStatus(status);
        result.setMessage(ServiceLocalization.getLocalizedMessage(locale, code, args));
        return result;
    }

    @Override
    public RESTActionResult notifyRuleAppChanges(RESTContext context, String name, String version) {
        try {
            RuleApp tmp = this.getRuleApp(context, name, version, null);
            if (tmp == null) {
                return this.putOnError(new RESTActionResult(), context.getLocale(), ServiceLocalization.UNKNOW_RULEAPP_ERROR, "/" + name + "/" + version);
            }
            this.managementService.notifyRuleAppChange(new IlrPath(name, IlrVersion.parseVersion(version)));
            RESTActionResult result = new RESTActionResult();
            result.setResource(tmp);
            return result;
        }
        catch (Exception e) {
            throw new HTTPError(500, e);
        }
    }

    @Override
    public RESTActionResult notifyRulesetChanges(RESTContext context, String raname, String raversion, String rsname, String rsversion) {
        try {
            Ruleset tmp = this.getRuleset(context, raname, raversion, rsname, rsversion, null);
            if (tmp == null) {
                return this.putOnError(new RESTActionResult(), context.getLocale(), ServiceLocalization.UNKNOW_RULESET_ERROR, "/" + raname + "/" + raversion + "/" + rsname + "/" + rsversion);
            }
            this.managementService.notifyRulesetChange(new IlrPath(raname, IlrVersion.parseVersion(raversion), rsname, IlrVersion.parseVersion(rsversion)));
            RESTActionResult result = new RESTActionResult();
            result.setResource(tmp);
            return result;
        }
        catch (Exception e) {
            throw new HTTPError(500, e);
        }
    }

    @Override
    public AllRulesets getAllRulesets(String parts, RESTContext context) {
        if (this.repository == null) {
            return null;
        }
        Parts parsedParts = new Parts(parts);
        AllRulesets result = new AllRulesets(this.repository.getRuleApps(), context.getLocale(), parsedParts);
        return result;
    }

    private RESTActionResult check(RESTActionResult result, Locale locale, Library library) {
        if (library.getName() == null) {
            return this.putOnError(result, locale, ServiceLocalization.NULL_LIBRARY_NAME, new Object[0]);
        }
        try {
            XOMInternalNameUtil.getXOMLibraryId(library.getName());
        }
        catch (IlrFormatException e) {
            return this.putOnError(result, locale, ServiceLocalization.INVALID_LIBRARY_NAME, library.getName());
        }
        if (library.getVersion() == null) {
            return this.putOnError(result, locale, ServiceLocalization.NULL_LIBRARY_VERSION, new Object[0]);
        }
        this.checkLibraryContent(result, locale, library.getContent(), null);
        return result;
    }

    private RESTActionResult checkLibraryContent(RESTActionResult result, Locale locale, String[] uris, String path) {
        int index = 0;
        if (uris == null || uris.length == 0 || uris.length == 1 && uris[0].trim().length() == 0) {
            return result;
        }
        for (String uri : uris) {
            try {
                XOMInternalNameUtil.validateURL(uri);
            }
            catch (LocalizedException e) {
                if (path == null) {
                    return this.putOnError(result, locale, ServiceLocalization.INVALID_URI_ON_LIBRARY_CONTENT_WITHOUT_LOC, new Object[0]);
                }
                return this.putOnError(result, locale, ServiceLocalization.INVALID_URI_ON_LIBRARY_CONTENT, path + "/[" + index + "]");
            }
            ++index;
        }
        return result;
    }

    private void checkVersionPolicy(Locale locale, String version) {
        if (version != null && (version.equals("MAJOR_VERSION_POLICY") || version.equals("MINOR_VERSION_POLICY"))) {
            return;
        }
        throw new HTTPError(400, ServiceLocalization.getLocalizedMessage(locale, ServiceLocalization.INVALID_VERSION_POLICY, version), null);
    }

    private void checkMergingPolicy(Locale locale, String merge) {
        if (merge != null && (merge.equals("ADD_AT_END_MERGING_POLICY") || merge.equals("REPLACE_MERGING_POLICY") || merge.equals("ADD_AT_END_RULESET_MERGING_POLICY") || merge.equals("REPLACE_RULESET_MERGING_POLICY"))) {
            return;
        }
        throw new HTTPError(400, ServiceLocalization.getLocalizedMessage(locale, ServiceLocalization.INVALID_MERGING_POLICY, merge), null);
    }

    private RESTActionResult check(RESTContext context, RESTActionResult result, RuleApp ruleapp, String path) {
        if (ruleapp == null) {
            return this.putOnError(result, context.getLocale(), ServiceLocalization.INVALID_RULEAPP_ARCHIVE_ERROR, new Object[0]);
        }
        if (ruleapp.getName() == null) {
            return this.putOnError(result, context.getLocale(), ServiceLocalization.NULL_RULEAPP_NAME, path);
        }
        try {
            IlrNameValidator.validateRuleAppName(ruleapp.getName());
        }
        catch (IlrFormatException e) {
            return this.putOnError(result, context.getLocale(), ServiceLocalization.INVALID_RULEAPP_NAME, ruleapp.getName());
        }
        if (ruleapp.getVersion() == null) {
            return this.putOnError(result, context.getLocale(), ServiceLocalization.NULL_RULEAPP_VERSION, path);
        }
        try {
            IlrVersion.parseVersion(ruleapp.getVersion());
        }
        catch (IlrFormatException e) {
            return this.putOnError(result, context.getLocale(), ServiceLocalization.INVALID_RULEAPP_VERSION, ruleapp.getVersion());
        }
        this.check(context, result, ruleapp.getProperties(), path);
        this.check(context, result, ruleapp.getRulesets(), path);
        return result;
    }

    private RESTActionResult check(RESTContext context, RESTActionResult result, Rulesets rulesets, String path) {
        int index = 0;
        if (rulesets != null) {
            for (Ruleset ruleset : rulesets.getRulesets()) {
                this.check(context, result, ruleset, path + "/ruleset[" + index++ + "]");
            }
        }
        return result;
    }

    private RESTActionResult check(RESTContext context, RESTActionResult result, Ruleset ruleset, String path) {
        if (ruleset.getName() == null) {
            return this.putOnError(result, context.getLocale(), ServiceLocalization.NULL_RULESET_NAME, path);
        }
        if (ruleset.getVersion() == null) {
            return this.putOnError(result, context.getLocale(), ServiceLocalization.NULL_RULESET_VERSION, path);
        }
        if (ruleset.getArchive() == null) {
            return this.putOnError(result, context.getLocale(), ServiceLocalization.NULL_RULESET_ARCHIVE, path);
        }
        try {
            byte[] archive = null;
            RESTRequestMultipartParser.Part archivePart = context.getFiles().get(new String(ruleset.getByteArchive()));
            archive = archivePart == null ? ruleset.getByteArchive() : archivePart.getContent();
            EngineType engineType = EngineArchiveUtil.getEngineType((InputStream)StreamUtil.toStream(archive));
            IlrRESArchiveUtil.getRESRulesetArchive(IlrEngineType.toEngineType(engineType), StreamUtil.toStream(archive));
            if (engineType == null) {
                return this.putOnError(result, context.getLocale(), ServiceLocalization.INVALID_RULESET_ARCHIVE, path);
            }
        }
        catch (Exception e) {
            return this.putOnError(result, context.getLocale(), ServiceLocalization.RULESET_ARCHIVE_EXCEPTION, path, e.getMessage());
        }
        this.check(context, result, ruleset.getProperties(), path);
        return result;
    }

    private RESTActionResult check(RESTContext context, RESTActionResult result, RESTProperties properties, String path) {
        int index = 0;
        if (properties != null) {
            for (RESTProperty property : properties.getProperties()) {
                this.check(context, result, property, path + "/property[" + index++ + "]");
            }
        }
        return result;
    }

    private RESTActionResult check(RESTContext context, RESTActionResult result, RESTProperty property, String path) {
        if (property.getId() == null) {
            return this.putOnError(result, context.getLocale(), ServiceLocalization.NULL_PROPERTY_ID, path);
        }
        return result;
    }

    @Override
    public RESTPreResponse getRulesetXOMs(RESTContext context, String ruleappname, String ruleappversion, String rulesetname, String rulesetversion, String fileName) {
        IlrRulesetArchive creArchive;
        Map ns2name;
        Ruleset ruleset = this.getRuleset(context, ruleappname, ruleappversion, rulesetname, rulesetversion, null);
        if (ruleset == null) {
            return null;
        }
        HashMap<String, byte[]> xsds = new HashMap<String, byte[]>();
        IlrRESRulesetArchive archive = ruleset.getInternalObject().getRESRulesetArchive();
        if (archive instanceof IlrCRERulesetArchive && (ns2name = (creArchive = ((IlrCRERulesetArchive)archive).getRulesetArchive()).getSchemaNames(true)) != null) {
            for (Map.Entry entry : ns2name.entrySet()) {
                String namespace = (String)entry.getKey();
                List files = (List)entry.getValue();
                for (String string : files) {
                    InputStream stream = (InputStream)creArchive.getSchema(namespace, string);
                    if (stream == null) continue;
                    try {
                        xsds.put(string, StreamUtil.toByteArray(stream));
                    }
                    catch (IOException e) {}
                }
            }
        }
        try {
            ZipEntry zentry;
            String[] strings = ruleset.getInternalObject().getProperties().getManagedXOMURIs();
            XOMClassLoaderFactory factory = new XOMClassLoaderFactory();
            XOMLibraryIdImpl tmpLibrary = new XOMLibraryIdImpl("<TMP>", IlrVersion.parseVersion("1.0"));
            tmpLibrary.setLoadingInfo("\\-");
            factory.setTmpLibraryContent(strings);
            factory.setXomRepository(this.repository.getDAO().getXOMRepositoryDAO());
            List<XOMResourceId> resources = XOMClassLoaderFactory.getContent(factory, tmpLibrary);
            if ((resources == null || resources.size() == 0) && xsds.size() == 0) {
                return null;
            }
            ByteArrayOutputStream outstream = new ByteArrayOutputStream();
            ZipOutputStream zos = new ZipOutputStream(outstream);
            if (resources != null) {
                for (XOMResourceId xOMResourceId : resources) {
                    if (xOMResourceId instanceof XOMResourceIdURL) {
                        XOMResourceIdURL tmp = (XOMResourceIdURL)xOMResourceId;
                        URL url = tmp.getURL();
                        ZipEntry zentry2 = new ZipEntry(this.getFileNameFromURL(url));
                        zos.putNextEntry(zentry2);
                        zos.write(StreamUtil.toByteArray(url.openConnection().getInputStream()));
                        zos.closeEntry();
                        continue;
                    }
                    zentry = new ZipEntry(xOMResourceId.getName());
                    zos.putNextEntry(zentry);
                    zos.write(this.managementService.getResourceContent(xOMResourceId.getName(), xOMResourceId.getVersion().toString()).toByteArray());
                    zos.closeEntry();
                }
            }
            for (Map.Entry entry : xsds.entrySet()) {
                zentry = new ZipEntry((String)entry.getKey());
                zos.putNextEntry(zentry);
                zos.write((byte[])entry.getValue());
                zos.closeEntry();
            }
            zos.close();
            outstream.close();
            RESTPreResponse result = new RESTPreResponse();
            result.setData(outstream.toByteArray());
            result.setContentType("application/octet-stream; charset=utf-8");
            if (fileName == null || fileName.length() == 0) {
                result.setContentDisposition("attachment; filename=xoms.zip");
            } else if (fileName.endsWith(".zip")) {
                result.setContentDisposition("attachment; filename=" + fileName);
            } else {
                result.setContentDisposition("attachment; filename=" + fileName + ".zip");
            }
            return result;
        }
        catch (Exception e) {
            throw new HTTPError(500, e);
        }
    }

    private String getFileNameFromURL(URL url) {
        return url.getPath();
    }
}

