/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.security.internal;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.FileHandler;

public abstract class FileHandlerPrivilegedAction
implements PrivilegedExceptionAction<FileHandler> {
    protected String fileName;
    protected int limit;
    protected int count;
    protected boolean append = false;

    public FileHandlerPrivilegedAction(String fileName) {
        this.fileName = fileName;
    }

    public FileHandlerPrivilegedAction(String fileName, int limit, int count) {
        this.fileName = fileName;
        this.limit = limit;
        this.count = count;
    }

    public FileHandlerPrivilegedAction(String fileName, int limit, int count, boolean append) {
        this.fileName = fileName;
        this.limit = limit;
        this.count = count;
        this.append = append;
    }

    public static FileHandler newFileHandler(String fileName) throws PrivilegedActionException {
        return AccessController.doPrivileged(new FileHandlerPrivilegedAction(fileName){

            @Override
            public FileHandler run() throws SecurityException, IOException {
                return new FileHandler(this.fileName);
            }
        });
    }

    public static FileHandler newFileHandler(String fileName, int limit, int count) throws PrivilegedActionException {
        return AccessController.doPrivileged(new FileHandlerPrivilegedAction(fileName, limit, count){

            @Override
            public FileHandler run() throws SecurityException, IOException {
                return new FileHandler(this.fileName, this.limit, this.count);
            }
        });
    }

    public static FileHandler newFileHandler(String fileName, int limit, int count, boolean append) throws PrivilegedActionException {
        return AccessController.doPrivileged(new FileHandlerPrivilegedAction(fileName, limit, count, append){

            @Override
            public FileHandler run() throws SecurityException, IOException {
                return new FileHandler(this.fileName, this.limit, this.count, this.append);
            }
        });
    }
}

