/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.util.internal;

import com.ibm.rules.res.util.internal.HTTPTransparentNegociation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RESTUtil {
    public static final List<Locale> availableLocales = new ArrayList<Locale>();

    public static Locale chooseBestLanguage(String acceptLanguage) {
        if (acceptLanguage == null) {
            return null;
        }
        HTTPTransparentNegociation tn = new HTTPTransparentNegociation(acceptLanguage);
        Set<HTTPTransparentNegociation.TNPart> tnparts = tn.getParts();
        Locale tmpAlt1 = null;
        Locale tmpAlt2 = null;
        for (HTTPTransparentNegociation.TNPart tnPart : tnparts) {
            String root = tnPart.getRoot();
            Locale tmp = null;
            if (root != null) {
                String[] languageAndCountry = root.split("-");
                switch (languageAndCountry.length) {
                    case 1: {
                        tmp = new Locale(languageAndCountry[0]);
                        break;
                    }
                    case 2: {
                        tmp = new Locale(languageAndCountry[0], languageAndCountry[1]);
                        if (tmpAlt1 == null) {
                            tmpAlt1 = new Locale(languageAndCountry[0]);
                            break;
                        }
                        if (tmpAlt2 != null) break;
                        tmpAlt2 = new Locale(languageAndCountry[0]);
                        break;
                    }
                    case 3: {
                        tmp = new Locale(languageAndCountry[0], languageAndCountry[1], languageAndCountry[2]);
                        if (tmpAlt1 == null) {
                            tmpAlt1 = new Locale(languageAndCountry[0], languageAndCountry[1]);
                            tmpAlt2 = new Locale(languageAndCountry[0]);
                            break;
                        }
                        if (tmpAlt2 != null) break;
                        tmpAlt2 = new Locale(languageAndCountry[0], languageAndCountry[1]);
                        break;
                    }
                }
            }
            if (tmp == null || !availableLocales.contains(tmp)) continue;
            return tmp;
        }
        if (tmpAlt1 != null && availableLocales.contains(tmpAlt1)) {
            return tmpAlt1;
        }
        if (tmpAlt2 != null && availableLocales.contains(tmpAlt2)) {
            return tmpAlt2;
        }
        return null;
    }

    public static <T> T chooseBestBinding(String contentTypeString, Map<String, T> name2binding, T defaultBinding) {
        T result = null;
        HTTPTransparentNegociation tn = new HTTPTransparentNegociation(contentTypeString);
        Set<HTTPTransparentNegociation.TNPart> tnparts = tn.getParts();
        for (HTTPTransparentNegociation.TNPart tnPart : tnparts) {
            String root = tnPart.getRoot();
            String complement = tnPart.getComplement();
            if (complement != null) {
                if (!"application".equals(root) && !"text".equals(root) && !"*".equals(root)) continue;
                if (complement.equals("*")) {
                    result = defaultBinding;
                    break;
                }
                result = name2binding.get(complement);
                if (result == null) continue;
                break;
            }
            result = name2binding.get(root);
        }
        return result;
    }

    public static <T> T getBinding(Request req, String uriFormat, String headerKey, String paramKey, boolean accept, Map<String, T> name2binding, T defaultBinding) {
        T result = null;
        if (uriFormat != null) {
            result = name2binding.get(uriFormat);
        } else {
            String tmp = req.getHeaders().get(headerKey);
            if (tmp != null) {
                int indexSemicolon = 0;
                indexSemicolon = tmp.indexOf(59);
                if (indexSemicolon != -1) {
                    tmp = tmp.substring(0, indexSemicolon);
                }
                result = RESTUtil.chooseBestBinding(tmp, name2binding, defaultBinding);
            }
        }
        if (result == null) {
            return defaultBinding;
        }
        return result;
    }

    static {
        availableLocales.add(new Locale("de"));
        availableLocales.add(new Locale("en"));
        availableLocales.add(new Locale("es"));
        availableLocales.add(new Locale("fr"));
        availableLocales.add(new Locale("it"));
        availableLocales.add(new Locale("ja"));
        availableLocales.add(new Locale("ko"));
        availableLocales.add(new Locale("nl"));
        availableLocales.add(new Locale("pl"));
        availableLocales.add(new Locale("pt", "BR"));
        availableLocales.add(new Locale("ru"));
        availableLocales.add(new Locale("zh", "TW"));
        availableLocales.add(new Locale("zh"));
    }

    public static interface Response {
        public void setStatus(int var1);

        public void setContentType(String var1);

        public void setHeader(String var1, String var2);

        public OutputStream getOutputStream() throws IOException;

        public Writer getWriter() throws IOException;

        public void sendRedirect(String var1) throws IOException;
    }

    public static interface Request {
        public Locale getLocale();

        public String getContextPath();

        public String getPathInfo();

        public StringBuffer getRequestURL();

        public Map<String, String> getHeaders();

        public Map<String, String> getParameters();

        public InputStream getInputStream() throws IOException;

        public String getCharacterEncoding();

        public String getRequestURI();

        public String getQueryString();

        public boolean supportSetAttribute();

        public void setAttribute(String var1, Object var2);
    }
}

