/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xml.internal;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;

public class DefaultEventAllocator
implements XMLEventAllocator {
    private XMLEventFactory xmlEventFactory;

    public DefaultEventAllocator(XMLEventFactory xmlEventFactory) {
        this.xmlEventFactory = xmlEventFactory;
    }

    @Override
    public XMLEvent allocate(XMLStreamReader r) throws XMLStreamException {
        switch (r.getEventType()) {
            case 12: {
                return this.xmlEventFactory.createCData(r.getText());
            }
            case 4: {
                if (r.isWhiteSpace()) {
                    return this.xmlEventFactory.createSpace(r.getText());
                }
                return this.xmlEventFactory.createCharacters(r.getText());
            }
            case 5: {
                return this.xmlEventFactory.createComment(r.getText());
            }
            case 11: {
                return this.xmlEventFactory.createDTD(r.getText());
            }
            case 8: {
                return this.xmlEventFactory.createEndDocument();
            }
            case 2: {
                return this.xmlEventFactory.createEndElement(r.getName(), this.allocateNamespaces(r));
            }
            case 3: {
                return this.xmlEventFactory.createProcessingInstruction(r.getPITarget(), r.getPIData());
            }
            case 6: {
                return this.xmlEventFactory.createIgnorableSpace(r.getText());
            }
            case 7: {
                String encoding = r.getEncoding();
                String version = r.getVersion();
                if (encoding != null && version != null && r.standaloneSet()) {
                    return this.xmlEventFactory.createStartDocument(encoding, version, r.isStandalone());
                }
                if (encoding != null && version != null) {
                    return this.xmlEventFactory.createStartDocument(encoding, version);
                }
                if (encoding != null) {
                    return this.xmlEventFactory.createStartDocument(encoding);
                }
                return this.xmlEventFactory.createStartDocument();
            }
            case 1: {
                return this.xmlEventFactory.createStartElement(r.getName(), this.allocateAttributes(r), this.allocateNamespaces(r));
            }
        }
        return null;
    }

    private Iterator<Namespace> allocateNamespaces(XMLStreamReader reader) {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        int n = reader.getNamespaceCount();
        for (int i = 0; i < n; ++i) {
            String prefix = reader.getNamespacePrefix(i);
            String uri = reader.getNamespaceURI(i);
            Namespace namespace = prefix == null ? this.xmlEventFactory.createNamespace(uri) : this.xmlEventFactory.createNamespace(prefix, uri);
            namespaces.add(namespace);
        }
        return namespaces.iterator();
    }

    private Iterator<Attribute> allocateAttributes(XMLStreamReader r) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int n = r.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            attributes.add(this.xmlEventFactory.createAttribute(r.getAttributeName(i), r.getAttributeValue(i)));
        }
        return attributes.iterator();
    }

    @Override
    public void allocate(XMLStreamReader reader, XMLEventConsumer consumer) throws XMLStreamException {
        XMLEvent event = this.allocate(reader);
        if (event != null) {
            consumer.add(event);
        }
    }

    @Override
    public XMLEventAllocator newInstance() {
        return new DefaultEventAllocator(this.xmlEventFactory);
    }
}

