/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xml.internal;

import com.ibm.rules.res.logging.internal.AbstractLogger;
import com.ibm.rules.res.message.internal.XXMessageCode;
import com.ibm.rules.res.util.internal.StreamUtil;
import com.ibm.rules.res.xml.internal.ContextClassLoaderPrivilegedAction;
import com.ibm.rules.res.xml.internal.DefaultEventAllocator;
import com.ibm.rules.res.xml.internal.HTDSStartElement;
import com.ibm.rules.res.xml.internal.JAXBClassDesciption;
import com.ibm.rules.res.xml.internal.JAXBContext;
import com.ibm.rules.res.xml.internal.JavaSchemaOutputResolver;
import com.ibm.rules.res.xml.internal.StAXFactory;
import com.ibm.rules.res.xml.internal.XMLConstants;
import com.ibm.rules.res.xml.internal.XSD;
import com.ibm.rules.res.xml.internal.XSDWrapper;
import ilog.rules.bom.IlrType;
import ilog.rules.engine.IlrRulesetParameter;
import ilog.rules.util.IlrIdConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.PrivilegedActionException;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XSDUtil {
    private static final String ASCII = "AaEeIiOoUuAaEeIiOoUuYyAaEeIiOoUuYyAaOoNnAaEeIiOoUuYyAaCcOoUu";
    private static final String UNICODE = "\u00c0\u00e0\u00c8\u00e8\u00cc\u00ec\u00d2\u00f2\u00d9\u00f9\u00c1\u00e1\u00c9\u00e9\u00cd\u00ed\u00d3\u00f3\u00da\u00fa\u00dd\u00fd\u00c2\u00e2\u00ca\u00ea\u00ce\u00ee\u00d4\u00f4\u00db\u00fb\u0176\u0177\u00c3\u00e3\u00d5\u00f5\u00d1\u00f1\u00c4\u00e4\u00cb\u00eb\u00cf\u00ef\u00d6\u00f6\u00dc\u00fc\u0178\u00ff\u00c5\u00e5\u00c7\u00e7\u0150\u0151\u0170\u0171";
    private static Map<String, String> simpleJavaType2XMLType;
    private static Map<String, Class> simpleJavaType2DeserializationClassType;
    private static Map<String, Class> simpleJavaType2JavaClassType;
    private static Map<Class, Map<String, JAXBContext>> class2jaxbcontext;
    private final XMLEventFactory eventFactory;
    private final AbstractLogger logger;

    public static TypeArrayType extractTypeArrayType(IlrType type) {
        TypeArrayType result = null;
        if (type != null) {
            int depth = 0;
            while (type.isArray()) {
                ++depth;
                type = type.getComponentType();
            }
            result = new TypeArrayType(type, depth);
        }
        return result;
    }

    public static boolean isSimpleJavaType(String type) {
        return XSDUtil.getSimpleJavaType(type) != null;
    }

    public static Object deserializeSimpleJavaType(String type, String value, boolean strict) throws JAXBException {
        XSDUtil.init();
        Class clazz = simpleJavaType2DeserializationClassType.get(type);
        return XSDUtil.deserializeJavaType(clazz, value, strict);
    }

    public static Object deserializeJavaType(Class clazz, String value, boolean strict) throws JAXBException {
        if (strict) {
            XSDUtil.init();
            JAXBContext jaxb = XSDUtil.getJAXBContext(null, clazz);
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            JAXBElement resultElement = unmarshaller.unmarshal((Source)new StreamSource(new StringReader("<root>" + value + "</root>")), clazz);
            Object result = resultElement.getValue();
            if (result == null) {
                throw new JAXBException(XXMessageCode.HELPER.getLocalizedMessage(XXMessageCode.ERROR_STRING_COULD_NOT_BE_TRANSLATED_INTO_CLASS, new Object[]{value, clazz}));
            }
            return result;
        }
        try {
            if (clazz.equals(Integer.TYPE)) {
                return (int)new Integer(value);
            }
            if (clazz.equals(Short.TYPE)) {
                return (short)new Short(value);
            }
            if (clazz.equals(Long.TYPE)) {
                return (long)new Long(value);
            }
            if (clazz.equals(Float.TYPE)) {
                return Float.valueOf(new Float(value).floatValue());
            }
            if (clazz.equals(Double.TYPE)) {
                return (double)new Double(value);
            }
            if (clazz.equals(Boolean.TYPE)) {
                return (boolean)new Boolean("1".equals(value) || Boolean.parseBoolean(value));
            }
            if (clazz.equals(Integer.class)) {
                return new Integer(value);
            }
            if (clazz.equals(Short.class)) {
                return new Short(value);
            }
            if (clazz.equals(Long.class)) {
                return new Long(value);
            }
            if (clazz.equals(Float.class)) {
                return new Float(value);
            }
            if (clazz.equals(Double.class)) {
                return new Double(value);
            }
            if (clazz.equals(Boolean.class)) {
                return new Boolean("1".equals(value) || Boolean.parseBoolean(value));
            }
            if (clazz.equals(String.class)) {
                return value;
            }
            if (clazz.equals(BigInteger.class)) {
                return new BigInteger(value);
            }
            if (clazz.equals(BigDecimal.class)) {
                return new BigDecimal(value);
            }
            if (clazz.equals(Date.class)) {
                return ISO8601.parse(value);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return XSDUtil.deserializeJavaType(clazz, value, true);
    }

    public static Object deserializeJavaType(Class clazz, XMLEventReader eventReader, String defaultNamespace) throws JAXBException {
        JAXBContext jaxb = XSDUtil.getJAXBContext(defaultNamespace, clazz);
        Unmarshaller unmarshaller = jaxb.createUnmarshaller();
        JAXBElement result = unmarshaller.unmarshal(eventReader, clazz);
        return result.getValue();
    }

    public static Object deserializeJavaType(Class clazz, Node node, String defaultNamespace) throws JAXBException {
        JAXBContext jaxb = XSDUtil.getJAXBContext(defaultNamespace, clazz);
        Unmarshaller unmarshaller = jaxb.createUnmarshaller();
        JAXBElement result = unmarshaller.unmarshal(node, clazz);
        return result.getValue();
    }

    public static String serializeSimpleJavaType(String type, Object value, boolean strict) throws JAXBException {
        if (strict) {
            if (value == null) {
                return null;
            }
            XSDUtil.init();
            Class clazz = simpleJavaType2DeserializationClassType.get(type);
            JAXBContext jaxb = XSDUtil.getJAXBContext(null, clazz);
            Marshaller marshaller = jaxb.createMarshaller();
            DOMResult result = new DOMResult();
            marshaller.marshal((Object)new JAXBElement(new QName("root"), clazz, value), (Result)result);
            return result.getNode().getFirstChild().getFirstChild().getNodeValue();
        }
        try {
            if (value == null) {
                value = "null";
            }
            if (value instanceof Date) {
                value = ISO8601.format((Date)value);
            }
            if (value instanceof Character) {
                value = (int)((Character)value).charValue();
            }
            return value.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return XSDUtil.serializeSimpleJavaType(type, value, true);
        }
    }

    public static String replaceTagsIfAny(String result, String pattern, String replaceToNCName, int fromIndex, boolean changeStressedLetter, boolean idConverter) {
        if (result.indexOf(pattern, fromIndex) != -1) {
            if (idConverter) {
                replaceToNCName = IlrIdConverter.getBusinessIdentifier(replaceToNCName);
            }
            return result.replaceAll(pattern, XSDUtil.getNCName(replaceToNCName, true, changeStressedLetter));
        }
        return result;
    }

    public static Class getJavaType(ClassLoader classLoader, String type, boolean strict) throws ClassNotFoundException {
        XSDUtil.init();
        Class clazz = simpleJavaType2JavaClassType.get(type);
        if (clazz == null) {
            if (strict) {
                return classLoader.loadClass(type);
            }
            return XSDUtil.findClass(classLoader, type);
        }
        return clazz;
    }

    public static Class<?> findClass(ClassLoader cl, String javaType) throws ClassNotFoundException {
        String tmpJavaType = javaType;
        Class<?> result = null;
        while (result == null) {
            try {
                result = XSDUtil.getJavaType(cl, tmpJavaType, true);
            }
            catch (ClassNotFoundException e) {
                try {
                    result = Thread.currentThread().getContextClassLoader().loadClass(tmpJavaType);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                if (result != null) continue;
                int indexSlash = tmpJavaType.lastIndexOf(46);
                if (indexSlash == -1) {
                    throw new ClassNotFoundException(javaType);
                }
                tmpJavaType = tmpJavaType.substring(0, indexSlash) + "$" + tmpJavaType.substring(indexSlash + 1);
            }
        }
        return result;
    }

    public static char changeStressedLetter(char c) {
        int pos = UNICODE.indexOf(c);
        if (pos > -1) {
            char tmp = ASCII.charAt(pos);
            return tmp;
        }
        return c;
    }

    public static boolean isParameterXML(IlrRulesetParameter param) {
        if (param.getType().isArray()) {
            IlrType currentType = param.getType();
            while (currentType.isArray()) {
                currentType = currentType.getComponentType();
            }
            return currentType.getJavaClass() == null;
        }
        return param.getKind() == 1;
    }

    public static String getNCName(String name, boolean firstUpperCase, boolean changeStressedLetter) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0) {
            return "";
        }
        String tmp = "";
        int index = 0;
        char ch = '_';
        while (index != name.length() && !Character.isLetter(ch = name.charAt(index++)) && ch != '_') {
        }
        if (Character.isLetter(ch) || ch == '_' || ch == ':') {
            tmp = firstUpperCase ? tmp + Character.toUpperCase(changeStressedLetter ? XSDUtil.changeStressedLetter(ch) : ch) : tmp + (changeStressedLetter ? XSDUtil.changeStressedLetter(ch) : ch);
        }
        int length = name.length();
        for (int i = index; i < length; ++i) {
            ch = name.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '.' && ch != '-' && ch != '_' && ch != 58) continue;
            tmp = tmp + (changeStressedLetter ? XSDUtil.changeStressedLetter(ch) : ch);
        }
        return tmp;
    }

    public static void indentXML(byte[] initialXML, Result outputXML) throws IOException, ParserConfigurationException, SAXException {
        block6: {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new ByteArrayInputStream(initialXML));
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                try {
                    transformerFactory.setAttribute("indent-number", 2);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(new DOMSource(doc), outputXML);
            }
            catch (Exception e) {
                if (outputXML instanceof StreamResult) {
                    ((StreamResult)outputXML).getOutputStream().write(initialXML);
                }
                if (outputXML instanceof DOMResult) {
                    ((DOMResult)outputXML).setNode(doc);
                }
                if (!(outputXML instanceof SAXResult)) break block6;
                throw new RuntimeException(XXMessageCode.HELPER.getLocalizedMessage(XXMessageCode.ERROR_METHOD_NOT_IMPLEMENTED_FOR_SAXRESULT));
            }
        }
    }

    public static URL toEndpointURL(URL customerURL, String stringToAppend) {
        String[] tokens;
        String file = customerURL.getFile();
        StringBuffer newFile = new StringBuffer();
        for (String token : tokens = file.split("/")) {
            if (token.length() == 0) continue;
            try {
                newFile.append("/").append(URLEncoder.encode(token, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (stringToAppend != null) {
            newFile.append(stringToAppend);
        }
        try {
            return new URL(customerURL.getProtocol(), customerURL.getHost(), customerURL.getPort(), newFile.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getShortNamespace(String namespace) {
        if (namespace == null) {
            return null;
        }
        int nsLength = namespace.length();
        while (nsLength > 1 && namespace.charAt(nsLength - 1) == '/') {
            namespace = namespace.substring(0, nsLength - 1);
            nsLength = namespace.length();
        }
        return namespace;
    }

    public static String stripFileName(String fileName) {
        int idx = fileName.lastIndexOf("/");
        if (idx < 0) {
            return fileName;
        }
        return fileName.substring(idx + 1);
    }

    public static String getSimpleJavaType(String type) {
        XSDUtil.init();
        return simpleJavaType2XMLType.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (simpleJavaType2XMLType != null) return;
        Class<XSDUtil> clazz = XSDUtil.class;
        synchronized (XSDUtil.class) {
            if (simpleJavaType2XMLType != null) return;
            simpleJavaType2XMLType = new HashMap<String, String>();
            simpleJavaType2DeserializationClassType = new HashMap<String, Class>();
            simpleJavaType2JavaClassType = new HashMap<String, Class>();
            for (int i = 0; i < XMLConstants.SIMPLE_JAVA_TYPE.length; ++i) {
                simpleJavaType2XMLType.put(XMLConstants.SIMPLE_JAVA_TYPE[i], XMLConstants.SIMPLE_JAVA_TYPE_TO_XML[i]);
                simpleJavaType2DeserializationClassType.put(XMLConstants.SIMPLE_JAVA_TYPE[i], XMLConstants.JAXB_TYPE_TO_DESERIALIZE[i]);
                simpleJavaType2JavaClassType.put(XMLConstants.SIMPLE_JAVA_TYPE[i], XMLConstants.JAVA_TYPE[i]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static ArrayType extractArrayType(String type) {
        ArrayType result = null;
        if (type != null) {
            int depth = 0;
            while (type.endsWith("[]")) {
                ++depth;
                type = type.substring(0, type.length() - 2);
            }
            result = new ArrayType(type, depth);
        }
        return result;
    }

    public static JAXBContext getJAXBContext(String defaultNamespace, Class clazz) throws JAXBException {
        JAXBContext jaxbContext = null;
        Map<String, JAXBContext> ns2jaxbcontext = class2jaxbcontext.get(clazz);
        if (ns2jaxbcontext == null) {
            ns2jaxbcontext = new HashMap<String, JAXBContext>();
            class2jaxbcontext.put(clazz, ns2jaxbcontext);
        }
        if ((jaxbContext = ns2jaxbcontext.get(defaultNamespace)) == null) {
            jaxbContext = JAXBContext.newInstance(new Class[]{clazz}, defaultNamespace, null);
            ns2jaxbcontext.put(defaultNamespace, jaxbContext);
        }
        return jaxbContext;
    }

    public XSDUtil(AbstractLogger logger) {
        this.logger = logger;
        this.eventFactory = StAXFactory.newXMLEventFactory(logger);
    }

    private boolean isIncluded(String xsdName, Map<String, XSD> map) {
        for (Map.Entry<String, XSD> entry : map.entrySet()) {
            XSD tmp = entry.getValue();
            if (tmp.getIncludes() == null) continue;
            for (String include : tmp.getIncludes()) {
                if (xsdName.equals(include)) {
                    return true;
                }
                if (!include.endsWith("/" + xsdName)) continue;
                return true;
            }
        }
        return false;
    }

    private XSD containsNamespace(String namespace, Map<String, XSD> map) {
        for (Map.Entry<String, XSD> entry : map.entrySet()) {
            XSD tmp = entry.getValue();
            if (tmp.getTargetNamespace() == null && namespace == null) {
                return tmp;
            }
            if (!tmp.getTargetNamespace().equals(namespace)) continue;
            return tmp;
        }
        return null;
    }

    private XSD getXSD(String xsdName, Map<String, XSD> map) {
        for (Map.Entry<String, XSD> entry : map.entrySet()) {
            if (xsdName.equals(entry.getKey())) {
                return entry.getValue();
            }
            if (!xsdName.endsWith("/" + entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private Queue<XMLEvent> replaceIncludeAndImport(Queue<XMLEvent> events, Map<String, XSD> map, TreeSet<String> mapImp, TreeSet<String> listIncludes, String defaultNamespaceURI, Set<Namespace> namespacesUsed) {
        boolean replace = false;
        boolean skipNext = false;
        LinkedList<XMLEvent> mergedEvents = new LinkedList<XMLEvent>();
        HTDSStartElement rootSchema = null;
        for (XMLEvent event : events) {
            if (rootSchema == null && event.isStartElement() && "schema".equals(event.asStartElement().getName().getLocalPart())) {
                rootSchema = new HTDSStartElement(event.asStartElement());
                event = rootSchema;
            }
            if (skipNext) {
                if (!event.isEndElement()) continue;
                skipNext = false;
                continue;
            }
            if (replace && event.isEndElement() && "include".equals(event.asEndElement().getName().getLocalPart())) {
                replace = false;
                continue;
            }
            if (replace) continue;
            if (event.isStartElement() && "include".equals(event.asStartElement().getName().getLocalPart())) {
                StartElement includeElement = event.asStartElement();
                replace = true;
                String includedXSDName = includeElement.getAttributeByName(new QName("schemaLocation")).getValue();
                if (listIncludes.contains(includedXSDName)) continue;
                listIncludes.add(includedXSDName);
                XSD included = this.getXSD(includedXSDName, map);
                if (included == null) continue;
                HashSet<Namespace> namespaces = new HashSet<Namespace>();
                this.copySchemaContent(mergedEvents, this.replaceIncludeAndImport(included.getEvents(), map, mapImp, listIncludes, defaultNamespaceURI, namespaces), false, false);
                for (Namespace namespace : namespaces) {
                    rootSchema.addNamespaceIfNotExists(namespace);
                    namespacesUsed.add(namespace);
                }
                for (Namespace namespace : included.getNamespaces()) {
                    rootSchema.addNamespaceIfNotExists(namespace);
                    namespacesUsed.add(namespace);
                }
                continue;
            }
            if (event.isStartElement() && "import".equals(event.asStartElement().getName().getLocalPart())) {
                StartElement importElement = event.asStartElement();
                Iterator<Attribute> attributes1 = importElement.getAttributes();
                boolean isDuplicateImport = false;
                Iterator<Attribute> it = attributes1;
                while (it.hasNext()) {
                    Attribute attr = it.next();
                    if (!attr.getName().getLocalPart().equals("namespace")) continue;
                    String string = attr.getValue();
                    if (mapImp.contains(string)) {
                        isDuplicateImport = true;
                        break;
                    }
                    mapImp.add(string);
                    break;
                }
                final Iterator<Attribute> attributes = importElement.getAttributes();
                if (isDuplicateImport) {
                    skipNext = true;
                    continue;
                }
                event = this.eventFactory.createStartElement(importElement.getName(), new Iterator(){
                    Object next;
                    boolean nextOk = false;
                    boolean first = true;

                    @Override
                    public boolean hasNext() {
                        if (!this.first && !this.nextOk) {
                            return this.next != null;
                        }
                        this.first = false;
                        this.next = attributes.hasNext() ? attributes.next() : null;
                        this.nextOk = false;
                        if (this.next != null && ((Attribute)this.next).getName().getLocalPart().equals("schemaLocation")) {
                            this.next = attributes.hasNext() ? attributes.next() : null;
                        }
                        return this.next != null;
                    }

                    public Object next() {
                        this.nextOk = true;
                        return this.next;
                    }

                    @Override
                    public void remove() {
                    }
                }, importElement.getNamespaces());
            }
            mergedEvents.add(event);
        }
        return this.reorderEvents(mergedEvents);
    }

    private Queue<XMLEvent> copySchemaContent(Queue<XMLEvent> mergedEvents, Queue<XMLEvent> additional, boolean includeStart, boolean includeEnd) {
        boolean include = includeStart;
        LinkedList<XMLEvent> outEvents = new LinkedList<XMLEvent>();
        for (XMLEvent eventToInclude : additional) {
            if (include && eventToInclude.isEndElement() && "schema".equals(eventToInclude.asEndElement().getName().getLocalPart())) {
                include = includeEnd;
                outEvents.add(eventToInclude);
                continue;
            }
            if (!include) {
                if (eventToInclude.isStartElement() && "schema".equals(eventToInclude.asStartElement().getName().getLocalPart())) {
                    include = true;
                    continue;
                }
                outEvents.add(eventToInclude);
                continue;
            }
            mergedEvents.add(eventToInclude);
        }
        return outEvents;
    }

    public Queue<XMLEvent> mergeEvents(Queue<XMLEvent> target, Queue<XMLEvent> additional) {
        LinkedList<XMLEvent> importEvents1 = new LinkedList<XMLEvent>();
        LinkedList<XMLEvent> importEvents2 = new LinkedList<XMLEvent>();
        LinkedList<XMLEvent> otherEvents1 = new LinkedList<XMLEvent>();
        LinkedList<XMLEvent> otherEvents2 = new LinkedList<XMLEvent>();
        LinkedList<XMLEvent> endEvents1 = new LinkedList<XMLEvent>();
        LinkedList<XMLEvent> endEvents2 = new LinkedList<XMLEvent>();
        if (target == null) {
            return additional;
        }
        if (additional == null) {
            return target;
        }
        StartElement startEvent1 = this.separateEvents(target, importEvents1, otherEvents1, endEvents1);
        StartElement startEvent2 = this.separateEvents(additional, importEvents2, otherEvents2, endEvents2);
        LinkedList<XMLEvent> mergedEvents = new LinkedList<XMLEvent>();
        mergedEvents.add(this.mergeStartEvents(startEvent1, startEvent2));
        mergedEvents.addAll(importEvents1);
        mergedEvents.addAll(importEvents2);
        mergedEvents.addAll(otherEvents1);
        mergedEvents.addAll(otherEvents2);
        mergedEvents.addAll(endEvents1);
        return mergedEvents;
    }

    public Queue<XMLEvent> reorderEvents(Queue<XMLEvent> events) {
        if (events == null) {
            return null;
        }
        LinkedList<XMLEvent> importEvents = new LinkedList<XMLEvent>();
        LinkedList<XMLEvent> otherEvents = new LinkedList<XMLEvent>();
        LinkedList<XMLEvent> endEvents = new LinkedList<XMLEvent>();
        StartElement startEvent = this.separateEvents(events, importEvents, otherEvents, endEvents);
        LinkedList<XMLEvent> result = new LinkedList<XMLEvent>();
        result.add(startEvent);
        result.addAll(importEvents);
        result.addAll(otherEvents);
        result.addAll(endEvents);
        return result;
    }

    private XMLEvent mergeStartEvents(StartElement master, StartElement slave) {
        Namespace ns;
        Attribute attr;
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        ArrayList<String> attributeNames = new ArrayList<String>();
        Iterator<Attribute> itAttributes = master.getAttributes();
        while (itAttributes.hasNext()) {
            attr = itAttributes.next();
            attributeNames.add(attr.getName().getLocalPart());
            attributes.add(attr);
        }
        itAttributes = slave.getAttributes();
        while (itAttributes.hasNext()) {
            attr = itAttributes.next();
            if (attributeNames.contains(attr.getName().getLocalPart())) continue;
            attributes.add(attr);
        }
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        ArrayList<String> namespaceNames = new ArrayList<String>();
        Iterator<Namespace> itNamespaces = master.getNamespaces();
        while (itNamespaces.hasNext()) {
            ns = itNamespaces.next();
            namespaceNames.add(ns.getName().getLocalPart());
            namespaces.add(ns);
        }
        itNamespaces = slave.getNamespaces();
        while (itNamespaces.hasNext()) {
            ns = itNamespaces.next();
            if (namespaceNames.contains(ns.getName().getLocalPart())) continue;
            namespaces.add(ns);
        }
        return this.eventFactory.createStartElement(master.getName(), attributes.iterator(), namespaces.iterator());
    }

    private StartElement separateEvents(Queue<XMLEvent> fullEvents, Queue<XMLEvent> importEvents, Queue<XMLEvent> otherEvents, Queue<XMLEvent> endEvents) {
        assert (fullEvents != null);
        StartElement start = null;
        boolean startEventOk = false;
        boolean collectEndEvents = false;
        boolean collectImportEvents = false;
        for (XMLEvent event : fullEvents) {
            if (!startEventOk) {
                if (!event.isStartElement() || !"schema".equals(event.asStartElement().getName().getLocalPart())) continue;
                startEventOk = true;
                start = event.asStartElement();
                continue;
            }
            if (collectEndEvents) {
                endEvents.add(event);
                continue;
            }
            if (collectImportEvents) {
                importEvents.add(event);
                if (!event.isEndElement() || !"import".equals(event.asEndElement().getName().getLocalPart())) continue;
                collectImportEvents = false;
                continue;
            }
            if (event.isEndElement() && "schema".equals(event.asEndElement().getName().getLocalPart())) {
                collectEndEvents = true;
                endEvents.add(event);
                continue;
            }
            if (event.isStartElement() && "import".equals(event.asStartElement().getName().getLocalPart())) {
                collectImportEvents = true;
                importEvents.add(event);
                continue;
            }
            otherEvents.add(event);
        }
        return start;
    }

    public Map<String, XSD> treatSameNamespaces(Map<String, XSD> map, boolean rootOnly) {
        TreeMap<String, XSD> result = new TreeMap<String, XSD>();
        for (Map.Entry<String, XSD> entry : map.entrySet()) {
            XSD xsd = entry.getValue();
            if (rootOnly && this.isIncluded(entry.getKey(), map)) continue;
            XSD sameNamespace = this.containsNamespace(xsd.getTargetNamespace(), result);
            if (sameNamespace != null) {
                sameNamespace.setEvents(this.mergeEvents(sameNamespace.getEvents(), xsd.getEvents()));
                continue;
            }
            result.put(entry.getKey(), xsd);
        }
        if (result.size() == map.size()) {
            return map;
        }
        return result;
    }

    public Map<String, XSD> treatIncludeAndImport(Map<String, XSD> map, String defaultNamespaceURI, XSD forcedRoot) {
        Map<String, XSD> result = new TreeMap<String, XSD>();
        HashMap<String, TreeSet<String>> mapImportNameSpace = new HashMap<String, TreeSet<String>>();
        TreeSet<String> listIncludes = new TreeSet<String>();
        for (Map.Entry<String, XSD> entry : map.entrySet()) {
            XSD xsd = entry.getValue();
            if (this.isIncluded(entry.getKey(), map) && forcedRoot != xsd) continue;
            if (forcedRoot == xsd) {
                listIncludes.add(entry.getKey());
            }
            result.put(entry.getKey(), xsd);
            if (xsd.getImports() == null && xsd.getIncludes() == null) continue;
            TreeSet<String> mapImport = (TreeSet<String>)mapImportNameSpace.get(xsd.getTargetNamespace());
            if (mapImport == null) {
                mapImport = new TreeSet<String>();
                mapImportNameSpace.put(xsd.getTargetNamespace(), mapImport);
            }
            xsd.setEvents(this.replaceIncludeAndImport(xsd.getEvents(), map, mapImport, listIncludes, defaultNamespaceURI, new HashSet<Namespace>()));
        }
        if (result.size() == 0) {
            int bestResult = 0;
            XSD bestXSD = null;
            for (Map.Entry<String, XSD> entry : map.entrySet()) {
                XSD xsd = entry.getValue();
                if (bestXSD == null) {
                    bestXSD = xsd;
                }
                int attachements = 0;
                if (xsd.getImports() != null) {
                    attachements += xsd.getImports().size();
                }
                if (xsd.getIncludes() != null) {
                    attachements += xsd.getIncludes().size();
                }
                if (attachements <= bestResult) continue;
                bestResult = attachements;
                bestXSD = xsd;
            }
            if (bestXSD != null) {
                result = this.treatIncludeAndImport(map, defaultNamespaceURI, bestXSD);
            }
        }
        return result;
    }

    public XSD analyse(InputStream schema, boolean inline, String defaultNamespaceURI) throws XMLStreamException {
        XMLEvent xmlEvent;
        XSD result = new XSD(this.logger);
        if (!inline) {
            try {
                result.setOriginalXSD(StreamUtil.toByteArray(schema));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            schema = new ByteArrayInputStream(result.getOriginalXSD());
        }
        XMLInputFactory inputFactory = StAXFactory.newXMLInputFactory(this.logger);
        XMLStreamReader reader = inputFactory.createXMLStreamReader(schema);
        DefaultEventAllocator allocator = new DefaultEventAllocator(this.eventFactory);
        NamespaceContext nsCtx = reader.getNamespaceContext();
        boolean rootElement = true;
        boolean skipElement = false;
        while (true) {
            int event = reader.next();
            if (skipElement && event == 2) {
                skipElement = false;
            }
            xmlEvent = allocator.allocate(reader);
            if (event == 8) break;
            if (event == 1) {
                String localName = reader.getLocalName();
                if (rootElement) {
                    result.setTargetNamespace(reader.getAttributeValue(null, "targetNamespace"));
                    result.setDefaultNamespace(nsCtx.getNamespaceURI(""));
                    result.setXSDNamespace(xmlEvent.asStartElement().getName().getNamespaceURI());
                    Iterator<Namespace> itNs = xmlEvent.asStartElement().getNamespaces();
                    while (itNs.hasNext()) {
                        Namespace ns = itNs.next();
                        result.getNamespaces().add(ns);
                    }
                    if (result.getTargetNamespace() == null || result.getTargetNamespace().equals("")) {
                        StartElement startEvent = xmlEvent.asStartElement();
                        xmlEvent = this.affectTargetNamespace(startEvent, defaultNamespaceURI);
                        result.setTargetNamespace(defaultNamespaceURI);
                    }
                    if (inline && (result.getDefaultNamespace() == null || result.getDefaultNamespace().equals(""))) {
                        result.setDefaultNamespace(defaultNamespaceURI);
                    }
                    rootElement = false;
                }
                if (localName.equals("include")) {
                    result.getIncludesNotNull().add(reader.getAttributeValue(null, "schemaLocation"));
                } else if (localName.equals("import")) {
                    String namespace = reader.getAttributeValue(null, "namespace");
                    XSDWrapper xsdWrapper = result.getImportsNotNull().get(namespace);
                    if (xsdWrapper == null) {
                        xsdWrapper = new XSDWrapper();
                        xsdWrapper.setNamespaceUri(namespace);
                        result.getImportsNotNull().put(namespace, xsdWrapper);
                    }
                    xsdWrapper.getSchemaLocationList().add(reader.getAttributeValue(null, "schemaLocation"));
                }
                if (!inline) {
                    String location = null;
                    if (localName.equals("include")) {
                        location = reader.getAttributeValue(null, "schemaLocation");
                    } else if (localName.equals("import")) {
                        location = reader.getAttributeValue(null, "schemaLocation");
                    }
                    if (location != null && !XSDUtil.stripFileName(location).equals(location)) {
                        result.setFlattenedInclusion(true);
                        xmlEvent = this.stripSchemaLocationIfNecessary(xmlEvent, result.getXSDNamespace());
                    }
                }
            }
            if (skipElement) continue;
            result.getEventsNotNull().add(xmlEvent);
        }
        result.getEventsNotNull().add(xmlEvent);
        reader.close();
        return result;
    }

    private boolean hasJAXBContextClass(ClassLoader cl) {
        try {
            cl.loadClass("com.sun.xml.bind.v2.ContextFactory");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<String, XSD> generateSchema(Set<Class<?>> classes, String defaultNs, boolean inline, String fileNamePrefix, Map<String, String[]> uri2nameAndLocation, String defaultNsPrefix, Map<String, JAXBClassDesciption> javaFqn2QName, boolean ignoreXSDgeneration) throws IOException, JAXBException, XMLStreamException, PrivilegedActionException {
        ClassLoader bckup = Thread.currentThread().getContextClassLoader();
        if (this.hasJAXBContextClass(bckup)) {
            bckup = null;
        } else {
            ContextClassLoaderPrivilegedAction.execute(this.getClass().getClassLoader());
        }
        JAXBContext context = JAXBContext.newInstance(classes.toArray(new Class[classes.size()]), defaultNs, this.logger);
        if (bckup != null) {
            ContextClassLoaderPrivilegedAction.execute(bckup);
        }
        LinkedHashMap tmp = null;
        if (!ignoreXSDgeneration) {
            LinkedHashMap<String, ByteArrayOutputStream> results = new LinkedHashMap<String, ByteArrayOutputStream>();
            context.generateSchema(new JavaSchemaOutputResolver(fileNamePrefix, results));
            tmp = new LinkedHashMap(results.size());
            HashMap tragetNamespace2location = new HashMap();
            for (Map.Entry entry : results.entrySet()) {
                ((ByteArrayOutputStream)entry.getValue()).flush();
                ((ByteArrayOutputStream)entry.getValue()).close();
                XSD xsd = this.analyse(new ByteArrayInputStream(((ByteArrayOutputStream)entry.getValue()).toByteArray()), inline, defaultNs);
                tmp.put(entry.getKey(), xsd);
                String[] nameAndLocation = XSDUtil.NameAndLocationWithCreation(uri2nameAndLocation, xsd.getTargetNamespace(), (String)entry.getKey(), defaultNsPrefix);
                nameAndLocation[1] = (String)entry.getKey();
                tragetNamespace2location.put(xsd.getTargetNamespace(), entry.getKey());
            }
        }
        for (Class<?> clazz : classes) {
            String elementLocalName = context.getElementLocalName(clazz);
            String elementNamespaceURI = context.getElementNamespaceURI(clazz);
            QName qname = context.getTypeName(clazz);
            if (javaFqn2QName == null) continue;
            javaFqn2QName.put(clazz.getName(), new JAXBClassDesciption(elementLocalName, elementNamespaceURI, qname));
        }
        return tmp;
    }

    public static String[] NameAndLocationWithCreation(Map<String, String[]> uri2nameAndLocation, String namespaceURI, String location, String defaultNsPrefix) {
        String[] nameAndlocation = uri2nameAndLocation.get(namespaceURI);
        if (nameAndlocation == null) {
            nameAndlocation = new String[]{defaultNsPrefix + uri2nameAndLocation.size(), location};
            uri2nameAndLocation.put(namespaceURI, nameAndlocation);
        }
        return nameAndlocation;
    }

    public XMLEvent stripSchemaLocationIfNecessary(XMLEvent event, String xsdNamespace) {
        StartElement tmpStartElement = event.asStartElement();
        QName qname = tmpStartElement.getName();
        final Iterator<Attribute> attributes = tmpStartElement.getAttributes();
        if ((qname.getLocalPart().equals("import") || qname.getLocalPart().equals("include")) && qname.getNamespaceURI().equals(xsdNamespace)) {
            event = this.eventFactory.createStartElement(qname, new Iterator(){

                @Override
                public boolean hasNext() {
                    return attributes.hasNext();
                }

                public Object next() {
                    Attribute value = (Attribute)attributes.next();
                    if (value.getName().getLocalPart().equals("schemaLocation")) {
                        return XSDUtil.this.eventFactory.createAttribute("schemaLocation", XSDUtil.stripFileName(value.getValue()));
                    }
                    return value;
                }

                @Override
                public void remove() {
                }
            }, tmpStartElement.getNamespaces());
        }
        return event;
    }

    public XMLEvent affectTargetNamespace(StartElement event, final String defaultNamespaceURI) {
        final Iterator<Attribute> attributes = event.getAttributes();
        final Iterator<Namespace> namespaces = event.getNamespaces();
        event = this.eventFactory.createStartElement(event.getName(), new Iterator(){
            boolean first = true;

            @Override
            public boolean hasNext() {
                if (this.first) {
                    return true;
                }
                return attributes.hasNext();
            }

            public Object next() {
                if (this.first) {
                    this.first = false;
                    return XSDUtil.this.eventFactory.createAttribute("targetNamespace", defaultNamespaceURI);
                }
                return attributes.next();
            }

            @Override
            public void remove() {
            }
        }, new Iterator(){
            boolean first = true;

            @Override
            public boolean hasNext() {
                if (this.first) {
                    return true;
                }
                return namespaces.hasNext();
            }

            public Object next() {
                if (this.first) {
                    this.first = false;
                    return XSDUtil.this.eventFactory.createNamespace(defaultNamespaceURI);
                }
                return namespaces.next();
            }

            @Override
            public void remove() {
            }
        });
        return event;
    }

    static {
        class2jaxbcontext = new WeakHashMap<Class, Map<String, JAXBContext>>();
    }

    public static final class ISO8601 {
        protected Date value = null;
        private static final String[] masks = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSz", "yyyy-MM-dd't'HH:mm:ss.SSSz", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd't'HH:mm:ss.SSS'z'", "yyyy-MM-dd'T'HH:mm:ssz", "yyyy-MM-dd't'HH:mm:ssz", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd't'HH:mm:ss'z'", "yyyy-MM-dd'T'HH:mmz", "yyyy-MM-dd't'HH:mmz", "yyyy-MM-dd'T'HH:mm'Z'", "yyyy-MM-dd't'HH:mm'z'", "yyyy-MM-dd", "yyyy-MM", "yyyy"};

        public ISO8601() {
        }

        public ISO8601(String value) {
            this(ISO8601.parse(value));
        }

        public ISO8601(Date value) {
            this.value = value;
        }

        public ISO8601(Calendar value) {
            this(value.getTime());
        }

        public ISO8601(long value) {
            this(new Date(value));
        }

        public String getValue() {
            return ISO8601.format(this.value);
        }

        public void setValue(String value) {
            this.value = ISO8601.parse(value);
        }

        public void setValue(Date date) {
            this.value = date;
        }

        public void setValue(Calendar calendar) {
            this.value = calendar.getTime();
        }

        public void setValue(long timestamp) {
            this.value = new Date(timestamp);
        }

        public Date getDate() {
            return this.value;
        }

        public Calendar getCalendar() {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.value);
            return cal;
        }

        public long getTime() {
            return this.value.getTime();
        }

        public String toString() {
            return this.getValue();
        }

        public boolean equals(Object obj) {
            boolean answer = false;
            if (obj instanceof Date) {
                Date d = (Date)obj;
                answer = this.value.equals(d);
            } else if (obj instanceof String) {
                Date d = ISO8601.parse((String)obj);
                answer = this.value.equals(d);
            } else if (obj instanceof Calendar) {
                Calendar c = (Calendar)obj;
                answer = this.value.equals(c.getTime());
            } else if (obj instanceof ISO8601) {
                Date d = ((ISO8601)obj).value;
                answer = this.value.equals(d);
            }
            return answer;
        }

        public static Date parse(String date) {
            Date d = null;
            SimpleDateFormat sdf = new SimpleDateFormat();
            for (int n = 0; n < masks.length; ++n) {
                try {
                    sdf.applyPattern(masks[n]);
                    sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                    sdf.setLenient(true);
                    d = sdf.parse(date, new ParsePosition(0));
                    if (d == null) continue;
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (d == null) {
                throw new IllegalArgumentException();
            }
            return d;
        }

        public static String format(Date d) {
            StringBuffer iso8601 = new StringBuffer();
            SimpleDateFormat sdf = new SimpleDateFormat(masks[2]);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            sdf.format(d, iso8601, new FieldPosition(0));
            return iso8601.toString();
        }

        public static ISO8601 valueOf(String value) {
            return new ISO8601(value);
        }

        public static ISO8601 valueOf(Date value) {
            return new ISO8601(value);
        }

        public static ISO8601 valueOf(Calendar value) {
            return new ISO8601(value);
        }

        public static ISO8601 valueOf(long value) {
            return new ISO8601(value);
        }
    }

    public static class TypeArrayType {
        protected int depth;
        protected IlrType ilrType;

        public TypeArrayType(IlrType ilrType, int depth) {
            this.ilrType = ilrType;
            this.depth = depth;
        }

        public int getDepth() {
            return this.depth;
        }

        public IlrType getType() {
            return this.ilrType;
        }
    }

    public static class ArrayType {
        protected int depth;
        protected String javaType;

        public ArrayType(String type, int depth) {
            this.javaType = type;
            this.depth = depth;
        }

        public int getDepth() {
            return this.depth;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public ArrayType getSubArrayType() {
            if (this.depth == 0) {
                return this;
            }
            return new ArrayType(this.javaType, this.depth - 1);
        }
    }
}

