/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.xu.client.internal.ConnectionPoolConfigImpl;
import com.ibm.rules.res.xu.client.internal.DocumentBuilderPoolConfig;
import com.ibm.rules.res.xu.client.internal.PersistenceConfigImpl;
import com.ibm.rules.res.xu.client.internal.RulesetCacheConfigImpl;
import com.ibm.rules.res.xu.client.internal.TransformerPoolConfig;
import com.ibm.rules.res.xu.client.internal.jca.DescriptorException;
import com.ibm.rules.res.xu.client.internal.jca.DescriptorParser;
import com.ibm.rules.res.xu.client.internal.jca.JCAPluginsPropertyParser;
import com.ibm.rules.res.xu.client.internal.jca.ParseException;
import com.ibm.rules.res.xu.config.internal.ConnectionPoolConfig;
import com.ibm.rules.res.xu.config.internal.PersistenceConfig;
import com.ibm.rules.res.xu.config.internal.PluginConfig;
import com.ibm.rules.res.xu.config.internal.PoolConfig;
import com.ibm.rules.res.xu.config.internal.RulesetCacheConfig;
import com.ibm.rules.res.xu.config.internal.XUConfig;
import com.ibm.rules.res.xu.internal.XUException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.resource.spi.ManagedConnectionFactory;

public class XUConfigImpl
implements XUConfig {
    protected final ConnectionPoolConfig connPoolConfig;
    protected final PoolConfig documentBuilderPoolConfig;
    protected final PoolConfig transformerPoolConfig;
    protected final PersistenceConfig persistenceConfig;
    protected final RulesetCacheConfig rulesetCacheConfig;
    protected final ManagedConnectionFactory factory;

    public XUConfigImpl(ManagedConnectionFactory factory) {
        this.factory = factory;
        this.documentBuilderPoolConfig = new DocumentBuilderPoolConfig(factory);
        this.transformerPoolConfig = new TransformerPoolConfig(factory);
        this.persistenceConfig = new PersistenceConfigImpl(factory);
        this.rulesetCacheConfig = new RulesetCacheConfigImpl(factory);
        this.connPoolConfig = new ConnectionPoolConfigImpl(factory);
    }

    @Override
    public final PoolConfig getDocumentBuilderPoolConfig() throws XUException {
        return this.documentBuilderPoolConfig;
    }

    @Override
    public final PoolConfig getTransformerPoolConfig() {
        return this.transformerPoolConfig;
    }

    @Override
    public final void loadJCADescriptor(InputStream in) throws DescriptorException {
        DescriptorParser parser = new DescriptorParser();
        Map<String, Object> props = parser.getConfigProperties(in);
        for (Map.Entry<String, Object> p : props.entrySet()) {
            XUConfigImpl.setConfigProperty(this.factory, p.getKey(), p.getValue());
        }
    }

    @Override
    public final void setLogLevel(Level lvl) throws XUException {
        try {
            Object xuCfg = XUConfigImpl.getXUConfig(this.factory);
            Method m = xuCfg.getClass().getDeclaredMethod("setLogLevel", Level.class);
            m.invoke(xuCfg, lvl);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_SET_PROPERTY_FAIL, new String[]{"logLevel"}, (Throwable)e);
        }
    }

    @Override
    public final Level getLogLevel() throws XUException {
        try {
            Object xuCfg = XUConfigImpl.getXUConfig(this.factory);
            Method m = xuCfg.getClass().getDeclaredMethod("getLogLevel", new Class[0]);
            return (Level)m.invoke(xuCfg, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_GET_PROPERTY_FAIL, new String[]{"logLevel"}, (Throwable)e);
        }
    }

    @Override
    public final void setLogAutoFlush(Boolean autoflush) throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("setLogAutoFlush", Boolean.class);
            m.invoke((Object)this.factory, autoflush);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_SET_PROPERTY_FAIL, new String[]{"logAutoFlush"}, (Throwable)e);
        }
    }

    @Override
    public final Boolean getLogAutoFlush() throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("getLogAutoFlush", new Class[0]);
            return (Boolean)m.invoke((Object)this.factory, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_GET_PROPERTY_FAIL, new String[]{"logAutoFlush"}, (Throwable)e);
        }
    }

    @Override
    public final PersistenceConfig getPersistenceConfig() throws XUException {
        return this.persistenceConfig;
    }

    @Override
    public final RulesetCacheConfig getRulesetCacheConfig() throws XUException {
        return this.rulesetCacheConfig;
    }

    @Override
    public final void setPluginConfigs(List<PluginConfig> cfg) throws XUException {
        XUConfigImpl.setConfigProperty(this.factory, "plugins", JCAPluginsPropertyParser.toString(cfg));
    }

    static final void setConfigProperty(ManagedConnectionFactory factory, String name, Object value) throws DescriptorException {
        Class<?> type = value.getClass();
        String methodName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            Method method = factory.getClass().getMethod(methodName, type);
            method.invoke((Object)factory, value);
        }
        catch (NoSuchMethodException e) {
            throw new DescriptorException("XU.ERROR.10100", new String[]{name, value.toString()}, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DescriptorException("XU.ERROR.10100", new String[]{name, value.toString()}, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new DescriptorException("XU.ERROR.10100", new String[]{name, value.toString()}, (Throwable)e);
        }
    }

    static final Object getConfigProperty(ManagedConnectionFactory factory, String name) throws DescriptorException {
        String methodName = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        try {
            Method method = factory.getClass().getMethod(methodName, new Class[0]);
            return method.invoke((Object)factory, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new DescriptorException("XU.ERROR.10100", new String[]{name}, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DescriptorException("XU.ERROR.10100", new String[]{name}, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new DescriptorException("XU.ERROR.10100", new String[]{name}, (Throwable)e);
        }
    }

    @Override
    public final void setProfilingInfoLogged(boolean enable) throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("setProfilingEnabled", Boolean.class);
            m.invoke((Object)this.factory, enable);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_SET_PROPERTY_FAIL, new String[]{"profilingEnabled"}, (Throwable)e);
        }
    }

    @Override
    public final Boolean isProfilingInfoLogged() throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("getProfilingEnabled", new Class[0]);
            return (Boolean)m.invoke((Object)this.factory, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_GET_PROPERTY_FAIL, new String[]{"profilingEnabled"}, (Throwable)e);
        }
    }

    @Override
    public final List<PluginConfig> getPluginConfigs() throws XUException {
        String str = (String)XUConfigImpl.getConfigProperty(this.factory, "plugins");
        try {
            return JCAPluginsPropertyParser.parsePluginConfigs(str);
        }
        catch (ParseException e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_GET_PROPERTY_FAIL, new String[]{"pluginConfigs"}, (Throwable)e);
        }
    }

    @Override
    public final void setRulesetUsageMonitorEnabled(Boolean enable) throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("setRulesetUsageMonitorEnabled", Boolean.class);
            m.invoke((Object)this.factory, enable);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_SET_PROPERTY_FAIL, new String[]{"rulesetUsageMonitorEnabled"}, (Throwable)e);
        }
    }

    @Override
    public final Boolean isRulesetUsageMonitorEnabled() throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("getRulesetUsageMonitorEnabled", new Class[0]);
            return (Boolean)m.invoke((Object)this.factory, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_GET_PROPERTY_FAIL, new String[]{"rulesetUsageMonitorEnabled"}, (Throwable)e);
        }
    }

    @Override
    public final Boolean isAsynchronousRulesetParsingEnabled() throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("getAsynchronousRulesetParsing", new Class[0]);
            return (Boolean)m.invoke((Object)this.factory, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_GET_PROPERTY_FAIL, new String[]{"asynchronousRulesetParsing"}, (Throwable)e);
        }
    }

    @Override
    public final void setAsynchronousRulesetParsingEnabled(Boolean enable) throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("setAsynchronousRulesetParsing", Boolean.class);
            m.invoke((Object)this.factory, enable);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_SET_PROPERTY_FAIL, new String[]{"asynchronousRulesetParsing"}, (Throwable)e);
        }
    }

    protected static final Object getXUConfig(ManagedConnectionFactory factory) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = factory.getClass().getDeclaredMethod("getXUConfig", new Class[0]);
        return m.invoke((Object)factory, new Object[0]);
    }

    @Override
    public final Boolean isConcurrentOpenCloseEnabled() throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("getConcurrentOpenClose", new Class[0]);
            return (Boolean)m.invoke((Object)this.factory, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_GET_PROPERTY_FAIL, new String[]{"concurrentOpenClose"}, (Throwable)e);
        }
    }

    @Override
    public final void setConcurrentOpenCloseEnabled(Boolean enable) throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("setConcurrentOpenClose", Boolean.class);
            m.invoke((Object)this.factory, enable);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_SET_PROPERTY_FAIL, new String[]{"concurrentOpenClose"}, (Throwable)e);
        }
    }

    @Override
    public final ConnectionPoolConfig getConnectionPoolConfig() throws XUException {
        return this.connPoolConfig;
    }

    @Override
    public final void setCompiledArchivesCacheProperties(Map<String, String> props) throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("getXUConfig", new Class[0]);
            Object cfg = m.invoke((Object)this.factory, new Object[0]);
            m = cfg.getClass().getDeclaredMethod("setCompiledArchivesCacheProperties", Map.class);
            m.invoke(cfg, props);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_SET_PROPERTY_FAIL, new String[]{"compiledArchivesCacheProperties"}, (Throwable)e);
        }
    }

    @Override
    public final Map<String, String> getCompiledArchivesCacheProperties() throws XUException {
        try {
            Method m = this.factory.getClass().getDeclaredMethod("getXUConfig", new Class[0]);
            Object cfg = m.invoke((Object)this.factory, new Object[0]);
            m = cfg.getClass().getDeclaredMethod("getCompiledArchivesCacheProperties", new Class[0]);
            return (Map)m.invoke(cfg, new Object[0]);
        }
        catch (Exception e) {
            throw new XUException(XUMessageCode.ERROR_XUCONFIG_GET_PROPERTY_FAIL, new String[]{"compiledArchivesCacheProperties"}, (Throwable)e);
        }
    }
}

