/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal;

import com.ibm.rules.res.xu.client.internal.OperationListParameter;
import com.ibm.rules.res.xu.client.internal.OperationMapParameter;
import com.ibm.rules.res.xu.client.internal.OperationParameter;
import com.ibm.rules.res.xu.client.internal.XUSession;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.xu.cci.IlrXUManagementInteractionSpec;
import java.util.Map;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;

public class XUManagementSession
extends XUSession {
    public XUManagementSession(Connection connection, ConnectionFactory factory) {
        super(connection, factory);
    }

    public void startMaintenanceTasks() throws XUException {
        this.checkConnection();
        this.executeOperation(IlrXUManagementInteractionSpec.FUNCTION_NAME_START_MAINTENANCE_TASKS, null, null);
    }

    public Map<String, Object> getRulesetUsageInformation(IlrPath canonicalRulesetPath) throws XUException {
        this.checkConnection();
        IlrXUManagementInteractionSpec spec = new IlrXUManagementInteractionSpec();
        spec.setFunctionName(IlrXUManagementInteractionSpec.FUNCTION_NAME_GET_RULESET_USAGE_INFORMATION);
        spec.setCanonicalRulesetPath(canonicalRulesetPath.toString());
        OperationMapParameter out = new OperationMapParameter();
        this.executeOperation(spec, null, (OperationParameter)out);
        return out;
    }

    public void notifyRulesetArchiveChanged(IlrPath rulesetPath) throws XUException {
        if (rulesetPath == null) {
            throw new XUException("XU.ERROR.19000");
        }
        this.checkConnection();
        IlrXUManagementInteractionSpec spec = new IlrXUManagementInteractionSpec();
        spec.setFunctionName(IlrXUManagementInteractionSpec.FUNCTION_NAME_RULESET_ARCHIVE_CHANGED);
        spec.setCanonicalRulesetPath(rulesetPath.toString());
        this.executeOperation(spec, null, null);
    }

    public IlrPath solveRulesetPath(IlrPath rulesetPath) throws XUException {
        this.checkConnection();
        IlrXUManagementInteractionSpec spec = new IlrXUManagementInteractionSpec();
        spec.setFunctionName(IlrXUManagementInteractionSpec.FUNCTION_NAME_SOLVE_RULESET_PATH);
        spec.setRulesetPath(rulesetPath.toString());
        OperationListParameter out = new OperationListParameter();
        this.executeOperation(spec, null, (OperationParameter)out);
        try {
            return IlrPath.parsePath((String)out.get(0));
        }
        catch (IlrFormatException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
    }
}

