/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal;

import com.ibm.rules.res.xu.client.internal.OperationListParameter;
import com.ibm.rules.res.xu.client.internal.OperationMapParameter;
import com.ibm.rules.res.xu.client.internal.OperationParameter;
import com.ibm.rules.res.xu.client.internal.OperationSpec;
import com.ibm.rules.res.xu.client.internal.XUWarningListener;
import com.ibm.rules.res.xu.client.internal.XUWarningListenerSupport;
import com.ibm.rules.res.xu.client.internal.jca.JCAWarning;
import com.ibm.rules.res.xu.client.internal.jca.JCAWarningWrapper;
import com.ibm.rules.res.xu.client.internal.jca.XUInteractionSpec;
import com.ibm.rules.res.xu.internal.LocalizedResourceException;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.xu.cci.IlrConnectionId;
import ilog.rules.res.xu.cci.IlrXUConnection;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.resource.cci.ResourceWarning;

public class XUSession {
    protected Connection connection;
    protected ConnectionFactory factory;
    protected XUWarningListenerSupport listenerSupport;
    protected static final XUInteractionSpec getConnectionIdInteractionSpec = new XUInteractionSpec();

    XUSession(Connection connection, ConnectionFactory factory) {
        this.connection = connection;
        this.factory = factory;
        this.listenerSupport = new XUWarningListenerSupport();
    }

    public void setUserData(Serializable userData) throws XUException {
        this.checkConnection();
        OperationListParameter in = new OperationListParameter(1);
        in.add(userData);
        this.executeOperation(XUInteractionSpec.FUNCTION_NAME_SET_USER_DATA, (OperationParameter)in, null);
    }

    public void close() throws XUException {
        this.checkConnection();
        try {
            this.connection.close();
            this.connection = null;
            this.factory = null;
        }
        catch (ResourceException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
    }

    public void writeLog(String message) throws XUException {
        this.checkConnection();
        OperationListParameter in = new OperationListParameter(1);
        in.add(message);
        this.executeOperation(XUInteractionSpec.FUNCTION_NAME_WRITE_LOG, (OperationParameter)in, null);
    }

    public IlrConnectionId getConnectionId() throws XUException {
        this.checkConnection();
        try {
            OperationListParameter out = new OperationListParameter();
            this.executeOperation(getConnectionIdInteractionSpec, null, (OperationParameter)out);
            return IlrConnectionId.toConnectionId(out.get(0));
        }
        catch (NoSuchFieldException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
        catch (IllegalAccessException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
        catch (NoSuchMethodException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
        catch (InstantiationException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
        catch (InvocationTargetException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
    }

    public Map<String, Object> getConnectorConfigProperties() throws XUException {
        this.checkConnection();
        OperationMapParameter out = new OperationMapParameter();
        this.executeOperation(XUInteractionSpec.FUNCTION_NAME_GET_CONNECTOR_CONFIG_PROPERTIES, null, (OperationParameter)out);
        return out;
    }

    public void addXUWarningListener(XUWarningListener listener) {
        this.listenerSupport.addResourceWarningListener(listener);
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected void checkConnection() {
        if (this.connection == null) {
            throw new IllegalStateException();
        }
    }

    protected final void fireWarnings(IlrXUConnection conn) {
        ResourceWarning w = conn.getWarnings();
        if (w != null) {
            if (w instanceof JCAWarning) {
                this.listenerSupport.fire((JCAWarning)w);
            } else {
                this.listenerSupport.fire(new JCAWarningWrapper((Serializable)w));
            }
            conn.clearWarnings();
        }
    }

    public final boolean executeOperation(OperationSpec spec, OperationParameter in, OperationParameter out) throws XUException {
        Interaction interaction = null;
        try {
            interaction = this.connection.createInteraction();
            boolean result = interaction.execute((InteractionSpec)spec, (Record)in, (Record)out);
            ResourceWarning w = interaction.getWarnings();
            if (w != null) {
                if (w instanceof JCAWarning) {
                    this.listenerSupport.fire((JCAWarning)w);
                } else {
                    this.listenerSupport.fire(new JCAWarningWrapper((Serializable)w));
                }
                interaction.clearWarnings();
            }
            boolean bl = result;
            return bl;
        }
        catch (LocalizedResourceException e) {
            throw new XUException(e.getMessageCode(), e.getMessageParameters(), e.getCause());
        }
        catch (ResourceException e) {
            throw new XUException("XU.ERROR.10900", e);
        }
        finally {
            if (interaction != null) {
                try {
                    interaction.close();
                }
                catch (ResourceException ignore) {}
            }
        }
    }

    protected boolean executeOperation(String name, OperationParameter in, OperationParameter out) throws XUException {
        XUInteractionSpec spec = new XUInteractionSpec();
        spec.setFunctionName(name);
        return this.executeOperation(spec, in, out);
    }

    static {
        getConnectionIdInteractionSpec.setFunctionName(XUInteractionSpec.FUNCTION_NAME_GET_CONNECTION_ID);
    }
}

