/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal.jca;

import com.ibm.rules.res.xu.client.internal.jca.DescriptorException;
import com.ibm.rules.res.xu.client.internal.jca.OutboundRADescriptor;
import com.ibm.rules.res.xu.client.internal.jca.RADescriptor;
import ilog.rules.res.util.xml.IlrDOMUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DescriptorParser {
    protected static final String OUTBOUND_RESOURCE_ADAPTER_TAG_NAME = "outbound-resourceadapter";
    protected static final String CONNECTOR_TAG_NAME = "connector";
    protected static final String RESOURCE_ADAPTER_TAG_NAME = "resourceadapter";
    protected static final String MANAGED_CONNECTION_FACTORY_CLASS_TAG_NAME = "managedconnectionfactory-class";
    protected static final String CONFIG_PROPERTY_TAG_NAME = "config-property";
    protected static final String CONFIG_PROPERTY_NAME_TAG_NAME = "config-property-name";
    protected static final String CONFIG_PROPERTY_VALUE_TAG_NAME = "config-property-value";
    protected static final String CONFIG_PROPERTY_TYPE_TAG_NAME = "config-property-type";
    protected static final String CONNECTION_DEFINITION_TAG_NAME = "connection-definition";
    protected Logger logger = null;

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Map<String, Object> getConfigProperties(InputStream in) throws DescriptorException {
        RADescriptor desc = this.parse(in);
        return desc.getOutboundResourceAdapters().next().getConfigProperties();
    }

    public RADescriptor parse(InputStream input) throws DescriptorException {
        try {
            Document doc = this.parseDocument(input);
            Element connector = doc.getDocumentElement();
            if (!connector.getAttribute("version").equals("1.5")) {
                throw new DescriptorException("XU.ERROR.10307", null, null);
            }
            if (!connector.getTagName().equals(CONNECTOR_TAG_NAME)) {
                throw new DescriptorException("XU.ERROR.10300", null, null);
            }
            Element ra = IlrDOMUtil.getFirstElementByTagName(connector, RESOURCE_ADAPTER_TAG_NAME);
            if (ra == null) {
                throw new DescriptorException("XU.ERROR.10301", null, null);
            }
            NodeList outboundRAs = IlrDOMUtil.getChildElementsByTagName(ra, OUTBOUND_RESOURCE_ADAPTER_TAG_NAME);
            ArrayList<OutboundRADescriptor> descriptors = new ArrayList<OutboundRADescriptor>();
            for (int i = 0; i < outboundRAs.getLength(); ++i) {
                descriptors.add(this.toOutboundRA((Element)outboundRAs.item(i)));
            }
            return new RADescriptor(connector.getAttribute("version"), descriptors);
        }
        catch (ParserConfigurationException e) {
            throw new DescriptorException("XU.ERROR.10308", null, (Throwable)e);
        }
        catch (SAXException e) {
            throw new DescriptorException("XU.ERROR.10303", null, (Throwable)e);
        }
        catch (IOException e) {
            throw new DescriptorException("XU.ERROR.10308", null, (Throwable)e);
        }
    }

    protected Document parseDocument(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        return this.createDocumentBuilder().parse(input);
    }

    protected OutboundRADescriptor toOutboundRA(Element elt) throws DescriptorException {
        Element connDef = IlrDOMUtil.getFirstElementByTagName(elt, CONNECTION_DEFINITION_TAG_NAME);
        if (connDef == null) {
            throw new DescriptorException("XU.ERROR.10309", new String[]{CONNECTION_DEFINITION_TAG_NAME}, null);
        }
        Element spiConnFactoryClassElt = IlrDOMUtil.getFirstElementByTagName(connDef, MANAGED_CONNECTION_FACTORY_CLASS_TAG_NAME);
        if (spiConnFactoryClassElt == null) {
            throw new DescriptorException("XU.ERROR.10302", null, null);
        }
        String spiConnFactoryClass = IlrDOMUtil.textNodesToString(spiConnFactoryClassElt.getChildNodes());
        if (spiConnFactoryClass == null) {
            throw new DescriptorException("XU.ERROR.10302", null, null);
        }
        spiConnFactoryClass = spiConnFactoryClass.trim();
        NodeList cfgPropElts = IlrDOMUtil.getChildElementsByTagName(connDef, CONFIG_PROPERTY_TAG_NAME);
        Map<String, Object> props = this.toConfigProperties(cfgPropElts);
        return new OutboundRADescriptor(spiConnFactoryClass, props);
    }

    protected DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (this.logger != null) {
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException e) {
                    if (e.getMessage() == null) {
                        DescriptorParser.this.logger.severe("null");
                    } else {
                        DescriptorParser.this.logger.severe(e.getMessage());
                    }
                }

                @Override
                public void warning(SAXParseException e) {
                    DescriptorParser.this.logger.warning(e.getMessage());
                }

                @Override
                public void fatalError(SAXParseException e) {
                    DescriptorParser.this.logger.severe(e.getMessage());
                }
            });
        }
        return builder;
    }

    protected Map<String, Object> toConfigProperties(NodeList configPropertyElements) throws DescriptorException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < configPropertyElements.getLength(); ++i) {
            this.addConfigProperty(result, (Element)configPropertyElements.item(i));
        }
        return result;
    }

    protected void addConfigProperty(Map<String, Object> props, Element configPropertyElement) throws DescriptorException {
        Element nameElt = IlrDOMUtil.getFirstElementByTagName(configPropertyElement, CONFIG_PROPERTY_NAME_TAG_NAME);
        if (nameElt == null) {
            throw new DescriptorException("XU.ERROR.10304");
        }
        String name = IlrDOMUtil.textNodesToString(nameElt.getChildNodes());
        if (name == null || name.trim().equals("")) {
            throw new DescriptorException("XU.ERROR.10304");
        }
        Element typeElt = IlrDOMUtil.getFirstElementByTagName(configPropertyElement, CONFIG_PROPERTY_TYPE_TAG_NAME);
        Class<?> type = this.toConfigPropertyType(typeElt);
        Element valueElt = IlrDOMUtil.getFirstElementByTagName(configPropertyElement, CONFIG_PROPERTY_VALUE_TAG_NAME);
        if (valueElt == null) {
            throw new DescriptorException("XU.ERROR.10305", new String[]{name}, null);
        }
        Object value = this.toConfigPropertyValue(valueElt, type);
        props.put(name, value);
    }

    protected Class<?> toConfigPropertyType(Element typeElement) throws DescriptorException {
        String strType = IlrDOMUtil.textNodesToString(typeElement.getChildNodes());
        if (strType == null || (strType = strType.trim()).equals("")) {
            throw new DescriptorException("XU.ERROR.10306", new String[]{strType}, null);
        }
        try {
            return Class.forName(strType);
        }
        catch (ClassNotFoundException e) {
            throw new DescriptorException("XU.ERROR.10306", new String[]{strType}, (Throwable)e);
        }
    }

    protected Object toConfigPropertyValue(Element elt, Class<?> type) throws DescriptorException {
        String className;
        String strValue = IlrDOMUtil.textNodesToString(elt.getChildNodes());
        if (strValue == null) {
            strValue = "";
        }
        if ((className = type.getName()).equals("java.lang.String")) {
            return strValue;
        }
        if (className.equals("java.lang.Boolean")) {
            return new Boolean(strValue);
        }
        if (className.equals("java.lang.Integer")) {
            return new Integer(strValue);
        }
        if (className.equals("java.lang.Long")) {
            return new Long(strValue);
        }
        throw new DescriptorException("XU.ERROR.10306", new String[]{className}, null);
    }
}

