/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.res.xu.client.internal.jca;

import com.ibm.rules.res.xu.client.internal.OperationSpec;
import com.ibm.rules.res.xu.client.internal.jca.JCAInteractionFunctionNames;
import com.ibm.rules.res.xu.internal.XUException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import javax.resource.cci.InteractionSpec;

public class XUInteractionSpec
implements OperationSpec,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final ConcurrentHashMap<String, String> functionNames = new ConcurrentHashMap();
    protected String functionName = null;
    protected final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String FUNCTION_NAME_GET_CONNECTION_ID = XUInteractionSpec.intern("connectionId");
    public static final String FUNCTION_NAME_WRITE_LOG = XUInteractionSpec.intern("log.write");
    public static final String FUNCTION_NAME_SET_USER_DATA = XUInteractionSpec.intern("userdata.set");
    public static final String FUNCTION_NAME_GET_CONNECTOR_CONFIG_PROPERTIES = XUInteractionSpec.intern("connector.getConfigProperties");

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        String oldFunctionName = this.functionName;
        this.functionName = functionName;
        this.propertyChangeSupport.firePropertyChange("functionName", oldFunctionName, functionName);
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String toString() {
        return this.getClass().getName() + "[functionName=" + this.functionName + "]";
    }

    public static final String intern(String str) {
        String v = functionNames.putIfAbsent(str, str);
        if (v == null) {
            return str;
        }
        return v;
    }

    public static final String getFunctionName(InteractionSpec spec) throws XUException {
        String fct;
        if (spec instanceof XUInteractionSpec) {
            fct = ((XUInteractionSpec)spec).getFunctionName();
        } else {
            fct = JCAInteractionFunctionNames.getFunctionName(spec);
            fct = XUInteractionSpec.intern(fct);
        }
        if (fct == null) {
            throw new XUException("XU.ERROR.10012", new String[]{spec.toString()});
        }
        return fct;
    }
}

