/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.rest;

import com.ibm.rules.rest.Converter;
import com.ibm.rules.rest.HTTPError;
import com.ibm.rules.rest.io.RESTRequestMultipartParser;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RESTContext {
    public static final String GROUP_BY = "groupby";
    public static final String COUNT = "count";
    public static final String REGEXP_START = "exp(";
    public static final int REGEXP_START_LENGTH = "exp(".length();
    public static final String REGEXP_END = ")";
    public static final int REGEXP_END_LENGTH = ")".length();
    private short method;
    private String context;
    private String location;
    private Map<String, String> headersIn;
    private final Map<String, String> headersOut = new HashMap<String, String>();
    private Map<String, String> parameters;
    private Map<String, RESTRequestMultipartParser.Part> files;
    private byte[] body;
    private Locale locale = Locale.getDefault();
    private String version = "1.0";
    private String messageId;
    private String authToken;
    private String contentType;
    private Converter converterIn;
    private Converter converterOut;
    private Object incomingObject;
    private boolean iso8601dateFormat = false;
    private String charEncoding;

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public short getMethod() {
        return this.method;
    }

    public void setMethod(short method) {
        this.method = method;
    }

    public Map<String, String> getHeadersIn() {
        return this.headersIn;
    }

    public void setHeadersIn(Map<String, String> headers) {
        this.headersIn = headers;
    }

    public Map<String, String> getHeadersOut() {
        return this.headersOut;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<String, RESTRequestMultipartParser.Part> getFiles() {
        return this.files;
    }

    public void setFiles(Map<String, RESTRequestMultipartParser.Part> files) {
        this.files = files;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean isIso8601dateFormat() {
        return this.iso8601dateFormat;
    }

    public void setIso8601dateFormat(boolean iso8601dateFormat) {
        this.iso8601dateFormat = iso8601dateFormat;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getMessageId() {
        if (this.messageId == null) {
            // empty if block
        }
        return this.messageId;
    }

    public String getAuthToken() {
        if (this.authToken == null) {
            // empty if block
        }
        return this.authToken;
    }

    public Converter getConverterIn() {
        return this.converterIn;
    }

    public void setConverterIn(Converter converter) {
        this.converterIn = converter;
    }

    public Converter getConverterOut() {
        return this.converterOut;
    }

    public void setConverterOut(Converter converter) {
        this.converterOut = converter;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getCharacterEncoding() {
        return this.charEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.charEncoding = characterEncoding;
    }

    public Object computeIncomingObject(Class<?> clazz, Converter dataReader) {
        if (this.method != 1 && this.body.length > 0) {
            this.incomingObject = dataReader.toObject(clazz, this.body, this);
        }
        return this.incomingObject;
    }

    public void prechecks() {
        Map<String, String> params = this.getParameters();
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (entry.getValue() == null || entry.getValue().length() == 0 || GROUP_BY.equals(entry.getKey()) || !entry.getValue().startsWith(REGEXP_START) || !entry.getValue().endsWith(REGEXP_END)) continue;
                try {
                    String regex = entry.getValue().substring(REGEXP_START_LENGTH, entry.getValue().length() - REGEXP_END_LENGTH);
                    Pattern.compile(regex);
                }
                catch (PatternSyntaxException e) {
                    throw new HTTPError(412, "'" + entry.getKey() + "'='" + entry.getValue() + "': " + e.getMessage(), null);
                }
            }
        }
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public static enum Format {
        XML,
        JSON;

    }
}

