/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.rest.io;

import com.ibm.rules.rest.io.RESTRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MultipartStream;

public class RESTRequestMultipartParser
extends FileUploadBase {
    private static final Pattern CONTENT_TYPE_BOUNDARY = Pattern.compile("multipart/(?:[^\\;]*);(?:[\\s]*)boundary=(.*)");

    public Map<String, Part> extractMultipart(RESTRequest req, byte[] data, Map<String, String> parameters) throws MultipartStream.MalformedStreamException, IOException, FileUploadException {
        HashMap<String, Part> result = new HashMap<String, Part>();
        String contentType = req.getHeaders().get("Content-type".toLowerCase());
        if (null != contentType && contentType.startsWith("multipart/")) {
            Matcher m = CONTENT_TYPE_BOUNDARY.matcher(contentType);
            byte[] boundary = null;
            if (m.matches()) {
                boundary = m.group(1).getBytes();
            }
            if (data != null) {
                MultipartStream mStream = new MultipartStream((InputStream)new ByteArrayInputStream(data), boundary);
                boolean haveNext = mStream.skipPreamble();
                while (haveNext) {
                    Part part = new Part();
                    Map headers = this.parseHeaders(mStream.readHeaders());
                    part.setHeaders(headers);
                    String fieldName = this.getFieldName(headers);
                    if (fieldName != null) {
                        String otherContentType = this.getHeader(headers, "Content-type".toLowerCase());
                        if (otherContentType != null && otherContentType.startsWith("multipart/mixed")) {
                            m = CONTENT_TYPE_BOUNDARY.matcher(otherContentType);
                            byte[] otherBoundary = null;
                            if (m.matches()) {
                                boundary = m.group(1).getBytes();
                            }
                            mStream.setBoundary(otherBoundary);
                            boolean otherHaveNext = mStream.skipPreamble();
                            while (otherHaveNext) {
                                headers = this.parseHeaders(mStream.readHeaders());
                                if (this.getFileName(headers) != null) {
                                    part.setContent(this.readBody(mStream));
                                    result.put(this.getFieldName(headers), part);
                                } else {
                                    mStream.discardBodyData();
                                }
                                otherHaveNext = mStream.readBoundary();
                            }
                            mStream.setBoundary(boundary);
                        } else if (this.getFileName(headers) != null) {
                            part.setContent(this.readBody(mStream));
                            result.put(this.getFieldName(headers), part);
                        } else {
                            parameters.put(this.getFieldName(headers), new String(this.readBody(mStream)));
                        }
                    } else {
                        mStream.discardBodyData();
                    }
                    haveNext = mStream.readBoundary();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readBody(MultipartStream mStream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            mStream.readBodyData((OutputStream)os);
        }
        finally {
            os.close();
        }
        return os.toByteArray();
    }

    public FileItemFactory getFileItemFactory() {
        return null;
    }

    public void setFileItemFactory(FileItemFactory factory) {
    }

    public static class Part {
        private Map<String, String> headers = null;
        private byte[] content = null;

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setHeaders(Map<String, String> headers) {
            this.headers = headers;
        }

        public byte[] getContent() {
            return this.content;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }
    }
}

