/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rules.util.ffdc;

import com.ibm.rules.util.ffdc.FFDCManager;
import com.ibm.rules.util.ffdc.FFDCManagerImpl;
import com.ibm.rules.util.ffdc.NullFFDCManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class FFDCLogger {
    protected static final FFDCManager manager = FFDCLogger.createManager();

    private static FFDCManager createManager() {
        try {
            Class<?> managerClass = Class.forName("com.ibm.ffdc.Manager");
            Field ffdcSingletonField = managerClass.getDeclaredField("Ffdc");
            Method simpleLogMethod = managerClass.getMethod("log", Throwable.class, Object.class, String.class, String.class);
            Method detailedLogMethod = managerClass.getMethod("log", Throwable.class, Object.class, String.class, String.class, Object[].class);
            if (ffdcSingletonField != null) {
                return new FFDCManagerImpl(ffdcSingletonField.get(null), simpleLogMethod, detailedLogMethod);
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return new NullFFDCManager();
    }

    public static void log(Throwable issue, Object emitter, String emitterClassName, String probeID) {
        manager.log(issue, emitter, emitterClassName, probeID);
    }

    public static void log(Throwable issue, Object emitter, String emitterClassName, String probeID, Object ... details) {
        manager.log(issue, emitter, emitterClassName, probeID, details);
    }
}

