/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.archive;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.archive.IlrRulesetArchiveLoader;
import ilog.rules.util.prefs.IlrMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class IlrArchiveLoader
extends IlrRulesetArchiveLoader {
    IlrRulesetArchive archive;
    private static int nbReadBytes = 1024;

    public IlrArchiveLoader(IlrRulesetArchive archive) {
        this.archive = archive;
    }

    @Override
    public IlrRulesetArchive.Element getEntry(String entryName) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IlrRulesetArchive.Element element = null;
        int[] size = new int[1];
        this.extractBytes(entryName, outputStream, size);
        if (size[0] != -1) {
            element = this.currentArchive.createElement(entryName, outputStream.toByteArray(), false, size[0]);
        }
        return element;
    }

    @Override
    public IlrRulesetArchive.Element getCompressedEntry(String entryName) {
        IlrRulesetArchive.Element element = null;
        int[] size = new int[1];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipStream = new GZIPOutputStream(outputStream);
            this.extractBytes(entryName, gzipStream, size);
        }
        catch (IOException ex) {
            String msg = IlrMessages.format("messages.RulesetArchive.18", entryName);
            throw new IlrRulesetArchive.RulesetArchiveException(ex, msg);
        }
        if (size[0] != -1) {
            element = this.currentArchive.createElement(entryName, outputStream.toByteArray(), true, size[0]);
        }
        return element;
    }

    private void extractBytes(String entryName, OutputStream outputStream, int[] size) {
        IlrRulesetArchive.Element elt = this.archive.getElement(entryName);
        try {
            if (elt != null) {
                byte[] content = elt.getContent();
                if (content != null) {
                    outputStream.write(content, 0, content.length);
                    size[0] = elt.getUncompressedSize();
                } else {
                    size[0] = -1;
                }
                outputStream.close();
            } else {
                size[0] = -1;
            }
        }
        catch (IOException ex) {
            String msg = IlrMessages.format("messages.RulesetArchive.2", entryName);
            size[0] = -1;
            throw new IlrRulesetArchive.RulesetArchiveException(ex, msg);
        }
    }

    @Override
    boolean collectUserData(Map entries) {
        Collection userdata = this.archive.getElements();
        for (IlrRulesetArchive.Element elt : userdata) {
            String name = elt.getKey();
            if (!IlrRulesetArchive.isUserData(name)) continue;
            IlrRulesetArchive.Element element = elt.copy();
            entries.put(elt.getKey(), element);
        }
        return true;
    }
}

