/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.archive;

import ilog.rules.archive.IlrContentManager;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.util.prefs.IlrMessages;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class IlrFileStorage
implements IlrContentManager {
    private HashMap contents = new HashMap();
    private String directory;
    private boolean deleteRoot = false;

    public IlrFileStorage(String directory) {
        this(directory, false);
    }

    public IlrFileStorage(String directory, boolean delete) {
        this.setDirectory(directory, delete);
    }

    public IlrFileStorage() {
    }

    public void setDirectory(String directory, boolean delete) {
        this.deleteRoot = delete;
        this.directory = directory;
        try {
            File dir = new File(this.directory);
            if (!dir.exists()) {
                dir.mkdirs();
            }
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
    }

    public String getDirectory() {
        return this.directory;
    }

    @Override
    public byte[] getContent(IlrRulesetArchive.Element elt) {
        byte[] result;
        if (this.directory == null) {
            String msg = IlrMessages.getMessage("messages.ContentManager.2");
            throw new IlrRulesetArchive.RulesetArchiveException(msg);
        }
        String filename = (String)this.contents.get(elt);
        try {
            FileInputStream stream = new FileInputStream(filename);
            int nbread = -1;
            byte[] theBytes = new byte[1024];
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while ((nbread = stream.read(theBytes)) != -1) {
                output.write(theBytes, 0, nbread);
            }
            output.close();
            stream.close();
            result = output.toByteArray();
        }
        catch (IOException ex) {
            String msg = IlrMessages.format("messages.ContentManager.1", filename);
            throw new IlrRulesetArchive.RulesetArchiveException(ex, msg);
        }
        return result;
    }

    @Override
    public void setContent(IlrRulesetArchive.Element elt, byte[] content) {
        if (this.directory == null) {
            String msg = IlrMessages.getMessage("messages.ContentManager.2");
            throw new IlrRulesetArchive.RulesetArchiveException(msg);
        }
        String filename = this.directory + '/' + elt.getKey();
        int lastSlashIndex = filename.lastIndexOf(47);
        String dirName = filename.substring(0, lastSlashIndex);
        try {
            File file = new File(dirName);
            file.mkdirs();
            FileOutputStream stream = new FileOutputStream(filename);
            stream.write(content);
            stream.close();
        }
        catch (SecurityException ex) {
            String msg = IlrMessages.format("messages.ContentManager.0", dirName);
            throw new IlrRulesetArchive.RulesetArchiveException(ex, msg);
        }
        catch (IOException ex) {
            String msg = IlrMessages.format("messages.ContentManager.0", dirName);
            throw new IlrRulesetArchive.RulesetArchiveException(ex, msg);
        }
        this.contents.put(elt, filename);
    }

    @Override
    public void reset() {
        Collection filenames = this.contents.values();
        Iterator it = filenames.iterator();
        while (it.hasNext()) {
            try {
                String filename = (String)it.next();
                File file = new File(filename);
                file.delete();
            }
            catch (SecurityException ex) {
                ex.printStackTrace();
            }
        }
        this.contents.clear();
        if (this.directory == null) {
            return;
        }
        File rootDir = new File(this.directory);
        String[] lsRootDir = rootDir.list();
        if (lsRootDir != null) {
            int len = lsRootDir.length;
            for (int i = 0; i < len; ++i) {
                String[] ls;
                File f = new File(this.directory, lsRootDir[i]);
                if (!f.isDirectory() || (ls = f.list()).length != 0) continue;
                f.delete();
            }
        }
        try {
            if (this.deleteRoot) {
                rootDir.delete();
            }
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
    }
}

