/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.archive;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.archive.IlrRulesetArchiveLoader;
import ilog.rules.util.prefs.IlrMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;

public class IlrJarArchiveLoader
extends IlrRulesetArchiveLoader {
    private Map<String, IlrRulesetArchive.Element> unreadJarEntries;
    private JarInputStream jarInputStream;
    private static int nbReadBytes = 1024;

    public IlrJarArchiveLoader(JarInputStream stream) {
        this.jarInputStream = stream;
    }

    @Override
    public IlrRulesetArchive.Element getEntry(String entryName) {
        return this.extractBytes(entryName, false);
    }

    @Override
    public IlrRulesetArchive.Element getCompressedEntry(String entryName) {
        return this.extractBytes(entryName, true);
    }

    @Override
    public void endLoad() {
        this.jarInputStream = null;
    }

    private IlrRulesetArchive.Element findEntry(String entryName) {
        if (this.unreadJarEntries == null) {
            return null;
        }
        IlrRulesetArchive.Element elt = this.unreadJarEntries.get(entryName);
        if (elt == null) {
            return null;
        }
        return elt;
    }

    private void removeEntry(String entryName) {
        if (this.unreadJarEntries == null) {
            return;
        }
        this.unreadJarEntries.remove(entryName);
    }

    private void addEntry(ZipEntry entry, boolean compressed) {
        if (this.unreadJarEntries == null) {
            this.unreadJarEntries = new HashMap<String, IlrRulesetArchive.Element>();
        }
        IlrRulesetArchive.Element elt = this.extractBytes(entry, compressed);
        this.unreadJarEntries.put(entry.getName(), elt);
    }

    private IlrRulesetArchive.Element extractBytes(String entryName, boolean compressed) {
        this.checkStream();
        IlrRulesetArchive.Element elt = this.findEntry(entryName);
        if (elt != null) {
            this.removeEntry(entryName);
            return elt;
        }
        try {
            ZipEntry jarEntry;
            while ((jarEntry = this.jarInputStream.getNextEntry()) != null) {
                String name = jarEntry.getName();
                if (name.equals(entryName)) {
                    elt = this.extractBytes(jarEntry, compressed);
                    this.jarInputStream.closeEntry();
                    break;
                }
                this.addEntry(jarEntry, compressed);
                this.jarInputStream.closeEntry();
            }
            return elt;
        }
        catch (IOException ex) {
            String msg = IlrMessages.format("messages.RulesetArchive.19", entryName);
            throw new IlrRulesetArchive.RulesetArchiveException(ex, msg);
        }
    }

    private IlrRulesetArchive.Element extractBytes(ZipEntry jarEntry, boolean compressed) {
        int[] size = new int[1];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        if (compressed) {
            try {
                GZIPOutputStream gzipStream = new GZIPOutputStream(outputStream);
                this.extractBytes(jarEntry, gzipStream, size);
            }
            catch (IOException ex) {
                String msg = IlrMessages.getMessage("messages.RulesetArchive.12");
                throw new IlrRulesetArchive.RulesetArchiveException(ex, msg);
            }
        } else {
            this.extractBytes(jarEntry, outputStream, size);
        }
        IlrRulesetArchive.Element element = this.currentArchive.createElement(jarEntry.getName(), outputStream.toByteArray(), compressed, size[0]);
        return element;
    }

    private void extractBytes(ZipEntry jarEntry, OutputStream stream, int[] size) {
        this.checkStream();
        try {
            int nbRead;
            size[0] = 0;
            byte[] bytes = new byte[nbReadBytes];
            while ((nbRead = this.jarInputStream.read(bytes, 0, bytes.length)) != -1) {
                stream.write(bytes, 0, nbRead);
                size[0] = size[0] + nbRead;
            }
            stream.close();
        }
        catch (IOException ex) {
            String msg = IlrMessages.format("messages.RulesetArchive.19", jarEntry.getName());
            size[0] = -1;
            throw new IlrRulesetArchive.RulesetArchiveException(ex, msg);
        }
    }

    private String getExtension(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        String extension = name.substring(index + 1, name.length());
        return extension;
    }

    @Override
    boolean collectUserData(Map entries) {
        this.checkStream();
        if (this.unreadJarEntries != null) {
            for (String entryName : this.unreadJarEntries.keySet()) {
                if (!IlrRulesetArchive.isUserData(entryName)) continue;
                IlrRulesetArchive.Element elt = this.unreadJarEntries.get(entryName);
                entries.put(entryName, elt);
            }
        }
        String name = null;
        try {
            ZipEntry jarEntry = this.jarInputStream.getNextEntry();
            while (jarEntry != null) {
                name = jarEntry.getName();
                if (IlrRulesetArchive.isUserData(name)) {
                    int[] size = new int[1];
                    IlrRulesetArchive.Element elt = this.extractBytes(jarEntry, true);
                    this.jarInputStream.closeEntry();
                    entries.put(name, elt);
                    break;
                }
                this.addEntry(jarEntry, true);
                this.jarInputStream.closeEntry();
                jarEntry = this.jarInputStream.getNextEntry();
            }
        }
        catch (IOException ex) {
            String msg = IlrMessages.format("messages.RulesetArchive.19", name);
            throw new IlrRulesetArchive.RulesetArchiveException(ex, msg);
        }
        return true;
    }

    private void checkStream() {
        if (this.jarInputStream == null) {
            String msg = IlrMessages.getMessage("messages.RulesetArchive.20");
            throw new IlrRulesetArchive.RulesetArchiveException(msg);
        }
    }
}

