/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.archive;

import ilog.rules.archive.IlrContentManager;
import ilog.rules.archive.IlrMemoryStorage;
import ilog.rules.archive.IlrRulesetArchiveLoader;
import ilog.rules.archive.IlrStringEncoder;
import ilog.rules.util.prefs.IlrMessages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IlrRulesetArchive
implements Serializable {
    private HashMap elementByNames = new HashMap();
    private transient JarOutputStream jarOutputStream;
    private boolean isBusiness = false;
    private boolean isUnknownArtifactAnError;
    private String indexName;
    private IlrContentManager contentManager = null;
    private transient IlrRulesetArchiveLoader loader;
    String encoding = "UTF-8";
    static final String xmlEncoding = "UTF-8";
    static final int nbReadBytes = 10000;
    public static final String SEPARATOR = "/";
    public static final String IRL_EXTENSION = ".irl";
    static final String META_INF = "META-INF";
    public static final String RESOURCES = "RESOURCES";
    public static final String DESCRIPTOR = "META-INF/descriptor.xml";
    public static final String VARIABLES = "variables";
    public static final String VARIABLES_IRL = "variables.irl";
    static String SETUP = "setup";
    public static final String SETUP_IRL = SETUP + ".irl";
    public static final String METADATA = "RESOURCES/metadata.xml";
    public static final String INDEX = "index.xml";
    public static final String BOM_INFO = "RESOURCES/bominfo.xml";
    public static final String ENGINE_CONF_NAME = "RESOURCES/engine.conf";
    public static final String HEADER = "RESOURCES/header.irl";
    public static final String BOMXOM = "RESOURCES/";
    public static final String USER_DATA_DIR = "USER_DATA/";
    public static final String IRL_DIR = "IRL/";
    public static final String LOOKUPTABLE_DIR = "LOOKUP_TABLE";
    public static final int IRL = 0;
    public static final int BOM = 1;
    public static final int B2X = 2;
    public static final int XOM = 3;
    public static final int ENGINE_CONF = 4;
    public static final int USER_DATA = 5;
    public static final int XSD = 6;
    public static final int WSDL = 7;
    public static final int MISC = 8;
    public static final int GENERATED = 20;
    private boolean indexExtracted = false;
    private String rulesetSignature;
    int extractedMajorJRulesVersion;
    int extractedMinorJRulesVersion;
    public static int localMajorJRulesVersion = 8;
    public static int localMinorJRulesVersion = 7;
    private ArrayList bomPathes;
    public HashMap bom2XomNames;
    private ArrayList bomTocs;
    private ArrayList b2xTocs;
    public ArrayList xomTocs;
    public ArrayList xsdTocs;
    private HashMap xsdDocs;
    public ArrayList wsdlTocs;
    private HashMap miscTocs;
    public HashMap irlTocs;
    private BooleanAttribute isBusinessDataXmlServiceEnable = new BooleanAttribute();
    private transient IlrStringEncoder stringEncoder;

    public ClassLoader getClassLoader() {
        return IlrMessages.getMessages().getClassLoader();
    }

    public synchronized void setClassLoader(ClassLoader cl) {
        IlrMessages.getMessages().setClassLoader(cl);
    }

    public boolean needExtraction() {
        return this.irlTocs == null;
    }

    public int getSize() {
        int size = 0;
        if (this.elementByNames != null) {
            Collection elements = this.elementByNames.values();
            for (Element elt : elements) {
                size += elt.getSize();
            }
        }
        return size;
    }

    public int getIndexSize() {
        Element index = this.getElement(this.indexName);
        if (index != null) {
            return index.getSize();
        }
        return 0;
    }

    public IlrRulesetArchive(String encoding) {
        this(new IlrMemoryStorage(), encoding);
    }

    public IlrRulesetArchive() {
        this(new IlrMemoryStorage(), xmlEncoding);
    }

    public IlrRulesetArchive(IlrContentManager mgr, String encoding) {
        this.contentManager = mgr;
        this.encoding = encoding;
    }

    IlrRulesetArchive(IlrContentManager mgr) {
        this(mgr, xmlEncoding);
    }

    private void setLoader(IlrRulesetArchiveLoader loader) {
        this.loader = loader;
        loader.setCurrentArchive(this);
    }

    public Collection getElements() {
        return this.elementByNames.values();
    }

    public IlrContentManager getContentManager() {
        return this.contentManager;
    }

    public void reset() {
        this.elementByNames.clear();
        this.contentManager.reset();
        this.indexExtracted = false;
        this.rulesetSignature = null;
        this.resetParsing();
        this.resetExtraction();
    }

    public void resetParsing() {
        if (this.irlTocs != null) {
            this.irlTocs.clear();
        }
        this.irlTocs = null;
        if (this.xomTocs != null) {
            this.xomTocs.clear();
        }
        this.xomTocs = null;
        if (this.xsdTocs != null) {
            this.xsdTocs.clear();
        }
        this.xsdTocs = null;
        if (this.wsdlTocs != null) {
            this.wsdlTocs.clear();
        }
        this.wsdlTocs = null;
        if (this.bomPathes != null) {
            this.bomPathes.clear();
        }
        this.bomPathes = null;
        if (this.b2xTocs != null) {
            this.b2xTocs.clear();
        }
        this.b2xTocs = null;
    }

    private void resetExtraction() {
        if (this.bomTocs != null) {
            this.bomTocs.clear();
        }
        this.bomTocs = null;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getXmlEncoding() {
        return xmlEncoding;
    }

    public Collection getElements(int kind) {
        if (!this.indexExtracted) {
            Element indexElt = this.getElement(this.indexName);
            if (indexElt == null) {
                return null;
            }
            byte[] xmlIndexBytes = indexElt.getContent();
            this.extractIndex(xmlIndexBytes);
            this.tagElements();
        }
        ArrayList<Element> list = new ArrayList<Element>();
        Collection elements = this.getElements();
        for (Element elt : elements) {
            if (elt.kind != kind) continue;
            list.add(elt);
        }
        return list;
    }

    public String getRulesetSignature() {
        if (this.rulesetSignature == null) {
            boolean isEmptySignature;
            Element descriptor = this.getElement(DESCRIPTOR);
            if (descriptor == null) {
                return null;
            }
            String xmlDesc = descriptor.toString();
            int xmlEncodingIndex = xmlDesc.indexOf(62);
            String xmlEncodingDecl = xmlDesc.substring(0, xmlEncodingIndex + 1);
            int xmlNsIndex = xmlDesc.indexOf("xmlns");
            int closing = xmlDesc.indexOf(62, xmlNsIndex);
            String namespaces = xmlDesc.substring(xmlNsIndex, closing);
            String signatureTag = IlrRulesetArchive.namespaceDescriptor("signature-declaration");
            int start = xmlDesc.indexOf(signatureTag) - 1;
            int endSignatureTagIndex = start + signatureTag.length() + 1;
            char isSlash = xmlDesc.charAt(endSignatureTagIndex);
            boolean bl = isEmptySignature = isSlash == '/';
            if (isEmptySignature) {
                int end = endSignatureTagIndex + 2;
                String signature = xmlDesc.substring(start, end);
                closing = signature.indexOf("/>");
                String firstPart = signature.substring(0, closing);
                this.rulesetSignature = xmlEncodingDecl + "\n" + firstPart + ' ' + namespaces + "/>";
            } else {
                int end = xmlDesc.lastIndexOf(signatureTag) + signatureTag.length() + 1;
                String signature = xmlDesc.substring(start, end);
                closing = signature.indexOf(62);
                String firstPart = signature.substring(0, closing);
                String secondPart = signature.substring(closing + 1, signature.length());
                this.rulesetSignature = xmlEncodingDecl + "\n" + firstPart + " " + namespaces + '>' + secondPart;
            }
        }
        return this.rulesetSignature;
    }

    public Object getSchema(String namespace, String name) {
        ArrayList schemaDocs;
        if (name != null && this.xsdDocs != null && (schemaDocs = (ArrayList)this.xsdDocs.get(name)) != null) {
            SchemaDocument schemaDocument;
            if (namespace != null) {
                int i;
                for (i = 0; !namespace.equals(((SchemaDocument)schemaDocs.get(i)).namespace) && i < schemaDocs.size(); ++i) {
                }
                if (i == schemaDocs.size()) {
                    return null;
                }
                schemaDocument = (SchemaDocument)schemaDocs.get(i);
            } else {
                schemaDocument = (SchemaDocument)schemaDocs.get(0);
            }
            if (schemaDocument != null) {
                if (schemaDocument.location == null) {
                    String key = BOMXOM + schemaDocument.entryName;
                    Element elt = this.getElement(key);
                    return new ByteArrayInputStream(elt.getContent());
                }
                return schemaDocument.location;
            }
        }
        return null;
    }

    public Map getSchemaNames(boolean onlyContained) {
        if (this.xsdDocs != null) {
            HashMap result = new HashMap();
            for (ArrayList schemaDocuments : this.xsdDocs.values()) {
                for (int i = 0; i < schemaDocuments.size(); ++i) {
                    SchemaDocument schemaDocument = (SchemaDocument)schemaDocuments.get(i);
                    if (onlyContained && schemaDocument.location != null) continue;
                    if (result.get(schemaDocument.namespace) == null) {
                        result.put(schemaDocument.namespace, new ArrayList());
                    }
                    ((List)result.get(schemaDocument.namespace)).add(schemaDocument.xsdName);
                }
            }
            return result;
        }
        return null;
    }

    private void tagElements() {
        this.tagModelElements(this.bomTocs, RESOURCES, 1);
        this.tagModelElements(this.b2xTocs, RESOURCES, 2);
        this.tagModelElements(this.xomTocs, RESOURCES, 3);
        this.tagModelElements(this.xsdTocs, RESOURCES, 6);
        this.tagModelElements(this.wsdlTocs, RESOURCES, 7);
        this.tagIRLElements();
        this.tagMiscElements();
    }

    private void tagModelElements(ArrayList list, String dir, int kind) {
        if (list == null) {
            return;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            String name = (String)list.get(i);
            String entryName = dir + SEPARATOR + name;
            this.tagElement(entryName, kind);
        }
    }

    private void tagIRLElements() {
        if (this.irlTocs == null) {
            return;
        }
        for (String pkgName : this.irlTocs.keySet()) {
            PackageContent pkgContent = (PackageContent)this.irlTocs.get(pkgName);
            this.tagIRLElements(pkgContent);
        }
    }

    private void tagIRLElements(PackageContent pkgContent) {
        if (pkgContent == null) {
            return;
        }
        this.tagIRLElements(pkgContent.rules);
        this.tagIRLElements(pkgContent.functions);
        this.tagIRLElements(pkgContent.tasks);
        this.tagIRLElements(pkgContent.irls);
        this.tagElement(pkgContent.variables, 0);
    }

    private void tagIRLElements(ArrayList artifacts) {
        int size = artifacts.size();
        for (int i = 0; i < size; ++i) {
            String irlName = (String)artifacts.get(i);
            this.tagElement(irlName, 0);
        }
    }

    private void tagElement(String entryName, int kind) {
        if (entryName == null) {
            return;
        }
        Element elt = this.getElement(entryName);
        if (elt != null) {
            elt.setKind(kind);
        }
    }

    private void tagMiscElements() {
        if (this.miscTocs == null) {
            return;
        }
        for (String miscType : this.miscTocs.keySet()) {
            ArrayList miscEntryNames = (ArrayList)this.miscTocs.get(miscType);
            int size = miscEntryNames.size();
            for (int i = 0; i < size; ++i) {
                String entryName = (String)miscEntryNames.get(i);
                this.tagElement(entryName, 8);
            }
        }
    }

    private Element extractElement(String entryName, int kind) {
        return this.extractElement(entryName, kind, true);
    }

    private Element extractElement(String entryName, int kind, boolean insert) {
        Element element = this.loader.getCompressedEntry(entryName);
        if (element == null) {
            element = this.loader.getEntry(entryName);
        }
        if (element != null) {
            element.setKind(kind);
            if (insert) {
                this.addElement(element);
            }
        }
        return element;
    }

    Element createElement(String key, byte[] content, boolean compressed, int size) {
        Element elt = new Element(key, -1);
        elt.setContent(content, compressed);
        elt.setUncompressedSize(size);
        return elt;
    }

    public void addElement(Element element) {
        int indexIdx = element.key.indexOf(INDEX);
        if (indexIdx != -1) {
            this.indexName = element.key;
        }
        this.elementByNames.put(element.key, element);
    }

    public Element getElement(String key) {
        return (Element)this.elementByNames.get(key);
    }

    public static String computeEntryName(String artifactName) {
        String name = artifactName.replace('.', SEPARATOR.charAt(0));
        name = name + IRL_EXTENSION;
        return name;
    }

    public static String computeFQName(String pkgName, String name) {
        return pkgName.length() > 0 ? pkgName + '.' + name : name;
    }

    public static String computeEntryName(String directory, String eltName) {
        String result = directory;
        int idx = result.indexOf(SEPARATOR);
        if (!directory.equals("")) {
            result = directory;
            if (idx == -1) {
                result = result + SEPARATOR;
            }
        }
        result = result + eltName;
        return result;
    }

    public boolean isBusiness() {
        return this.isBusiness;
    }

    void isBusiness(boolean isBusiness) {
        this.isBusiness = isBusiness;
    }

    public List getBomPathes() {
        if (this.bomPathes == null) {
            return Collections.EMPTY_LIST;
        }
        return this.bomPathes;
    }

    public void isUnknownArtifactAnError(boolean isError) {
        this.isUnknownArtifactAnError = isError;
    }

    public boolean isUnknownArtifactAnError() {
        return this.isUnknownArtifactAnError;
    }

    private void insertInJar(Element element) throws IOException {
        String entryName = element.getKey();
        byte[] content = element.getContent();
        this.insertInJar(entryName, content);
    }

    private void insertInJar(String entryName, byte[] content) throws IOException {
        JarEntry jarEntry = new JarEntry(entryName);
        this.jarOutputStream.putNextEntry(jarEntry);
        this.jarOutputStream.write(content, 0, content.length);
        this.jarOutputStream.closeEntry();
    }

    public void write(JarOutputStream jarOutputStream) throws IOException {
        this.jarOutputStream = jarOutputStream;
        Collection elements = this.getElements();
        for (Element element : elements) {
            this.insertInJar(element);
        }
        this.jarOutputStream = null;
    }

    public boolean compare(IlrRulesetArchive archive) {
        Collection elements = this.getElements();
        Collection elements2 = archive.getElements();
        if (elements.size() != elements2.size()) {
            return false;
        }
        if (this.isBusiness != archive.isBusiness) {
            return false;
        }
        for (Element elt : elements) {
            Element elt2;
            boolean comparison = elt.compare(elt2 = archive.getElement(elt.key));
            if (comparison) continue;
            return false;
        }
        return true;
    }

    public static String getObjectModelName(String bom2XomPath) {
        int dotIndex = bom2XomPath.lastIndexOf(46);
        return bom2XomPath.substring(0, dotIndex);
    }

    public static String getBom2XomFromBom(String bomPath, Map nameTable) {
        String bomName = IlrRulesetArchive.getObjectModelName(bomPath);
        return (String)nameTable.get(bomName);
    }

    public Element getBom2XomElement(String bomPath) {
        if (this.b2xTocs == null) {
            return null;
        }
        String bom2XomPath = BOMXOM + IlrRulesetArchive.getBom2XomFromBom(bomPath, this.bom2XomNames);
        if (bom2XomPath == null) {
            return null;
        }
        return this.getElement(bom2XomPath);
    }

    public static org.w3c.dom.Element readXmlDocument(final String code, final String docName, final IlrStringEncoder stringEncoder) {
        return (org.w3c.dom.Element)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return IlrRulesetArchive.readXmlDocumentInternal(code, docName, stringEncoder);
            }
        });
    }

    private static org.w3c.dom.Element readXmlDocumentInternal(String code, String docName, IlrStringEncoder stringEncoder) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream istream = new ByteArrayInputStream(stringEncoder.encode(code, xmlEncoding));
            Document doc = docBuilder.parse(istream);
            istream.close();
            return doc.getDocumentElement();
        }
        catch (ParserConfigurationException ex) {
            String msg = IlrMessages.format("messages.RulesetArchive.1", docName, code);
            throw new RulesetArchiveException(ex, msg);
        }
        catch (SAXException ex) {
            String msg = IlrMessages.format("messages.RulesetArchive.1", docName, code);
            throw new RulesetArchiveException(ex, msg);
        }
        catch (IOException ex) {
            String msg = IlrMessages.format("messages.RulesetArchive.1", docName, code);
            throw new RulesetArchiveException(ex, msg);
        }
    }

    public static String convertIntoString(byte[] bytes, String encoding) {
        try {
            String converted = new String(bytes, encoding);
            return converted;
        }
        catch (UnsupportedEncodingException ex) {
            String msg = IlrMessages.getMessage("messages.RulesetArchive.4");
            throw new RulesetArchiveException(ex, msg);
        }
    }

    static void alreadyInsertedError(String name) {
        String msg = IlrMessages.format("messages.RulesetArchive.3", name);
        throw new RulesetArchiveException(msg);
    }

    static void entryNameNotValid(String name) {
        String msg = IlrMessages.format("messages.RulesetArchive.21", name);
        throw new RulesetArchiveException(msg);
    }

    public static IlrRulesetArchive extractArchive(IlrRulesetArchiveLoader loader) {
        return IlrRulesetArchive.extractArchive(loader, new IlrMemoryStorage());
    }

    public static IlrRulesetArchive extractArchive(IlrRulesetArchiveLoader loader, IlrContentManager contentMgr) {
        IlrRulesetArchive archive = new IlrRulesetArchive(contentMgr);
        archive.setLoader(loader);
        archive.extractArchive();
        return archive;
    }

    private void extractArchive() {
        this.extractDescriptor();
        this.extractBomInfo();
        this.extractContent(ENGINE_CONF_NAME, 4, false);
        this.extractContent(HEADER, 0, false);
        this.extractIndex();
        this.extractModelElements(this.bomTocs, 1);
        this.extractModelElements(this.xomTocs, 3);
        this.extractModelElements(this.xsdTocs, 6);
        this.extractModelElements(this.wsdlTocs, 7);
        this.extractModelElements(this.b2xTocs, 2);
        this.extractContent(METADATA, 20, true);
        this.extractArtifacts();
        this.extractMiscElements();
        this.extractUserData();
        this.loader.endLoad();
        this.resetExtraction();
    }

    public String getIRL(String pkgName, String artifactName) {
        String text;
        Element elt;
        if (artifactName.endsWith(IRL_EXTENSION)) {
            artifactName = artifactName.substring(0, artifactName.lastIndexOf(IRL_EXTENSION));
        }
        String fqn = IlrRulesetArchive.computeFQName(pkgName, artifactName);
        String entryName = IlrRulesetArchive.computeEntryName(fqn);
        String directory = "";
        if (this.isExtractedVersionAtLeast(6, 5)) {
            directory = IRL_DIR;
        }
        if ((elt = this.getElement(directory + entryName)) == null) {
            return null;
        }
        byte[] irlByte = elt.getContent();
        try {
            text = new String(irlByte, this.encoding);
        }
        catch (UnsupportedEncodingException ex) {
            String msg = IlrMessages.getMessage("messages.RulesetArchive.4");
            throw new RulesetArchiveException(ex, msg);
        }
        return text;
    }

    public String getContent(String entryName) {
        Element elt = this.getElement(entryName);
        if (elt == null) {
            return null;
        }
        return elt.toString();
    }

    public static void throwExtractionError(String phase) {
        String msg = IlrMessages.format("messages.RulesetArchive.5", phase);
        throw new RulesetArchiveException(msg);
    }

    public static void checkXmlExtractionError(org.w3c.dom.Element elt, String expectedElement) {
        if (elt == null) {
            String msg = IlrMessages.getMessage("messages.RulesetArchive.16.1", expectedElement);
            throw new RulesetArchiveException(msg);
        }
    }

    public static void checkXmlExtractionError(Attr attr, String expectedAttribute) {
        if (attr == null) {
            String msg = IlrMessages.getMessage("messages.RulesetArchive.16.2", expectedAttribute);
            throw new RulesetArchiveException(msg);
        }
    }

    private void extractDescriptor() {
        Element elt = this.extractElement(DESCRIPTOR, 20);
        this.interpretDescriptor(elt);
    }

    private void interpretDescriptor(Element elt) {
        if (elt == null) {
            elt = this.getElement(DESCRIPTOR);
        }
        if (elt != null) {
            byte[] xmlDescriptorBytes = elt.getContent();
            if (xmlDescriptorBytes == null) {
                IlrRulesetArchive.throwExtractionError(DESCRIPTOR);
            }
            String xmlDescriptor = IlrRulesetArchive.convertIntoString(xmlDescriptorBytes, xmlEncoding);
            this.decomposeDescriptor(xmlDescriptor);
        } else {
            IlrRulesetArchive.throwExtractionError(DESCRIPTOR);
        }
    }

    private void decomposeDescriptor(String xmlDescriptor) {
        org.w3c.dom.Element rootDescriptor = IlrRulesetArchive.readXmlDocument(xmlDescriptor, "descriptor", this.getStringEncoder());
        this.extractSignature(rootDescriptor);
        this.extractBusinessState(rootDescriptor);
        this.extractBusinessXMLService(rootDescriptor);
        this.extractUnknownArtifact(rootDescriptor);
        this.extractArchiveEncoding(rootDescriptor);
        this.extractJRulesVersion(rootDescriptor);
        this.extractRulesetVersion(rootDescriptor);
    }

    public static org.w3c.dom.Element getElementChild(org.w3c.dom.Element parent, String name) {
        NodeList children = parent.getChildNodes();
        int nbNodes = children.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(name)) continue;
            return (org.w3c.dom.Element)node;
        }
        return null;
    }

    private static String namespace(String ns, String tag) {
        return ns + ":" + tag;
    }

    public static String namespaceMetadata(String tag) {
        return IlrRulesetArchive.namespace("metadata", tag);
    }

    public static String namespaceSignature(String tag) {
        return IlrRulesetArchive.namespace("sig", tag);
    }

    public static String namespaceDescriptor(String tag) {
        return IlrRulesetArchive.namespace("desc", tag);
    }

    public static String namespaceIndex(String tag) {
        return IlrRulesetArchive.namespace("index", tag);
    }

    public static String namespaceBom(String tag) {
        return IlrRulesetArchive.namespace("bom", tag);
    }

    private void extractSignature(org.w3c.dom.Element root) {
        org.w3c.dom.Element parameterDeclaration = IlrRulesetArchive.getElementChild(root, IlrRulesetArchive.namespaceDescriptor("signature-declaration"));
        IlrRulesetArchive.checkXmlExtractionError(parameterDeclaration, "signature-declaration");
    }

    private void extractBusinessState(org.w3c.dom.Element root) {
        org.w3c.dom.Element businessDeclaration = IlrRulesetArchive.getElementChild(root, IlrRulesetArchive.namespaceDescriptor("isbusiness"));
        IlrRulesetArchive.checkXmlExtractionError(businessDeclaration, "isbusiness");
        NodeList children = businessDeclaration.getChildNodes();
        int nbNodes = children.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 3) continue;
            String bStr = node.getNodeValue();
            Boolean isB = Boolean.valueOf(bStr);
            boolean isbusiness = isB;
            this.isBusiness(isbusiness);
            break;
        }
    }

    private void extractBusinessXMLService(org.w3c.dom.Element root) {
        Node node;
        NodeList children;
        int nbNodes;
        int i;
        org.w3c.dom.Element businessXMLServiceElt = IlrRulesetArchive.getElementChild(root, IlrRulesetArchive.namespaceDescriptor("businessxmlserviceenable"));
        if (businessXMLServiceElt != null && (i = 0) < (nbNodes = (children = businessXMLServiceElt.getChildNodes()).getLength()) && (node = children.item(i)).getNodeType() == 3) {
            String bStr = node.getNodeValue();
            Boolean isB = Boolean.valueOf(bStr);
            if (!this.isBusinessDataXmlServiceEnable.setByApi) {
                this.isBusinessDataXmlServiceEnable.value = isB;
            }
            if (this.isBusinessDataXmlServiceEnable.value && !this.isBusiness()) {
                throw new RulesetArchiveException(IlrMessages.getMessage("messages.RulesetArchive.22"));
            }
        }
    }

    private void extractUnknownArtifact(org.w3c.dom.Element root) {
        org.w3c.dom.Element unknwonArtifactDeclaration = IlrRulesetArchive.getElementChild(root, IlrRulesetArchive.namespaceDescriptor("error-for-unknown-artifact"));
        if (unknwonArtifactDeclaration == null) {
            return;
        }
        NodeList children = unknwonArtifactDeclaration.getChildNodes();
        int nbNodes = children.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 3) continue;
            String unknownArtifactStr = node.getNodeValue();
            Boolean unknownArtifactStrB = Boolean.valueOf(unknownArtifactStr);
            boolean unknwonArtifactAnArror = unknownArtifactStrB;
            this.isUnknownArtifactAnError(unknwonArtifactAnArror);
            break;
        }
    }

    private void extractArchiveEncoding(org.w3c.dom.Element root) {
        org.w3c.dom.Element encodingDeclaration = IlrRulesetArchive.getElementChild(root, IlrRulesetArchive.namespaceDescriptor("encoding"));
        IlrRulesetArchive.checkXmlExtractionError(encodingDeclaration, "encoding");
        NodeList children = encodingDeclaration.getChildNodes();
        int nbNodes = children.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 3) continue;
            this.encoding = node.getNodeValue();
            break;
        }
    }

    private void extractJRulesVersion(org.w3c.dom.Element root) {
        org.w3c.dom.Element versionDeclaration = IlrRulesetArchive.getElementChild(root, IlrRulesetArchive.namespaceDescriptor("jrules-version"));
        if (versionDeclaration == null) {
            return;
        }
        String majorMarker = "major";
        String minorMarker = "minor";
        Attr majorAttr = versionDeclaration.getAttributeNode(majorMarker);
        IlrRulesetArchive.checkXmlExtractionError(majorAttr, majorMarker);
        this.extractedMajorJRulesVersion = Integer.parseInt(majorAttr.getValue());
        Attr minorAttr = versionDeclaration.getAttributeNode(minorMarker);
        IlrRulesetArchive.checkXmlExtractionError(minorAttr, minorMarker);
        this.extractedMinorJRulesVersion = Integer.parseInt(minorAttr.getValue());
    }

    private void extractRulesetVersion(org.w3c.dom.Element root) {
        org.w3c.dom.Element versionDeclaration = IlrRulesetArchive.getElementChild(root, IlrRulesetArchive.namespaceDescriptor("version"));
        IlrRulesetArchive.checkXmlExtractionError(versionDeclaration, "version");
        String majorMarker = "major";
        String minorMarker = "minor";
        Attr majorAttr = versionDeclaration.getAttributeNode(majorMarker);
        IlrRulesetArchive.checkXmlExtractionError(majorAttr, majorMarker);
        Attr minorAttr = versionDeclaration.getAttributeNode(minorMarker);
        IlrRulesetArchive.checkXmlExtractionError(minorAttr, minorMarker);
    }

    private void extractBomInfo() {
        Element elt = this.extractElement(BOM_INFO, 20);
        this.interpretBomInfo(elt);
    }

    private void interpretBomInfo(Element elt) {
        Element bomInfoElt = elt;
        if (bomInfoElt == null) {
            bomInfoElt = this.getElement(BOM_INFO);
        }
        if (bomInfoElt != null) {
            this.decomposeBomInfo(bomInfoElt.toString());
        } else {
            IlrRulesetArchive.throwExtractionError(BOM_INFO);
        }
    }

    private void decomposeBomInfo(String xmlBomInfo) {
        org.w3c.dom.Element root = IlrRulesetArchive.readXmlDocument(xmlBomInfo, "bom", this.getStringEncoder());
        this.extractBomPathes(root);
    }

    private void extractBomPathes(org.w3c.dom.Element root) {
        org.w3c.dom.Element bomPathesDeclaration = IlrRulesetArchive.getElementChild(root, IlrRulesetArchive.namespaceBom("bompathes"));
        if (bomPathesDeclaration == null) {
            return;
        }
        NodeList children = bomPathesDeclaration.getChildNodes();
        int nbNodes = children.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            Node childNode = children.item(i);
            if (childNode.getNodeType() != 1) continue;
            org.w3c.dom.Element child = (org.w3c.dom.Element)childNode;
            this.extractBomPath(child);
        }
    }

    private void extractBomPath(org.w3c.dom.Element child) {
        Attr bomAttr = child.getAttributeNode("value");
        IlrRulesetArchive.checkXmlExtractionError(bomAttr, "value");
        String bomPath = bomAttr.getValue();
        if (this.bomPathes == null) {
            this.bomPathes = new ArrayList();
        }
        this.bomPathes.add(bomPath);
    }

    private void extractContent(String key, int kind, boolean mandatory) {
        Element elt = this.extractElement(key, kind);
        if (mandatory && elt == null) {
            IlrRulesetArchive.throwExtractionError(key);
        }
    }

    private void extractIndex() {
        String indexDir = this.isExtractedVersionAtLeast(6, 5) ? META_INF : RESOURCES;
        String indexEntryName = indexDir + SEPARATOR + INDEX;
        Element elt = this.extractElement(indexEntryName, 20);
        this.interpretIndex(elt);
    }

    private void interpretIndex(Element elt) {
        if (this.irlTocs != null) {
            return;
        }
        Element indexElt = elt;
        if (indexElt == null) {
            String indexDir = this.isExtractedVersionAtLeast(6, 5) ? META_INF : RESOURCES;
            String indexEntryName = indexDir + SEPARATOR + INDEX;
            indexElt = this.getElement(indexEntryName);
        }
        if (indexElt != null) {
            this.extractIndex(indexElt.getContent());
        } else {
            IlrRulesetArchive.throwExtractionError(INDEX);
        }
    }

    public void interpret() {
        this.interpretDescriptor(null);
        this.interpretIndex(null);
        this.interpretBomInfo(null);
        this.tagElements();
    }

    private void extractIndex(byte[] xmlIndexBytes) {
        String xmlIndex = IlrRulesetArchive.convertIntoString(xmlIndexBytes, xmlEncoding);
        this.decomposeIndex(xmlIndex);
        this.indexExtracted = true;
    }

    private void decomposeIndex(String xmlIndex) {
        org.w3c.dom.Element rootIndex = IlrRulesetArchive.readXmlDocument(xmlIndex, "index", this.getStringEncoder());
        this.extractToc(rootIndex);
    }

    private void extractToc(org.w3c.dom.Element root) {
        org.w3c.dom.Element tocDeclaration = IlrRulesetArchive.getElementChild(root, IlrRulesetArchive.namespaceIndex("toc"));
        IlrRulesetArchive.checkXmlExtractionError(tocDeclaration, "toc");
        org.w3c.dom.Element bomToc = IlrRulesetArchive.getElementChild(tocDeclaration, IlrRulesetArchive.namespaceIndex("bomToc"));
        IlrRulesetArchive.checkXmlExtractionError(bomToc, "bomToc");
        this.bomTocs = this.extractTocContent(bomToc);
        org.w3c.dom.Element b2xToc = IlrRulesetArchive.getElementChild(tocDeclaration, IlrRulesetArchive.namespaceIndex("bom2xomToc"));
        IlrRulesetArchive.checkXmlExtractionError(b2xToc, "bom2xomToc");
        this.b2xTocs = this.extractTocContent(b2xToc);
        this.organizeB2X();
        org.w3c.dom.Element xomToc = IlrRulesetArchive.getElementChild(tocDeclaration, IlrRulesetArchive.namespaceIndex("xomToc"));
        IlrRulesetArchive.checkXmlExtractionError(xomToc, "xomToc");
        this.xomTocs = this.extractTocContent(xomToc);
        org.w3c.dom.Element irlToc = IlrRulesetArchive.getElementChild(tocDeclaration, IlrRulesetArchive.namespaceIndex("irlToc"));
        IlrRulesetArchive.checkXmlExtractionError(irlToc, "irlToc");
        this.extractIRLContent(irlToc);
        if (this.isExtractedVersionAtLeast(6, 5)) {
            org.w3c.dom.Element xsdToc = IlrRulesetArchive.getElementChild(tocDeclaration, IlrRulesetArchive.namespaceIndex("xsdToc"));
            IlrRulesetArchive.checkXmlExtractionError(xsdToc, "xsdToc");
            this.extractXSDTocContent(xsdToc);
            org.w3c.dom.Element wsdlToc = IlrRulesetArchive.getElementChild(tocDeclaration, IlrRulesetArchive.namespaceIndex("wsdlToc"));
            IlrRulesetArchive.checkXmlExtractionError(wsdlToc, "wsdlToc");
            this.wsdlTocs = this.extractTocContent(wsdlToc);
            org.w3c.dom.Element miscToc = IlrRulesetArchive.getElementChild(tocDeclaration, IlrRulesetArchive.namespaceIndex("miscElementsToc"));
            IlrRulesetArchive.checkXmlExtractionError(miscToc, "miscElementsToc");
            this.extractMiscTocContent(miscToc);
        }
    }

    private void extractIRLContent(org.w3c.dom.Element toc) {
        NodeList pkgChildren = toc.getChildNodes();
        int len = pkgChildren.getLength();
        for (int i = 0; i < len; ++i) {
            Node pkgNode = pkgChildren.item(i);
            if (pkgNode.getNodeType() != 1) continue;
            org.w3c.dom.Element pkgElt = (org.w3c.dom.Element)pkgNode;
            String pkgName = pkgElt.getAttribute("name");
            PackageContent pkgContent = this.extractPackageContent(pkgElt);
            if (pkgContent == null) continue;
            if (this.irlTocs == null) {
                this.irlTocs = new HashMap();
            }
            this.irlTocs.put(pkgName, pkgContent);
        }
    }

    private PackageContent extractPackageContent(org.w3c.dom.Element pkgElt) {
        PackageContent pkgContent = null;
        NodeList pkgChildren = pkgElt.getChildNodes();
        int len = pkgChildren.getLength();
        for (int i = 0; i < len; ++i) {
            Node pkgNode = pkgChildren.item(i);
            if (pkgNode.getNodeType() != 1) continue;
            org.w3c.dom.Element kindElt = (org.w3c.dom.Element)pkgNode;
            if (pkgContent == null) {
                pkgContent = new PackageContent();
            }
            String kindEltName = kindElt.getTagName();
            ArrayList artifacts = this.extractTocContent(kindElt);
            if (artifacts == null) continue;
            if (kindEltName.equals(IlrRulesetArchive.namespaceIndex("rules"))) {
                pkgContent.setRules(artifacts);
                continue;
            }
            if (kindEltName.equals(IlrRulesetArchive.namespaceIndex("functions"))) {
                pkgContent.setFunctions(artifacts);
                continue;
            }
            if (kindEltName.equals(IlrRulesetArchive.namespaceIndex("tasks"))) {
                pkgContent.setTasks(artifacts);
                continue;
            }
            if (kindEltName.equals(IlrRulesetArchive.namespaceIndex("irls"))) {
                pkgContent.setIrls(artifacts);
                continue;
            }
            if (!kindEltName.equals(IlrRulesetArchive.namespaceIndex(VARIABLES))) continue;
            String name = (String)artifacts.get(0);
            pkgContent.setVariables(name);
        }
        return pkgContent;
    }

    private ArrayList extractTocContent(org.w3c.dom.Element toc) {
        ArrayList<String> entries = null;
        NodeList children = toc.getChildNodes();
        int nbNodes = children.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            Node entryNode = children.item(i);
            if (entryNode.getNodeType() != 1) continue;
            org.w3c.dom.Element entryElt = (org.w3c.dom.Element)entryNode;
            String entryName = entryElt.getAttribute("name");
            if (entries == null) {
                entries = new ArrayList<String>();
            }
            entries.add(entryName);
        }
        return entries;
    }

    private void extractXSDTocContent(org.w3c.dom.Element toc) {
        NodeList children = toc.getChildNodes();
        int nbNodes = children.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            Node entryNode = children.item(i);
            if (entryNode.getNodeType() != 1) continue;
            org.w3c.dom.Element entryElt = (org.w3c.dom.Element)entryNode;
            SchemaDocument schemaDocument = new SchemaDocument();
            schemaDocument.entryName = entryElt.getAttribute("name");
            schemaDocument.namespace = entryElt.getAttribute("schemaNamespace");
            schemaDocument.xsdName = entryElt.getAttribute("xsdName");
            String urlAsString = entryElt.getAttribute("URL");
            if (urlAsString != null && urlAsString.length() > 0) {
                try {
                    schemaDocument.location = new URL(urlAsString);
                }
                catch (MalformedURLException mfue) {
                    throw new RuntimeException(mfue);
                }
            }
            if (this.xsdTocs == null) {
                this.xsdTocs = new ArrayList();
            }
            if (schemaDocument.location == null) {
                this.xsdTocs.add(schemaDocument.entryName);
            }
            if (this.xsdDocs == null) {
                this.xsdDocs = new HashMap();
            }
            if (this.xsdDocs.get(schemaDocument.xsdName) == null) {
                this.xsdDocs.put(schemaDocument.xsdName, new ArrayList());
            }
            ((ArrayList)this.xsdDocs.get(schemaDocument.xsdName)).add(schemaDocument);
        }
    }

    private void organizeB2X() {
        if (this.b2xTocs == null) {
            return;
        }
        this.bom2XomNames = new HashMap();
        int size = this.b2xTocs.size();
        for (int i = 0; i < size; ++i) {
            String b2x = (String)this.b2xTocs.get(i);
            String bom2XomName = IlrRulesetArchive.getObjectModelName(b2x);
            this.bom2XomNames.put(bom2XomName, b2x);
        }
    }

    private void extractMiscTocContent(org.w3c.dom.Element toc) {
        NodeList children = toc.getChildNodes();
        int nbNodes = children.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            Node miscNode = children.item(i);
            if (miscNode.getNodeType() != 1) continue;
            org.w3c.dom.Element miscElt = (org.w3c.dom.Element)miscNode;
            String entryName = miscElt.getAttribute("type");
            ArrayList miscTypeElts = this.extractTocContent(miscElt);
            if (this.miscTocs == null) {
                this.miscTocs = new HashMap();
            }
            this.miscTocs.put(entryName, miscTypeElts);
        }
    }

    private void extractModelElements(ArrayList tocs, int kind) {
        if (tocs == null) {
            return;
        }
        int size = tocs.size();
        for (int i = 0; i < size; ++i) {
            String rsc = (String)tocs.get(i);
            String key = BOMXOM + rsc;
            Element elt = this.extractElement(key, kind);
            if (elt != null) continue;
            IlrRulesetArchive.throwExtractionError(key);
        }
    }

    private void extractMiscElements() {
        if (this.miscTocs == null) {
            return;
        }
        for (String miscType : this.miscTocs.keySet()) {
            ArrayList entries = (ArrayList)this.miscTocs.get(miscType);
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                String entryName = (String)entries.get(i);
                Element elt = this.extractElement(entryName, 8);
                if (elt != null) continue;
                IlrRulesetArchive.throwExtractionError(entryName);
            }
        }
    }

    static boolean isUserData(String entryName) {
        int slashIndex = entryName.indexOf(SEPARATOR);
        String directory = slashIndex == -1 ? "" : entryName.substring(0, slashIndex);
        int dotIndex = entryName.lastIndexOf(46);
        String extension = "";
        if (dotIndex != -1) {
            extension = entryName.substring(dotIndex, entryName.length());
        }
        int lastSlashIndex = entryName.lastIndexOf(SEPARATOR);
        return !directory.equals(RESOURCES) && !directory.equals(META_INF) && !extension.equals(IRL_EXTENSION) && lastSlashIndex != entryName.length() - 1;
    }

    private void extractUserData() {
        HashMap remainingEntries = new HashMap();
        this.loader.collectUserData(remainingEntries);
        for (String entryName : remainingEntries.keySet()) {
            Element elt = (Element)remainingEntries.get(entryName);
            elt.setKind(5);
            this.addElement(elt);
        }
    }

    private void extractArtifacts() {
        if (this.irlTocs != null) {
            for (String pkgName : this.irlTocs.keySet()) {
                PackageContent pkgContent = (PackageContent)this.irlTocs.get(pkgName);
                this.extractPackageContent(pkgContent);
            }
        }
    }

    private void extractPackageContent(PackageContent pkgContent) {
        this.extractPackageContent(pkgContent.rules);
        this.extractPackageContent(pkgContent.functions);
        this.extractPackageContent(pkgContent.tasks);
        this.extractPackageContent(pkgContent.irls);
        this.extractPackageContent(pkgContent.variables);
    }

    private void extractPackageContent(ArrayList list) {
        int size = list.size();
        for (int j = 0; j < size; ++j) {
            String artifactName = (String)list.get(j);
            this.extractPackageContent(artifactName);
        }
    }

    private void extractPackageContent(String artifactName) {
        if (artifactName == null) {
            return;
        }
        Element elt = this.extractElement(artifactName, 0);
        if (elt == null) {
            IlrRulesetArchive.throwExtractionError(artifactName);
        }
    }

    boolean isExtractedVersionAtLeast(int major, int minor) {
        return IlrRulesetArchive.compareVersion(this.extractedMajorJRulesVersion, this.extractedMinorJRulesVersion, major, minor);
    }

    static boolean isCurrentVersionAtLeast(int major, int minor) {
        return IlrRulesetArchive.compareVersion(localMajorJRulesVersion, localMinorJRulesVersion, major, minor);
    }

    private static boolean compareVersion(int major1, int minor1, int major2, int minor2) {
        return major1 > major2 || major1 == major2 && minor1 >= minor2;
    }

    public boolean isBusinessDataXmlServiceEnable() {
        return this.isBusinessDataXmlServiceEnable.value;
    }

    public void setBusinessDataXmlServiceEnable(boolean businessDataXmlServiceEnable) {
        this.isBusinessDataXmlServiceEnable.value = businessDataXmlServiceEnable;
        this.isBusinessDataXmlServiceEnable.setByApi = true;
        this.irlTocs = null;
    }

    public IlrStringEncoder getStringEncoder() {
        if (this.stringEncoder == null) {
            this.stringEncoder = new IlrStringEncoder();
        }
        return this.stringEncoder;
    }

    public static class ErrorChecker
    implements ErrorHandler {
        private void display(SAXParseException e, String head) {
            System.out.println(head + e.getMessage() + " in " + e.getSystemId() + " at line " + e.getLineNumber() + " at column " + e.getColumnNumber());
        }

        @Override
        public void error(SAXParseException e) {
            this.display(e, "Parsing error:  ");
        }

        @Override
        public void warning(SAXParseException e) {
            this.display(e, "Parsing warning:  ");
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.display(e, "Parsing error:  ");
            System.out.println("Cannot continue.");
        }
    }

    public static class PackageContent
    implements Serializable {
        public ArrayList rules = new ArrayList();
        public ArrayList functions = new ArrayList();
        public ArrayList tasks = new ArrayList();
        public ArrayList irls = new ArrayList();
        public String variables;
        public int nbArtifacts;

        PackageContent() {
        }

        void addRule(String name) {
            if (this.rules.indexOf(name) != -1) {
                IlrRulesetArchive.alreadyInsertedError(name);
            }
            this.rules.add(name);
            ++this.nbArtifacts;
        }

        void setRules(ArrayList rules) {
            this.rules = rules;
            if (rules != null) {
                this.nbArtifacts += rules.size();
            }
        }

        void addFunction(String name) {
            if (this.functions.indexOf(name) != -1) {
                IlrRulesetArchive.alreadyInsertedError(name);
            }
            this.functions.add(name);
            ++this.nbArtifacts;
        }

        void setFunctions(ArrayList functions) {
            this.functions = functions;
            if (functions != null) {
                this.nbArtifacts += functions.size();
            }
        }

        void addTask(String name) {
            if (this.tasks.indexOf(name) != -1) {
                IlrRulesetArchive.alreadyInsertedError(name);
            }
            this.tasks.add(name);
            ++this.nbArtifacts;
        }

        void setTasks(ArrayList tasks) {
            this.tasks = tasks;
            if (tasks != null) {
                this.nbArtifacts += tasks.size();
            }
        }

        void setVariables(String name) {
            if (this.variables != null) {
                IlrRulesetArchive.alreadyInsertedError(name);
            }
            this.variables = name;
            ++this.nbArtifacts;
        }

        void addIrls(String name) {
            if (this.irls.indexOf(name) != -1) {
                IlrRulesetArchive.alreadyInsertedError(name);
            }
            this.irls.add(name);
            ++this.nbArtifacts;
        }

        void setIrls(ArrayList irls) {
            this.irls = irls;
            if (irls != null) {
                this.nbArtifacts += irls.size();
            }
        }
    }

    private static class BooleanAttribute
    implements Serializable {
        private boolean setByApi;
        private boolean value;

        private BooleanAttribute() {
        }
    }

    private static class SchemaDocument
    implements Serializable {
        private String xsdName;
        private String namespace;
        private String entryName;
        private URL location;

        private SchemaDocument() {
        }
    }

    public class Element
    implements Serializable {
        private String key;
        private int kind;
        private boolean compressed = false;
        private int uncompressedSize = 0;

        public Element(String key) {
            this.key = key;
            this.kind = -1;
            this.tagElement();
        }

        Element(String key, int kind) {
            this.key = key;
            this.kind = kind;
        }

        private void tagElement() {
            if (this.key.equals(IlrRulesetArchive.DESCRIPTOR) || this.key.equals(IlrRulesetArchive.INDEX) || this.key.equals(IlrRulesetArchive.BOM_INFO) || this.key.equals(IlrRulesetArchive.METADATA)) {
                this.kind = 20;
            } else if (this.key.equals(IlrRulesetArchive.ENGINE_CONF_NAME)) {
                this.kind = 4;
            } else if (this.key.equals(IlrRulesetArchive.HEADER)) {
                this.kind = 0;
            }
        }

        public String getKey() {
            return this.key;
        }

        public void setUncompressedSize(int size) {
            this.uncompressedSize = size;
        }

        public void setContent(byte[] content) {
            this.setContent(content, false);
            this.uncompressedSize = content.length;
        }

        public void setContent(byte[] content, boolean compressed) {
            this.compressed = compressed;
            IlrRulesetArchive.this.contentManager.setContent(this, content);
        }

        public void compressAndSetContent(byte[] content) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                GZIPOutputStream gzipStream = new GZIPOutputStream(outputStream);
                gzipStream.write(content, 0, content.length);
                gzipStream.close();
                outputStream.close();
                this.uncompressedSize = content.length;
                this.setContent(outputStream.toByteArray(), true);
            }
            catch (IOException ex) {
                String msg = IlrMessages.getMessage("messages.RulesetArchive.12");
                throw new RulesetArchiveException(ex, msg);
            }
        }

        public byte[] getContent() {
            byte[] theContent = IlrRulesetArchive.this.contentManager.getContent(this);
            if (theContent == null) {
                return null;
            }
            if (!this.compressed) {
                return theContent;
            }
            return this.uncompress(theContent);
        }

        private byte[] uncompress(byte[] theContent) {
            byte[] result = new byte[this.uncompressedSize];
            try {
                int limitSup;
                int length;
                ByteArrayInputStream inputStream = new ByteArrayInputStream(theContent);
                GZIPInputStream gzipStream = new GZIPInputStream(inputStream);
                int lengthRead = 0;
                while ((lengthRead += gzipStream.read(result, lengthRead, length = (limitSup = Math.min(result.length, 10000 + lengthRead)) - lengthRead)) < result.length) {
                }
                gzipStream.close();
            }
            catch (IOException ex) {
                String msg = IlrMessages.format("messages.RulesetArchive.17", this.key);
                throw new RulesetArchiveException(ex, msg);
            }
            return result;
        }

        public int getKind() {
            return this.kind;
        }

        public void setKind(int kind) {
            this.kind = kind;
        }

        public String toString() {
            String toString;
            String encoding = this.kind == 20 ? IlrRulesetArchive.xmlEncoding : IlrRulesetArchive.this.getEncoding();
            try {
                toString = this.kind == 5 ? "[IlrRulesetArchive.Element " + this.key + "]" : new String(this.getContent(), encoding);
            }
            catch (UnsupportedEncodingException ex) {
                String msg = IlrMessages.getMessage("messages.RulesetArchive.4");
                throw new RulesetArchiveException(ex, msg);
            }
            return toString;
        }

        public int getSize() {
            byte[] theContent = IlrRulesetArchive.this.contentManager.getContent(this);
            if (theContent != null) {
                return theContent.length;
            }
            return 0;
        }

        int getUncompressedSize() {
            return this.uncompressedSize;
        }

        boolean compare(Element elt) {
            if (elt == null) {
                return false;
            }
            String thisContent = IlrRulesetArchive.convertIntoString(this.getContent(), IlrRulesetArchive.this.encoding);
            String eltContent = IlrRulesetArchive.convertIntoString(elt.getContent(), IlrRulesetArchive.this.encoding);
            if (thisContent.hashCode() != eltContent.hashCode()) {
                return false;
            }
            return thisContent.equals(eltContent);
        }

        public Element copy() {
            Element elt = new Element(this.key);
            elt.uncompressedSize = this.uncompressedSize;
            byte[] theContent = this.getContent();
            if (this.compressed) {
                elt.compressAndSetContent(theContent);
            } else {
                elt.setContent(theContent);
            }
            elt.kind = this.kind;
            return elt;
        }
    }

    public static class RulesetArchiveException
    extends RuntimeException {
        private Throwable target;
        private String precision;

        public RulesetArchiveException(Throwable target, String message) {
            super(target.getMessage());
            this.target = target;
            this.precision = message;
        }

        public RulesetArchiveException(String message) {
            this.precision = message;
        }

        @Override
        public String getMessage() {
            String msg = this.precision;
            if (this.target != null) {
                if (msg.length() != 0) {
                    msg = msg + ":\n";
                }
                msg = msg + this.target.getMessage();
            }
            return msg;
        }

        public void printHeader(PrintWriter s) {
            String msg = IlrMessages.format("messages.Misc.12", this.getShortName(this.getClass()));
            s.println('\n' + msg + ". " + this.precision + ':');
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            this.printHeader(s);
            if (this.target != null) {
                s.println("Target exception stack trace:");
                this.target.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        String getShortName(Class clazz) {
            String name = clazz.getName();
            int index = name.lastIndexOf(46);
            return name.substring(index + 1);
        }
    }
}

