/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.archive;

import ilog.rules.archive.IlrContentManager;
import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.archive.IlrStringEncoder;
import ilog.rules.util.engine.IlrXmlRulesetArchiveTag;
import ilog.rules.util.prefs.IlrMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class IlrRulesetArchiveBuilderBase {
    protected ArrayList artifacts = new ArrayList();
    protected ArrayList artifactNames = new ArrayList();
    protected HashMap irlTocs;
    protected ArrayList bomPathes;
    protected HashMap bom2XomNames;
    protected HashMap miscTocs;
    protected String xsdMetadataFileName;
    protected String xsdIndexFileName;
    protected String xsdDescriptorFileName;
    protected String xsdBomInfoFileName;
    protected ArrayList bomTocs;
    protected ArrayList b2xTocs;
    protected ArrayList xomTocs;
    protected ArrayList xsdTocs;
    protected ArrayList wsdlTocs;
    protected ArrayList userDataTocs;
    private int majorNbVersion;
    private int minorNbVersion;
    private PrintWriter messageWriter;
    private boolean isUnknownArtifactAnError;
    protected ArrayList<String> archiveBuildingErrors = new ArrayList();
    protected IlrRulesetArchive currentArchive;
    protected String encoding = "UTF-8";
    protected static final int RULE = 0;
    protected static final int FUNCTION = 1;
    protected static final int TASK = 2;
    protected static final int VARIABLE = 3;
    protected static final int MISC = 4;
    private int nbXsdNameIndex = 0;
    protected DocumentBuilderFactory documentBuilderFactory;
    protected TransformerFactory transformerFactory;
    protected final IlrStringEncoder stringEncoder;

    public IlrRulesetArchiveBuilderBase() {
        this.currentArchive = new IlrRulesetArchive();
        this.stringEncoder = this.currentArchive.getStringEncoder();
    }

    public IlrRulesetArchiveBuilderBase(IlrContentManager mgr) {
        this.currentArchive = new IlrRulesetArchive(mgr);
        this.stringEncoder = this.currentArchive.getStringEncoder();
    }

    public ClassLoader getClassLoader() {
        return IlrMessages.getMessages().getClassLoader();
    }

    public synchronized void setClassLoader(ClassLoader cl) {
        IlrMessages.getMessages().setClassLoader(cl);
    }

    public void setEncoding(String encoding) {
        this.currentArchive.encoding = encoding;
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void reset() {
        this.artifacts.clear();
        this.artifactNames.clear();
        if (this.irlTocs != null) {
            this.irlTocs.clear();
        }
        if (this.bomTocs != null) {
            this.bomTocs.clear();
        }
        if (this.b2xTocs != null) {
            this.b2xTocs.clear();
        }
        if (this.xomTocs != null) {
            this.xomTocs.clear();
        }
        if (this.miscTocs != null) {
            this.miscTocs.clear();
        }
        if (this.xsdTocs != null) {
            this.xsdTocs.clear();
        }
        if (this.wsdlTocs != null) {
            this.wsdlTocs.clear();
        }
        if (this.userDataTocs != null) {
            this.userDataTocs.clear();
        }
        if (this.bom2XomNames != null) {
            this.bom2XomNames.clear();
        }
        if (this.bomPathes != null) {
            this.bomPathes.clear();
        }
        this.archiveBuildingErrors.clear();
    }

    public void setMessageWriter(PrintWriter writer) {
        this.messageWriter = writer;
    }

    public void isUnknownArtifactAnError(boolean isError) {
        this.isUnknownArtifactAnError = isError;
    }

    public void addIRLEntry(String irlName, InputStream inputStream) {
        try {
            if (inputStream == null) {
                return;
            }
            if (irlName.endsWith(".irl")) {
                irlName = irlName.substring(0, irlName.lastIndexOf(".irl"));
            }
            this.storeArtifact("", irlName, this.getContentInByteArray(inputStream, irlName), 4);
            inputStream.close();
        }
        catch (IOException ex) {
            this.problemDuringArchiveEntryCreation(ex, irlName);
        }
    }

    public void addRuleEntry(String pkgName, String ruleName, String code) {
        byte[] codeAsBytes = this.convertIntoBytes(code);
        this.addRuleEntry(pkgName, ruleName, codeAsBytes);
    }

    public void addRuleEntry(String pkgName, String ruleName, InputStream inputStream) {
        String key = IlrRulesetArchive.computeFQName(pkgName, ruleName);
        String entryName = IlrRulesetArchive.computeEntryName(key);
        try {
            if (inputStream == null) {
                return;
            }
            this.addRuleEntry(pkgName, ruleName, this.getContentInByteArray(inputStream, entryName));
            inputStream.close();
        }
        catch (IOException ex) {
            this.problemDuringArchiveEntryCreation(ex, entryName);
        }
    }

    private void addRuleEntry(String pkgName, String ruleName, byte[] code) {
        String key = IlrRulesetArchive.computeFQName(pkgName, ruleName);
        this.storeArtifact(pkgName, key, code, 0);
    }

    public void addFunctionEntry(String pkgName, String fctName, String code) {
        byte[] codeAsBytes = this.convertIntoBytes(code);
        this.addFunctionEntry(pkgName, fctName, codeAsBytes);
    }

    public void addFunctionEntry(String pkgName, String fctName, InputStream inputStream) {
        String key = IlrRulesetArchive.computeFQName(pkgName, fctName);
        String entryName = IlrRulesetArchive.computeEntryName(key);
        try {
            if (inputStream == null) {
                return;
            }
            this.addFunctionEntry(pkgName, fctName, this.getContentInByteArray(inputStream, entryName));
            inputStream.close();
        }
        catch (IOException ex) {
            this.problemDuringArchiveEntryCreation(ex, entryName);
        }
    }

    private void addFunctionEntry(String pkgName, String fctName, byte[] code) {
        String key = IlrRulesetArchive.computeFQName(pkgName, fctName);
        this.storeArtifact(pkgName, key, code, 1);
    }

    public void addRuleflowEntry(String pkgName, String flowName, String code) {
        byte[] codeAsBytes = this.convertIntoBytes(code);
        this.addRuleflowEntry(pkgName, flowName, codeAsBytes);
    }

    public void addRuleflowEntry(String pkgName, String flowName, InputStream inputStream) {
        String key = IlrRulesetArchive.computeFQName(pkgName, flowName);
        String entryName = IlrRulesetArchive.computeEntryName(key);
        try {
            if (inputStream == null) {
                return;
            }
            this.addRuleflowEntry(pkgName, flowName, this.getContentInByteArray(inputStream, entryName));
            inputStream.close();
        }
        catch (IOException ex) {
            this.problemDuringArchiveEntryCreation(ex, entryName);
        }
    }

    private void addRuleflowEntry(String pkgName, String flowName, byte[] code) {
        String key = IlrRulesetArchive.computeFQName(pkgName, flowName);
        this.storeArtifact(pkgName, key, code, 2);
    }

    protected void storeArtifact(String pkgName, String key, byte[] code, int kind) {
        String entryName = IlrRulesetArchive.computeEntryName(key);
        IlrRulesetArchiveBuilderBase.checkEntryName(entryName);
        this.registerArtifact(entryName, code);
        this.registerInToc(pkgName, entryName, kind);
    }

    protected void registerInToc(String pkgName, String name, int kind) {
        IlrRulesetArchive.PackageContent pkgContent;
        String entryDir = "";
        if (IlrRulesetArchive.isCurrentVersionAtLeast(6, 5)) {
            entryDir = "IRL/";
        }
        String entryName = entryDir + name;
        if (this.irlTocs == null) {
            this.irlTocs = new HashMap();
        }
        if ((pkgContent = (IlrRulesetArchive.PackageContent)this.irlTocs.get(pkgName)) == null) {
            pkgContent = new IlrRulesetArchive.PackageContent();
            this.irlTocs.put(pkgName, pkgContent);
        }
        switch (kind) {
            case 0: {
                pkgContent.addRule(entryName);
                break;
            }
            case 1: {
                pkgContent.addFunction(entryName);
                break;
            }
            case 2: {
                pkgContent.addTask(entryName);
                break;
            }
            case 3: {
                pkgContent.setVariables(entryName);
                break;
            }
            case 4: {
                pkgContent.addIrls(entryName);
            }
        }
    }

    public void setVersion(int major, int minor) {
        this.majorNbVersion = major;
        this.minorNbVersion = minor;
    }

    public void setEngineConfEntry(InputStream config) {
        try {
            byte[] engineConf = this.getContentInByteArray(config, "RESOURCES/engine.conf");
            this.byteEntry("RESOURCES/engine.conf", 4, engineConf);
            config.close();
        }
        catch (IOException ex) {
            this.problemDuringArchiveEntryCreation(ex, "RESOURCES/engine.conf");
        }
    }

    protected void defineCurrentArchiveBusiness(boolean isBusiness) {
        this.currentArchive.isBusiness(isBusiness);
    }

    public void setBusinessModelPath(ArrayList businessModelPath) {
        this.bomPathes = businessModelPath;
    }

    public void addBusinessModelEntry(String businessModelName, InputStream businessModelStream) {
        try {
            IlrRulesetArchiveBuilderBase.checkDuplicatedEntry(this.bomTocs, businessModelName);
            if (this.bomPathes == null) {
                this.bomPathes = new ArrayList();
            }
            byte[] bomAsBytes = this.getContentInByteArray(businessModelStream, businessModelName);
            businessModelStream.close();
            this.fillBomXom(businessModelName, bomAsBytes, 1);
            if (this.bomTocs == null) {
                this.bomTocs = new ArrayList();
            }
            this.bomTocs.add(businessModelName);
        }
        catch (IOException ex) {
            this.problemDuringArchiveEntryCreation(ex, businessModelName);
        }
    }

    public void addMappingEntry(String b2XPath, InputStream bom2XomStream) {
        try {
            IlrRulesetArchiveBuilderBase.checkDuplicatedEntry(this.b2xTocs, b2XPath);
            byte[] b2xAsBytes = this.getContentInByteArray(bom2XomStream, b2XPath);
            bom2XomStream.close();
            this.fillBomXom(b2XPath, b2xAsBytes, 2);
            String bom2XomName = IlrRulesetArchive.getObjectModelName(b2XPath);
            if (this.bom2XomNames == null) {
                this.bom2XomNames = new HashMap();
            }
            if (this.b2xTocs == null) {
                this.b2xTocs = new ArrayList();
            }
            this.b2xTocs.add(b2XPath);
            this.bom2XomNames.put(bom2XomName, b2XPath);
        }
        catch (IOException ex) {
            this.problemDuringArchiveEntryCreation(ex, b2XPath);
        }
    }

    public void addDynamicModelEntry(String modelName, InputStream modelStream) {
        modelName = this.normalizeEntryNameGiven(modelName);
        try {
            IlrRulesetArchiveBuilderBase.checkDuplicatedEntry(this.xomTocs, modelName);
            if (this.xomTocs == null) {
                this.xomTocs = new ArrayList();
            }
            this.xomTocs.add(modelName);
            byte[] xomAsBytes = this.getContentInByteArray(modelStream, modelName);
            modelStream.close();
            this.fillBomXom(modelName, xomAsBytes, 3);
        }
        catch (IOException ex) {
            this.problemDuringArchiveEntryCreation(ex, modelName);
        }
    }

    public void enableBusinessXMLService(boolean enable) {
        this.currentArchive.setBusinessDataXmlServiceEnable(enable);
    }

    static void checkDuplicatedEntry(ArrayList tocs, Object name) {
        if (tocs == null) {
            return;
        }
        if (tocs.contains(name)) {
            IlrRulesetArchive.alreadyInsertedError(name.toString());
        }
    }

    static void checkEntryName(String name) {
        if (name.length() > 65535) {
            IlrRulesetArchive.entryNameNotValid(name);
        }
        if (name.indexOf("//") > 0 || name.indexOf("*") > 0 || name.indexOf("?") > 0) {
            IlrRulesetArchive.entryNameNotValid(name);
        }
    }

    public void addXsdEntry(String xsdName, InputStream xsdStream) {
        xsdName = this.normalizeEntryNameGiven(xsdName);
        this.addSchema(xsdName, null, xsdName, xsdStream, null);
    }

    public void addSchema(String schemaNamespace, String name, InputStream inputStream) {
        String entryName = this.createEntryName(name) + ".xsd";
        this.addSchema(entryName, schemaNamespace, name, inputStream, null);
    }

    public void addSchema(String schemaNamespace, String name, URL location) {
        String entryName = this.createEntryName(name) + ".xsd";
        this.addSchema(entryName, schemaNamespace, name, null, location);
    }

    private void addSchema(String entryName, String schemaNamespace, String name, InputStream inputStream, URL location) {
        SchemaDocument schemaDocument = new SchemaDocument(entryName, name, schemaNamespace, location);
        if (inputStream != null) {
            IlrRulesetArchiveBuilderBase.checkDuplicatedEntry(this.xsdTocs, schemaDocument);
            byte[] xsdAsbyte = this.getContentInByteArray(inputStream, name);
            try {
                inputStream.close();
            }
            catch (IOException ioe) {
                this.problemDuringArchiveEntryCreation(ioe, name);
            }
            this.fillBomXom(entryName, xsdAsbyte, 6);
        }
        if (this.xsdTocs == null) {
            this.xsdTocs = new ArrayList();
        }
        this.xsdTocs.add(schemaDocument);
    }

    public void addWsdlEntry(String wsdlName, InputStream wsdlStream) {
        wsdlName = this.normalizeEntryNameGiven(wsdlName);
        try {
            IlrRulesetArchiveBuilderBase.checkDuplicatedEntry(this.wsdlTocs, wsdlName);
            if (this.wsdlTocs == null) {
                this.wsdlTocs = new ArrayList();
            }
            this.wsdlTocs.add(wsdlName);
            byte[] wsdlAsBytes = this.getContentInByteArray(wsdlStream, wsdlName);
            wsdlStream.close();
            this.fillBomXom(wsdlName, wsdlAsBytes, 7);
        }
        catch (IOException ex) {
            this.problemDuringArchiveEntryCreation(ex, wsdlName);
        }
    }

    public void addUserDataEntry(String userDataName, InputStream userDataStream) {
        try {
            if (this.userDataTocs == null) {
                this.userDataTocs = new ArrayList();
            }
            this.userDataTocs.add(userDataName);
            byte[] userDataAsBytes = this.getContentInByteArray(userDataStream, userDataName);
            userDataStream.close();
            this.byteEntry("USER_DATA/" + userDataName, 5, userDataAsBytes);
        }
        catch (IOException ex) {
            this.problemDuringArchiveEntryCreation(ex, userDataName);
        }
    }

    public void setXsdMetadata(String xsd) {
        this.xsdMetadataFileName = xsd;
    }

    public void setXsdIndex(String xsd) {
        this.xsdIndexFileName = xsd;
    }

    public void setXsdDescriptor(String xsd) {
        this.xsdDescriptorFileName = xsd;
    }

    public void setXsdBomInfo(String xsd) {
        this.xsdBomInfoFileName = xsd;
    }

    protected void addErrorId(String errorId) {
        this.addError(IlrMessages.getMessage(errorId));
    }

    protected void addErrorId(Exception e, String errorId) {
        this.addError(e, IlrMessages.getMessage(errorId));
    }

    protected void addErrorId(String errorId, Object ... arguments) {
        this.addError(IlrMessages.getMessage(errorId, arguments));
    }

    protected void addErrorId(Exception e, String errorId, Object ... arguments) {
        this.addError(e, IlrMessages.getMessage(errorId, arguments));
    }

    protected void addError(Exception ex, String msg) {
        this.archiveBuildingErrors.add(msg);
        throw new IlrRulesetArchive.RulesetArchiveException(ex, msg);
    }

    protected void addError(String msg) {
        this.archiveBuildingErrors.add(msg);
        throw new IlrRulesetArchive.RulesetArchiveException(msg);
    }

    public IlrRulesetArchive generate() {
        String[] errors = this.getErrors();
        int len = errors.length;
        if (len > 0) {
            this.printErrors();
            return null;
        }
        IlrRulesetArchive archive = this.currentArchive;
        try {
            archive = this.generateArchive(archive);
            archive.interpret();
        }
        catch (IlrRulesetArchive.RulesetArchiveException ex) {
            this.archiveBuildingErrors.add(ex.getMessage());
            this.printErrors();
            archive = null;
        }
        return archive;
    }

    public String[] getErrors() {
        int size = this.archiveBuildingErrors.size();
        String[] msgs = new String[size];
        this.archiveBuildingErrors.toArray(msgs);
        return msgs;
    }

    public void printErrors() {
        String[] errors = this.getErrors();
        int len = errors.length;
        if (this.messageWriter == null) {
            this.messageWriter = new PrintWriter(System.out, true);
        }
        for (int i = 0; i < len; ++i) {
            this.messageWriter.println(errors[i]);
        }
    }

    protected IlrRulesetArchive generateArchive(IlrRulesetArchive archive) {
        this.fillArchive();
        this.currentArchive = null;
        return archive;
    }

    protected void fillArchive() {
        this.fillResources();
        this.fillMetaInf();
        this.fillIndex();
    }

    protected void fillResources() {
        this.fillMetadata();
        this.fillBomInfos();
        if (this.bomTocs != null) {
            this.currentArchive.isBusiness(true);
        }
    }

    protected void fillMetaInf() {
        XmlDescriptorBase xmlDesc = this.makeDescriptor();
        String descriptor = this.xmlEntry("META-INF/descriptor.xml", xmlDesc);
        if (this.xsdDescriptorFileName != null) {
            this.validateXmlDocument(descriptor);
        }
    }

    protected XmlDescriptorBase makeDescriptor() {
        return new XmlDescriptorBase();
    }

    protected void fillMetadata() {
        XmlMetadataBase xmlMetadata = this.createMetadata();
        String metadata = this.xmlEntry("RESOURCES/metadata.xml", xmlMetadata);
        if (this.xsdMetadataFileName != null) {
            this.validateXmlDocument(metadata);
        }
    }

    protected XmlMetadataBase createMetadata() {
        return new XmlMetadataBase();
    }

    protected void fillIndex() {
        XmlIndex xmlIndex = new XmlIndex();
        String indexDir = IlrRulesetArchive.isCurrentVersionAtLeast(6, 5) ? "META-INF" : "RESOURCES";
        String indexEntryName = indexDir + "/" + "index.xml";
        String index = this.xmlEntry(indexEntryName, xmlIndex);
        if (this.xsdIndexFileName != null) {
            this.validateXmlDocument(index);
        }
    }

    protected void fillBomInfos() {
        XmlBomInfo xmlBomInfo = new XmlBomInfo();
        String bomInfo = this.xmlEntry("RESOURCES/bominfo.xml", xmlBomInfo);
        if (this.xsdBomInfoFileName != null) {
            this.validateXmlDocument(bomInfo);
        }
    }

    protected void fillBomXom(String key, byte[] code, int kind) {
        StringBuilder entryName = new StringBuilder("RESOURCES");
        if (!key.startsWith("/")) {
            entryName.append("/");
        }
        entryName.append(key);
        String entry = entryName.toString();
        IlrRulesetArchiveBuilderBase.checkEntryName(entry);
        this.byteEntry(entry, kind, code);
    }

    protected void registerArtifact(String entryName, byte[] code) {
        String directory = "";
        if (IlrRulesetArchive.isCurrentVersionAtLeast(6, 5)) {
            directory = "IRL/";
        }
        this.byteEntry(directory + entryName, 0, code);
    }

    public void addMiscElementEntry(String directory, String name, byte[] content) {
        ArrayList<String> elements;
        String entryName;
        String string = entryName = !directory.equals("") ? directory + "/" + name : name;
        if (this.miscTocs == null) {
            this.miscTocs = new HashMap();
        }
        if ((elements = (ArrayList<String>)this.miscTocs.get(directory)) == null) {
            elements = new ArrayList<String>();
            this.miscTocs.put(directory, elements);
        }
        elements.add(name);
        this.byteEntry(entryName, 8, content);
    }

    protected String xmlEntry(String entryName, XmlBase xmlGenerator) {
        StringWriter writer = new StringWriter();
        String desc = null;
        try {
            xmlGenerator.write(writer);
            desc = writer.toString();
            this.createUTF8Element(entryName, 20, desc);
        }
        catch (IOException ex) {
            this.addErrorId(ex, "messages.RulesetArchive.2", entryName);
        }
        return desc;
    }

    protected final byte[] convertIntoBytes(String code) {
        byte[] result = null;
        try {
            if (code != null && code.length() > 0) {
                result = this.stringEncoder.encode(code, this.encoding);
            }
        }
        catch (CharacterCodingException ex) {
            result = null;
            this.addErrorId(ex, "messages.RulesetArchive.4");
        }
        return result;
    }

    protected final byte[] getContentInByteArray(InputStream stream, String name) {
        ReadableByteChannel readByteChannel = Channels.newChannel(stream);
        ByteBuffer byteBuffer = ByteBuffer.allocate(10000);
        ByteArrayOutputStream ostream = new ByteArrayOutputStream(10000);
        WritableByteChannel writableByteChannel = Channels.newChannel(ostream);
        try {
            int nbOfBytesRead = 0;
            do {
                byteBuffer.clear();
                nbOfBytesRead = readByteChannel.read(byteBuffer);
                byteBuffer.flip();
                writableByteChannel.write(byteBuffer);
            } while (nbOfBytesRead > 0);
        }
        catch (IOException ioe) {
            throw new RuntimeException(name, ioe);
        }
        finally {
            try {
                readByteChannel.close();
                writableByteChannel.close();
            }
            catch (IOException ioeclose) {}
        }
        return ostream.toByteArray();
    }

    protected void problemDuringArchiveEntryCreation(IOException ex, String name) {
        this.addErrorId(ex, "messages.RulesetArchive.0", name);
    }

    protected void byteEntry(String entryName, int kind, byte[] content) {
        this.createElement(entryName, kind, content);
    }

    private void createElement(String key, int kind, String code) {
        this.createElement(key, kind, code, this.encoding);
    }

    private void createUTF8Element(String key, int kind, String code) {
        this.createElement(key, kind, code, "UTF-8");
    }

    private void createElement(String key, int kind, String code, String enc) {
        try {
            byte[] contents = this.stringEncoder.encode(code, enc);
            this.createElement(key, kind, contents);
        }
        catch (CharacterCodingException ex) {
            this.addErrorId(ex, "messages.RulesetArchive.0", key);
        }
    }

    private void createElement(String key, int kind, byte[] content) {
        IlrRulesetArchive ilrRulesetArchive = this.currentArchive;
        ilrRulesetArchive.getClass();
        IlrRulesetArchive.Element element = ilrRulesetArchive.new IlrRulesetArchive.Element(key, kind);
        element.setContent(content);
        this.currentArchive.addElement(element);
    }

    private void validateXmlDocument(String xmlDocument) {
        DocumentBuilder parser = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setValidating(true);
            docBuilderFactory.setNamespaceAware(true);
            parser = docBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            this.addErrorId(e, "RulesetArchive.RulesetSignature.4", e.toString());
        }
        ErrorChecker errors = new ErrorChecker();
        parser.setErrorHandler(errors);
        try {
            parser.parse(new InputSource(new StringReader(xmlDocument)));
        }
        catch (Exception e) {
            this.addErrorId(e, "RulesetArchive.RulesetSignature.4", e.toString());
        }
    }

    public void setXMLBuilderFactory(DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
        this.transformerFactory = transformerFactory;
    }

    private String createEntryName(String name) {
        char[] nameInChar = name.toCharArray();
        char[] shortName = new char[5];
        Arrays.fill(shortName, 'a');
        for (int i = 0; i < nameInChar.length && i < shortName.length; ++i) {
            char currentChar = nameInChar[i];
            if (!Character.isJavaIdentifierStart(currentChar)) continue;
            shortName[i] = currentChar;
        }
        String prefix = new String(shortName);
        return prefix + Integer.toString(this.nbXsdNameIndex++);
    }

    private String normalizeEntryNameGiven(String entryName) {
        if (entryName.startsWith("/")) {
            entryName = entryName.substring(1, entryName.length() - 1);
        }
        return entryName;
    }

    private class ErrorChecker
    extends DefaultHandler {
        private void display(SAXParseException e, String head) {
            System.out.println(head + e.getMessage() + " in " + e.getSystemId() + " at line " + e.getLineNumber() + " at column " + e.getColumnNumber());
        }

        @Override
        public void error(SAXParseException e) {
            this.display(e, "Parsing error:  ");
        }

        @Override
        public void warning(SAXParseException e) {
            this.display(e, "Parsing warning:  ");
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.display(e, "Parsing error:  ");
            System.out.println("Cannot continue.");
            super.fatalError(e);
        }
    }

    private final class SchemaDocument {
        private String entryName;
        private String name;
        private String namespace;
        private URL location;

        private SchemaDocument(String entryName, String name, String namespace, URL location) {
            this.entryName = entryName;
            this.name = name;
            this.namespace = namespace;
            this.location = location;
        }

        public int hashCode() {
            return this.entryName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SchemaDocument) {
                SchemaDocument other = (SchemaDocument)obj;
                return this.entryName.equals(other.entryName);
            }
            return false;
        }

        public String toString() {
            return this.entryName.toString();
        }
    }

    protected class XmlIndex
    extends XmlBase
    implements IlrXmlRulesetArchiveTag {
        @Override
        protected Document buildDocument() {
            Document document = this.domImplementation.createDocument("http://www.ilog.com/products/xml/schemas/ruleset_index_1.0", "XmlIndex", null);
            Node root = document.getFirstChild();
            Element elt = document.createElement("index:ruleset-index");
            elt.setAttribute("xmlns:index", "http://www.ilog.com/products/xml/schemas/ruleset_index_1.0");
            document.replaceChild(elt, root);
            if (IlrRulesetArchiveBuilderBase.this.xsdIndexFileName != null) {
                elt.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                String value = "http://www.ilog.com/products/xml/schemas/ruleset_index_1.0 " + IlrRulesetArchiveBuilderBase.this.xsdIndexFileName;
                elt.setAttribute("xsi:schemaLocation", value);
            }
            this.buildGenerationDate(document, elt, "index");
            this.buildToc(document, elt);
            return document;
        }

        private void buildToc(Document doc, Element fatherElement) {
            Element tocEl = doc.createElement("index:toc");
            fatherElement.appendChild(tocEl);
            this.buildModelToc(doc, tocEl, IlrRulesetArchiveBuilderBase.this.bomTocs, "bomToc");
            this.buildModelToc(doc, tocEl, IlrRulesetArchiveBuilderBase.this.b2xTocs, "bom2xomToc");
            this.buildModelToc(doc, tocEl, IlrRulesetArchiveBuilderBase.this.xomTocs, "xomToc");
            this.buildXSDModelToc(doc, tocEl);
            this.buildModelToc(doc, tocEl, IlrRulesetArchiveBuilderBase.this.wsdlTocs, "wsdlToc");
            this.buildModelToc(doc, tocEl, IlrRulesetArchiveBuilderBase.this.userDataTocs, "userDataToc");
            this.buildArtifactsToc(doc, tocEl);
            this.buildMiscElementsToc(doc, tocEl);
        }

        private void buildModelToc(Document doc, Element fatherElement, ArrayList entries, String tag) {
            Element tocEl = doc.createElement("index:" + tag);
            fatherElement.appendChild(tocEl);
            this.buildTocEntries(doc, entries, tocEl);
        }

        private void buildXSDModelToc(Document doc, Element fatherElement) {
            Element tocEl = doc.createElement("index:xsdToc");
            fatherElement.appendChild(tocEl);
            this.buildXSDTocEntries(doc, tocEl);
        }

        private void buildArtifactsToc(Document doc, Element fatherElement) {
            Element tocEl = doc.createElement("index:irlToc");
            fatherElement.appendChild(tocEl);
            if (IlrRulesetArchiveBuilderBase.this.irlTocs == null) {
                return;
            }
            for (String pkgName : IlrRulesetArchiveBuilderBase.this.irlTocs.keySet()) {
                Element pkgEl = doc.createElement("index:package");
                tocEl.appendChild(pkgEl);
                pkgEl.setAttribute("name", pkgName);
                IlrRulesetArchive.PackageContent pkgContent = (IlrRulesetArchive.PackageContent)IlrRulesetArchiveBuilderBase.this.irlTocs.get(pkgName);
                this.buildTocTypedEntries(doc, pkgContent, pkgEl);
            }
        }

        private void buildTocTypedEntries(Document doc, IlrRulesetArchive.PackageContent pkgContent, Element fatherElement) {
            if (pkgContent == null) {
                return;
            }
            Element miscEl = doc.createElement("index:irls");
            fatherElement.appendChild(miscEl);
            this.buildTocEntries(doc, pkgContent.irls, miscEl);
            Element ruleEl = doc.createElement("index:rules");
            fatherElement.appendChild(ruleEl);
            this.buildTocEntries(doc, pkgContent.rules, ruleEl);
            Element functionEl = doc.createElement("index:functions");
            fatherElement.appendChild(functionEl);
            this.buildTocEntries(doc, pkgContent.functions, functionEl);
            Element taskEl = doc.createElement("index:tasks");
            fatherElement.appendChild(taskEl);
            this.buildTocEntries(doc, pkgContent.tasks, taskEl);
            Element variableEl = doc.createElement("index:variables");
            fatherElement.appendChild(variableEl);
            this.buildTocEntry(doc, pkgContent.variables, variableEl);
        }

        private void buildTocEntries(Document doc, ArrayList entries, Element fatherElement) {
            if (entries == null || entries.size() == 0) {
                return;
            }
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                String entryName = (String)entries.get(i);
                this.buildTocEntry(doc, entryName, fatherElement);
            }
        }

        private void buildXSDTocEntries(Document doc, Element fatherElement) {
            if (IlrRulesetArchiveBuilderBase.this.xsdTocs == null || IlrRulesetArchiveBuilderBase.this.xsdTocs.size() == 0) {
                return;
            }
            int size = IlrRulesetArchiveBuilderBase.this.xsdTocs.size();
            for (int i = 0; i < size; ++i) {
                SchemaDocument schemaDocument = (SchemaDocument)IlrRulesetArchiveBuilderBase.this.xsdTocs.get(i);
                this.buildXSDTocEntry(doc, schemaDocument, fatherElement);
            }
        }

        private void buildTocEntry(Document doc, String entry, Element fatherElement) {
            if (entry == null) {
                return;
            }
            Element entryEl = doc.createElement("index:entry");
            fatherElement.appendChild(entryEl);
            entryEl.setAttribute("name", entry);
        }

        private void buildXSDTocEntry(Document doc, SchemaDocument schemaDocument, Element fatherElement) {
            if (schemaDocument == null) {
                return;
            }
            Element entryEl = doc.createElement("index:xsdEntry");
            fatherElement.appendChild(entryEl);
            entryEl.setAttribute("name", schemaDocument.entryName);
            entryEl.setAttribute("schemaNamespace", schemaDocument.namespace);
            entryEl.setAttribute("xsdName", schemaDocument.name);
            if (schemaDocument.location != null) {
                entryEl.setAttribute("URL", schemaDocument.location.toString());
            } else {
                entryEl.setAttribute("URL", null);
            }
        }

        private void buildMiscElementsToc(Document doc, Element fatherElement) {
            if (!IlrRulesetArchive.isCurrentVersionAtLeast(6, 5)) {
                return;
            }
            Element tocEl = doc.createElement("index:miscElementsToc");
            fatherElement.appendChild(tocEl);
            if (IlrRulesetArchiveBuilderBase.this.miscTocs == null) {
                return;
            }
            for (String directory : IlrRulesetArchiveBuilderBase.this.miscTocs.keySet()) {
                Element miscEl = doc.createElement("index:misc");
                tocEl.appendChild(miscEl);
                miscEl.setAttribute("type", directory);
                ArrayList elements = (ArrayList)IlrRulesetArchiveBuilderBase.this.miscTocs.get(directory);
                int size = elements.size();
                for (int i = 0; i < size; ++i) {
                    String name = (String)elements.get(i);
                    String entryName = !directory.equals("") ? directory + '/' + name : name;
                    this.buildTocEntry(doc, entryName, miscEl);
                }
            }
        }
    }

    protected class XmlMetadataBase
    extends XmlBase
    implements IlrXmlRulesetArchiveTag {
        @Override
        protected Document buildDocument() {
            Document document = this.domImplementation.createDocument("http://www.ilog.com/products/xml/schemas/ruleset_metadata_1.0", "XmlMetadata", null);
            Node root = document.getFirstChild();
            Element elt = document.createElement("metadata:ruleset-metadata");
            elt.setAttribute("xmlns:metadata", "http://www.ilog.com/products/xml/schemas/ruleset_metadata_1.0");
            document.replaceChild(elt, root);
            if (IlrRulesetArchiveBuilderBase.this.xsdMetadataFileName != null) {
                elt.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                String value = "http://www.ilog.com/products/xml/schemas/ruleset_metadata_1.0 " + IlrRulesetArchiveBuilderBase.this.xsdMetadataFileName;
                elt.setAttribute("xsi:schemaLocation", value);
            }
            this.buildMetadata(document, elt);
            return document;
        }

        protected void buildMetadata(Document doc, Element root) {
            this.buildGenerationDate(doc, root, "metadata");
        }
    }

    protected class XmlDescriptorBase
    extends XmlBase
    implements IlrXmlRulesetArchiveTag {
        @Override
        protected Document buildDocument() {
            Document document = this.domImplementation.createDocument("http://www.ilog.com/products/xml/schemas/ruleset_descriptor_1.0", "XmlDescriptorBase", null);
            Node root = document.getFirstChild();
            Element elt = document.createElement("desc:ruleset-descriptor");
            elt.setAttribute("xmlns:desc", "http://www.ilog.com/products/xml/schemas/ruleset_descriptor_1.0");
            elt.setAttribute("xmlns:sig", "http://www.ilog.com/products/xml/schemas/signature_2.0");
            document.replaceChild(elt, root);
            if (IlrRulesetArchiveBuilderBase.this.xsdDescriptorFileName != null) {
                elt.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                String value = "http://www.ilog.com/products/xml/schemas/ruleset_descriptor_1.0 " + IlrRulesetArchiveBuilderBase.this.xsdDescriptorFileName;
                elt.setAttribute("xsi:schemaLocation", value);
            }
            this.addElement(document, elt, "desc:ruleset-name", "ruleset");
            this.buildIsBusinessElt(document, elt);
            this.buildBusinessXMLServiceElt(document, elt);
            this.buildGenerationDate(document, elt, "desc");
            this.buildRulesetParameterElements(document, elt);
            this.buildUnknownArtifact(document, elt);
            this.buildArchiveEncoding(document, elt);
            this.buildJRulesVersion(document, elt);
            this.buildRulesetVersion(document, elt);
            return document;
        }

        protected void buildIsBusinessElt(Document doc, Element fatherElement) {
            String isB = String.valueOf(IlrRulesetArchiveBuilderBase.this.currentArchive.isBusiness());
            this.addElement(doc, fatherElement, "desc:isbusiness", isB);
        }

        protected void buildBusinessXMLServiceElt(Document doc, Element fatherElement) {
            if (!IlrRulesetArchiveBuilderBase.this.currentArchive.isBusiness() && IlrRulesetArchiveBuilderBase.this.currentArchive.isBusinessDataXmlServiceEnable()) {
                throw new IlrRulesetArchive.RulesetArchiveException(IlrMessages.getMessage("messages.RulesetArchive.22"));
            }
            String isB = String.valueOf(IlrRulesetArchiveBuilderBase.this.currentArchive.isBusinessDataXmlServiceEnable());
            this.addElement(doc, fatherElement, "desc:businessxmlserviceenable", isB);
        }

        protected void buildRulesetParameterElements(Document doc, Element fatherElement) {
            Element elt = doc.createElement("desc:signature-declaration");
            fatherElement.appendChild(elt);
        }

        protected void buildArchiveEncoding(Document doc, Element fatherElement) {
            this.addElement(doc, fatherElement, "desc:encoding", IlrRulesetArchiveBuilderBase.this.currentArchive.encoding);
        }

        protected void buildUnknownArtifact(Document doc, Element fatherElement) {
            this.addElement(doc, fatherElement, "desc:error-for-unknown-artifact", String.valueOf(IlrRulesetArchiveBuilderBase.this.isUnknownArtifactAnError));
        }

        protected void buildJRulesVersion(Document doc, Element fatherElement) {
            Element versionEl = doc.createElement("desc:jrules-version");
            fatherElement.appendChild(versionEl);
            versionEl.setAttribute("major", String.valueOf(IlrRulesetArchive.localMajorJRulesVersion));
            versionEl.setAttribute("minor", String.valueOf(IlrRulesetArchive.localMinorJRulesVersion));
        }

        protected void buildRulesetVersion(Document doc, Element fatherElement) {
            Element versionEl = doc.createElement("desc:version");
            fatherElement.appendChild(versionEl);
            versionEl.setAttribute("major", String.valueOf(IlrRulesetArchiveBuilderBase.this.majorNbVersion));
            versionEl.setAttribute("minor", String.valueOf(IlrRulesetArchiveBuilderBase.this.minorNbVersion));
        }
    }

    protected class XmlBomInfo
    extends XmlBase
    implements IlrXmlRulesetArchiveTag {
        @Override
        protected Document buildDocument() {
            Document document = this.domImplementation.createDocument("http://www.ilog.com/products/xml/schemas/bominfo_1.0", "XmlBomInfo", null);
            Node root = document.getFirstChild();
            Element elt = document.createElement("bom:bom-info");
            elt.setAttribute("xmlns:bom", "http://www.ilog.com/products/xml/schemas/bominfo_1.0");
            document.replaceChild(elt, root);
            if (IlrRulesetArchiveBuilderBase.this.xsdBomInfoFileName != null) {
                elt.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                String value = "http://www.ilog.com/products/xml/schemas/bominfo_1.0 " + IlrRulesetArchiveBuilderBase.this.xsdBomInfoFileName;
                elt.setAttribute("xsi:schemaLocation", value);
            }
            this.buildGenerationDate(document, elt, "bom");
            this.buildBomPathes(document, elt);
            return document;
        }

        private void buildBomPathes(Document doc, Element fatherElement) {
            if (IlrRulesetArchiveBuilderBase.this.bomPathes == null || IlrRulesetArchiveBuilderBase.this.bomPathes.size() == 0) {
                return;
            }
            Element bomPathEl = doc.createElement("bom:bompathes");
            fatherElement.appendChild(bomPathEl);
            int size = IlrRulesetArchiveBuilderBase.this.bomPathes.size();
            for (int i = 0; i < size; ++i) {
                Element pathEl = doc.createElement("bom:bompath");
                String path = (String)IlrRulesetArchiveBuilderBase.this.bomPathes.get(i);
                bomPathEl.appendChild(pathEl);
                pathEl.setAttribute("value", path);
            }
        }
    }

    protected abstract class XmlBase {
        protected boolean errorEncountered;
        protected DocumentBuilderFactory documentBuilderFact = null;
        protected DocumentBuilder documentBuilder = null;
        protected DOMImplementation domImplementation = null;

        protected XmlBase() {
            try {
                this.documentBuilderFact = IlrRulesetArchiveBuilderBase.this.documentBuilderFactory != null ? IlrRulesetArchiveBuilderBase.this.documentBuilderFactory : DocumentBuilderFactory.newInstance();
                this.documentBuilder = this.documentBuilderFact.newDocumentBuilder();
                this.domImplementation = this.documentBuilder.getDOMImplementation();
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean write(Writer writer) throws IOException {
            this.errorEncountered = false;
            Document doc = this.buildDocument();
            this.writeDocument(doc, writer);
            return !this.errorEncountered;
        }

        private void writeDocument(final Document doc, final Writer writer) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    XmlBase.this.writeDocumentInternal(doc, writer);
                    return null;
                }
            });
        }

        private void writeDocumentInternal(Document doc, Writer writer) {
            try {
                TransformerFactory transformerFact = IlrRulesetArchiveBuilderBase.this.transformerFactory == null ? TransformerFactory.newInstance() : IlrRulesetArchiveBuilderBase.this.transformerFactory;
                Transformer transformer = transformerFact.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("omit-xml-declaration", "no");
                DOMSource xmlSource = new DOMSource(doc);
                StreamResult xmlDest = new StreamResult(writer);
                transformer.transform(xmlSource, xmlDest);
            }
            catch (TransformerConfigurationException ex) {
                throw new RuntimeException(ex);
            }
            catch (TransformerException ex) {
                throw new RuntimeException(ex);
            }
        }

        private void printDoubleDigit(int d, StringBuilder buf) {
            if (d < 10) {
                buf.append('0');
            }
            buf.append(d);
        }

        protected void buildGenerationDate(Document doc, Element rootEl, String ns) {
            GregorianCalendar cal = new GregorianCalendar();
            StringBuilder buf = new StringBuilder();
            buf.append(cal.get(1));
            buf.append('-');
            this.printDoubleDigit(cal.get(2) + 1, buf);
            buf.append('-');
            this.printDoubleDigit(cal.get(5), buf);
            buf.append('T');
            this.printDoubleDigit(cal.get(11), buf);
            buf.append(':');
            this.printDoubleDigit(cal.get(12), buf);
            buf.append(':');
            this.printDoubleDigit(cal.get(13), buf);
            buf.append('Z');
            this.addElement(doc, rootEl, ns + ":" + "generation-date", buf.toString());
        }

        protected void addElement(Document doc, Element fatherElement, String elementName, String elementContent) {
            Element elt = doc.createElement(elementName);
            Text text = doc.createTextNode(elementContent);
            elt.appendChild(text);
            fatherElement.appendChild(elt);
        }

        protected abstract Document buildDocument();
    }
}

