/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.archive;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.HashMap;
import java.util.Map;

public final class IlrStringEncoder {
    private static int INITIAL_SIZE_OF_BUFFER = 0x100000;
    private int currentSizeOfBuffer = INITIAL_SIZE_OF_BUFFER;
    private ByteBuffer byteBuffer;
    private final Map<String, CharsetEncoder> encoders = new HashMap<String, CharsetEncoder>(1);

    public synchronized byte[] encode(String input, String charset) throws CharacterCodingException {
        CharsetEncoder ce = this.getEncoder(charset);
        CharBuffer inputBuffer = CharBuffer.wrap(input);
        while (inputBuffer.hasRemaining()) {
            this.initializeBuffer();
            CoderResult cr = ce.encode(inputBuffer, this.byteBuffer, true);
            if (cr.isUnderflow() && (cr = ce.flush(this.byteBuffer)).isUnderflow()) break;
            if (cr.isOverflow()) {
                inputBuffer.rewind();
                this.reinitBuffer();
            }
            if (!cr.isError()) continue;
            cr.throwException();
        }
        return this.getBufferContent();
    }

    private byte[] getBufferContent() {
        this.byteBuffer.flip();
        byte[] array = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(array);
        return array;
    }

    private CharsetEncoder getEncoder(String charset) {
        CharsetEncoder ce = this.encoders.get(charset);
        if (ce == null) {
            Charset cs = Charset.forName(charset);
            ce = cs.newEncoder();
            this.encoders.put(charset, ce);
        }
        ce.reset();
        return ce;
    }

    private void reinitBuffer() {
        this.currentSizeOfBuffer *= 2;
        this.byteBuffer = null;
    }

    private void initializeBuffer() {
        if (this.byteBuffer == null) {
            this.allocateBuffer(this.currentSizeOfBuffer, true);
        }
        this.byteBuffer.clear();
    }

    private void allocateBuffer(int size, boolean direct) {
        this.byteBuffer = direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }
}

