/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml;

import ilog.rules.base.xml.IlrQNameHelper;
import ilog.rules.base.xml.IlrXmlBaseConstants;
import ilog.rules.base.xml.IlrXmlConverter;
import ilog.rules.base.xml.IlrXmlMarshallingContext;
import ilog.rules.base.xml.IlrXmlNamespaceManager;
import ilog.rules.base.xml.IlrXmlUnmarshallingContext;
import ilog.rules.base.xml.converter.IlrExtendedXmlConverter;
import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import ilog.rules.util.issue.IlrIssueHandler;
import ilog.rules.util.issue.IlrWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public class IlrXmlDefaultConverterManager
implements IlrXmlBaseConstants {
    protected HashMap<String, IlrXmlConverter> converterFromXmlElement = new HashMap();
    protected HashMap<String, IlrXmlConverter> converterFromXmlType = new HashMap();
    protected HashMap<Object, IlrXmlConverter> converterFromClass = new HashMap();
    protected List<IlrXmlConverter> converterFromNonConcreteClass = new ArrayList<IlrXmlConverter>();
    protected Map<Object, String> singletonNames = new IdentityHashMap<Object, String>();
    protected Map<String, Object> singletons = new HashMap<String, Object>();
    protected IlrIssueHandler errorManager;
    protected boolean objectGraphSupport;
    protected static final Object NULLPLACEHOLDER = new Object();

    public IlrXmlDefaultConverterManager(boolean objectGraphSupport) {
        this.objectGraphSupport = objectGraphSupport;
    }

    public IlrXmlDefaultConverterManager(IlrIssueHandler errorManager, boolean objectGraphSupport) {
        this.errorManager = errorManager;
        this.objectGraphSupport = objectGraphSupport;
    }

    public void writeObject(Object object, QName rootQName, IlrXmlNamespaceManager nsManager, Document document, Map data) throws IlrErrorException {
        IlrXmlMarshallingContext context = this.createContext(nsManager, document, data);
        Element elmt = context.writeObject(object, null, rootQName);
        if (elmt == null) {
            this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_001", object.getClass().getName()));
        } else {
            document.appendChild(elmt);
            this.declareNamespaceAttributes(elmt, nsManager);
            context.declareSchemaLocationAttribute(elmt);
        }
    }

    protected IlrXmlMarshallingContext createContext(IlrXmlNamespaceManager nsManager, Document document, Map data) {
        MarshallingContext context = this.objectGraphSupport ? new GraphMarshallingContext(nsManager, document, data) : new TreeMarshallingContext(nsManager, document, data);
        return context;
    }

    protected void declareNamespaceAttributes(Element elem, IlrXmlNamespaceManager nsManager) {
        Iterator prefixIte = nsManager.iteratePrefix();
        while (prefixIte.hasNext()) {
            String prefix = (String)prefixIte.next();
            String ns = nsManager.getNamespace(prefix);
            elem.setAttribute("xmlns:" + prefix, ns);
        }
    }

    public Object readObject(Document document, Map data, Class expectedType) throws IlrErrorException {
        IlrXmlNamespaceManager nsManager = this.createNamespaceManager(document.getDocumentElement());
        UnmarshallingContext context = this.objectGraphSupport ? new GraphUnmarshallingContext(nsManager, document, data) : new TreeUnmarshallingContext(nsManager, document, data);
        Object obj = context.readObject(null, document.getDocumentElement());
        if (obj != null && expectedType != null && !expectedType.isAssignableFrom(obj.getClass())) {
            this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_002", obj.toString(), obj.getClass().getName(), expectedType.getName()));
            return null;
        }
        return obj;
    }

    private IlrXmlNamespaceManager createNamespaceManager(Element rootElement) {
        IlrXmlNamespaceManager nsManager = new IlrXmlNamespaceManager();
        NamedNodeMap attributesMap = rootElement.getAttributes();
        int s = attributesMap.getLength();
        for (int i = 0; i < s; ++i) {
            Node attr = attributesMap.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            nsManager.addNamespace(attr.getLocalName(), attr.getNodeValue());
        }
        return nsManager;
    }

    public void addConverter(IlrXmlConverter converter) {
        Class[] classes;
        QName xmlType;
        QName xmlElement = converter.getXmlElement();
        if (xmlElement != null) {
            this.converterFromXmlElement.put(xmlElement.toString(), converter);
        }
        if ((xmlType = converter.getXmlType()) != null) {
            this.converterFromXmlType.put(xmlType.toString(), converter);
        }
        if ((classes = converter.getSupportedClasses()) != null) {
            for (int i = 0; i < classes.length; ++i) {
                Class clazz = classes[i];
                if (clazz == null) {
                    this.converterFromClass.put(NULLPLACEHOLDER, converter);
                    continue;
                }
                if ((clazz.getModifiers() & 0x600) != 0 && !clazz.isPrimitive()) {
                    this.converterFromNonConcreteClass.add(converter);
                    continue;
                }
                this.converterFromClass.put(clazz, converter);
            }
        }
    }

    public void removeConverter(IlrXmlConverter converter) {
        Class[] classes;
        QName xmlType;
        QName xmlElement = converter.getXmlElement();
        if (xmlElement != null) {
            this.converterFromXmlElement.remove(xmlElement.toString());
        }
        if ((xmlType = converter.getXmlType()) != null) {
            this.converterFromXmlType.remove(xmlType.toString());
        }
        if ((classes = converter.getSupportedClasses()) != null) {
            for (int i = 0; i < classes.length; ++i) {
                Class clazz = classes[i];
                if (clazz == null) {
                    this.converterFromClass.remove(NULLPLACEHOLDER);
                    continue;
                }
                if ((clazz.getModifiers() & 0x600) != 0) {
                    this.converterFromNonConcreteClass.remove(converter);
                    break;
                }
                this.converterFromClass.remove(clazz);
            }
        }
    }

    public void addSingleton(String id, Object singleton) {
        this.singletons.put(id, singleton);
        this.singletonNames.put(singleton, id);
    }

    public IlrIssueHandler getErrorManager() {
        return this.errorManager;
    }

    protected IlrXmlConverter getConverter(IlrXmlMarshallingContext context, Element father, Object object) {
        if (object == null) {
            return this.converterFromClass.get(NULLPLACEHOLDER);
        }
        IlrXmlConverter result = this.converterFromClass.get(object.getClass());
        if (result == null) {
            return this.getConverterForClassHierarchy(context, father, object);
        }
        return result;
    }

    protected IlrXmlConverter getConverterForClassHierarchy(IlrXmlMarshallingContext context, Element father, Object object) {
        for (IlrXmlConverter converter : this.converterFromNonConcreteClass) {
            Class[] classes;
            for (Class clazz : classes = converter.getSupportedClasses()) {
                if (!clazz.isAssignableFrom(object.getClass())) continue;
                return converter;
            }
        }
        return null;
    }

    protected IlrXmlConverter getConverter(IlrXmlUnmarshallingContext context, Element element) {
        QName qType = context.getXsiType(element);
        IlrXmlConverter converter = null;
        if (qType != null) {
            converter = this.converterFromXmlType.get(qType.toString());
        }
        if (converter == null) {
            String qElement = IlrQNameHelper.toString(element.getNamespaceURI(), element.getLocalName(), null);
            converter = this.converterFromXmlElement.get(qElement);
        }
        return converter;
    }

    public static String parsePrefix(String str) {
        int ix = str.indexOf(58);
        if (ix == -1) {
            return null;
        }
        return str.substring(0, ix);
    }

    private class TreeUnmarshallingContext
    extends UnmarshallingContext {
        TreeUnmarshallingContext(IlrXmlNamespaceManager nsManager, Document document, Map data) {
            super(nsManager, document, data);
        }

        @Override
        public Object readObject(Object parent, Element element) throws IlrErrorException {
            if (element == null) {
                return null;
            }
            IlrXmlConverter converter = IlrXmlDefaultConverterManager.this.getConverter(this, element);
            if (converter == null) {
                IlrXmlDefaultConverterManager.this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_006", element.getTagName()));
                return null;
            }
            try {
                return converter.readObject(element, this);
            }
            catch (IlrErrorException e) {
                throw e;
            }
            catch (RuntimeException e) {
                IlrXmlDefaultConverterManager.this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_012", e, e.getClass().getName(), e.getMessage(), element.getTagName()));
                IlrXmlDefaultConverterManager.this.errorManager.throwException();
                return null;
            }
        }
    }

    private class GraphUnmarshallingContext
    extends UnmarshallingContext {
        private Map<String, Object> id2Object;
        private Stack<String> parentIdStack;

        GraphUnmarshallingContext(IlrXmlNamespaceManager nsManager, Document document, Map data) {
            super(nsManager, document, data);
            this.id2Object = new HashMap<String, Object>();
            this.parentIdStack = new Stack();
        }

        @Override
        public Object readObject(Object parent, Element element) throws IlrErrorException {
            IlrXmlConverter converter;
            String parentId;
            if (this.parentIdStack.size() > 0 && !this.id2Object.containsKey(parentId = this.parentIdStack.peek())) {
                this.id2Object.put(parentId, parent);
            }
            if (element == null) {
                return null;
            }
            String refId = element.getAttribute("reference");
            if (refId.length() != 0) {
                Object object = this.id2Object.get(refId);
                if (object != null) {
                    return object;
                }
                IlrXmlDefaultConverterManager.this.errorManager.add(new IlrWarning("ilog.rules.xml.data.messages", "WARNING_XML_001", refId));
            }
            if ((converter = IlrXmlDefaultConverterManager.this.getConverter(this, element)) == null) {
                IlrXmlDefaultConverterManager.this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_006", element.getTagName()));
                return null;
            }
            String id = element.getAttribute("id");
            this.parentIdStack.push(id);
            Object object = converter.readObject(element, this);
            if (id.length() != 0) {
                this.id2Object.put(id, object);
            }
            this.parentIdStack.pop();
            return object;
        }
    }

    private abstract class UnmarshallingContext
    implements IlrXmlUnmarshallingContext {
        private IlrXmlNamespaceManager nsManager;
        private Document document;
        private Map data;

        UnmarshallingContext(IlrXmlNamespaceManager nsManager, Document document, Map data) {
            this.nsManager = nsManager;
            this.document = document;
            this.data = data;
        }

        @Override
        public Object readObject(Object parent, Element element, Class expectedType) throws IlrErrorException {
            Object object;
            String singletonId = element.getAttribute("singleton");
            if (singletonId.length() != 0) {
                object = IlrXmlDefaultConverterManager.this.singletons.get(singletonId);
                if (object != null) {
                    return object;
                }
                IlrXmlDefaultConverterManager.this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_014", element.getTagName(), singletonId));
            }
            if ((object = this.readObject(parent, element)) != null && !expectedType.isAssignableFrom(object.getClass())) {
                IlrXmlDefaultConverterManager.this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_002", object.toString(), object.getClass().getName(), expectedType.getName()));
                return null;
            }
            return object;
        }

        private boolean isSelectedNode(Node node, String namespace, String localName) {
            if (node.getNodeType() == 1) {
                boolean sameNs = namespace == null || namespace.equals(node.getNamespaceURI());
                boolean sameName = localName == null || localName.equals(node.getLocalName());
                return sameNs && sameName;
            }
            return false;
        }

        @Override
        public Element getFirstElement(Element father, String namespace, String localName) {
            Node child;
            if (father == null) {
                return null;
            }
            for (child = father.getFirstChild(); child != null && !this.isSelectedNode(child, namespace, localName); child = child.getNextSibling()) {
            }
            return (Element)child;
        }

        @Override
        public Element getNextElement(Element previous, String namespace, String localName) {
            Node child;
            if (previous == null) {
                return null;
            }
            for (child = previous.getNextSibling(); child != null && !this.isSelectedNode(child, namespace, localName); child = child.getNextSibling()) {
            }
            return (Element)child;
        }

        @Override
        public Document getDocument() {
            return this.document;
        }

        @Override
        public String getNamespace(String prefix) {
            return this.getNamespaceManager().getNamespace(prefix);
        }

        @Override
        public IlrIssueHandler getErrorManager() {
            return IlrXmlDefaultConverterManager.this.errorManager;
        }

        public IlrXmlNamespaceManager getNamespaceManager() {
            return this.nsManager;
        }

        @Override
        public Object getData(String key) {
            return this.data.get(key);
        }

        @Override
        public IlrXmlConverter getConverterFromClass(Class objectClass) {
            return IlrXmlDefaultConverterManager.this.converterFromClass.get(objectClass);
        }

        @Override
        public QName getXsiType(Element element) {
            String type = element.getAttributeNS("http://www.w3.org/2000/10/XMLSchema-instance", "type");
            if (type == null || type.length() == 0) {
                TypeInfo typeInfo = element.getSchemaTypeInfo();
                if (typeInfo != null && typeInfo.getTypeName() != null) {
                    return new QName(typeInfo.getTypeNamespace(), typeInfo.getTypeName());
                }
                return null;
            }
            String prefix = IlrXmlDefaultConverterManager.parsePrefix(type);
            if (prefix != null) {
                String namespace = this.getNamespace(prefix);
                return new QName(namespace, type.substring(prefix.length() + 1));
            }
            return QName.valueOf(type);
        }
    }

    protected class GraphMarshallingContext
    extends MarshallingContext {
        protected Map<Object, Element> object2Element;
        private int idCounter;

        protected GraphMarshallingContext(IlrXmlNamespaceManager nsManager, Document document, Map data) {
            super(nsManager, document, data);
            this.object2Element = new IdentityHashMap<Object, Element>();
        }

        protected String getId(Element element) {
            String id = element.getAttribute("id");
            if (id.length() == 0) {
                ++this.idCounter;
                id = "" + this.idCounter;
                element.setAttribute("id", id);
            }
            return id;
        }

        @Override
        protected void writeObjectInternal(Object object, Element elmt, IlrXmlConverter converter) throws IlrErrorException {
            if (converter.isReferenceWorthy()) {
                Element previouslyWritten = this.object2Element.get(object);
                if (previouslyWritten == null) {
                    this.object2Element.put(object, elmt);
                    converter.writeObject(object, elmt, this);
                } else {
                    String id = this.getId(previouslyWritten);
                    elmt.setAttribute("reference", id);
                }
            } else {
                converter.writeObject(object, elmt, this);
            }
        }
    }

    private class TreeMarshallingContext
    extends MarshallingContext {
        TreeMarshallingContext(IlrXmlNamespaceManager nsManager, Document document, Map data) {
            super(nsManager, document, data);
        }

        @Override
        protected void writeObjectInternal(Object object, Element elmt, IlrXmlConverter converter) throws IlrErrorException {
            converter.writeObject(object, elmt, this);
        }
    }

    private abstract class MarshallingContext
    implements IlrXmlMarshallingContext {
        private IlrXmlNamespaceManager nsManager;
        private Document document;
        private Map data;
        private Map<String, String> xsdLocationFromNs = new HashMap<String, String>();
        private Set<String> notValidXMLNames = null;

        MarshallingContext(IlrXmlNamespaceManager nsManager, Document document, Map data) {
            this.nsManager = nsManager;
            this.document = document;
            this.data = data;
        }

        @Override
        public Element writeObject(Object object, Element father) throws IlrErrorException {
            return this.writeObject(object, father, null);
        }

        @Override
        public Element writeObject(Object object, Element father, QName elementQName) throws IlrErrorException {
            String singletonId = IlrXmlDefaultConverterManager.this.singletonNames.get(object);
            if (singletonId != null) {
                Element element = this.createElement(null, "singleton");
                element.setAttribute("singleton", singletonId);
                if (father != null) {
                    father.appendChild(element);
                }
                return element;
            }
            IlrXmlConverter converter = IlrXmlDefaultConverterManager.this.getConverter(this, father, object);
            Element elmt = null;
            QName xsiType = null;
            if (converter == null) {
                IlrXmlDefaultConverterManager.this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_003", object.getClass().getName()));
            } else {
                if (converter instanceof IlrExtendedXmlConverter) {
                    elmt = ((IlrExtendedXmlConverter)converter).createElement(this);
                } else {
                    if (elementQName == null) {
                        elementQName = converter.getXmlElement();
                    } else if (!elementQName.equals(converter.getXmlElement())) {
                        xsiType = converter.getXmlType();
                    }
                    if (elementQName == null) {
                        IlrXmlDefaultConverterManager.this.errorManager.add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_004", object.toString(), object.getClass().getName()));
                    } else {
                        QName xsdLocation = converter.getSchemaLocation();
                        if (xsdLocation != null) {
                            this.addSchemaLocation(xsdLocation.getNamespaceURI(), xsdLocation.getLocalPart());
                        }
                        elmt = this.createElement(elementQName.getNamespaceURI(), elementQName.getLocalPart());
                    }
                }
                if (elmt != null) {
                    if (father != null) {
                        father.appendChild(elmt);
                    }
                    this.writeObjectInternal(object, elmt, converter);
                    if (xsiType != null) {
                        this.setXsiTypeAttribute(elmt, xsiType);
                    }
                }
            }
            return elmt;
        }

        protected abstract void writeObjectInternal(Object var1, Element var2, IlrXmlConverter var3) throws IlrErrorException;

        @Override
        public Element createElement(String namespace, String localName) {
            if (namespace == null || namespace.length() == 0) {
                return this.createElement(localName);
            }
            String prefix = this.nsManager.getPrefix(namespace);
            if (prefix == null) {
                prefix = this.nsManager.getNewPrefix(namespace, "ns");
            }
            String qName = prefix == null ? localName : prefix + ":" + localName;
            return this.document.createElementNS(namespace, qName);
        }

        @Override
        public Element createElement(String localName) {
            return this.document.createElement(localName);
        }

        @Override
        public Element createElementAnyway(String localName, String alternateElementName, String attributeName) {
            if (this.notValidXMLNames != null && this.notValidXMLNames.contains(localName)) {
                return this.createAlternateElement(localName, alternateElementName, attributeName);
            }
            try {
                return this.createElement(localName);
            }
            catch (DOMException e) {
                if (e.code == 5) {
                    if (this.notValidXMLNames == null) {
                        this.notValidXMLNames = new HashSet<String>();
                    }
                    this.notValidXMLNames.add(localName);
                    return this.createAlternateElement(localName, alternateElementName, attributeName);
                }
                throw e;
            }
        }

        private Element createAlternateElement(String localName, String alternateElementName, String attributeName) {
            Element element = this.createElement(alternateElementName);
            element.setAttribute(attributeName, localName);
            return element;
        }

        @Override
        public void setAttribute(Element element, String namespace, String localName, String value) {
            String prefix;
            if (namespace == null) {
                element.setAttribute(localName, value);
            }
            if ((prefix = this.nsManager.getPrefix(namespace)) == null) {
                prefix = this.nsManager.getNewPrefix(namespace, "ns");
            }
            String qName = prefix == null ? localName : prefix + ":" + localName;
            element.setAttributeNS(namespace, qName, value);
        }

        @Override
        public Document getDocument() {
            return this.document;
        }

        @Override
        public IlrIssueHandler getErrorManager() {
            return IlrXmlDefaultConverterManager.this.errorManager;
        }

        @Override
        public IlrXmlNamespaceManager getNamespaceManager() {
            return this.nsManager;
        }

        @Override
        public void setXsiTypeAttribute(Element element, QName xmlType) {
            String typePrefix = this.nsManager.getPrefix(xmlType.getNamespaceURI());
            if (typePrefix == null) {
                typePrefix = this.nsManager.getNewPrefix(xmlType.getNamespaceURI(), "ns");
            }
            String value = IlrQNameHelper.toString(null, xmlType.getLocalPart(), typePrefix);
            this.setAttribute(element, "http://www.w3.org/2000/10/XMLSchema-instance", "type", value);
        }

        @Override
        public Object getData(Object key) {
            return this.data.get(key);
        }

        @Override
        public Object putData(Object key, Object value) {
            return this.data.put(key, value);
        }

        @Override
        public Object removeData(Object key) {
            return this.data.remove(key);
        }

        @Override
        public void addSchemaLocation(String namespace, String location) {
            this.xsdLocationFromNs.put(namespace, location);
        }

        @Override
        public void declareSchemaLocationAttribute(Element elem) {
            Iterator<String> nsIte = this.xsdLocationFromNs.keySet().iterator();
            StringBuilder buf = new StringBuilder();
            boolean first = true;
            while (nsIte.hasNext()) {
                String ns = nsIte.next();
                String location = this.xsdLocationFromNs.get(ns);
                if (first) {
                    first = false;
                } else {
                    buf.append(' ');
                }
                buf.append(ns);
                buf.append(' ');
                buf.append(location);
            }
            String value = buf.toString();
            if (value.length() != 0) {
                elem.setAttribute("xsi:schemaLocation", value);
            }
        }
    }
}

