/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml.converter;

import ilog.rules.base.xml.IlrXmlBaseConstants;
import ilog.rules.base.xml.IlrXmlConverter;
import ilog.rules.base.xml.IlrXmlMarshallingContext;
import ilog.rules.base.xml.IlrXmlUnmarshallingContext;
import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class IlrGregorianCalendarConverter
implements IlrXmlConverter,
IlrXmlBaseConstants {
    private static IlrGregorianCalendarConverter INSTANCE = new IlrGregorianCalendarConverter();
    private static final QName XML_ELEMENT = new QName(GregorianCalendar.class.getName());

    public static IlrGregorianCalendarConverter getInstance() {
        return INSTANCE;
    }

    @Override
    public Class[] getSupportedClasses() {
        return new Class[]{GregorianCalendar.class};
    }

    @Override
    public QName getXmlElement() {
        return XML_ELEMENT;
    }

    @Override
    public QName getXmlType() {
        return null;
    }

    @Override
    public QName getSchemaLocation() {
        return null;
    }

    @Override
    public boolean isReferenceWorthy() {
        return false;
    }

    @Override
    public Object readObject(Element element, IlrXmlUnmarshallingContext context) throws IlrErrorException {
        String timeZone;
        NodeList timeList = element.getElementsByTagName("time");
        if (timeList == null || timeList.getLength() == 0) {
            context.getErrorManager().add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_009", "time", element.getTagName()));
            context.getErrorManager().throwException();
        }
        Node timeElement = timeList.item(0);
        Text t = (Text)timeElement.getFirstChild();
        long timeInMillis = Long.valueOf(t.getData());
        NodeList timezoneList = element.getElementsByTagName("timezoneList");
        if (timezoneList == null || timezoneList.getLength() == 0) {
            timeZone = TimeZone.getDefault().getID();
        } else {
            t = (Text)timezoneList.item(0).getFirstChild();
            timeZone = t.getData();
        }
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeZone(TimeZone.getTimeZone(timeZone));
        result.setTimeInMillis(timeInMillis);
        return result;
    }

    @Override
    public void writeObject(Object object, Element element, IlrXmlMarshallingContext context) throws IlrErrorException {
        GregorianCalendar calendar = (GregorianCalendar)object;
        Element time = context.createElement("time");
        element.appendChild(time);
        long timeInMillis = calendar.getTimeInMillis();
        Text t = context.getDocument().createTextNode(String.valueOf(timeInMillis));
        time.appendChild(t);
        Element timezone = context.createElement("timezone");
        element.appendChild(timezone);
        t = context.getDocument().createTextNode(calendar.getTimeZone().getID());
        timezone.appendChild(t);
    }
}

