/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml.converter;

import ilog.rules.base.xml.IlrXmlMarshallingContext;
import ilog.rules.base.xml.IlrXmlUnmarshallingContext;
import ilog.rules.base.xml.converter.IlrMapConverter;
import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IlrTreeMapConverter
extends IlrMapConverter {
    private static final QName XML_ELEMENT = new QName("treeMap");

    @Override
    public Class[] getSupportedClasses() {
        return new Class[]{TreeMap.class};
    }

    @Override
    public QName getXmlElement() {
        return XML_ELEMENT;
    }

    @Override
    public void writeObject(Object object, Element element, IlrXmlMarshallingContext context) throws IlrErrorException {
        TreeMap treeMap = (TreeMap)object;
        if (treeMap.comparator() != null) {
            Element comparatorElement = context.createElement("comparator");
            element.appendChild(comparatorElement);
            context.writeObject(treeMap.comparator(), comparatorElement);
        }
        super.writeObject(object, element, context);
    }

    @Override
    public Object readObject(Element element, IlrXmlUnmarshallingContext context) throws IlrErrorException {
        NodeList list = element.getChildNodes();
        TreeMap c = null;
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element) || !"comparator".equals(node.getLocalName())) continue;
            NodeList subList = node.getChildNodes();
            for (int j = 0; j < subList.getLength(); ++j) {
                Node subNode = subList.item(j);
                if (!(subNode instanceof Element)) continue;
                Object comparator = context.readObject(c, (Element)subNode);
                if (comparator instanceof Comparator) {
                    c = new TreeMap((Comparator)comparator);
                    continue;
                }
                context.getErrorManager().add(new IlrError("ilog.rules.xml.data.messages", "ERROR_XML_002", comparator.toString(), comparator.getClass().getName(), Comparator.class.getName()));
            }
        }
        if (c == null) {
            c = new TreeMap();
        }
        this.fillMap(context, list, c);
        return c;
    }

    @Override
    protected Map createInstance(int initialCapacity) {
        return null;
    }
}

