/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.base.xml.converter;

import ilog.rules.base.xml.converter.IlrPrimitiveConverter;
import ilog.rules.util.issue.IlrError;
import ilog.rules.util.issue.IlrErrorException;
import ilog.rules.util.issue.IlrIssueHandler;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class XMLGregorianCalendarConverter
extends IlrPrimitiveConverter {
    private final DatatypeFactory datatypeFactory;

    public XMLGregorianCalendarConverter() throws DatatypeConfigurationException {
        this(DatatypeFactory.newInstance());
    }

    public XMLGregorianCalendarConverter(DatatypeFactory datatypeFactory) {
        super(XMLGregorianCalendar.class);
        this.datatypeFactory = datatypeFactory;
    }

    protected String toString(XMLGregorianCalendar object) throws IlrErrorException {
        return object.toXMLFormat();
    }

    @Override
    protected Object convert(String text, IlrIssueHandler issueHandler) throws IlrErrorException {
        try {
            return this.datatypeFactory.newXMLGregorianCalendar(text);
        }
        catch (IllegalArgumentException e) {
            issueHandler.add(new IlrError("ilog.rules.xml.data.messages", "ParseException", e.getMessage(), text));
            return WRONG_VALUE;
        }
    }
}

