/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.data;

import ilog.rules.data.IlrActionKey;
import ilog.rules.data.IlrBlockSourceSupport;
import ilog.rules.data.IlrFunctionSourceSupport;
import ilog.rules.data.IlrPackageSourceSupport;
import ilog.rules.data.IlrRuleSourceSupport;
import ilog.rules.data.IlrSourceZone;
import ilog.rules.data.IlrTaskSourceSupport;
import ilog.rules.data.IlrTasksetSourceSupport;
import java.util.List;
import java.util.Vector;

public final class IlrRulesetSourceSupport {
    Vector functions = new Vector();
    Vector rules = new Vector();
    Vector tasks = new Vector();

    public void addFunctionSupport(IlrFunctionSourceSupport support) {
        this.functions.addElement(support);
    }

    public void addRuleSupport(IlrRuleSourceSupport support) {
        this.rules.addElement(support);
    }

    public void addTaskSupport(IlrTaskSourceSupport support) {
        this.tasks.addElement(support);
    }

    public void addSupport(IlrBlockSourceSupport support) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (!(support instanceof IlrPackageSourceSupport)) break block2;
                        IlrPackageSourceSupport pkgSupport = (IlrPackageSourceSupport)support;
                        List pkgSupports = pkgSupport.getSupports();
                        int len = pkgSupports.size();
                        for (int j = 0; j < len; ++j) {
                            IlrBlockSourceSupport defsupport = (IlrBlockSourceSupport)pkgSupports.get(j);
                            this.addSupport(defsupport);
                        }
                        break block3;
                    }
                    if (!(support instanceof IlrRuleSourceSupport)) break block4;
                    this.rules.addElement(support);
                    break block3;
                }
                if (!(support instanceof IlrFunctionSourceSupport)) break block5;
                this.functions.addElement(support);
                break block3;
            }
            if (!(support instanceof IlrTasksetSourceSupport)) break block3;
            IlrTasksetSourceSupport taskset = (IlrTasksetSourceSupport)support;
            Vector taskSupports = taskset.getTaskSupports();
            int len = taskSupports.size();
            for (int i = 0; i < len; ++i) {
                this.tasks.addElement((IlrTaskSourceSupport)taskSupports.elementAt(i));
            }
        }
    }

    public IlrRuleSourceSupport[] getRules() {
        Object[] arr = new IlrRuleSourceSupport[this.rules.size()];
        this.rules.copyInto(arr);
        return arr;
    }

    public IlrBlockSourceSupport getRule(IlrActionKey key) {
        int size = this.rules.size();
        for (int i = 0; i < size; ++i) {
            IlrBlockSourceSupport support = (IlrBlockSourceSupport)this.rules.elementAt(i);
            if (!support.isSameSourceIdentifier(key.sourceIdentifier)) continue;
            return support;
        }
        return null;
    }

    public IlrFunctionSourceSupport[] getFunctions() {
        Object[] arr = new IlrFunctionSourceSupport[this.functions.size()];
        this.functions.copyInto(arr);
        return arr;
    }

    public IlrFunctionSourceSupport getFunction(IlrActionKey key) {
        int size = this.functions.size();
        for (int i = 0; i < size; ++i) {
            IlrFunctionSourceSupport support = (IlrFunctionSourceSupport)this.functions.elementAt(i);
            if (!support.isSameSourceIdentifier(key.sourceIdentifier)) continue;
            return support;
        }
        return null;
    }

    public IlrTaskSourceSupport[] getTasks() {
        Object[] arr = new IlrTaskSourceSupport[this.tasks.size()];
        this.tasks.copyInto(arr);
        return arr;
    }

    public IlrTaskSourceSupport getTask(IlrActionKey key) {
        if (key.type == IlrActionKey.Task) {
            int size = this.tasks.size();
            for (int i = 0; i < size; ++i) {
                IlrTaskSourceSupport support = (IlrTaskSourceSupport)this.tasks.elementAt(i);
                if (!support.isSameSourceIdentifier(key.sourceIdentifier)) continue;
                return support;
            }
        }
        return null;
    }

    public IlrSourceZone getActionZone(IlrActionKey key) {
        int size = 0;
        if (key.type == IlrActionKey.Task) {
            size = this.tasks.size();
            for (int i = 0; i < size; ++i) {
                IlrTaskSourceSupport support = (IlrTaskSourceSupport)this.tasks.elementAt(i);
                if (!support.isSameSourceIdentifier(key.sourceIdentifier)) continue;
                return support.getActionZone(key);
            }
            return null;
        }
        if (key.type == IlrActionKey.Rule) {
            size = this.rules.size();
            for (int i = 0; i < size; ++i) {
                IlrBlockSourceSupport support = (IlrBlockSourceSupport)this.rules.elementAt(i);
                if (!support.isSameSourceIdentifier(key.sourceIdentifier)) continue;
                return support.getActionZone(key);
            }
            return null;
        }
        if (key.type == IlrActionKey.Function) {
            size = this.functions.size();
            for (int i = 0; i < size; ++i) {
                IlrBlockSourceSupport support = (IlrBlockSourceSupport)this.functions.elementAt(i);
                if (!support.isSameSourceIdentifier(key.sourceIdentifier)) continue;
                return support.getActionZone(key);
            }
            return null;
        }
        return null;
    }

    public IlrActionKey getActionKey(int offset) {
        IlrActionKey key;
        IlrBlockSourceSupport support;
        int i;
        int size = 0;
        size = this.tasks.size();
        for (i = 0; i < size; ++i) {
            support = (IlrTaskSourceSupport)this.tasks.elementAt(i);
            key = support.getActionKey(offset);
            if (key == null) continue;
            return key;
        }
        size = this.rules.size();
        for (i = 0; i < size; ++i) {
            support = (IlrBlockSourceSupport)this.rules.elementAt(i);
            key = support.getActionKey(offset);
            if (key == null) continue;
            return key;
        }
        size = this.functions.size();
        for (i = 0; i < size; ++i) {
            support = (IlrBlockSourceSupport)this.functions.elementAt(i);
            key = support.getActionKey(offset);
            if (key == null) continue;
            return key;
        }
        return null;
    }

    public String toString() {
        IlrBlockSourceSupport support;
        int i;
        String msg = "";
        int size = this.rules.size();
        for (i = 0; i < size; ++i) {
            support = (IlrBlockSourceSupport)this.rules.elementAt(i);
            msg = msg + support.toString();
            if (i <= 0) continue;
            msg = msg + "\n";
        }
        size = this.functions.size();
        for (i = 0; i < size; ++i) {
            support = (IlrBlockSourceSupport)this.functions.elementAt(i);
            msg = msg + support.toString();
            if (i <= 0) continue;
            msg = msg + "\n";
        }
        size = this.tasks.size();
        for (i = 0; i < size; ++i) {
            support = (IlrBlockSourceSupport)this.tasks.elementAt(i);
            msg = msg + support.toString();
            if (i <= 0) continue;
            msg = msg + "\n";
        }
        return msg;
    }
}

