/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.datasource;

import ilog.rules.datasource.IlrDataSource;
import ilog.rules.datasource.IlrDataSourcePool;
import ilog.rules.datasource.IlrInvalidDataSourceException;
import ilog.rules.datasource.IlrMutableDataSourcePool;
import ilog.rules.datasource.IlrTableDataSource;
import java.util.HashMap;

public class IlrDefaultDataSourcePool
implements IlrMutableDataSourcePool {
    HashMap datasourceFromKey = new HashMap();
    HashMap keyFromDatasource = new HashMap();
    int keyCounter = 0;

    @Override
    public IlrDataSource createDataSourceProxy(IlrDataSourcePool.Key key) throws IlrInvalidDataSourceException {
        IlrDataSource ds = this.getDataSource(key);
        if (ds == null) {
            throw new IlrInvalidDataSourceException("No such datasource linked to key " + key);
        }
        if (ds instanceof IlrTableDataSource) {
            return ds;
        }
        throw new IlrInvalidDataSourceException("Can't create a proxy on a data source of type " + ds.getClass().getName());
    }

    @Override
    public IlrDataSource[] getDataSources() {
        IlrDataSource[] dss = new IlrDataSource[this.datasourceFromKey.size()];
        this.datasourceFromKey.values().toArray(dss);
        return dss;
    }

    @Override
    public IlrDataSource getDataSource(IlrDataSourcePool.Key key) {
        return (IlrDataSource)this.datasourceFromKey.get(key);
    }

    @Override
    public IlrDataSource getDataSource(String dsName) {
        for (IlrDataSource ds : this.datasourceFromKey.values()) {
            if (!dsName.equals(ds.getName())) continue;
            return ds;
        }
        return null;
    }

    @Override
    public IlrDataSourcePool.Key getDataSourceKey(IlrDataSource dataSource) {
        return (IlrDataSourcePool.Key)this.keyFromDatasource.get(dataSource);
    }

    void addDataSource(IlrDataSourcePool.Key key, IlrDataSource ds) {
        this.keyFromDatasource.put(ds, key);
        this.datasourceFromKey.put(key, ds);
    }

    @Override
    public IlrDataSourcePool.Key declareDataSource(IlrDataSource dataSource) {
        DefaultKey key = (DefaultKey)this.getDataSourceKey(dataSource);
        if (key == null) {
            key = new DefaultKey(this.keyCounter++);
            while (this.getDataSource(key) != null) {
                key.setValue(this.keyCounter++);
            }
            this.addDataSource(key, dataSource);
        }
        return key;
    }

    @Override
    public void removeDataSource(IlrDataSource dataSource) {
        IlrDataSourcePool.Key key = (IlrDataSourcePool.Key)this.keyFromDatasource.get(dataSource);
        this.keyFromDatasource.remove(dataSource);
        this.datasourceFromKey.remove(key);
    }

    @Override
    public void reset() {
        this.keyFromDatasource.clear();
        this.datasourceFromKey.clear();
        this.keyCounter = 0;
    }

    static class DefaultKey
    implements IlrDataSourcePool.Key {
        int value = 0;

        DefaultKey(int value) {
            this.value = value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        @Override
        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof DefaultKey) {
                return this.value == ((DefaultKey)o).value;
            }
            return false;
        }
    }
}

