/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.datasource;

import ilog.rules.datasource.IlrDataSource;
import ilog.rules.datasource.IlrDataSourcePool;
import ilog.rules.datasource.IlrInvalidDataSourceException;
import ilog.rules.datasource.IlrTableDataSource;
import ilog.rules.datasource.IlrTableDataSourceModel;
import ilog.rules.util.issue.IlrErrorException;
import ilog.rules.util.issue.IlrWarning;
import java.util.Collection;

public class IlrPoolTableDataSourceProxy
implements IlrTableDataSource {
    private IlrDataSourcePool.Key key;
    private IlrDataSourcePool dataSourcePool;

    public IlrPoolTableDataSourceProxy(IlrDataSourcePool.Key key, IlrDataSourcePool dataSourcePool) {
        this.key = key;
        this.dataSourcePool = dataSourcePool;
    }

    private IlrTableDataSource getDataSource() throws IlrInvalidDataSourceException {
        IlrDataSource ds = this.dataSourcePool.getDataSource(this.key);
        if (ds == null) {
            throw new IlrInvalidDataSourceException("No such datasource with key " + this.key);
        }
        if (ds instanceof IlrTableDataSource) {
            return (IlrTableDataSource)ds;
        }
        throw new IlrInvalidDataSourceException("Bad data source type " + this.key);
    }

    public IlrDataSourcePool.Key getKey() {
        return this.key;
    }

    @Override
    public Collection<IlrWarning> check() throws IlrErrorException {
        return this.getDataSource().check();
    }

    @Override
    public void connectDevice() throws Exception {
        this.getDataSource().connectDevice();
    }

    @Override
    public void connectDevice(String password) throws Exception {
        this.getDataSource().connectDevice(password);
    }

    @Override
    public void disconnectDevice() throws Exception {
        this.getDataSource().disconnectDevice();
    }

    @Override
    public String getName() {
        return this.getDataSource().getName();
    }

    @Override
    public Object getNullValue() {
        return this.getDataSource().getNullValue();
    }

    @Override
    public boolean isConnected() {
        return this.getDataSource().isConnected();
    }

    @Override
    public boolean isNullValue(Object object) {
        return this.getDataSource().isNullValue(object);
    }

    @Override
    public boolean isQuerySupported() {
        return this.getDataSource().isQuerySupported();
    }

    @Override
    public IlrTableDataSourceModel getModel() {
        return this.getDataSource().getModel();
    }

    @Override
    public IlrTableDataSource.RowIterator iterateRows(String tableName, String query) throws Exception {
        return this.getDataSource().iterateRows(tableName, query);
    }

    @Override
    public IlrTableDataSource.RowIterator iterateRows(String tableName) throws Exception {
        return this.getDataSource().iterateRows(tableName);
    }
}

