/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.dvs.rsi.internal;

import com.ibm.rules.res.message.internal.LocalizedMessageHelper;
import ilog.rules.bom.IlrAttribute;
import ilog.rules.bom.IlrCollectionDomain;
import ilog.rules.bom.IlrConstructor;
import ilog.rules.bom.IlrDomain;
import ilog.rules.bom.IlrParameter;
import ilog.rules.bom.IlrType;
import ilog.rules.bom.util.IlrClassUtilities;
import ilog.rules.dvs.rsi.IlrBOMTypeDescriptor;
import ilog.rules.dvs.rsi.IlrBusinessObjectModelServices;
import ilog.rules.dvs.rsi.IlrObjectModelHelper;
import ilog.rules.dvs.rsi.exception.IlrBOMTypeNotFoundException;
import ilog.rules.dvs.rsi.exception.IlrMissingDefaultConstructorException;
import ilog.rules.dvs.rsi.exception.IlrUnsupportedBOMTypeException;
import ilog.rules.dvs.rsi.internal.IlrCommonMessageHelper;
import ilog.rules.dvs.rsi.internal.IlrDefaultBOMTypeDescriptor;
import ilog.rules.dvs.rsi.ofactory.IlrObjectFactoryParameter;
import ilog.rules.dvs.rsi.ofactory.internal.IlrObjectFactoryParameterImpl;
import ilog.rules.dvs.rsi.utils.IlrHRSerializationUtils;
import ilog.rules.dvs.rsi.utils.IlrSerializationException;
import ilog.rules.factory.IlrReflect;
import ilog.rules.factory.IlrReflectClass;
import ilog.rules.factory.IlrReflectField;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IlrCommonBusinessObjectModelServices
implements IlrBusinessObjectModelServices {
    public static final String OLD_DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY = "ilog.rules.engine.dataio.forConversion";
    public static final String DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY = "dataio.default";
    public static final String DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY_IN_BOOT_BOM = "factory.default";
    public static final String IGNORE_ATTRIBUTE_FOR_FACTORY_PROPERTY = "factory.ignore";
    public static final String FACTORY_PARAMETER_NAME_FOR_STRING_VALUES = "value";
    private static final Logger LOGGER = Logger.getLogger(IlrCommonBusinessObjectModelServices.class.getName());
    protected IlrReflect bom = null;

    public IlrCommonBusinessObjectModelServices(IlrReflect theBOM) {
        this.bom = theBOM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, IlrObjectFactoryParameter> getObjectFactorySignature(IlrBOMTypeDescriptor theBOMType) throws IlrUnsupportedBOMTypeException {
        IlrReflect ilrReflect = this.bom;
        synchronized (ilrReflect) {
            FactorySignature signature = this.internalGetObjectFactorySignature(theBOMType);
            Map<String, IlrObjectFactoryParameter> returnedValue = null;
            if (signature != null) {
                returnedValue = signature.getParameters();
            }
            return returnedValue;
        }
    }

    @Override
    public boolean isArrayType(String theBOMTypeFullyQualifiedName) throws IlrUnsupportedBOMTypeException {
        return this.getTypeOfArrayElements(theBOMTypeFullyQualifiedName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IlrBOMTypeDescriptor getFieldDeclaringClass(String theBOMTypeFullyQualifiedName, String theFieldName) throws IlrUnsupportedBOMTypeException {
        if (theBOMTypeFullyQualifiedName == null || theFieldName == null) {
            throw new IllegalArgumentException();
        }
        IlrDefaultBOMTypeDescriptor returnedValue = null;
        IlrReflect ilrReflect = this.bom;
        synchronized (ilrReflect) {
            IlrReflectClass bomClass = this.bom.getClassByName(theBOMTypeFullyQualifiedName);
            if (bomClass == null) {
                throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor(theBOMTypeFullyQualifiedName, null));
            }
            IlrReflectField field = bomClass.getField(theFieldName);
            if (field != null) {
                returnedValue = new IlrDefaultBOMTypeDescriptor((IlrType)field.getDeclaringClass());
            }
        }
        return returnedValue;
    }

    @Override
    public IlrBOMTypeDescriptor getTypeOfArrayElements(String theBOMTypeFullyQualifiedName) throws IlrUnsupportedBOMTypeException {
        if (theBOMTypeFullyQualifiedName == null) {
            throw new IllegalArgumentException();
        }
        IlrDefaultBOMTypeDescriptor returnedValue = null;
        IlrType bomType = this.bom.getType(theBOMTypeFullyQualifiedName);
        if (bomType == null) {
            throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor(theBOMTypeFullyQualifiedName, null));
        }
        if (bomType.isArray()) {
            IlrType elementsType = bomType.getComponentType();
            returnedValue = new IlrDefaultBOMTypeDescriptor(elementsType);
            returnedValue.setDomainValues(IlrDefaultBOMTypeDescriptor.getDomainValues(elementsType.getDomain(), elementsType.getFullyQualifiedName()));
        }
        return returnedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCollection(String theBOMTypeFullyQualifiedName) throws IlrUnsupportedBOMTypeException {
        String collectionTypeFullyQualifiedName = "java.util.Collection";
        IlrReflect ilrReflect = this.bom;
        synchronized (ilrReflect) {
            IlrType bomType = this.bom.getType(theBOMTypeFullyQualifiedName);
            if (bomType == null) {
                throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor(theBOMTypeFullyQualifiedName, null));
            }
            IlrType collectionType = this.bom.getType("java.util.Collection");
            if (collectionType == null) {
                throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor("java.util.Collection", null));
            }
            return collectionType.isAssignableFrom(bomType);
        }
    }

    @Override
    public boolean isCollectionWithSingleFactoryParameterForContent(IlrBOMTypeDescriptor theBOMDescriptor) throws IlrUnsupportedBOMTypeException {
        boolean returnedValue = false;
        if (this.isCollection(theBOMDescriptor.getFullyQualifiedName())) {
            Map<String, IlrObjectFactoryParameter> objectFactorySignature = null;
            objectFactorySignature = this.getObjectFactorySignature(theBOMDescriptor);
            if (objectFactorySignature != null && objectFactorySignature.size() == 1 && objectFactorySignature.containsKey("_content")) {
                returnedValue = true;
            }
        }
        return returnedValue;
    }

    protected FactorySignature internalGetObjectFactorySignature(IlrBOMTypeDescriptor theBOMType) throws IlrUnsupportedBOMTypeException {
        Map<String, IlrObjectFactoryParameter> formatterSignature;
        Map<String, IlrObjectFactoryParameter> signatureParameters = null;
        FactorySignature.SignatureType signatureType = FactorySignature.SignatureType.BEAN;
        try {
            signatureParameters = this.getBeanFactorySignature(theBOMType);
        }
        catch (IlrUnsupportedBOMTypeException e) {
            signatureParameters = this.getFormatterFactorySignature(theBOMType);
            if (signatureParameters == null) {
                throw e;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Exception was thrown retrieving the bean signature: using formatter signature for " + IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMType));
            }
            signatureType = FactorySignature.SignatureType.FORMATTER;
        }
        if (this.isCollection(theBOMType.getFullyQualifiedName())) {
            IlrType containedElements;
            String collectionContentParameterName = "_content";
            if (signatureParameters.get(collectionContentParameterName) != null) {
                throw new RuntimeException(LocalizedMessageHelper.getLocalizedMessage(IlrSerializationException.RESOURCE_BUNDLE_NAME, IlrCommonMessageHelper.ERROR_FACTORY_SIGNATURE_ALREADY_CONTAINS_A_PARAMETER, new Object[]{theBOMType.getFullyQualifiedName(), "_content"}, null, null));
            }
            IlrBOMTypeDescriptor typeOfContainedElements = theBOMType.getElementsType();
            if (typeOfContainedElements == null) {
                typeOfContainedElements = new IlrDefaultBOMTypeDescriptor((IlrType)this.bom.objectClass());
            }
            if ((containedElements = this.bom.getType(typeOfContainedElements.getFullyQualifiedName())) == null) {
                throw new IlrBOMTypeNotFoundException(new IlrDefaultBOMTypeDescriptor(typeOfContainedElements.getFullyQualifiedName(), null));
            }
            signatureParameters.put(collectionContentParameterName, new IlrObjectFactoryParameterImpl(collectionContentParameterName, new IlrDefaultBOMTypeDescriptor(containedElements.getArrayType().getFullyQualifiedName(), typeOfContainedElements.getElementsType()), true));
        }
        if (signatureParameters.isEmpty() && (formatterSignature = this.getFormatterFactorySignature(theBOMType)) != null) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Using formatter signature for " + IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMType) + " as the bean signature is empty");
            }
            signatureParameters = formatterSignature;
            signatureType = FactorySignature.SignatureType.FORMATTER;
        }
        return new FactorySignature(signatureParameters, signatureType);
    }

    protected Map<String, IlrObjectFactoryParameter> getBeanFactorySignature(IlrBOMTypeDescriptor theBOMType) throws IlrUnsupportedBOMTypeException {
        if (theBOMType == null) {
            throw new IllegalArgumentException();
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Retrieving object factory signature for BOM type " + IlrHRSerializationUtils.serializeBOMTypeDescriptor(theBOMType));
        }
        LinkedHashMap<String, IlrObjectFactoryParameter> returnedValue = new LinkedHashMap<String, IlrObjectFactoryParameter>();
        IlrReflectClass clazz = this.bom.findClassByName(theBOMType.getFullyQualifiedName());
        if (clazz == null) {
            throw new IlrBOMTypeNotFoundException(theBOMType);
        }
        if (IlrClassUtilities.isEnumClass((IlrType)clazz)) {
            IlrDefaultBOMTypeDescriptor parameterBOMType = new IlrDefaultBOMTypeDescriptor("string", null);
            parameterBOMType.setDomainValues(IlrDefaultBOMTypeDescriptor.getDomainValues(clazz.getDomain(), clazz.getFullyQualifiedName()));
            returnedValue.put(FACTORY_PARAMETER_NAME_FOR_STRING_VALUES, new IlrObjectFactoryParameterImpl(FACTORY_PARAMETER_NAME_FOR_STRING_VALUES, parameterBOMType, false));
        } else {
            IlrReflectField[] allClazzFields;
            IlrConstructor constructorToUse = this.getDefaultConstructor(clazz);
            List mandatoryParameters = constructorToUse.getParameters();
            if (mandatoryParameters != null) {
                for (IlrParameter mandatoryParameter : mandatoryParameters) {
                    IlrType elementsType;
                    IlrDefaultBOMTypeDescriptor parameterTypeDescriptor = new IlrDefaultBOMTypeDescriptor(mandatoryParameter.getParameterType());
                    IlrDomain parameterDomain = mandatoryParameter.getParameterDomain();
                    String[] domainValues = IlrDefaultBOMTypeDescriptor.getDomainValues(parameterDomain, mandatoryParameter.getFullyQualifiedName());
                    if (domainValues == null) {
                        domainValues = IlrDefaultBOMTypeDescriptor.getDomainValues(mandatoryParameter.getParameterType().getDomain(), mandatoryParameter.getParameterType().getFullyQualifiedName());
                    }
                    parameterTypeDescriptor.setDomainValues(domainValues);
                    if (parameterDomain != null && parameterDomain instanceof IlrCollectionDomain && (elementsType = ((IlrCollectionDomain)parameterDomain).getElementType()) != null) {
                        parameterTypeDescriptor.setElementsType(new IlrDefaultBOMTypeDescriptor(elementsType));
                    }
                    IlrObjectFactoryParameterImpl param = new IlrObjectFactoryParameterImpl(mandatoryParameter.getName(), parameterTypeDescriptor, false);
                    param.setIsConstructorParameter(true);
                    returnedValue.put(mandatoryParameter.getName(), param);
                }
            }
            if ((allClazzFields = clazz.getAllFields()) != null) {
                this.sortFieldsByAlphabeticalOrder(allClazzFields);
                for (IlrReflectField field : allClazzFields) {
                    if (field.isStatic() || field.isReadonly()) continue;
                    Object ignoreAttributePropertyValue = field.getPropertyValue(IGNORE_ATTRIBUTE_FOR_FACTORY_PROPERTY, (Object)"false");
                    boolean isOptional = IlrObjectModelHelper.isOptional((IlrAttribute)field);
                    if (ignoreAttributePropertyValue == null || !Boolean.valueOf(ignoreAttributePropertyValue.toString()).booleanValue() || !isOptional) {
                        IlrType elementsType;
                        if (Boolean.valueOf(ignoreAttributePropertyValue.toString()).booleanValue() && !isOptional && LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("Attribute " + field.getName() + " marked with property " + IGNORE_ATTRIBUTE_FOR_FACTORY_PROPERTY + " is not ignored because it is not optional");
                        }
                        if (returnedValue.containsKey(field.getName())) continue;
                        IlrDefaultBOMTypeDescriptor attributeTypeDescriptor = new IlrDefaultBOMTypeDescriptor(field.getAttributeType());
                        IlrDomain attributeDomain = field.getDomain();
                        String[] domainValues = IlrDefaultBOMTypeDescriptor.getDomainValues(attributeDomain, field.getAttributeType().getFullyQualifiedName());
                        if (domainValues == null) {
                            domainValues = IlrDefaultBOMTypeDescriptor.getDomainValues(field.getAttributeType().getDomain(), field.getAttributeType().getFullyQualifiedName());
                        }
                        attributeTypeDescriptor.setDomainValues(domainValues);
                        if (attributeDomain != null && attributeDomain instanceof IlrCollectionDomain && (elementsType = ((IlrCollectionDomain)attributeDomain).getElementType()) != null) {
                            attributeTypeDescriptor.setElementsType(new IlrDefaultBOMTypeDescriptor(elementsType));
                        }
                        IlrObjectFactoryParameterImpl param = new IlrObjectFactoryParameterImpl(field.getName(), attributeTypeDescriptor, isOptional);
                        param.setIsConstructorParameter(false);
                        returnedValue.put(field.getName(), param);
                        continue;
                    }
                    if (!LOGGER.isLoggable(Level.FINER)) continue;
                    LOGGER.finer("Ignoring attribute " + field.getName() + " marked with property " + IGNORE_ATTRIBUTE_FOR_FACTORY_PROPERTY);
                }
            }
        }
        return returnedValue;
    }

    protected Map<String, IlrObjectFactoryParameter> getFormatterFactorySignature(IlrBOMTypeDescriptor theBOMType) throws IlrUnsupportedBOMTypeException {
        LinkedHashMap<String, IlrObjectFactoryParameterImpl> returnedValue = null;
        IlrReflectClass clazz = this.bom.findClassByName(theBOMType.getFullyQualifiedName());
        if (clazz == null) {
            throw new IlrBOMTypeNotFoundException(theBOMType);
        }
        if (this.bom.getFormat().isSupported((IlrType)clazz)) {
            returnedValue = new LinkedHashMap<String, IlrObjectFactoryParameterImpl>();
            IlrDefaultBOMTypeDescriptor bomType = new IlrDefaultBOMTypeDescriptor("string", null);
            bomType.setDomainValues(IlrDefaultBOMTypeDescriptor.getDomainValues(clazz.getDomain(), clazz.getFullyQualifiedName()));
            returnedValue.put(FACTORY_PARAMETER_NAME_FOR_STRING_VALUES, new IlrObjectFactoryParameterImpl(FACTORY_PARAMETER_NAME_FOR_STRING_VALUES, bomType, false));
        }
        return returnedValue;
    }

    protected IlrConstructor getDefaultConstructor(IlrReflectClass theBOMClass) throws IlrUnsupportedBOMTypeException {
        IlrConstructor returnedValue = null;
        List ctors = theBOMClass.getConstructors();
        if (ctors == null || ctors.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("No constructor defined for BOM type " + theBOMClass.getFullyQualifiedName());
            }
        } else if (ctors.size() == 1) {
            returnedValue = (IlrConstructor)ctors.get(0);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Using the single constructor defined for BOM type " + theBOMClass.getFullyQualifiedName());
            }
        } else {
            for (IlrConstructor constructor : ctors) {
                Object defaultConstructorPropertyValue = constructor.getPropertyValue(DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY_IN_BOOT_BOM, (Object)"false");
                if (defaultConstructorPropertyValue != null && Boolean.valueOf(defaultConstructorPropertyValue.toString()).booleanValue()) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Using default constructor defined for BOM type " + theBOMClass.getFullyQualifiedName() + " by property " + DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY_IN_BOOT_BOM);
                    }
                    returnedValue = constructor;
                    break;
                }
                defaultConstructorPropertyValue = constructor.getPropertyValue(OLD_DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY, (Object)"false");
                if (defaultConstructorPropertyValue != null && Boolean.valueOf(defaultConstructorPropertyValue.toString()).booleanValue()) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Using default constructor defined for BOM type " + theBOMClass.getFullyQualifiedName() + " by property " + OLD_DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY);
                    }
                    returnedValue = constructor;
                    break;
                }
                defaultConstructorPropertyValue = constructor.getPropertyValue(DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY, (Object)"false");
                if (defaultConstructorPropertyValue != null && Boolean.valueOf(defaultConstructorPropertyValue.toString()).booleanValue()) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.finer("Using default constructor defined for BOM type " + theBOMClass.getFullyQualifiedName() + " by property " + DEFAULT_FACTORY_CONSTRUCTOR_PROPERTY);
                    }
                    returnedValue = constructor;
                    break;
                }
                List constructorParameters = constructor.getParameters();
                if (constructorParameters != null && !constructorParameters.isEmpty()) continue;
                returnedValue = constructor;
            }
        }
        if (returnedValue == null) {
            throw new IlrMissingDefaultConstructorException(new IlrDefaultBOMTypeDescriptor((IlrType)theBOMClass));
        }
        return returnedValue;
    }

    protected void sortFieldsByAlphabeticalOrder(IlrReflectField[] theFieldsToSort) {
        if (theFieldsToSort != null && theFieldsToSort.length != 0) {
            Arrays.sort(theFieldsToSort, new Comparator<IlrReflectField>(){

                @Override
                public int compare(IlrReflectField o1, IlrReflectField o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
    }

    protected static class FactorySignature {
        private Map<String, IlrObjectFactoryParameter> parameters = null;
        private SignatureType type = null;

        public FactorySignature(Map<String, IlrObjectFactoryParameter> parameters, SignatureType type) {
            this.parameters = parameters;
            this.type = type;
        }

        public Map<String, IlrObjectFactoryParameter> getParameters() {
            return this.parameters;
        }

        public SignatureType getType() {
            return this.type;
        }

        public static enum SignatureType {
            BEAN,
            FORMATTER;

        }
    }
}

