/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.dvs.rsi.utils;

import ilog.rules.dvs.rsi.IlrBOMTypeDescriptor;
import ilog.rules.dvs.rsi.IlrNamedBOMParameter;
import ilog.rules.dvs.rsi.exception.IlrObjectFactoryParametersException;
import ilog.rules.dvs.rsi.ofactory.IlrObjectFactoryParameter;
import ilog.rules.dvs.rsi.ofactory.IlrObjectFactoryParameterValue;
import ilog.rules.dvs.rsi.ofactory.internal.IlrMetaObject;
import ilog.rules.dvs.rsi.ofactory.internal.IlrNamedBOMParameterImpl;
import ilog.rules.dvs.rsi.ofactory.internal.IlrObjectFactoryParameterImpl;
import ilog.rules.dvs.rsi.ofactory.internal.IlrObjectFactoryParameterValueImpl;
import ilog.rules.dvs.rsi.signature.IlrRulesetParameter;
import ilog.rules.dvs.rsi.utils.IlrSerializationException;
import ilog.rules.dvs.rsi.utils.IlrXUStringCodec;
import java.util.HashMap;
import java.util.Map;

public class IlrXUSerializationUtils {
    private static final String NAMED_PARAMETER_BOM_TYPE = "bomType";
    private static final String NAMED_PARAMETER_NAME = "name";
    private static final String OBJECT_FACTORY_PARAMETER_OPTIONAL = "optional";
    private static final String OBJECT_FACTORY_PARAMETER_VALUE = "value";

    private IlrXUSerializationUtils() {
    }

    public static String serializeObjectFactoryParameter(IlrObjectFactoryParameter theObjectFactoryParameter) {
        IlrXUStringCodec<IlrObjectFactoryParameter> codec = new IlrXUStringCodec<IlrObjectFactoryParameter>();
        return codec.encode(theObjectFactoryParameter);
    }

    public static IlrObjectFactoryParameter deserializeObjectFactoryParameter(String theSerializedObjectFactoryParameter) throws IlrSerializationException {
        IlrXUStringCodec codec = new IlrXUStringCodec();
        return (IlrObjectFactoryParameter)codec.decode(theSerializedObjectFactoryParameter);
    }

    public static String serializeRulesetParameter(IlrRulesetParameter theRulesetParameter) {
        IlrXUStringCodec<IlrRulesetParameter> codec = new IlrXUStringCodec<IlrRulesetParameter>();
        return codec.encode(theRulesetParameter);
    }

    public static IlrRulesetParameter deserializeRulesetParameter(String theSerializedRulesetParameter) throws IlrSerializationException {
        IlrXUStringCodec codec = new IlrXUStringCodec();
        return (IlrRulesetParameter)codec.decode(theSerializedRulesetParameter);
    }

    public static String serializeBOMTypeDescriptor(IlrBOMTypeDescriptor theBOMTypeDescriptor) {
        IlrXUStringCodec<IlrBOMTypeDescriptor> codec = new IlrXUStringCodec<IlrBOMTypeDescriptor>();
        return codec.encode(theBOMTypeDescriptor);
    }

    public static IlrBOMTypeDescriptor deserializeBOMTypeDescriptor(String theSerializedBOMTypeDescriptor) throws IlrSerializationException {
        if (theSerializedBOMTypeDescriptor == null) {
            return null;
        }
        IlrXUStringCodec codec = new IlrXUStringCodec();
        return (IlrBOMTypeDescriptor)codec.decode(theSerializedBOMTypeDescriptor);
    }

    public static Map<String, Map<String, String>> serializeNamedParameters(Map<String, IlrNamedBOMParameter> theNamedParameters) {
        HashMap<String, Map<String, String>> returnedValue = new HashMap<String, Map<String, String>>();
        if (theNamedParameters == null) {
            returnedValue = null;
        } else {
            for (String key : theNamedParameters.keySet()) {
                IlrNamedBOMParameter parameterToSerialize = theNamedParameters.get(key);
                HashMap<String, String> serializedParameter = new HashMap<String, String>();
                if (parameterToSerialize == null) {
                    serializedParameter = null;
                } else {
                    if (parameterToSerialize.getName() != null) {
                        serializedParameter.put(NAMED_PARAMETER_NAME, parameterToSerialize.getName());
                    }
                    if (parameterToSerialize.getBOMType() != null) {
                        serializedParameter.put(NAMED_PARAMETER_BOM_TYPE, IlrXUSerializationUtils.serializeBOMTypeDescriptor(parameterToSerialize.getBOMType()));
                    }
                }
                returnedValue.put(key, serializedParameter);
            }
        }
        return returnedValue;
    }

    public static Map<String, IlrNamedBOMParameter> deserializeNamedParameters(Map<String, Map<String, String>> parameters) throws IlrSerializationException {
        HashMap<String, IlrNamedBOMParameter> returnedValue = new HashMap<String, IlrNamedBOMParameter>();
        if (parameters == null) {
            returnedValue = null;
        } else {
            for (String key : parameters.keySet()) {
                Map<String, String> serializedParameter = parameters.get(key);
                if (serializedParameter == null) continue;
                returnedValue.put(key, new IlrNamedBOMParameterImpl(serializedParameter.get(NAMED_PARAMETER_NAME), IlrXUSerializationUtils.deserializeBOMTypeDescriptor(serializedParameter.get(NAMED_PARAMETER_BOM_TYPE))));
            }
        }
        return returnedValue;
    }

    public static Map<String, Map<String, String>> serializeObjectFactorySignature(Map<String, IlrObjectFactoryParameter> theObjectFactorySignature) {
        HashMap<String, Map<String, String>> returnedValue = new HashMap<String, Map<String, String>>();
        if (theObjectFactorySignature == null) {
            returnedValue = null;
        } else {
            for (String key : theObjectFactorySignature.keySet()) {
                IlrObjectFactoryParameter parameterToSerialize = theObjectFactorySignature.get(key);
                HashMap<String, String> serializedParameter = new HashMap<String, String>();
                if (parameterToSerialize == null) {
                    serializedParameter = null;
                } else {
                    if (parameterToSerialize.getName() != null) {
                        serializedParameter.put(NAMED_PARAMETER_NAME, parameterToSerialize.getName());
                    }
                    if (parameterToSerialize.getBOMType() != null) {
                        serializedParameter.put(NAMED_PARAMETER_BOM_TYPE, IlrXUSerializationUtils.serializeBOMTypeDescriptor(parameterToSerialize.getBOMType()));
                    }
                    serializedParameter.put(OBJECT_FACTORY_PARAMETER_OPTIONAL, "" + parameterToSerialize.isOptional());
                }
                returnedValue.put(key, serializedParameter);
            }
        }
        return returnedValue;
    }

    public static Map<String, IlrObjectFactoryParameter> deserializeObjectFactorySignature(Map<String, Map<String, String>> theSerializedSignature) throws IlrSerializationException {
        HashMap<String, IlrObjectFactoryParameter> returnedValue = new HashMap<String, IlrObjectFactoryParameter>();
        if (theSerializedSignature == null) {
            returnedValue = null;
        } else {
            for (String key : theSerializedSignature.keySet()) {
                Map<String, String> serializedParameter = theSerializedSignature.get(key);
                if (serializedParameter == null) continue;
                returnedValue.put(key, new IlrObjectFactoryParameterImpl(serializedParameter.get(NAMED_PARAMETER_NAME), IlrXUSerializationUtils.deserializeBOMTypeDescriptor(serializedParameter.get(NAMED_PARAMETER_BOM_TYPE)), new Boolean(serializedParameter.get(OBJECT_FACTORY_PARAMETER_OPTIONAL))));
            }
        }
        return returnedValue;
    }

    public static Map<String, Map<String, Object>> serializeObjectFactoryInputParameters(Map<String, IlrObjectFactoryParameterValue> theObjectFactoryInputParameters) {
        HashMap<String, Map<String, Object>> returnedValue = new HashMap<String, Map<String, Object>>();
        if (theObjectFactoryInputParameters == null) {
            returnedValue = null;
        } else {
            for (String key : theObjectFactoryInputParameters.keySet()) {
                IlrObjectFactoryParameterValue parameterToSerialize = theObjectFactoryInputParameters.get(key);
                HashMap<String, Object> serializedParameter = new HashMap<String, Object>();
                if (parameterToSerialize == null) {
                    serializedParameter = null;
                } else {
                    if (parameterToSerialize.getName() != null) {
                        serializedParameter.put(NAMED_PARAMETER_NAME, parameterToSerialize.getName());
                    }
                    if (parameterToSerialize.getBOMType() != null) {
                        serializedParameter.put(NAMED_PARAMETER_BOM_TYPE, IlrXUSerializationUtils.serializeBOMTypeDescriptor(parameterToSerialize.getBOMType()));
                    }
                    serializedParameter.put(OBJECT_FACTORY_PARAMETER_OPTIONAL, "" + parameterToSerialize.isOptional());
                    Object value = parameterToSerialize.getValue();
                    if (value != null) {
                        if (value.getClass().equals(IlrMetaObject.class.getName())) {
                            serializedParameter.put(OBJECT_FACTORY_PARAMETER_VALUE, ((IlrMetaObject)value).getObject());
                        } else {
                            serializedParameter.put(OBJECT_FACTORY_PARAMETER_VALUE, value);
                        }
                    }
                }
                returnedValue.put(key, serializedParameter);
            }
        }
        return returnedValue;
    }

    public static Map<String, IlrObjectFactoryParameterValue> deserializeObjectFactoryInputParameters(Map<String, Map<String, Object>> theSerializedSignature) throws IlrSerializationException {
        HashMap<String, IlrObjectFactoryParameterValue> returnedValue = new HashMap<String, IlrObjectFactoryParameterValue>();
        if (theSerializedSignature == null) {
            returnedValue = null;
        } else {
            for (String key : theSerializedSignature.keySet()) {
                Map<String, Object> serializedParameter = theSerializedSignature.get(key);
                if (serializedParameter == null) continue;
                IlrObjectFactoryParameterImpl paramDescription = new IlrObjectFactoryParameterImpl((String)serializedParameter.get(NAMED_PARAMETER_NAME), IlrXUSerializationUtils.deserializeBOMTypeDescriptor((String)serializedParameter.get(NAMED_PARAMETER_BOM_TYPE)), new Boolean((String)serializedParameter.get(OBJECT_FACTORY_PARAMETER_OPTIONAL)));
                returnedValue.put(key, new IlrObjectFactoryParameterValueImpl(paramDescription, serializedParameter.get(OBJECT_FACTORY_PARAMETER_VALUE)));
            }
        }
        return returnedValue;
    }

    public static String serializeObjectFactoryParametersException(IlrObjectFactoryParametersException exception) {
        return exception.getMessage();
    }

    public static IlrObjectFactoryParametersException deserializeObjectFactoryParametersException(String serializedException) throws IlrSerializationException {
        return new IlrObjectFactoryParametersException(serializedException);
    }
}

