/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor;

import ilog.rules.monitor.IlrMonitorLocalTool;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public final class IlrMainMonitorTool {
    private static Method getMainMethod(String className) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> clazz = Class.forName(className);
        String[] arg = new String[]{};
        Class[] argClasses = new Class[]{arg.getClass()};
        return clazz.getDeclaredMethod("main", argClasses);
    }

    private static void invokeMainMethod(String className, String[] passedargs) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method mainMethod = IlrMainMonitorTool.getMainMethod(className);
        Object[] args = new Object[]{passedargs};
        mainMethod.invoke(null, args);
    }

    private static void printUsage() {
        System.out.println("IlrMainMonitorTool -stackTraceDepth <int> -monitoringPeriod <long> -fileName <fileName> -entryPoint <className> [-xml] <arguments for the main called>");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            IlrMainMonitorTool.printUsage();
        }
        Args as = new Args();
        String[] argsToPass = as.filterArgs(args);
        IlrMonitorLocalTool tool = new IlrMonitorLocalTool(as.stackTraceDepth, as.monitoringPeriod);
        Thread shutdownHookTh = new Thread(new ShutdownHook(tool, as.xmlFormat, as.fileName));
        Runtime.getRuntime().addShutdownHook(shutdownHookTh);
        tool.launch();
        try {
            IlrMainMonitorTool.invokeMainMethod(as.entryPoint, argsToPass);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class Args {
        public int stackTraceDepth = 20;
        public long monitoringPeriod = 200L;
        public boolean xmlFormat = false;
        private String fileName = null;
        public String entryPoint;

        private Args() {
        }

        public String[] filterArgs(String[] args) {
            ArrayList<String> passed = new ArrayList<String>(args.length);
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("-stackTraceDepth")) {
                    this.stackTraceDepth = Integer.parseInt(args[++i]);
                    continue;
                }
                if (arg.equals("-monitoringPeriod")) {
                    this.monitoringPeriod = Long.parseLong(args[++i]);
                    continue;
                }
                if (arg.equals("-fileName")) {
                    this.fileName = args[++i];
                    continue;
                }
                if (arg.equals("-entryPoint")) {
                    this.entryPoint = args[++i];
                    continue;
                }
                if (arg.equals("-xml")) {
                    this.xmlFormat = true;
                    continue;
                }
                passed.add(arg);
            }
            String[] result = new String[passed.size()];
            return passed.toArray(result);
        }
    }

    private static class ShutdownHook
    implements Runnable {
        private IlrMonitorLocalTool tool;
        private boolean xmlLog;
        private String fileName;

        public ShutdownHook(IlrMonitorLocalTool tool, boolean xmlLog, String fileName) {
            this.tool = tool;
            this.xmlLog = xmlLog;
            this.fileName = fileName != null ? fileName : (xmlLog ? "threadMonitoring.xml" : "threadMonitoring.log");
        }

        @Override
        public void run() {
            if (this.xmlLog) {
                this.tool.printXmlLogInFile(this.fileName);
            } else {
                this.tool.printTextLogInFile(this.fileName);
            }
        }
    }
}

