/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor;

import ilog.rules.monitor.IlrMonitorLocalTool;
import ilog.rules.monitor.IlrTestsDefinition;
import ilog.rules.monitor.model.IlrClassDescriptionSet;
import java.util.EnumSet;
import junit.framework.TestCase;

public class IlrMonitorJunitTestCase
extends TestCase {
    private IlrMonitorLocalTool monitorTool;
    private IlrTestsDefinition testsDef;
    private boolean isMonitoring = false;

    public IlrMonitorJunitTestCase(String string) {
        super(string);
    }

    public void initializeMonitorTestCase(int depth, long intervalMs, EnumSet<Thread.State> threadStates, long[] excludedThs) {
        this.monitorTool = new IlrMonitorLocalTool(depth, intervalMs, threadStates, excludedThs);
        this.monitorTool.launch();
        this.isMonitoring = true;
    }

    public void initializeMonitorTestCase(int depth, long intervalMs) {
        this.initializeMonitorTestCase(depth, intervalMs, EnumSet.of(Thread.State.BLOCKED, Thread.State.WAITING, Thread.State.TIMED_WAITING), new long[]{Thread.currentThread().getId()});
    }

    public void stopMonitoring() {
        IlrClassDescriptionSet classDescSet = this.monitorTool.getModel();
        this.testsDef = new IlrTestsDefinition(classDescSet);
        this.isMonitoring = false;
    }

    public boolean isMonitoring() {
        return this.isMonitoring;
    }

    public void assertNoContentionDetected(String message) {
        this.checkStateForAssert();
        IlrMonitorJunitTestCase.assertFalse((String)message, (boolean)this.testsDef.contentionPointsPresent());
    }

    public void assertNoContentionPointInThisClass(String message, String fullyQualifiedClassName) {
        this.checkStateForAssert();
        IlrMonitorJunitTestCase.assertFalse((String)message, (boolean)this.testsDef.contentionPointsPresentInThisClass(fullyQualifiedClassName));
    }

    public void assertClassNotInvolvedInContentionPointStackTrace(String message, String fullyQualifiedClassName) {
        this.checkStateForAssert();
        IlrMonitorJunitTestCase.assertFalse((String)message, (boolean)this.testsDef.classInvolvedInContentionPoint(fullyQualifiedClassName));
    }

    public void assertNoContentionPointOnThisMethod(String message, String fullyQualifiedMethodName) {
        this.checkStateForAssert();
        IlrMonitorJunitTestCase.assertFalse((String)message, (boolean)this.testsDef.contentionPointOnThisMethod(fullyQualifiedMethodName));
    }

    public void assertMethodNotInvolvedInContentionPointStackTrace(String message, String fullyQualifiedMethodName) {
        this.checkStateForAssert();
        IlrMonitorJunitTestCase.assertFalse((String)message, (boolean)this.testsDef.methodInvolvedInContentionPoint(fullyQualifiedMethodName));
    }

    public void assertNoContentionPointInThisPackage(String message, String fullyQualifiedPackageName) {
        this.checkStateForAssert();
        IlrMonitorJunitTestCase.assertFalse((String)message, (boolean)this.testsDef.contentionPointInThisPackage(fullyQualifiedPackageName));
    }

    public void assertPackageInvolvedInContentionPointStackTrace(String message, String fullyQualifiedPackageName) {
        this.checkStateForAssert();
        IlrMonitorJunitTestCase.assertFalse((String)message, (boolean)this.testsDef.contentionPointInvolveThisPackage(fullyQualifiedPackageName));
    }

    public void assertInstanceOfThisClassArentLock(String message, String fullyQualifiedClassName) {
        this.checkStateForAssert();
        IlrMonitorJunitTestCase.assertFalse((String)message, (boolean)this.testsDef.instanceOfClassIsALock(fullyQualifiedClassName));
    }

    public void assertNumberOfContentionPointsEquals(String message, int number) {
        this.checkStateForAssert();
        IlrMonitorJunitTestCase.assertEquals((String)message, (int)number, (int)this.testsDef.numberOfContentionPoints());
    }

    public void assertNumberOfContentionPointsInThisClass(String message, String fullyQualifiedClassName, int number) {
        this.checkStateForAssert();
        IlrMonitorJunitTestCase.assertEquals((String)message, (int)number, (int)this.testsDef.numberOfContentionPointPresentInThisClass(fullyQualifiedClassName));
    }

    private void checkStateForAssert() {
        if (this.isMonitoring()) {
            throw new IllegalStateException("STOP MONITORING BEFORE ASSERTION");
        }
    }
}

