/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor;

import ilog.rules.monitor.IlrMonitorTool;
import ilog.rules.monitor.jmx.IlrJMXLocalThreadMonitor;
import ilog.rules.monitor.model.IlrClassDescriptionSet;
import ilog.rules.monitor.report.IlrStackElementFilter;
import java.io.PrintWriter;
import java.util.EnumSet;
import org.w3c.dom.Document;

public final class IlrMonitorLocalTool
extends IlrMonitorTool {
    public IlrMonitorLocalTool(int depth, long intervalMs) {
        this(depth, intervalMs, null);
    }

    public IlrMonitorLocalTool(int depth, long intervalMs, EnumSet<Thread.State> threadStates) {
        this(depth, intervalMs, threadStates, null);
    }

    public IlrMonitorLocalTool(int depth, long intervalMs, EnumSet<Thread.State> threadStates, long[] excludedThreadIds) {
        this.initialize(depth, intervalMs, threadStates, excludedThreadIds);
    }

    @Override
    public void launch() {
        if (this.thread != null && !this.thread.getState().equals((Object)Thread.State.NEW)) {
            this.interrupt();
            this.jmxMonitor.reset();
        } else {
            this.jmxMonitor = new IlrJMXLocalThreadMonitor();
        }
        this.thread = new Thread((Runnable)new IlrMonitorTool.Listener(this), "jrules-listener-thread");
        this.thread.start();
    }

    @Override
    public void print(PrintWriter writer, IlrStackElementFilter filter, boolean xmlFormat) {
        this.interrupt();
        if (xmlFormat) {
            this.printXML(writer, filter);
        } else {
            this.printLogText(writer, filter);
        }
    }

    @Override
    public Document getXMLModel() {
        this.interrupt();
        return this.getXMLModelDocument(null);
    }

    IlrClassDescriptionSet getModel() {
        this.interrupt();
        return this.classDescSet;
    }
}

