/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor;

import ilog.rules.monitor.jmx.IlrJMXAbstractThreadMonitor;
import ilog.rules.monitor.model.IlrClassDescriptionSet;
import ilog.rules.monitor.report.IlrMonitorModelPrinter;
import ilog.rules.monitor.report.IlrMonitorModelXmlBuilder;
import ilog.rules.monitor.report.IlrStackElementFilter;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.Properties;
import org.w3c.dom.Document;

public abstract class IlrMonitorTool {
    protected int depth;
    protected long intervalMs;
    protected IlrClassDescriptionSet classDescSet;
    protected Thread thread;
    protected volatile boolean shouldTerminate;
    protected volatile boolean isWorking;
    protected EnumSet<Thread.State> threadStates;
    protected IlrJMXAbstractThreadMonitor jmxMonitor;
    protected long[] excludedThreadIds;

    public abstract void launch();

    public final void printTextLogInFile(String fileName) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(fileName);
            this.print(writer, null, false);
            writer.flush();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (FileNotFoundException fe) {
            throw new RuntimeException(fe);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public final void printXmlLogInFile(String fileName) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(fileName);
            this.print(writer, null, true);
            writer.flush();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (FileNotFoundException fe) {
            throw new RuntimeException(fe);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public abstract void print(PrintWriter var1, IlrStackElementFilter var2, boolean var3);

    public abstract Document getXMLModel();

    protected void printXML(PrintWriter writer, IlrStackElementFilter filter) {
        try {
            IlrMonitorModelXmlBuilder xmlBuilder = new IlrMonitorModelXmlBuilder();
            Properties xslProperties = new Properties();
            xslProperties.setProperty("indent", "yes");
            writer.print(xmlBuilder.generateXmlDocumentAsString(this.classDescSet, filter, xslProperties));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void printLogText(PrintWriter writer, IlrStackElementFilter filter) {
        IlrMonitorModelPrinter printer = new IlrMonitorModelPrinter(writer, filter);
        printer.print(this.classDescSet);
    }

    protected Document getXMLModelDocument(IlrStackElementFilter filter) {
        try {
            IlrMonitorModelXmlBuilder xmlBuilder = new IlrMonitorModelXmlBuilder();
            return xmlBuilder.generateXmlDocument(this.classDescSet, filter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initialize(int depth, long intervalMs, EnumSet<Thread.State> threadStates, long[] excludedThreadIds) {
        this.depth = depth;
        this.intervalMs = intervalMs;
        this.threadStates = threadStates != null ? threadStates : EnumSet.of(Thread.State.BLOCKED);
        this.shouldTerminate = false;
        this.isWorking = false;
        this.excludedThreadIds = excludedThreadIds;
    }

    protected void interrupt() {
        this.shouldTerminate = true;
        boolean wait = true;
        while (wait) {
            wait = this.isWorking;
        }
        this.thread.interrupt();
        this.jmxMonitor.endUsage();
    }

    protected class Listener
    implements Runnable {
        protected Listener() {
        }

        @Override
        public void run() {
            try {
                while (!IlrMonitorTool.this.shouldTerminate) {
                    Thread.sleep(IlrMonitorTool.this.intervalMs);
                    IlrMonitorTool.this.isWorking = true;
                    IlrMonitorTool.this.classDescSet = IlrMonitorTool.this.jmxMonitor.getBlockingClass(IlrMonitorTool.this.depth, IlrMonitorTool.this.threadStates, null);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                IlrMonitorTool.this.isWorking = false;
            }
        }
    }
}

