/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor;

import ilog.rules.monitor.model.IlrClassDescription;
import ilog.rules.monitor.model.IlrClassDescriptionSet;
import ilog.rules.monitor.model.IlrCodeLocation;
import ilog.rules.monitor.model.IlrExecutionPoint;
import ilog.rules.monitor.model.IlrStackElement;
import java.util.Iterator;

public final class IlrTestsDefinition {
    private IlrClassDescriptionSet classDescSet;

    public IlrTestsDefinition(IlrClassDescriptionSet classDescSet) {
        this.classDescSet = classDescSet;
    }

    public final boolean contentionPointsPresent() {
        return this.classDescSet.size() > 0;
    }

    public final int numberOfContentionPoints() {
        Iterator<IlrClassDescription> itClassDesc = this.classDescSet.iterator();
        int counter = 0;
        while (itClassDesc.hasNext()) {
            IlrClassDescription classDescription = itClassDesc.next();
            counter += classDescription.numbersOfCodeLocation();
        }
        return counter;
    }

    public final boolean contentionPointsPresentInThisClass(String fullyQualifiedName) {
        IlrClassDescription classDesc = this.classDescSet.getClassDescription(fullyQualifiedName);
        return classDesc != null;
    }

    public final int numberOfContentionPointPresentInThisClass(String fullyQualifiedName) {
        IlrClassDescription classDesc = this.classDescSet.getClassDescription(fullyQualifiedName);
        if (classDesc != null) {
            return classDesc.numbersOfCodeLocation();
        }
        return 0;
    }

    public final boolean classInvolvedInContentionPoint(String fullyQualifiedName) {
        boolean found;
        Iterator<IlrClassDescription> itClassDesc = this.classDescSet.iterator();
        boolean bl = found = this.classDescSet.getClassDescription(fullyQualifiedName) != null;
        while (itClassDesc.hasNext() && !found) {
            IlrClassDescription classDesc = itClassDesc.next();
            Iterator<IlrCodeLocation> itCodeLocs = classDesc.iterator();
            while (itCodeLocs.hasNext() && !found) {
                Iterator<IlrExecutionPoint> itExecPoint = itCodeLocs.next().getExecutionPointHistory().iterator();
                while (itExecPoint.hasNext() && !found) {
                    Iterator<IlrStackElement> stacks = itExecPoint.next().getStackBlocked();
                    while (stacks.hasNext() && !found) {
                        String methodName = stacks.next().getFullyQualifiedMethodName();
                        String className = methodName.substring(0, methodName.lastIndexOf(46));
                        found = className.equals(fullyQualifiedName);
                    }
                }
            }
        }
        return found;
    }

    public final boolean contentionPointOnThisMethod(String fullyQualifiedMethodName) {
        String[] fullyQualifiedMethodNameInTab = fullyQualifiedMethodName.split("[.]");
        StringBuilder fullyQualifiedClassName = new StringBuilder(fullyQualifiedMethodName.length());
        for (int i = 0; i < fullyQualifiedMethodNameInTab.length - 1; ++i) {
            String name = fullyQualifiedMethodNameInTab[i];
            fullyQualifiedClassName.append(name);
            fullyQualifiedClassName.append('.');
        }
        fullyQualifiedClassName.deleteCharAt(fullyQualifiedClassName.length() - 1);
        IlrClassDescription classDesc = this.classDescSet.getClassDescription(fullyQualifiedClassName.toString());
        if (classDesc != null) {
            boolean found = false;
            Iterator<IlrCodeLocation> itCodeLocs = classDesc.iterator();
            while (itCodeLocs.hasNext() && !found) {
                found = itCodeLocs.next().getMethod().equals(fullyQualifiedMethodNameInTab[fullyQualifiedMethodNameInTab.length - 1]);
            }
            return found;
        }
        return false;
    }

    public final boolean methodInvolvedInContentionPoint(String fullyQualifiedMethodName) {
        String[] fullyQualifiedMethodNameInTab = fullyQualifiedMethodName.split("[.]");
        StringBuilder fullyQualifiedClassName = new StringBuilder(fullyQualifiedMethodName.length());
        for (int i = 0; i < fullyQualifiedMethodNameInTab.length - 1; ++i) {
            String name = fullyQualifiedMethodNameInTab[i];
            fullyQualifiedClassName.append(name);
            fullyQualifiedClassName.append('.');
        }
        fullyQualifiedClassName.deleteCharAt(fullyQualifiedClassName.length() - 1);
        boolean found = false;
        Iterator<IlrClassDescription> itClassDesc = this.classDescSet.iterator();
        while (itClassDesc.hasNext() && !found) {
            IlrClassDescription classDesc = itClassDesc.next();
            Iterator<IlrCodeLocation> itCodeLocs = classDesc.iterator();
            while (itCodeLocs.hasNext() && !found) {
                IlrCodeLocation codeLoc = itCodeLocs.next();
                if (fullyQualifiedClassName.toString().equals(classDesc.getClassName())) {
                    found = codeLoc.getMethod().equals(fullyQualifiedMethodNameInTab[fullyQualifiedMethodNameInTab.length - 1]);
                }
                if (found) continue;
                Iterator<IlrExecutionPoint> itExecPoint = codeLoc.getExecutionPointHistory().iterator();
                while (itExecPoint.hasNext() && !found) {
                    Iterator<IlrStackElement> stacks = itExecPoint.next().getStackBlocked();
                    while (stacks.hasNext() && !found) {
                        found = stacks.next().getFullyQualifiedMethodName().equals(fullyQualifiedMethodName);
                    }
                }
            }
        }
        return found;
    }

    public final boolean instanceOfClassIsALock(String fullyQualifiedClassName) {
        for (IlrClassDescription aClassDesc : this.classDescSet) {
            for (IlrCodeLocation codeLocation : aClassDesc) {
                for (IlrExecutionPoint executionPoint : codeLocation.getExecutionPointHistory()) {
                    String fqn;
                    String lockDescription = executionPoint.getLockDescription();
                    if (lockDescription == null || !(fqn = lockDescription.split("[@]")[0]).equals(fullyQualifiedClassName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public final boolean contentionPointInThisPackage(String packageName) {
        Iterator<IlrClassDescription> itClassDesc = this.classDescSet.getClassDescriptionsOfPackage(packageName);
        return itClassDesc.hasNext();
    }

    public final boolean contentionPointInvolveThisPackage(String packageName) {
        for (IlrClassDescription classDescription : this.classDescSet) {
            String classDescPackageName = classDescription.getClassName().substring(0, classDescription.getClassName().lastIndexOf(46));
            if (classDescPackageName.equals(packageName)) {
                return true;
            }
            for (IlrCodeLocation codeLocation : classDescription) {
                for (IlrExecutionPoint executionPoint : codeLocation.getExecutionPointHistory()) {
                    Iterator<IlrStackElement> stacks = executionPoint.getStackBlocked();
                    while (stacks.hasNext()) {
                        IlrStackElement stackElement = stacks.next();
                        if (!stackElement.getPackageName().equals(packageName)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

