/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor;

import ilog.rules.monitor.jmx.IlrJMXLocalGCMonitor;
import ilog.rules.monitor.jmx.IlrJMXLocalThreadMonitor;
import ilog.rules.monitor.model.IlrClassDescriptionSet;
import ilog.rules.monitor.report.IlrMonitorModelXmlBuilder;
import java.util.EnumSet;
import java.util.Properties;

public class IlrXUMonitorTool {
    public static final String THREAD_MONITORING_STACKTRACEDEPTH = "STACKTRACE_DEPTH";
    protected IlrJMXLocalGCMonitor gcMonitor;
    protected IlrJMXLocalThreadMonitor threadMonitor;
    protected IlrMonitorModelXmlBuilder modelXMLSerializer;

    public IlrXUMonitorTool() throws XUMonitorToolException {
        try {
            this.gcMonitor = new IlrJMXLocalGCMonitor();
            this.threadMonitor = new IlrJMXLocalThreadMonitor();
            this.modelXMLSerializer = new IlrMonitorModelXmlBuilder();
        }
        catch (Exception e) {
            throw new XUMonitorToolException(e);
        }
    }

    public void enableJVMThreadContentionMonitoring() throws XUMonitorToolException {
        if (!this.threadMonitor.enableThreadContentionMonitoring()) {
            throw new XUMonitorToolException("JVM thread contention monitoring couldn't be enable");
        }
    }

    public String getDump(Properties properties) throws XUMonitorToolException {
        try {
            int depth = 5;
            if (properties != null && properties.getProperty(THREAD_MONITORING_STACKTRACEDEPTH) != null) {
                depth = Integer.valueOf(properties.getProperty(THREAD_MONITORING_STACKTRACEDEPTH));
            }
            IlrClassDescriptionSet model = this.threadMonitor.getBlockingClass(depth, EnumSet.of(Thread.State.BLOCKED, Thread.State.WAITING, Thread.State.TIMED_WAITING, Thread.State.RUNNABLE), null);
            this.threadMonitor.reset();
            return this.modelXMLSerializer.generateXmlDocumentAsString(model);
        }
        catch (Exception e) {
            throw new XUMonitorToolException(e);
        }
    }

    public long[] getGarbageCollectionTime() throws XUMonitorToolException {
        try {
            return this.gcMonitor.getGCCollectionTime();
        }
        catch (Exception e) {
            throw new XUMonitorToolException(e);
        }
    }

    public static final class XUMonitorToolException
    extends Exception {
        XUMonitorToolException(Exception e) {
            super(e);
        }

        XUMonitorToolException(String message) {
            super(message);
        }
    }
}

