/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor.jmx;

import ilog.rules.monitor.jmx.IlrMonitoringModelFactory;
import ilog.rules.monitor.model.IlrClassDescriptionSet;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.EnumSet;

public abstract class IlrJMXAbstractThreadMonitor {
    protected ThreadMXBean threadMxBean;
    private boolean jvmThreadContentionMonitoringEnable = false;
    private IlrMonitoringModelFactory modelFactory;

    protected abstract void initalizeThreadMXBean();

    protected final void createModelFactory() {
        if (!this.jvmThreadContentionMonitoringEnable) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    if (IlrJMXAbstractThreadMonitor.this.threadMxBean.isThreadContentionMonitoringSupported()) {
                        try {
                            IlrJMXAbstractThreadMonitor.this.jvmThreadContentionMonitoringEnable = IlrJMXAbstractThreadMonitor.this.threadMxBean.isThreadContentionMonitoringEnabled();
                        }
                        catch (Exception e) {
                            IlrJMXAbstractThreadMonitor.this.jvmThreadContentionMonitoringEnable = false;
                        }
                    } else {
                        IlrJMXAbstractThreadMonitor.this.jvmThreadContentionMonitoringEnable = false;
                    }
                    return null;
                }
            });
        }
        this.modelFactory = new IlrMonitoringModelFactory(this.jvmThreadContentionMonitoringEnable);
    }

    public final boolean enableThreadContentionMonitoring() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (IlrJMXAbstractThreadMonitor.this.threadMxBean.isThreadContentionMonitoringSupported()) {
                    try {
                        if (!IlrJMXAbstractThreadMonitor.this.threadMxBean.isThreadContentionMonitoringEnabled()) {
                            IlrJMXAbstractThreadMonitor.this.threadMxBean.setThreadContentionMonitoringEnabled(true);
                        }
                        IlrJMXAbstractThreadMonitor.this.jvmThreadContentionMonitoringEnable = true;
                    }
                    catch (Exception e) {
                        IlrJMXAbstractThreadMonitor.this.jvmThreadContentionMonitoringEnable = false;
                    }
                } else {
                    IlrJMXAbstractThreadMonitor.this.jvmThreadContentionMonitoringEnable = false;
                }
                return null;
            }
        });
        this.createModelFactory();
        return this.jvmThreadContentionMonitoringEnable;
    }

    public final IlrClassDescriptionSet getBlockingClass(final int stackTraceDepth, final EnumSet<Thread.State> threadStates, final long[] excludedThreadIds) {
        if (stackTraceDepth <= 0) {
            throw new IllegalArgumentException();
        }
        IlrMonitoringModelFactory.Input input = AccessController.doPrivileged(new PrivilegedAction<IlrMonitoringModelFactory.Input>(){

            @Override
            public IlrMonitoringModelFactory.Input run() {
                long[] threadIs = IlrJMXAbstractThreadMonitor.this.threadMxBean.getAllThreadIds();
                ThreadInfo[] threadInfos = IlrJMXAbstractThreadMonitor.this.threadMxBean.getThreadInfo(threadIs, stackTraceDepth);
                IlrMonitoringModelFactory.Input input = new IlrMonitoringModelFactory.Input();
                input.states = threadStates;
                input.threadInfos = threadInfos;
                input.nanoTime = System.nanoTime();
                input.totalNumberOfThreads = IlrJMXAbstractThreadMonitor.this.threadMxBean.getTotalStartedThreadCount();
                input.depth = stackTraceDepth;
                if (excludedThreadIds != null) {
                    Arrays.sort(excludedThreadIds);
                    input.excludedIds = excludedThreadIds;
                } else {
                    input.excludedIds = new long[0];
                }
                return input;
            }
        });
        return this.modelFactory.makeModel(input);
    }

    public final void reset() {
        this.createModelFactory();
    }

    public abstract void endUsage();
}

