/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor.jmx;

import ilog.rules.monitor.jmx.IlrJMXAbstractThreadMonitor;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.MalformedURLException;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public final class IlrJMXRemoteThreadMonitor
extends IlrJMXAbstractThreadMonitor {
    private Map<String, ?> properties;
    private JMXServiceURL jmxUrl;
    private JMXConnector connector;

    public IlrJMXRemoteThreadMonitor(String jmxUrl, Map<String, ?> properties) throws MalformedURLException {
        this.properties = properties;
        this.jmxUrl = new JMXServiceURL(jmxUrl);
        this.initalizeThreadMXBean();
    }

    @Override
    protected void initalizeThreadMXBean() {
        try {
            this.connector = JMXConnectorFactory.newJMXConnector(this.jmxUrl, this.properties);
            MBeanServerConnection connection = this.connector.getMBeanServerConnection();
            this.threadMxBean = ManagementFactory.newPlatformMXBeanProxy(connection, "java.lang:type=Threading", ThreadMXBean.class);
            this.createModelFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endUsage() {
        try {
            this.reset();
            this.connector.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

