/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.monitor.jmx;

import ilog.rules.monitor.model.IlrClassDescription;
import ilog.rules.monitor.model.IlrClassDescriptionSet;
import ilog.rules.monitor.model.IlrClassDescriptionSetImpl;
import ilog.rules.monitor.model.IlrCodeLocation;
import ilog.rules.monitor.model.IlrExecutionPoint;
import ilog.rules.monitor.model.IlrThread;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.EnumSet;

final class IlrMonitoringModelFactory {
    private IlrClassDescriptionSetImpl classDescriptionSet = new IlrClassDescriptionSetImpl();
    private long refTime = 0L;
    private boolean first = true;
    private boolean useJVMThreadContentionMonitoring;

    IlrMonitoringModelFactory(boolean useJVMThreadContentionMonitoring) {
        this.useJVMThreadContentionMonitoring = useJVMThreadContentionMonitoring;
    }

    IlrClassDescriptionSet makeModel(Input input) {
        if (this.first) {
            this.refTime = input.nanoTime;
            this.first = false;
        }
        this.classDescriptionSet.setTotalStartedThreadCount(input.totalNumberOfThreads);
        this.classDescriptionSet.setMaxStacktraceDepth(input.depth);
        long currentTime = input.nanoTime - this.refTime;
        this.classDescriptionSet.incrNumberOfSnapshots(currentTime);
        for (ThreadInfo threadInfo : input.threadInfos) {
            if (threadInfo == null || !input.states.contains((Object)threadInfo.getThreadState()) || Arrays.binarySearch(input.excludedIds, threadInfo.getThreadId()) >= 0) continue;
            IlrThread blockedTh = this.getThread(threadInfo.getThreadName(), threadInfo.getThreadId());
            IlrClassDescriptionSetImpl.setMeasureCount(blockedTh, threadInfo.getWaitedCount(), threadInfo.getBlockedCount());
            if (this.useJVMThreadContentionMonitoring) {
                IlrClassDescriptionSetImpl.setMeasureTime(blockedTh, threadInfo.getWaitedTime(), threadInfo.getBlockedTime());
            }
            IlrThread ownerTh = this.getThread(threadInfo.getLockOwnerName(), threadInfo.getLockOwnerId());
            StackTraceElement[] stackTrace = threadInfo.getStackTrace();
            if (stackTrace == null || stackTrace.length <= 0) continue;
            IlrClassDescription classDesc = this.classDescriptionSet.makeClassDescription(stackTrace[0].getClassName());
            IlrCodeLocation codeLocation = IlrClassDescriptionSetImpl.getCodeLocation(classDesc, stackTrace[0].getMethodName(), stackTrace[0].getLineNumber(), threadInfo.getThreadState(), stackTrace[0].isNativeMethod());
            IlrExecutionPoint execPoint = IlrClassDescriptionSetImpl.addExecutionPoint(codeLocation.getExecutionPointHistory(), blockedTh, ownerTh, currentTime, threadInfo.getLockName());
            for (int i = 1; i < stackTrace.length; ++i) {
                IlrClassDescriptionSetImpl.enlistBlockedStackElement(execPoint, stackTrace[i].getClassName() + "." + stackTrace[i].getMethodName(), stackTrace[i].getLineNumber(), stackTrace[i].isNativeMethod());
            }
            ThreadInfo ownerThreadIndo = this.getThreadOwner(threadInfo, input);
            if (ownerThreadIndo == null) continue;
            for (StackTraceElement stackTraceElement : stackTrace = ownerThreadIndo.getStackTrace()) {
                IlrClassDescriptionSetImpl.enlistOwnerStackElement(execPoint, stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName(), stackTraceElement.getLineNumber(), stackTraceElement.isNativeMethod());
            }
        }
        return this.classDescriptionSet;
    }

    private IlrThread getThread(String name, long id) {
        return IlrClassDescriptionSetImpl.getThread(name, id);
    }

    private ThreadInfo getThreadOwner(ThreadInfo threadInfo, Input allThs) {
        if (threadInfo.getLockOwnerId() != -1L) {
            for (ThreadInfo thInfo : allThs.threadInfos) {
                StackTraceElement[] stacks;
                String threadName;
                if (thInfo == null || thInfo.getThreadId() != threadInfo.getLockOwnerId() || ((threadName = thInfo.getThreadName()) == null || !threadName.equals(threadInfo.getLockOwnerName())) && (threadName != null || threadInfo.getLockOwnerName() != null) || (stacks = thInfo.getStackTrace()) == null || stacks.length <= 0) continue;
                return thInfo;
            }
        }
        return null;
    }

    static class Input {
        EnumSet<Thread.State> states;
        ThreadInfo[] threadInfos;
        long totalNumberOfThreads;
        long nanoTime;
        long[] excludedIds;
        int depth;

        Input() {
        }
    }
}

